/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchDependentJob;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseJob
implements Job {
    protected final List<File> jobPropertiesFiles = new ArrayList<File>();
    private final Job.BuildProfile _buildProfile;
    private final String _jobName;
    private final Properties _jobProperties = new Properties();

    @Override
    public Set<String> getBatchNames() {
        return this.getFilteredBatchNames(this.getRawBatchNames());
    }

    @Override
    public List<BatchTestClassGroup> getBatchTestClassGroups() {
        return this.getBatchTestClassGroups(this.getRawBatchNames());
    }

    @Override
    public List<Build> getBuildHistory(JenkinsMaster jenkinsMaster) {
        JSONObject jobJSONObject = this.getJobJSONObject(jenkinsMaster, "builds[number]");
        JSONArray buildsJSONArray = jobJSONObject.getJSONArray("builds");
        ArrayList<Build> builds = new ArrayList<Build>(buildsJSONArray.length());
        for (int i = 0; i < buildsJSONArray.length(); ++i) {
            JSONObject buildJSONObject = buildsJSONArray.getJSONObject(i);
            builds.add(BuildFactory.newBuild(JenkinsResultsParserUtil.combine(jenkinsMaster.getURL(), "/job/", this.getJobName(), "/", String.valueOf(buildJSONObject.getInt("number"))), null));
        }
        return builds;
    }

    @Override
    public Job.BuildProfile getBuildProfile() {
        return this._buildProfile;
    }

    @Override
    public Set<String> getDistTypesExcludingTomcat() {
        TreeSet<String> distTypesExcludingTomcat = new TreeSet<String>(this.getDistTypes());
        distTypesExcludingTomcat.remove("tomcat");
        return distTypesExcludingTomcat;
    }

    @Override
    public String getJobName() {
        return this._jobName;
    }

    @Override
    public Properties getJobProperties() {
        return this._jobProperties;
    }

    @Override
    public String getJobProperty(String key) {
        return this._jobProperties.getProperty(key);
    }

    @Override
    public String getJobURL(JenkinsMaster jenkinsMaster) {
        return JenkinsResultsParserUtil.combine(jenkinsMaster.getURL(), "/job/", this._jobName);
    }

    @Override
    public Set<String> getSegmentNames() {
        return this.getFilteredSegmentNames(this.getRawBatchNames());
    }

    @Override
    public List<SegmentTestClassGroup> getSegmentTestClassGroups() {
        return this.getSegmentTestClassGroups(this.getRawBatchNames());
    }

    @Override
    public String getTestPropertiesContent() {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        List<BatchTestClassGroup> batchTestClassGroups = this.getBatchTestClassGroups();
        if (this instanceof BatchDependentJob) {
            BatchDependentJob batchDependentJob = (BatchDependentJob)((Object)this);
            batchTestClassGroups.addAll(batchDependentJob.getDependentBatchTestClassGroups());
        }
        for (BatchTestClassGroup batchTestClassGroup : batchTestClassGroups) {
            Properties batchProperties = new Properties();
            batchProperties.setProperty("test.batch.maximum.slaves.per.host", String.valueOf(batchTestClassGroup.getMaximumSlavesPerHost()));
            batchProperties.setProperty("test.batch.minimum.slave.ram", String.valueOf(batchTestClassGroup.getMinimumSlaveRAM()));
            if (batchTestClassGroup instanceof FunctionalBatchTestClassGroup) {
                FunctionalBatchTestClassGroup functionalBatchTestClassGroup = (FunctionalBatchTestClassGroup)batchTestClassGroup;
                String relevantTestBatchRunPropertyQuery = functionalBatchTestClassGroup.getRelevantTestBatchRunPropertyQuery();
                if (relevantTestBatchRunPropertyQuery != null) {
                    batchProperties.setProperty("test.batch.run.property.query", relevantTestBatchRunPropertyQuery);
                }
            } else {
                batchProperties.setProperty("test.batch.size", String.valueOf(batchTestClassGroup.getAxisCount()));
            }
            propertiesMap.put(batchTestClassGroup.getBatchName(), batchProperties);
            for (int i = 0; i < batchTestClassGroup.getSegmentCount(); ++i) {
                Properties segmentProperties = new Properties();
                SegmentTestClassGroup segmentTestClassGroup = batchTestClassGroup.getSegmentTestClassGroup(i);
                segmentProperties.setProperty("test.batch.maximum.slaves.per.host", String.valueOf(segmentTestClassGroup.getMaximumSlavesPerHost()));
                segmentProperties.setProperty("test.batch.minimum.slave.ram", String.valueOf(segmentTestClassGroup.getMinimumSlaveRAM()));
                segmentProperties.setProperty("test.batch.name", segmentTestClassGroup.getBatchName());
                segmentProperties.setProperty("test.batch.size", String.valueOf(segmentTestClassGroup.getAxisCount()));
                String testCasePropertiesContent = segmentTestClassGroup.getTestCasePropertiesContent();
                if (testCasePropertiesContent != null) {
                    testCasePropertiesContent = testCasePropertiesContent.replaceAll("\n", "\\${line.separator}");
                    segmentProperties.setProperty("test.case.properties", testCasePropertiesContent);
                }
                if (segmentTestClassGroup instanceof FunctionalSegmentTestClassGroup) {
                    segmentProperties.setProperty("run.test.case.method.group", String.valueOf(i));
                }
                propertiesMap.put(segmentTestClassGroup.getSegmentName(), segmentProperties);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry propertiesEntry : propertiesMap.entrySet()) {
            Properties properties = (Properties)propertiesEntry.getValue();
            for (String propertyName : properties.stringPropertyNames()) {
                sb.append(propertyName);
                sb.append("[");
                sb.append((String)propertiesEntry.getKey());
                sb.append("]=");
                sb.append(properties.getProperty(propertyName));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isSegmentEnabled() {
        String segmentEnabled;
        String testSuiteName = "default";
        if (this instanceof TestSuiteJob) {
            TestSuiteJob testSuiteJob = (TestSuiteJob)((Object)this);
            testSuiteName = testSuiteJob.getTestSuiteName();
        }
        return (segmentEnabled = JenkinsResultsParserUtil.getProperty(this._jobProperties, "test.batch.segment.enabled", this.getJobName(), testSuiteName)) != null && segmentEnabled.equals("true");
    }

    @Override
    public boolean isValidationRequired() {
        return false;
    }

    @Override
    public void readJobProperties() {
        this._jobProperties.clear();
        for (File jobPropertiesFile : this.jobPropertiesFiles) {
            this._jobProperties.putAll((Map<?, ?>)JenkinsResultsParserUtil.getProperties(jobPropertiesFile));
        }
    }

    protected BaseJob(String jobName, Job.BuildProfile buildProfile) {
        this._jobName = jobName;
        this._buildProfile = buildProfile;
    }

    protected List<BatchTestClassGroup> getBatchTestClassGroups(Set<String> rawBatchNames) {
        if (rawBatchNames == null || rawBatchNames.isEmpty()) {
            return new ArrayList<BatchTestClassGroup>();
        }
        ArrayList<BatchTestClassGroup> batchTestClassGroups = new ArrayList<BatchTestClassGroup>();
        for (String batchName : rawBatchNames) {
            BatchTestClassGroup batchTestClassGroup = TestClassGroupFactory.newBatchTestClassGroup(batchName, this);
            if (batchTestClassGroup.getAxisCount() <= 0) continue;
            batchTestClassGroups.add(batchTestClassGroup);
        }
        return batchTestClassGroups;
    }

    protected Set<String> getFilteredBatchNames(Set<String> rawBatchNames) {
        TreeSet<String> batchNames = new TreeSet<String>();
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups(rawBatchNames)) {
            batchNames.add(batchTestClassGroup.getBatchName());
        }
        return batchNames;
    }

    protected Set<String> getFilteredSegmentNames(Set<String> rawBatchNames) {
        TreeSet<String> segmentNames = new TreeSet<String>();
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups(rawBatchNames)) {
            for (int i = 0; i < batchTestClassGroup.getSegmentCount(); ++i) {
                SegmentTestClassGroup segmentTestClassGroup = batchTestClassGroup.getSegmentTestClassGroup(i);
                if (segmentTestClassGroup.getAxisCount() <= 0) continue;
                segmentNames.add(batchTestClassGroup.getBatchName() + "/" + i);
            }
        }
        return segmentNames;
    }

    protected JSONObject getJobJSONObject(JenkinsMaster jenkinsMaster, String tree) {
        if (this.getJobURL(jenkinsMaster) == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(JenkinsResultsParserUtil.getLocalURL(this.getJobURL(jenkinsMaster)));
        sb.append("/api/json?pretty");
        if (tree != null) {
            sb.append("&tree=");
            sb.append(tree);
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(sb.toString(), false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get job JSON", ioException);
        }
    }

    protected abstract Set<String> getRawBatchNames();

    protected List<SegmentTestClassGroup> getSegmentTestClassGroups(Set<String> rawBatchNames) {
        ArrayList<SegmentTestClassGroup> segmentTestClassGroups = new ArrayList<SegmentTestClassGroup>();
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups(rawBatchNames)) {
            for (int i = 0; i < batchTestClassGroup.getSegmentCount(); ++i) {
                SegmentTestClassGroup segmentTestClassGroup = batchTestClassGroup.getSegmentTestClassGroup(i);
                if (segmentTestClassGroup.getAxisCount() <= 0) continue;
                segmentTestClassGroups.add(segmentTestClassGroup);
            }
        }
        return segmentTestClassGroups;
    }

    protected Set<String> getSetFromString(String string) {
        TreeSet<String> set = new TreeSet<String>();
        if (string == null) {
            return set;
        }
        for (String item : StringUtils.split((String)string, (String)",")) {
            if (item.startsWith("#")) continue;
            set.add(item.trim());
        }
        return set;
    }
}

