/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRepository;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseGitRepository
implements GitRepository {
    private static final String[] _KEYS_REQUIRED = new String[]{"name"};
    private static final String _URL_PROPERTIES_REPOSITORY = JenkinsResultsParserUtil.URL_CACHE + "/liferay-jenkins-ee/commands/repository.properties";
    private static Properties _repositoryProperties;
    private final JSONObject _jsonObject;

    public static void setRepositoryProperties(Properties repositoryProperties) {
        _repositoryProperties = repositoryProperties;
    }

    @Override
    public JSONObject getJSONObject() {
        return this._jsonObject;
    }

    @Override
    public String getName() {
        return this.getString("name");
    }

    protected BaseGitRepository(JSONObject jsonObject) {
        this._jsonObject = jsonObject;
        this.validateKeys(_KEYS_REQUIRED);
    }

    protected BaseGitRepository(String name) {
        this._jsonObject = new JSONObject();
        this._setName(name);
        this.validateKeys(_KEYS_REQUIRED);
    }

    protected File getFile(String key) {
        return new File(this.getString(key));
    }

    protected JSONArray getJSONArray(String key) {
        return this._jsonObject.getJSONArray(key);
    }

    protected Properties getRepositoryProperties() {
        if (_repositoryProperties != null) {
            return _repositoryProperties;
        }
        _repositoryProperties = new Properties();
        try {
            _repositoryProperties.load(new StringReader(JenkinsResultsParserUtil.toString(_URL_PROPERTIES_REPOSITORY, false)));
        }
        catch (IOException ioException) {
            System.out.println("Skipped downloading " + _URL_PROPERTIES_REPOSITORY);
        }
        _repositoryProperties.putAll((Map<?, ?>)JenkinsResultsParserUtil.getProperties(new File("repository.properties")));
        return _repositoryProperties;
    }

    protected String getString(String key) {
        return this._jsonObject.getString(key);
    }

    protected boolean has(String key) {
        return this._jsonObject.has(key);
    }

    protected String optString(String key) {
        return this._jsonObject.optString(key);
    }

    protected void put(String key, Object value) {
        this._jsonObject.put(key, value);
    }

    protected void validateKeys(String[] requiredKeys) {
        for (String requiredKey : requiredKeys) {
            if (this.has(requiredKey)) continue;
            throw new RuntimeException("Missing " + requiredKey);
        }
    }

    private void _setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name is null");
        }
        this.put("name", name);
    }
}

