/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitCommit;
import java.util.Date;
import java.util.Objects;
import org.json.JSONObject;

public abstract class BaseGitCommit
implements GitCommit {
    private final long _commitTime;
    private final String _gitRepositoryName;
    private final String _message;
    private final String _sha;
    private final GitCommit.Type _type;

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseGitCommit)) {
            return false;
        }
        return Objects.equals(this.hashCode(), object.hashCode());
    }

    @Override
    public String getAbbreviatedSHA() {
        return this._sha.substring(0, 7);
    }

    @Override
    public Date getCommitDate() {
        return new Date(this._commitTime);
    }

    @Override
    public String getGitRepositoryName() {
        return this._gitRepositoryName;
    }

    @Override
    public String getMessage() {
        return this._message;
    }

    @Override
    public String getSHA() {
        return this._sha;
    }

    @Override
    public GitCommit.Type getType() {
        return this._type;
    }

    public int hashCode() {
        String json = String.valueOf(this.toJSONObject());
        return json.hashCode();
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("commitTime", this._commitTime);
        jsonObject.put("message", (Object)this._message);
        jsonObject.put("sha", (Object)this._sha);
        return jsonObject;
    }

    protected BaseGitCommit(String gitRepositoryName, String message, String sha, GitCommit.Type type, long commitTime) {
        this._gitRepositoryName = gitRepositoryName;
        this._message = message;
        this._sha = sha;
        this._type = type;
        this._commitTime = commitTime;
    }
}

