/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.GitRepositoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseBuildDatabase
implements BuildDatabase {
    private final JSONObject _jsonObject;
    private final File _jsonObjectFile;

    @Override
    public File getBuildDatabaseJSFile() {
        File buildDatabaseJSFile = new File(this._jsonObjectFile.getParent(), "build-database.js");
        try {
            JenkinsResultsParserUtil.write(buildDatabaseJSFile, JenkinsResultsParserUtil.combine("build_database=", this._jsonObject.toString()));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return buildDatabaseJSFile;
    }

    @Override
    public JSONObject getBuildDataJSONObject(String key) {
        JSONObject buildsJSONObject = this._jsonObject.getJSONObject("builds");
        if (!buildsJSONObject.has(key)) {
            return new JSONObject();
        }
        return buildsJSONObject.getJSONObject(key);
    }

    @Override
    public JSONObject getBuildDataJSONObject(URL buildURL) {
        String buildURLString = buildURL.toString();
        JSONObject buildsJSONObject = this._jsonObject.getJSONObject("builds");
        for (Object key : buildsJSONObject.keySet()) {
            JSONObject buildJSONObject = buildsJSONObject.getJSONObject(key.toString());
            if (!buildJSONObject.has("build_url") || !buildURLString.equals(buildJSONObject.getString("build_url"))) continue;
            return buildJSONObject;
        }
        return new JSONObject();
    }

    @Override
    public Properties getProperties(String key) {
        return this.getProperties(key, null);
    }

    @Override
    public Properties getProperties(String key, Pattern pattern) {
        if (!this.hasProperties(key)) {
            throw new RuntimeException("Unable to find properties for " + key);
        }
        JSONObject propertiesJSONObject = this._jsonObject.getJSONObject("properties");
        Properties properties = new Properties();
        JSONArray propertyJSONArray = propertiesJSONObject.getJSONArray(key);
        for (int i = 0; i < propertyJSONArray.length(); ++i) {
            JSONObject propertyJSONObject = propertyJSONArray.getJSONObject(i);
            String propertyName = propertyJSONObject.getString("name");
            String propertyValue = propertyJSONObject.getString("value");
            if (pattern == null) {
                properties.setProperty(propertyName, propertyValue);
                continue;
            }
            Matcher matcher = pattern.matcher(propertyName);
            if (!matcher.matches()) continue;
            properties.setProperty(propertyName, propertyValue);
        }
        return properties;
    }

    @Override
    public WorkspaceGitRepository getWorkspaceGitRepository(String key) {
        if (!this.hasWorkspaceGitRepository(key)) {
            throw new RuntimeException("Unable to find workspace repository for " + key);
        }
        JSONObject workspaceGitRepositoriesJSONObject = this._jsonObject.getJSONObject("workspace_git_repositories");
        JSONObject workspaceGitRepositoryJSONObject = workspaceGitRepositoriesJSONObject.getJSONObject(key);
        return GitRepositoryFactory.getWorkspaceGitRepository(workspaceGitRepositoryJSONObject);
    }

    @Override
    public boolean hasBuildData(String key) {
        JSONObject buildsJSONObject = this._jsonObject.getJSONObject("builds");
        return buildsJSONObject.has(key);
    }

    @Override
    public boolean hasProperties(String key) {
        JSONObject buildsJSONObject = this._jsonObject.getJSONObject("properties");
        return buildsJSONObject.has(key);
    }

    @Override
    public boolean hasWorkspaceGitRepository(String key) {
        JSONObject workspaceGitRepositoriesJSONObject = this._jsonObject.getJSONObject("workspace_git_repositories");
        return workspaceGitRepositoriesJSONObject.has(key);
    }

    @Override
    public void putBuildData(String key, BuildData buildData) {
        JSONObject buildsJSONObject = this._jsonObject.getJSONObject("builds");
        buildsJSONObject.put(key, (Object)buildData.getJSONObject());
        this._jsonObject.put("builds", (Object)buildsJSONObject);
        this._writeJSONObjectFile();
    }

    @Override
    public void putProperties(String key, File propertiesFile) {
        this.putProperties(key, JenkinsResultsParserUtil.getProperties(propertiesFile));
    }

    @Override
    public void putProperties(String key, Properties properties) {
        JSONObject propertiesJSONObject = this._jsonObject.getJSONObject("properties");
        propertiesJSONObject.put(key, (Object)this._toJSONArray(properties));
        this._jsonObject.put("properties", (Object)propertiesJSONObject);
        this._writeJSONObjectFile();
    }

    @Override
    public void putWorkspaceGitRepository(String key, WorkspaceGitRepository workspaceGitRepository) {
        JSONObject workspaceGitRepositoriesJSONObject = this._jsonObject.getJSONObject("workspace_git_repositories");
        workspaceGitRepositoriesJSONObject.put(key, (Object)workspaceGitRepository.getJSONObject());
        this._jsonObject.put("workspace_git_repositories", (Object)workspaceGitRepositoriesJSONObject);
        this._writeJSONObjectFile();
    }

    @Override
    public void writeFilteredPropertiesToFile(String destFilePath, Pattern pattern, String key) {
        Properties properties = this.getProperties(key, pattern);
        StringBuilder sb = new StringBuilder();
        for (String propertyName : properties.stringPropertyNames()) {
            sb.append(propertyName);
            sb.append("=");
            sb.append(properties.getProperty(propertyName));
            sb.append("\n");
        }
        try {
            JenkinsResultsParserUtil.write(destFilePath, sb.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public void writePropertiesToFile(String destFilePath, String key) {
        this.writeFilteredPropertiesToFile(destFilePath, null, key);
    }

    protected BaseBuildDatabase(File baseDir) {
        this._jsonObjectFile = new File(baseDir, "build-database.json");
        this._jsonObject = this._getJSONObject();
        if (!this._jsonObject.has("builds")) {
            this._jsonObject.put("builds", (Object)new JSONObject());
        }
        if (!this._jsonObject.has("properties")) {
            this._jsonObject.put("properties", (Object)new JSONObject());
        }
        if (!this._jsonObject.has("workspace_git_repositories")) {
            this._jsonObject.put("workspace_git_repositories", (Object)new JSONObject());
        }
        this._writeJSONObjectFile();
    }

    private JSONObject _getJSONObject() {
        if (this._jsonObjectFile.exists()) {
            try {
                return new JSONObject(JenkinsResultsParserUtil.read(this._jsonObjectFile));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        return new JSONObject();
    }

    private JSONArray _toJSONArray(Properties properties) {
        JSONArray jsonArray = new JSONArray();
        int i = 0;
        for (String propertyName : properties.stringPropertyNames()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)propertyName);
            jsonObject.put("value", (Object)properties.getProperty(propertyName));
            jsonArray.put(i, (Object)jsonObject);
            ++i;
        }
        return jsonArray;
    }

    private void _writeJSONObjectFile() {
        try {
            JenkinsResultsParserUtil.write(this._jsonObjectFile, this._jsonObject.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

