/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.DefaultTestClassResult;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.JenkinsConsoleTextLoader;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobFactory;
import com.liferay.jenkins.results.parser.MultiPattern;
import com.liferay.jenkins.results.parser.NotificationUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.ReinvokeRule;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.SlaveOfflineRule;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TestResultFactory;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.URLCompareUtil;
import com.liferay.jenkins.results.parser.UpstreamFailureUtil;
import com.liferay.jenkins.results.parser.failure.message.generator.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GenericFailureMessageGenerator;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseBuild
implements Build {
    protected static final int REINVOCATIONS_SIZE_MAX = 1;
    protected static final String URL_BASE_FAILURES_JOB_UPSTREAM = "https://test-1-0.liferay.com/userContent/testResults/";
    protected static final String URL_BASE_TEMP_MAP = "http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/";
    protected static final Pattern downstreamBuildURLPattern = Pattern.compile("[\\'\\\"].*[\\'\\\"] started at (?<url>.+)\\.");
    protected static final Pattern invocationURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\w+://(?<master>[^/]+)/+job/+(?<jobName>[^/]+).*/", "buildWithParameters\\?(?<queryString>.*)"));
    protected static final Pattern jobNamePattern = Pattern.compile("(?<baseJob>[^\\(]+)\\((?<branchName>[^\\)]+)\\)");
    protected static final Pattern stopWatchPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\s*\\[stopwatch\\]\\s*\\[(?<name>[^:]+): ", "((?<minutes>\\d+):)?((?<seconds>\\d+))?\\.", "(?<milliseconds>\\d+) sec\\]"));
    protected static final Pattern stopWatchStartTimestampPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\s*\\[echo\\] (?<name>.*)\\.start\\.timestamp: ", "(?<timestamp>.*)$"));
    protected static final SimpleDateFormat stopWatchTimestampSimpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss:SSS z");
    protected String archiveName;
    protected List<Integer> badBuildNumbers = new ArrayList<Integer>();
    protected String branchName;
    protected int consoleReadCursor;
    protected List<Build> downstreamBuilds = new ArrayList<Build>();
    protected boolean fromArchive;
    protected boolean fromCompletedBuild;
    protected String gitRepositoryName;
    protected Long invokedTime;
    protected String jobName;
    protected List<ReinvokeRule> reinvokeRules = ReinvokeRule.getReinvokeRules();
    protected List<SlaveOfflineRule> slaveOfflineRules = SlaveOfflineRule.getSlaveOfflineRules();
    protected Long startTime;
    protected Map<String, Long> statusDurations = new HashMap<String, Long>();
    protected long statusModifiedTime;
    protected int stopWatchRecordConsoleReadCursor;
    protected StopWatchRecordsGroup stopWatchRecordsGroup = new StopWatchRecordsGroup();
    protected Element upstreamJobFailureMessageElement;
    private static final FailureMessageGenerator[] _FAILURE_MESSAGE_GENERATORS = new FailureMessageGenerator[]{new GenericFailureMessageGenerator()};
    private static final String _NAME_JENKINS_REPORT_TIME_ZONE;
    private static final int _PIXELS_WIDTH_EXPANDER = 20;
    private static final int _PIXELS_WIDTH_INDENT = 35;
    private static final String[] _TOKENS_HIGH_PRIORITY_CONTENT;
    private static final Pattern _archiveBuildURLPattern;
    private static final MultiPattern _buildURLMultiPattern;
    private final Map<String, Build.BranchInformation> _branchInformationMap = new HashMap<String, Build.BranchInformation>();
    private String _buildDescription;
    private int _buildNumber = -1;
    private JenkinsConsoleTextLoader _jenkinsConsoleTextLoader;
    private JenkinsMaster _jenkinsMaster;
    private JenkinsSlave _jenkinsSlave;
    private Job _job;
    private Properties _jobProperties;
    private Map<String, String> _parameters = new HashMap<String, String>();
    private final Build _parentBuild;
    private String _previousStatus;
    private String _result;
    private String _status;
    private List<TestClassResult> _testClassResults;

    @Override
    public void addDownstreamBuilds(String ... urls) {
        final BaseBuild thisBuild = this;
        ArrayList callables = new ArrayList(urls.length);
        for (String url : urls) {
            try {
                url = JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.decode(url));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException("Unable to decode " + url, unsupportedEncodingException);
            }
            if (this.hasBuildURL(url)) continue;
            final String buildURL = url;
            Callable<Build> callable = new Callable<Build>(){

                @Override
                public Build call() {
                    return BuildFactory.newBuild(buildURL, thisBuild);
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, this.getExecutorService());
        this.downstreamBuilds.addAll(parallelExecutor.execute());
    }

    public abstract void addTimelineData(TimelineData var1);

    @Override
    public void archive(final String archiveName) {
        if (!this._status.equals("completed")) {
            throw new RuntimeException("Invalid build status: " + this._status);
        }
        this.archiveName = archiveName;
        File archiveDir = new File(this.getArchivePath());
        if (archiveDir.exists()) {
            archiveDir.delete();
        }
        if (this.downstreamBuilds != null) {
            ArrayList callables = new ArrayList(this.downstreamBuilds.size());
            for (final Build downstreamBuild : this.downstreamBuilds) {
                Callable<Object> callable = new Callable<Object>(){

                    @Override
                    public Object call() {
                        downstreamBuild.archive(archiveName);
                        return null;
                    }
                };
                callables.add(callable);
            }
            ParallelExecutor parallelExecutor = new ParallelExecutor(callables, this.getExecutorService());
            parallelExecutor.execute();
        }
        try {
            this.writeArchiveFile(String.valueOf(System.currentTimeMillis()), this.getArchivePath() + "/archive-marker");
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to to write archive-marker file", ioException);
        }
        this.archiveConsoleLog();
        this.archiveJSON();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseBuild)) {
            return false;
        }
        BaseBuild baseBuild = (BaseBuild)object;
        return Objects.equals(this.getBuildURL(), baseBuild.getBuildURL());
    }

    @Override
    public String getAppServer() {
        return null;
    }

    @Override
    public String getArchivePath() {
        StringBuilder sb = new StringBuilder(this.archiveName);
        if (!this.archiveName.endsWith("/")) {
            sb.append("/");
        }
        sb.append(this._jenkinsMaster.getName());
        sb.append("/");
        sb.append(this.getJobName());
        sb.append("/");
        sb.append(this.getBuildNumber());
        return sb.toString();
    }

    @Override
    public long getAverageDelayTime() {
        if (this.getDownstreamBuildCount(null) == 0) {
            return 0L;
        }
        List<Build> allDownstreamBuilds = JenkinsResultsParserUtil.flatten(this.getDownstreamBuilds(null));
        if (allDownstreamBuilds.isEmpty()) {
            return 0L;
        }
        long totalDelayTime = 0L;
        for (Build downstreamBuild : allDownstreamBuilds) {
            totalDelayTime += downstreamBuild.getDelayTime().longValue();
        }
        return totalDelayTime / (long)allDownstreamBuilds.size();
    }

    @Override
    public List<String> getBadBuildURLs() {
        ArrayList<String> badBuildURLs = new ArrayList<String>();
        String jobURL = this.getJobURL();
        for (Integer badBuildNumber : this.badBuildNumbers) {
            badBuildURLs.add(JenkinsResultsParserUtil.combine(jobURL, "/", String.valueOf(badBuildNumber), "/"));
        }
        return badBuildURLs;
    }

    @Override
    public String getBaseGitRepositoryName() {
        if (this.gitRepositoryName == null) {
            Properties buildProperties = null;
            try {
                buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to get build.properties", ioException);
            }
            TopLevelBuild topLevelBuild = this.getTopLevelBuild();
            this.gitRepositoryName = topLevelBuild.getParameterValue("REPOSITORY_NAME");
            if (this.gitRepositoryName != null && !this.gitRepositoryName.isEmpty()) {
                return this.gitRepositoryName;
            }
            this.gitRepositoryName = buildProperties.getProperty(JenkinsResultsParserUtil.combine("repository[", topLevelBuild.getJobName(), "]"));
            if (this.gitRepositoryName == null) {
                throw new RuntimeException("Unable to get Git repository name for job " + topLevelBuild.getJobName());
            }
        }
        return this.gitRepositoryName;
    }

    @Override
    public String getBaseGitRepositorySHA(String gitRepositoryName) {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (gitRepositoryName.equals("liferay-jenkins-ee")) {
            Map<String, String> topLevelBuildStartPropertiesTempMap = topLevelBuild.getStartPropertiesTempMap();
            return topLevelBuildStartPropertiesTempMap.get("JENKINS_GITHUB_UPSTREAM_BRANCH_SHA");
        }
        Map<String, String> gitRepositoryGitDetailsTempMap = topLevelBuild.getBaseGitRepositoryDetailsTempMap();
        return gitRepositoryGitDetailsTempMap.get("github.upstream.branch.sha");
    }

    @Override
    public String getBranchName() {
        return this.branchName;
    }

    @Override
    public String getBrowser() {
        return null;
    }

    @Override
    public String getBuildDescription() {
        if (this._buildDescription == null && this.getBuildURL() != null) {
            JSONObject descriptionJSONObject = this.getBuildJSONObject("description");
            String description = descriptionJSONObject.optString("description");
            if (description.equals("")) {
                description = null;
            }
            this._buildDescription = description;
        }
        return this._buildDescription;
    }

    @Override
    public JSONObject getBuildJSONObject() {
        try {
            return JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(this.getBuildURL() + "api/json"), false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build JSON object", ioException);
        }
    }

    @Override
    public int getBuildNumber() {
        return this._buildNumber;
    }

    @Override
    public String getBuildURL() {
        String jobURL = this.getJobURL();
        if (jobURL == null || this._buildNumber == -1) {
            return null;
        }
        if (this.fromArchive) {
            return jobURL + "/" + this._buildNumber + "/";
        }
        try {
            jobURL = JenkinsResultsParserUtil.decode(jobURL);
            return JenkinsResultsParserUtil.encode(jobURL + "/" + this._buildNumber + "/");
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new RuntimeException("Unable to encode build URL", exception);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to decode job URL " + jobURL, unsupportedEncodingException);
        }
    }

    @Override
    public String getBuildURLRegex() {
        StringBuffer sb = new StringBuffer();
        sb.append("http[s]*:\\/\\/");
        sb.append(JenkinsResultsParserUtil.getRegexLiteral(this._jenkinsMaster.getName()));
        sb.append("[^\\/]*");
        sb.append("[\\/]+job[\\/]+");
        String jobNameRegexLiteral = JenkinsResultsParserUtil.getRegexLiteral(this.getJobName());
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\(", "(\\(|%28)");
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\)", "(\\)|%29)");
        sb.append(jobNameRegexLiteral);
        sb.append("[\\/]+");
        sb.append(this.getBuildNumber());
        sb.append("[\\/]*");
        return sb.toString();
    }

    @Override
    public String getConsoleText() {
        String buildURL = this.getBuildURL();
        if (buildURL == null) {
            return "";
        }
        if (this._jenkinsConsoleTextLoader == null) {
            this._jenkinsConsoleTextLoader = new JenkinsConsoleTextLoader(this.getBuildURL());
        }
        return this._jenkinsConsoleTextLoader.getConsoleText();
    }

    @Override
    public String getDatabase() {
        return null;
    }

    @Override
    public Long getDelayTime() {
        Long invokedTime;
        Long startTime = this.getStartTime();
        long currentTime = System.currentTimeMillis();
        if (startTime == null) {
            startTime = currentTime;
        }
        if ((invokedTime = this.getInvokedTime()) == null) {
            invokedTime = currentTime;
        }
        return startTime - invokedTime;
    }

    @Override
    public int getDepth() {
        Build parentBuild = this.getParentBuild();
        if (parentBuild == null) {
            return 0;
        }
        return parentBuild.getDepth() + 1;
    }

    @Override
    public String getDisplayName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJobName());
        String jobVariant = this.getParameterValue("JOB_VARIANT");
        if (jobVariant != null && !jobVariant.isEmpty()) {
            sb.append("/");
            sb.append(jobVariant);
        }
        return sb.toString();
    }

    @Override
    public int getDownstreamBuildCount(String status) {
        return this.getDownstreamBuildCount(null, status);
    }

    @Override
    public int getDownstreamBuildCount(String result, String status) {
        List<Build> downstreamBuilds = this.getDownstreamBuilds(result, status);
        return downstreamBuilds.size();
    }

    @Override
    public List<Build> getDownstreamBuilds(String status) {
        return this.getDownstreamBuilds(null, status);
    }

    @Override
    public List<Build> getDownstreamBuilds(String result, String status) {
        if (result == null && status == null) {
            return this.downstreamBuilds;
        }
        List<Build> filteredDownstreamBuilds = Collections.synchronizedList(new ArrayList());
        for (Build downstreamBuild : this.downstreamBuilds) {
            if (status != null && !status.equals(downstreamBuild.getStatus()) || result != null && !result.equals(downstreamBuild.getResult())) continue;
            filteredDownstreamBuilds.add(downstreamBuild);
        }
        return filteredDownstreamBuilds;
    }

    @Override
    public long getDuration() {
        JSONObject buildJSONObject = this.getBuildJSONObject("duration,timestamp");
        if (buildJSONObject == null) {
            return 0L;
        }
        long duration = buildJSONObject.getLong("duration");
        if (duration == 0L) {
            long timestamp = buildJSONObject.getLong("timestamp");
            duration = System.currentTimeMillis() - timestamp;
        }
        return duration;
    }

    @Override
    public Element getGitHubMessageBuildAnchorElement() {
        this.getResult();
        int i = 0;
        String result = this.getResult();
        while (result == null) {
            if (i == 20) {
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to create build anchor element. The process ", "timed out while waiting for a build result for ", this.getBuildURL(), "."));
            }
            JenkinsResultsParserUtil.sleep(30000L);
            result = this.getResult();
            ++i;
        }
        if (this._result.equals("SUCCESS")) {
            return Dom4JUtil.getNewAnchorElement(this.getBuildURL(), this.getDisplayName());
        }
        return Dom4JUtil.getNewAnchorElement(this.getBuildURL(), null, Dom4JUtil.getNewElement("strike", null, Dom4JUtil.getNewElement("strong", null, this.getDisplayName())));
    }

    @Override
    public Element getGitHubMessageElement() {
        return this.getGitHubMessageElement(false);
    }

    public Element getGitHubMessageElement(boolean showCommonFailuresCount) {
        String status = this.getStatus();
        if (!status.equals("completed") && this.getParentBuild() != null) {
            return null;
        }
        String result = this.getResult();
        if (result.equals("SUCCESS")) {
            return null;
        }
        Element messageElement = Dom4JUtil.getNewElement("div");
        Dom4JUtil.addToElement(messageElement, Dom4JUtil.getNewElement("h5", null, Dom4JUtil.getNewAnchorElement(this.getBuildURL(), this.getDisplayName())));
        if (showCommonFailuresCount) {
            Dom4JUtil.addToElement(messageElement, this.getGitHubMessageJobResultsElement(showCommonFailuresCount));
        } else {
            Dom4JUtil.addToElement(messageElement, this.getGitHubMessageJobResultsElement());
        }
        if (result.equals("ABORTED") && this.getDownstreamBuildCount(null) == 0) {
            messageElement.add(Dom4JUtil.toCodeSnippetElement("Build was aborted"));
            return messageElement;
        }
        Element failureMessageElement = this.getFailureMessageElement();
        if (failureMessageElement != null) {
            messageElement.add(failureMessageElement);
        }
        return messageElement;
    }

    @Override
    public Element getGitHubMessageUpstreamJobFailureElement() {
        return this.upstreamJobFailureMessageElement;
    }

    @Override
    public String getInvocationURL() {
        String jobURL = this.getJobURL();
        if (jobURL == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(jobURL);
        sb.append("/buildWithParameters?");
        HashMap<String, String> parameters = new HashMap<String, String>(this.getParameters());
        try {
            parameters.put("token", JenkinsResultsParserUtil.getBuildProperty("jenkins.authentication.token"));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get Jenkins authentication token", ioException);
        }
        for (Map.Entry parameter : parameters.entrySet()) {
            sb.append((String)parameter.getKey());
            sb.append("=");
            sb.append((String)parameter.getValue());
            sb.append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        try {
            return JenkinsResultsParserUtil.encode(sb.toString());
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new RuntimeException("Unable to encode URL " + sb.toString(), exception);
        }
    }

    @Override
    public Long getInvokedTime() {
        if (this.invokedTime != null) {
            return this.invokedTime;
        }
        this.invokedTime = this.getStartTime();
        return this.invokedTime;
    }

    @Override
    public String getJDK() {
        return null;
    }

    @Override
    public JenkinsMaster getJenkinsMaster() {
        return this._jenkinsMaster;
    }

    @Override
    public JenkinsSlave getJenkinsSlave() {
        if (this._jenkinsSlave != null) {
            return this._jenkinsSlave;
        }
        String buildURL = this.getBuildURL();
        if (buildURL == null || this._jenkinsMaster == null) {
            return null;
        }
        JSONObject builtOnJSONObject = this.getBuildJSONObject("builtOn");
        String slaveName = builtOnJSONObject.optString("builtOn");
        if (slaveName.equals("")) {
            slaveName = "master";
        }
        return this._jenkinsMaster.getJenkinsSlave(slaveName);
    }

    @Override
    public Job getJob() {
        String branchName;
        Map<String, String> buildParameters;
        String buildProfile;
        if (this._job != null) {
            return this._job;
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        String topLevelJobName = topLevelBuild.getJobName();
        String repositoryName = null;
        if (topLevelJobName.contains("subrepository")) {
            repositoryName = topLevelBuild.getBaseGitRepositoryName();
        }
        if ((buildProfile = (buildParameters = topLevelBuild.getParameters()).get("TEST_PORTAL_BUILD_PROFILE")) == null || !buildProfile.equals("dxp")) {
            buildProfile = "portal";
        }
        if ((branchName = topLevelBuild.getBranchName()).startsWith("ee-")) {
            buildProfile = "portal";
        }
        this._job = JobFactory.newJob(topLevelJobName, topLevelBuild.getTestSuiteName(), topLevelBuild.getBranchName(), repositoryName, Job.BuildProfile.valueOf(buildProfile.toUpperCase()));
        return this._job;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public Properties getJobProperties() {
        if (this._jobProperties != null) {
            return this._jobProperties;
        }
        Job job = this.getJob();
        this._jobProperties = job.getJobProperties();
        return this._jobProperties;
    }

    @Override
    public String getJobURL() {
        if (this._jenkinsMaster == null || this.jobName == null) {
            return null;
        }
        if (this.fromArchive) {
            return JenkinsResultsParserUtil.combine("${dependencies.url}/", this.archiveName, "/", this._jenkinsMaster.getName(), "/", this.jobName);
        }
        String jobURL = JenkinsResultsParserUtil.combine("https://", this._jenkinsMaster.getName(), ".liferay.com/job/", this.jobName);
        try {
            return JenkinsResultsParserUtil.encode(jobURL);
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new RuntimeException("Unable to encode job URL " + jobURL, exception);
        }
    }

    @Override
    public String getJobVariant() {
        String jobVariant = this.getParameterValue("JOB_VARIANT");
        if (jobVariant == null || jobVariant.isEmpty()) {
            jobVariant = this.getParameterValue("JENKINS_JOB_VARIANT");
        }
        return jobVariant;
    }

    @Override
    public int getJobVariantsDownstreamBuildCount(List<String> jobVariants, String result, String status) {
        List<Build> jobVariantsDownstreamBuilds = this.getJobVariantsDownstreamBuilds(jobVariants, result, status);
        return jobVariantsDownstreamBuilds.size();
    }

    @Override
    public List<Build> getJobVariantsDownstreamBuilds(Iterable<String> jobVariants, String result, String status) {
        ArrayList<Build> jobVariantsDownstreamBuilds = new ArrayList<Build>();
        List<Build> downstreamBuilds = this.getDownstreamBuilds(result, status);
        block0: for (Build downstreamBuild : downstreamBuilds) {
            String downstreamBuildJobVariant = downstreamBuild.getJobVariant();
            for (String jobVariant : jobVariants) {
                if (!downstreamBuildJobVariant.startsWith(jobVariant)) continue;
                jobVariantsDownstreamBuilds.add(downstreamBuild);
                continue block0;
            }
        }
        return jobVariantsDownstreamBuilds;
    }

    @Override
    public Long getLatestStartTimestamp() {
        Long latestStartTimestamp = this.getStartTime();
        if (latestStartTimestamp == null) {
            return null;
        }
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            Long downstreamBuildLatestStartTimestamp = downstreamBuild.getLatestStartTimestamp();
            if (downstreamBuildLatestStartTimestamp == null) {
                return null;
            }
            latestStartTimestamp = Math.max(latestStartTimestamp, downstreamBuild.getLatestStartTimestamp());
        }
        return latestStartTimestamp;
    }

    @Override
    public Build getLongestDelayedDownstreamBuild() {
        List<Build> downstreamBuilds = this.getDownstreamBuilds(null);
        if (downstreamBuilds.isEmpty()) {
            return this;
        }
        Build longestDelayedBuild = downstreamBuilds.get(0);
        for (Build downstreamBuild : downstreamBuilds) {
            Build longestDelayedDownstreamBuild = downstreamBuild.getLongestDelayedDownstreamBuild();
            if (downstreamBuild.getDelayTime() > longestDelayedDownstreamBuild.getDelayTime()) {
                longestDelayedDownstreamBuild = downstreamBuild;
            }
            if (longestDelayedDownstreamBuild.getDelayTime() <= longestDelayedBuild.getDelayTime()) continue;
            longestDelayedBuild = longestDelayedDownstreamBuild;
        }
        return longestDelayedBuild;
    }

    @Override
    public Build getLongestRunningDownstreamBuild() {
        Build longestRunningDownstreamBuild = null;
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            if (longestRunningDownstreamBuild != null && downstreamBuild.getDuration() <= longestRunningDownstreamBuild.getDuration()) continue;
            longestRunningDownstreamBuild = downstreamBuild;
        }
        return longestRunningDownstreamBuild;
    }

    @Override
    public TestResult getLongestRunningTest() {
        List<TestResult> testResults = this.getTestResults(null);
        long longestTestDuration = 0L;
        TestResult longestRunningTest = null;
        for (TestResult testResult : testResults) {
            long testDuration = testResult.getDuration();
            if (testDuration <= longestTestDuration) continue;
            longestTestDuration = testDuration;
            longestRunningTest = testResult;
        }
        return longestRunningTest;
    }

    @Override
    public Map<String, String> getMetricLabels() {
        if (this._parentBuild != null) {
            return this._parentBuild.getMetricLabels();
        }
        return new TreeMap<String, String>();
    }

    @Override
    public List<Build> getModifiedDownstreamBuilds() {
        return this.getModifiedDownstreamBuildsByStatus(null);
    }

    @Override
    public List<Build> getModifiedDownstreamBuildsByStatus(String status) {
        ArrayList<Build> modifiedDownstreamBuilds = new ArrayList<Build>();
        for (Build downstreamBuild : this.downstreamBuilds) {
            if (!downstreamBuild.isBuildModified() && !downstreamBuild.hasModifiedDownstreamBuilds()) continue;
            modifiedDownstreamBuilds.add(downstreamBuild);
        }
        if (status != null) {
            modifiedDownstreamBuilds.retainAll(this.getDownstreamBuilds(status));
        }
        return modifiedDownstreamBuilds;
    }

    @Override
    public String getOperatingSystem() {
        return null;
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this._parameters);
    }

    @Override
    public String getParameterValue(String name) {
        return this._parameters.get(name);
    }

    @Override
    public Build getParentBuild() {
        return this._parentBuild;
    }

    public long getQueuingDuration() {
        JSONObject buildJSONObject = this.getBuildJSONObject("actions[queuingDurationMillis]");
        JSONArray actionsJSONArray = buildJSONObject.getJSONArray("actions");
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionJSONObject;
            Object actions = actionsJSONArray.get(i);
            if (actions == JSONObject.NULL || !(actionJSONObject = actionsJSONArray.getJSONObject(i)).has("queuingDurationMillis")) continue;
            return actionJSONObject.getLong("queuingDurationMillis");
        }
        return 0L;
    }

    @Override
    public String getResult() {
        if (this._result == null && this.getBuildURL() != null) {
            JSONObject resultJSONObject = this.getBuildJSONObject("result");
            String result = resultJSONObject.optString("result");
            if (result.equals("")) {
                result = null;
            }
            this.setResult(result);
        }
        return this._result;
    }

    @Override
    public Map<String, String> getStartPropertiesTempMap() {
        return this.getTempMap("start.properties");
    }

    @Override
    public Long getStartTime() {
        if (this.startTime != null) {
            return this.startTime;
        }
        JSONObject buildJSONObject = this.getBuildJSONObject("timestamp");
        if (buildJSONObject == null) {
            return null;
        }
        long timestamp = buildJSONObject.getLong("timestamp");
        if (timestamp != 0L) {
            this.startTime = timestamp;
        }
        return this.startTime;
    }

    @Override
    public String getStatus() {
        return this._status;
    }

    @Override
    public long getStatusAge() {
        return System.currentTimeMillis() - this.statusModifiedTime;
    }

    @Override
    public long getStatusDuration(String status) {
        if (this.statusDurations.containsKey(status)) {
            return this.statusDurations.get(status);
        }
        return 0L;
    }

    @Override
    public String getStatusReport() {
        return this.getStatusReport(0);
    }

    @Override
    public String getStatusReport(int indentSize) {
        StringBuffer indentStringBuffer = new StringBuffer();
        for (int i = 0; i < indentSize; ++i) {
            indentStringBuffer.append(" ");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indentStringBuffer);
        sb.append("Build \"");
        sb.append(this.jobName);
        sb.append("\"");
        String status = this.getStatus();
        if (status.equals("completed")) {
            sb.append(" completed at ");
            sb.append(this.getBuildURL());
            sb.append(". ");
            sb.append(this.getResult());
            return sb.toString();
        }
        if (status.equals("missing")) {
            sb.append(" is missing ");
            sb.append(this.getJobURL());
            sb.append(".");
            return sb.toString();
        }
        if (status.equals("queued")) {
            sb.append(" is queued at ");
            sb.append(this.getJobURL());
            sb.append(".");
            return sb.toString();
        }
        if (status.equals("running")) {
            sb.append(" running at ");
            sb.append(this.getBuildURL());
            sb.append(".\n");
            if (this.getDownstreamBuildCount(null) > 0) {
                sb.append("\n");
                for (Build downstreamBuild : this.getDownstreamBuilds("running")) {
                    sb.append(downstreamBuild.getStatusReport(indentSize + 4));
                }
                sb.append("\n");
                sb.append(indentStringBuffer);
                sb.append(this.getStatusSummary());
                sb.append("\n");
            }
            return sb.toString();
        }
        if (status.equals("starting")) {
            sb.append(" invoked at ");
            sb.append(this.getJobURL());
            sb.append(".");
            return sb.toString();
        }
        throw new RuntimeException("Unknown status: " + status);
    }

    @Override
    public String getStatusSummary() {
        return JenkinsResultsParserUtil.combine(String.valueOf(this.getDownstreamBuildCount("starting")), " Starting  ", "/ ", String.valueOf(this.getDownstreamBuildCount("missing")), " Missing  ", "/ ", String.valueOf(this.getDownstreamBuildCount("queued")), " Queued  ", "/ ", String.valueOf(this.getDownstreamBuildCount("running")), " Running  ", "/ ", String.valueOf(this.getDownstreamBuildCount("completed")), " Completed  ", "/ ", String.valueOf(this.getDownstreamBuildCount(null)), " Total ");
    }

    @Override
    public Map<String, String> getStopPropertiesTempMap() {
        return this.getTempMap("stop.properties");
    }

    @Override
    public List<TestClassResult> getTestClassResults() {
        if (this._testClassResults != null) {
            return this._testClassResults;
        }
        List<TestResult> buildTestResults = this.getTestResults(null);
        if (buildTestResults.isEmpty()) {
            return new ArrayList<TestClassResult>();
        }
        HashMap<String, List> testClassResultsMap = new HashMap<String, List>();
        for (TestResult testResult : buildTestResults) {
            String testClassName = testResult.getClassName();
            List testResults = testClassResultsMap.getOrDefault(testClassName, new ArrayList());
            testResults.add(testResult);
            testClassResultsMap.put(testClassName, testResults);
        }
        this._testClassResults = new ArrayList<TestClassResult>();
        for (List testResults : testClassResultsMap.values()) {
            this._testClassResults.add(new DefaultTestClassResult(testResults));
        }
        return this._testClassResults;
    }

    @Override
    public JSONObject getTestReportJSONObject(boolean checkCache) {
        try {
            return JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(this.getBuildURL() + "testReport/api/json"), checkCache);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get test report JSON object", ioException);
        }
    }

    public List<TestResult> getTestResults(Build build, JSONArray suitesJSONArray, String testStatus) {
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (int i = 0; i < suitesJSONArray.length(); ++i) {
            JSONObject suiteJSONObject = suitesJSONArray.getJSONObject(i);
            JSONArray casesJSONArray = suiteJSONObject.getJSONArray("cases");
            for (int j = 0; j < casesJSONArray.length(); ++j) {
                TestResult testResult = TestResultFactory.newTestResult(build, casesJSONArray.getJSONObject(j));
                if (testStatus != null && !testStatus.equals(testResult.getStatus())) continue;
                testResults.add(testResult);
            }
        }
        return testResults;
    }

    @Override
    public List<TestResult> getTestResults(String testStatus) {
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            List<TestResult> downstreamTestResults = downstreamBuild.getTestResults(testStatus);
            if (downstreamTestResults == null) continue;
            testResults.addAll(downstreamTestResults);
        }
        return testResults;
    }

    @Override
    public String getTestSuiteName() {
        Build parentBuild = this.getParentBuild();
        if (parentBuild == null) {
            return "default";
        }
        return parentBuild.getTestSuiteName();
    }

    @Override
    public TopLevelBuild getTopLevelBuild() {
        Build topLevelBuild;
        for (topLevelBuild = this; topLevelBuild != null && !(topLevelBuild instanceof TopLevelBuild); topLevelBuild = topLevelBuild.getParentBuild()) {
        }
        return (TopLevelBuild)topLevelBuild;
    }

    @Override
    public long getTotalDuration() {
        long totalDuration = this.getDuration();
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            totalDuration += downstreamBuild.getTotalDuration();
        }
        return totalDuration;
    }

    @Override
    public int getTotalSlavesUsedCount() {
        return this.getTotalSlavesUsedCount(null, false);
    }

    @Override
    public int getTotalSlavesUsedCount(String status, boolean modifiedBuildsOnly) {
        return this.getTotalSlavesUsedCount(status, modifiedBuildsOnly, false);
    }

    @Override
    public int getTotalSlavesUsedCount(String status, boolean modifiedBuildsOnly, boolean ignoreCurrentBuild) {
        int totalSlavesUsedCount = 1;
        if (ignoreCurrentBuild || modifiedBuildsOnly && !this.isBuildModified() || status != null && !this._status.equals(status)) {
            totalSlavesUsedCount = 0;
        }
        List<Build> downstreamBuilds = modifiedBuildsOnly ? this.getModifiedDownstreamBuildsByStatus(status) : this.getDownstreamBuilds(status);
        for (Build downstreamBuild : downstreamBuilds) {
            totalSlavesUsedCount += downstreamBuild.getTotalSlavesUsedCount(status, modifiedBuildsOnly);
        }
        return totalSlavesUsedCount;
    }

    @Override
    public List<TestResult> getUniqueFailureTestResults() {
        ArrayList<TestResult> uniqueFailureTestResults = new ArrayList<TestResult>();
        for (Build downstreamBuild : this.getFailedDownstreamBuilds()) {
            uniqueFailureTestResults.addAll(downstreamBuild.getUniqueFailureTestResults());
        }
        return uniqueFailureTestResults;
    }

    @Override
    public List<TestResult> getUpstreamJobFailureTestResults() {
        ArrayList<TestResult> upstreamFailureTestResults = new ArrayList<TestResult>();
        for (Build downstreamBuild : this.getFailedDownstreamBuilds()) {
            upstreamFailureTestResults.addAll(downstreamBuild.getUpstreamJobFailureTestResults());
        }
        return upstreamFailureTestResults;
    }

    @Override
    public boolean hasBuildURL(String buildURL) {
        try {
            buildURL = JenkinsResultsParserUtil.decode(buildURL);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to decode " + buildURL, unsupportedEncodingException);
        }
        buildURL = JenkinsResultsParserUtil.getLocalURL(buildURL);
        String thisBuildURL = this.getBuildURL();
        if (thisBuildURL != null) {
            thisBuildURL = JenkinsResultsParserUtil.getLocalURL(thisBuildURL);
            try {
                if (URLCompareUtil.matches(new URL(buildURL), new URL(thisBuildURL))) {
                    return true;
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to compare urls ", buildURL, " and ", thisBuildURL), malformedURLException);
            }
        }
        for (Build downstreamBuild : this.downstreamBuilds) {
            if (!downstreamBuild.hasBuildURL(buildURL)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGenericCIFailure() {
        for (FailureMessageGenerator failureMessageGenerator : this.getFailureMessageGenerators()) {
            Element failureMessage = failureMessageGenerator.getMessageElement(this);
            if (failureMessage == null) continue;
            return failureMessageGenerator.isGenericCIFailure();
        }
        return false;
    }

    public int hashCode() {
        String key = this.getBuildURL();
        if (key != null) {
            return key.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public boolean hasModifiedDownstreamBuilds() {
        for (Build downstreamBuild : this.downstreamBuilds) {
            if (!downstreamBuild.isBuildModified() && !downstreamBuild.hasModifiedDownstreamBuilds()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBuildModified() {
        return !this._status.equals(this._previousStatus);
    }

    @Override
    public boolean isCompareToUpstream() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        return topLevelBuild.isCompareToUpstream();
    }

    @Override
    public boolean isFromArchive() {
        return this.fromArchive;
    }

    @Override
    public boolean isFromCompletedBuild() {
        return this.fromCompletedBuild;
    }

    @Override
    public boolean isUniqueFailure() {
        return !UpstreamFailureUtil.isBuildFailingInUpstreamJob(this);
    }

    @Override
    public void reinvoke() {
        this.reinvoke(null);
    }

    @Override
    public void reinvoke(ReinvokeRule reinvokeRule) {
        if (this.badBuildNumbers.size() >= 1) {
            return;
        }
        Build parentBuild = this.getParentBuild();
        String parentBuildStatus = parentBuild.getStatus();
        if (!parentBuildStatus.equals("running") || !JenkinsResultsParserUtil.isCINode()) {
            return;
        }
        if (reinvokeRule != null && !this.fromArchive) {
            String notificationRecipients;
            String message = JenkinsResultsParserUtil.combine(reinvokeRule.getName(), " failure detected at ", this.getBuildURL(), ". This build will be reinvoked.\n\n", reinvokeRule.toString(), "\n\n");
            System.out.println(message);
            TopLevelBuild topLevelBuild = this.getTopLevelBuild();
            if (topLevelBuild != null) {
                message = JenkinsResultsParserUtil.combine(message, "Top Level Build URL: ", topLevelBuild.getBuildURL());
            }
            if ((notificationRecipients = reinvokeRule.getNotificationRecipients()) != null && !notificationRecipients.isEmpty()) {
                NotificationUtil.sendEmail(message, "jenkins", "Build Reinvoked", reinvokeRule.notificationRecipients);
            }
        }
        String invocationURL = this.getInvocationURL();
        try {
            JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(invocationURL));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        System.out.println(this.getReinvokedMessage());
        this.reset();
    }

    @Override
    public String replaceBuildURL(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (this.downstreamBuilds != null) {
            Iterator<Build> iterator = this.downstreamBuilds.iterator();
            while (iterator.hasNext()) {
                Build downstreamBuild;
                Build downstreamBaseBuild = downstreamBuild = iterator.next();
                text = downstreamBaseBuild.replaceBuildURL(text);
            }
        }
        text = text.replaceAll(this.getBuildURLRegex(), Matcher.quoteReplacement("${dependencies.url}/" + this.getArchivePath()));
        for (Build parentBuild = this.getParentBuild(); parentBuild != null; parentBuild = parentBuild.getParentBuild()) {
            text = text.replaceAll(parentBuild.getBuildURLRegex(), Matcher.quoteReplacement("${dependencies.url}/" + parentBuild.getArchivePath()));
        }
        return text;
    }

    @Override
    public void setCompareToUpstream(boolean compareToUpstream) {
    }

    @Override
    public void takeSlaveOffline(SlaveOfflineRule slaveOfflineRule) {
        if (slaveOfflineRule == null || this.fromArchive) {
            return;
        }
        String pinnedMessage = "";
        if (!slaveOfflineRule.shutdown) {
            pinnedMessage = "PINNED\n";
        }
        JenkinsSlave jenkinsSlave = this.getJenkinsSlave();
        String message = JenkinsResultsParserUtil.combine(pinnedMessage, slaveOfflineRule.getName(), " failure detected at ", this.getBuildURL(), ". ", jenkinsSlave.getName(), " will be taken offline.\n\n", slaveOfflineRule.toString(), "\n\n\nOffline Slave URL: https://", this._jenkinsMaster.getName(), ".liferay.com/computer/", jenkinsSlave.getName(), "\n");
        System.out.println(message);
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild != null) {
            message = JenkinsResultsParserUtil.combine(message, "Top Level Build URL: ", topLevelBuild.getBuildURL());
        }
        jenkinsSlave.takeSlavesOffline(message);
        String notificationRecipients = slaveOfflineRule.getNotificationRecipients();
        if (notificationRecipients != null && !notificationRecipients.isEmpty()) {
            NotificationUtil.sendEmail(message, "jenkins", "Slave Offline", slaveOfflineRule.notificationRecipients);
        }
    }

    @Override
    public synchronized void update() {
        block17: {
            String status = this.getStatus();
            if (status.equals("completed") && (this.isBuildModified() || this.hasModifiedDownstreamBuilds()) || !status.equals("completed")) {
                this._previousStatus = this._status;
                try {
                    if (status.equals("missing") || status.equals("queued") || status.equals("starting")) {
                        JSONObject runningBuildJSONObject = this.getRunningBuildJSONObject();
                        if (runningBuildJSONObject != null) {
                            this.setBuildNumber(runningBuildJSONObject.getInt("number"));
                        } else {
                            JSONObject queueItemJSONObject = this.getQueueItemJSONObject();
                            if (status.equals("starting") && queueItemJSONObject != null) {
                                this.setStatus("queued");
                            } else if (status.equals("queued") && queueItemJSONObject == null) {
                                this.setStatus("missing");
                            }
                        }
                    }
                    if (this.downstreamBuilds == null) break block17;
                    ArrayList callables = new ArrayList();
                    for (final Build downstreamBuild : this.downstreamBuilds) {
                        Callable<Object> callable = new Callable<Object>(){

                            @Override
                            public Object call() {
                                downstreamBuild.update();
                                return null;
                            }
                        };
                        callables.add(callable);
                    }
                    ParallelExecutor parallelExecutor = new ParallelExecutor(callables, this.getExecutorService());
                    parallelExecutor.execute();
                    String result = this.getResult();
                    if (this.downstreamBuilds.size() == this.getDownstreamBuildCount("completed") && result != null) {
                        this.setResult(result);
                    }
                    this.findDownstreamBuilds();
                    if (result == null || result.equals("SUCCESS")) {
                        return;
                    }
                    JenkinsSlave jenkinsSlave = this.getJenkinsSlave();
                    if (jenkinsSlave != null) {
                        jenkinsSlave.update();
                        if (!this.fromArchive && !jenkinsSlave.isOffline()) {
                            for (SlaveOfflineRule slaveOfflineRule : this.slaveOfflineRules) {
                                if (!slaveOfflineRule.matches(this)) continue;
                                this.takeSlaveOffline(slaveOfflineRule);
                                break;
                            }
                        }
                    }
                    if (this instanceof AxisBuild || this instanceof BatchBuild || this instanceof TopLevelBuild || this.fromArchive || this.badBuildNumbers.size() >= 1) {
                        return;
                    }
                    for (ReinvokeRule reinvokeRule : this.reinvokeRules) {
                        if (!reinvokeRule.matches(this)) continue;
                        this.reinvoke(reinvokeRule);
                        break;
                    }
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
        }
    }

    protected static boolean isHighPriorityBuildFailureElement(Element gitHubMessage) {
        String content = null;
        try {
            content = Dom4JUtil.format(gitHubMessage, false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to format github message", ioException);
        }
        for (String highPriorityContentToken : _TOKENS_HIGH_PRIORITY_CONTENT) {
            if (!content.contains(highPriorityContentToken)) continue;
            return true;
        }
        return false;
    }

    protected BaseBuild(String url) {
        this(url, null);
    }

    protected BaseBuild(String url, Build parentBuild) {
        this._parentBuild = parentBuild;
        if (url.contains("buildWithParameters")) {
            this.setInvocationURL(url);
        } else {
            this.setBuildURL(url);
        }
        if (this.fromArchive || this.fromCompletedBuild) {
            this.update();
        }
    }

    protected void addDownstreamBuildsTimelineData(TimelineData timelineData) {
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            if (!(downstreamBuild instanceof BaseBuild)) continue;
            BaseBuild downstreamBaseBuild = (BaseBuild)downstreamBuild;
            downstreamBaseBuild.addTimelineData(timelineData);
        }
    }

    protected void archiveConsoleLog() {
        this.downloadSampleURL(this.getArchivePath(), true, this.getBuildURL(), "/consoleText");
    }

    protected void archiveJSON() {
        this.downloadSampleURL(this.getArchivePath(), true, this.getBuildURL(), "api/json");
        this.downloadSampleURL(this.getArchivePath(), false, this.getBuildURL(), "testReport/api/json");
        if (!this.getStartPropertiesTempMap().isEmpty()) {
            try {
                JSONObject startPropertiesTempMapJSONObject = JenkinsResultsParserUtil.toJSONObject(this.getStartPropertiesTempMapURL());
                this.writeArchiveFile(startPropertiesTempMapJSONObject.toString(4), this.getArchivePath() + "/start.properties.json");
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to create start.properties.json", ioException);
            }
        }
        if (!this.getStopPropertiesTempMap().isEmpty()) {
            try {
                JSONObject stopPropertiesTempMapJSONObject = JenkinsResultsParserUtil.toJSONObject(this.getStopPropertiesTempMapURL());
                this.writeArchiveFile(stopPropertiesTempMapJSONObject.toString(4), this.getArchivePath() + "/stop.properties.json");
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to create stop.properties.json", ioException);
            }
        }
    }

    protected void checkForReinvocation(String consoleText) {
        if (consoleText == null || consoleText.isEmpty()) {
            return;
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild == null || topLevelBuild.fromArchive) {
            return;
        }
        if (consoleText.contains(this.getReinvokedMessage())) {
            this.reset();
            this.update();
        }
    }

    protected void downloadSampleURL(String path, boolean required, String url, String urlSuffix) {
        String urlString = url + urlSuffix;
        if (urlString.endsWith("json")) {
            urlString = urlString + "?pretty";
        }
        urlSuffix = JenkinsResultsParserUtil.fixFileName(urlSuffix);
        String content = null;
        try {
            content = JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(urlString), false, 0, 0, 0);
        }
        catch (IOException ioException) {
            if (required) {
                throw new RuntimeException("Unable to download sample " + urlString, ioException);
            }
            return;
        }
        try {
            this.writeArchiveFile(content, path + "/" + urlSuffix);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to write file", ioException);
        }
    }

    protected void extractBuildURLComponents(Matcher matcher) {
        this._buildNumber = Integer.parseInt(matcher.group("buildNumber"));
        this.setJenkinsMaster(new JenkinsMaster(matcher.group("master")));
        this.setJobName(matcher.group("jobName"));
    }

    protected void findDownstreamBuilds() {
        JSONArray runsJSONArray;
        ArrayList<String> foundDownstreamBuildURLs = new ArrayList<String>(this.findDownstreamBuildsInConsoleText());
        JSONObject buildJSONObject = this.getBuildJSONObject("runs[number,url]");
        if (buildJSONObject != null && buildJSONObject.has("runs") && (runsJSONArray = buildJSONObject.getJSONArray("runs")) != null) {
            for (int i = 0; i < runsJSONArray.length(); ++i) {
                String url;
                JSONObject runJSONObject = runsJSONArray.getJSONObject(i);
                if (runJSONObject.getInt("number") != this._buildNumber || this.hasBuildURL(url = runJSONObject.getString("url")) || foundDownstreamBuildURLs.contains(url)) continue;
                foundDownstreamBuildURLs.add(url);
            }
        }
        this.addDownstreamBuilds(foundDownstreamBuildURLs.toArray(new String[0]));
    }

    protected List<String> findDownstreamBuildsInConsoleText() {
        return Collections.emptyList();
    }

    protected Pattern getArchiveBuildURLPattern() {
        return _archiveBuildURLPattern;
    }

    protected String getBaseGitRepositoryType() {
        if (this.jobName.startsWith("test-subrepository-acceptance-pullrequest")) {
            return this.getBaseGitRepositoryName();
        }
        if (this.jobName.contains("portal")) {
            return "portal";
        }
        if (this.jobName.contains("plugins")) {
            return "plugins";
        }
        return "jenkins";
    }

    protected Build.BranchInformation getBranchInformation(String repositoryType) {
        Build.BranchInformation branchInformation = this._branchInformationMap.get(repositoryType);
        if (branchInformation == null) {
            branchInformation = new DefaultBranchInformation(this, repositoryType);
            String repositoryName = branchInformation.getRepositoryName();
            if (repositoryName == null) {
                return null;
            }
            this._branchInformationMap.put(repositoryType, branchInformation);
        }
        return this._branchInformationMap.get(repositoryType);
    }

    protected JSONObject getBuildJSONObject(String tree) {
        if (this.getBuildURL() == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(JenkinsResultsParserUtil.getLocalURL(this.getBuildURL()));
        sb.append("/api/json?pretty");
        if (tree != null) {
            sb.append("&tree=");
            sb.append(tree);
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(sb.toString(), false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build JSON", ioException);
        }
    }

    protected String getBuildMessage() {
        if (this.jobName != null) {
            String status = this.getStatus();
            StringBuilder sb = new StringBuilder();
            sb.append("Build \"");
            sb.append(this.jobName);
            sb.append("\"");
            if (status.equals("completed")) {
                sb.append(" completed at ");
                sb.append(this.getBuildURL());
                sb.append(". ");
                sb.append(this.getResult());
                return sb.toString();
            }
            if (status.equals("missing")) {
                sb.append(" is missing ");
                sb.append(this.getJobURL());
                sb.append(".");
                return sb.toString();
            }
            if (status.equals("queued")) {
                sb.append(" is queued at ");
                sb.append(this.getJobURL());
                sb.append(".");
                return sb.toString();
            }
            if (status.equals("running")) {
                if (this.badBuildNumbers.size() > 0) {
                    sb.append(" ");
                    List<String> badBuildURLs = this.getBadBuildURLs();
                    sb.append(badBuildURLs.get(this.badBuildNumbers.size() - 1));
                    sb.append(" restarted at ");
                } else {
                    sb.append(" started at ");
                }
                sb.append(this.getBuildURL());
                sb.append(".");
                return sb.toString();
            }
            if (status.equals("starting")) {
                sb.append(" invoked at ");
                sb.append(this.getJobURL());
                sb.append(".");
                return sb.toString();
            }
            throw new RuntimeException("Unknown status: " + status);
        }
        return "";
    }

    protected JSONArray getBuildsJSONArray(int page) throws IOException {
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(this.getJobURL(), "/api/json?tree=allBuilds[actions[parameters", "[name,type,value]],building,duration,number,result,url]{", String.valueOf(page * 100), ",", String.valueOf((page + 1) * 100), "}")), false);
        return jsonObject.getJSONArray("allBuilds");
    }

    protected Element getBuildTimeElement() {
        return Dom4JUtil.getNewElement("p", null, "Build Time: ", JenkinsResultsParserUtil.toDurationString(this.getDuration()));
    }

    protected MultiPattern getBuildURLMultiPattern() {
        return _buildURLMultiPattern;
    }

    protected int getDownstreamBuildCountByResult(String result) {
        List<Build> downstreamBuilds = this.getDownstreamBuilds(null);
        if (result == null) {
            return downstreamBuilds.size();
        }
        int count = 0;
        for (Build downstreamBuild : downstreamBuilds) {
            String downstreamBuildResult = downstreamBuild.getResult();
            if (!Objects.equals(downstreamBuildResult, result)) continue;
            ++count;
        }
        return count;
    }

    protected Map<Build, Element> getDownstreamBuildMessages(List<Build> downstreamBuilds) {
        ArrayList callables = new ArrayList();
        for (final Build downstreamBuild : downstreamBuilds) {
            Callable<Element> callable = new Callable<Element>(){

                @Override
                public Element call() {
                    return downstreamBuild.getGitHubMessageElement();
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, this.getExecutorService());
        List elements = parallelExecutor.execute();
        LinkedHashMap<Build, Element> elementsMap = new LinkedHashMap<Build, Element>();
        for (int i = 0; i < elements.size(); ++i) {
            elementsMap.put(downstreamBuilds.get(i), (Element)elements.get(i));
        }
        return elementsMap;
    }

    protected ExecutorService getExecutorService() {
        return null;
    }

    protected List<Build> getFailedDownstreamBuilds() {
        ArrayList<Build> failedDownstreamBuilds = new ArrayList<Build>();
        failedDownstreamBuilds.addAll(this.getDownstreamBuilds("ABORTED", null));
        failedDownstreamBuilds.addAll(this.getDownstreamBuilds("FAILURE", null));
        failedDownstreamBuilds.addAll(this.getDownstreamBuilds("UNSTABLE", null));
        return failedDownstreamBuilds;
    }

    protected Element getFailureMessageElement() {
        for (FailureMessageGenerator failureMessageGenerator : this.getFailureMessageGenerators()) {
            Element failureMessage = failureMessageGenerator.getMessageElement(this);
            if (failureMessage == null) continue;
            return failureMessage;
        }
        return null;
    }

    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return _FAILURE_MESSAGE_GENERATORS;
    }

    protected Element getFullConsoleClickHereElement() {
        return Dom4JUtil.getNewElement("h5", null, "For full console, click ", Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "/consoleText", "here"), ".");
    }

    protected abstract Element getGitHubMessageJobResultsElement();

    protected Element getGitHubMessageJobResultsElement(boolean showCommonFailuresCount) {
        return this.getGitHubMessageJobResultsElement();
    }

    protected Map<String, String> getInjectedEnvironmentVariablesMap() throws IOException {
        String localBuildURL = JenkinsResultsParserUtil.getLocalURL(this.getBuildURL());
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(localBuildURL + "/injectedEnvVars/api/json", false);
        JSONObject envMapJSONObject = jsonObject.getJSONObject("envMap");
        Set envMapJSONObjectKeySet = envMapJSONObject.keySet();
        HashMap<String, String> injectedEnvironmentVariablesMap = new HashMap<String, String>();
        for (String key : envMapJSONObjectKeySet) {
            injectedEnvironmentVariablesMap.put(key, envMapJSONObject.getString(key));
        }
        return injectedEnvironmentVariablesMap;
    }

    protected String getJenkinsReportBuildInfoCellElementTagName() {
        return "td";
    }

    protected List<Element> getJenkinsReportStopWatchRecordElements() {
        ArrayList<Element> jenkinsReportStopWatchRecordTableRowElements = new ArrayList<Element>();
        for (StopWatchRecord stopWatchRecord : this.getStopWatchRecordsGroup()) {
            jenkinsReportStopWatchRecordTableRowElements.addAll(stopWatchRecord.getJenkinsReportTableRowElements());
        }
        return jenkinsReportStopWatchRecordTableRowElements;
    }

    protected Element getJenkinsReportTableRowElement() {
        String cellElementTagName = this.getJenkinsReportBuildInfoCellElementTagName();
        Element stopWatchRecordsExpanderAnchorElement = this.getStopWatchRecordsExpanderAnchorElement();
        Element nameCellElement = Dom4JUtil.getNewElement(cellElementTagName, null, stopWatchRecordsExpanderAnchorElement, Dom4JUtil.getNewAnchorElement(this.getBuildURL(), null, this.getDisplayName()));
        int indent = this.getDepth() * 35;
        if (stopWatchRecordsExpanderAnchorElement != null) {
            indent -= 20;
        }
        nameCellElement.addAttribute("style", "text-indent: " + indent);
        Element buildInfoElement = Dom4JUtil.getNewElement("tr", null, nameCellElement, Dom4JUtil.getNewElement(cellElementTagName, null, Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "console", null, "Console")), Dom4JUtil.getNewElement(cellElementTagName, null, Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "testReport", "Test Report")));
        StopWatchRecordsGroup stopWatchRecordsGroup = this.getStopWatchRecordsGroup();
        if (!stopWatchRecordsGroup.isEmpty()) {
            ArrayList<String> childStopWatchRecordNames = new ArrayList<String>(stopWatchRecordsGroup.size());
            for (StopWatchRecord stopWatchRecord : stopWatchRecordsGroup) {
                childStopWatchRecordNames.add(stopWatchRecord.getName());
            }
            buildInfoElement.addAttribute("child-stopwatch-rows", JenkinsResultsParserUtil.join(",", childStopWatchRecordNames));
        }
        buildInfoElement.addAttribute("id", String.valueOf(this.hashCode()) + "-");
        this.getStartTime();
        if (this.startTime == null) {
            Dom4JUtil.addToElement(buildInfoElement, Dom4JUtil.getNewElement(cellElementTagName, null, "", this.getJenkinsReportTimeZoneName()));
        } else {
            Dom4JUtil.addToElement(buildInfoElement, Dom4JUtil.getNewElement(cellElementTagName, null, this.toJenkinsReportDateString(new Date(this.startTime), this.getJenkinsReportTimeZoneName())));
        }
        Dom4JUtil.addToElement(buildInfoElement, Dom4JUtil.getNewElement(cellElementTagName, null, JenkinsResultsParserUtil.toDurationString(this.getDuration())));
        String status = this.getStatus();
        status = status != null ? StringUtils.upperCase((String)status) : "";
        Dom4JUtil.getNewElement(cellElementTagName, buildInfoElement, status);
        String result = this.getResult();
        if (result == null) {
            result = "";
        }
        Dom4JUtil.getNewElement(cellElementTagName, buildInfoElement, result);
        return buildInfoElement;
    }

    protected List<Element> getJenkinsReportTableRowElements(String result, String status) {
        ArrayList<Element> tableRowElements = new ArrayList<Element>();
        if (this.getParentBuild() != null && (result == null || result.equals(this.getResult())) && (status == null || status.equals(this.getStatus()))) {
            tableRowElements.add(this.getJenkinsReportTableRowElement());
            tableRowElements.addAll(this.getJenkinsReportStopWatchRecordElements());
        }
        List<Build> downstreamBuilds = this.getDownstreamBuilds(result, status);
        Collections.sort(downstreamBuilds, new BuildDisplayNameComparator());
        for (Build downstreamBuild : downstreamBuilds) {
            if (!(downstreamBuild instanceof BaseBuild)) continue;
            BaseBuild downstreamBaseBuild = (BaseBuild)downstreamBuild;
            tableRowElements.addAll(downstreamBaseBuild.getJenkinsReportTableRowElements(result, status));
        }
        return tableRowElements;
    }

    protected String getJenkinsReportTimeZoneName() {
        return _NAME_JENKINS_REPORT_TIME_ZONE;
    }

    protected Set<String> getJobParameterNames() {
        JSONObject jsonObject;
        try {
            jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(this.getJobURL(), "/api/json?tree=actions[", "parameterDefinitions[name,type,value]]")));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build JSON", ioException);
        }
        JSONArray actionsJSONArray = jsonObject.getJSONArray("actions");
        JSONObject firstActionJSONObject = actionsJSONArray.getJSONObject(0);
        JSONArray parameterDefinitionsJSONArray = firstActionJSONObject.getJSONArray("parameterDefinitions");
        HashSet<String> parameterNames = new HashSet<String>(parameterDefinitionsJSONArray.length());
        for (int i = 0; i < parameterDefinitionsJSONArray.length(); ++i) {
            JSONObject parameterDefinitionJSONObject = parameterDefinitionsJSONArray.getJSONObject(i);
            String type = parameterDefinitionJSONObject.getString("type");
            if (!type.equals("StringParameterDefinition")) continue;
            parameterNames.add(parameterDefinitionJSONObject.getString("name"));
        }
        return parameterNames;
    }

    protected Map<String, String> getParameters(JSONArray jsonArray) {
        HashMap<String, String> parameters = new HashMap<String, String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            parameters.put(jsonObject.getString("name"), jsonObject.optString("value"));
        }
        return parameters;
    }

    protected Map<String, String> getParameters(JSONObject buildJSONObject) {
        JSONArray actionsJSONArray = buildJSONObject.getJSONArray("actions");
        if (actionsJSONArray.length() == 0) {
            return new HashMap<String, String>();
        }
        JSONObject jsonObject = actionsJSONArray.getJSONObject(0);
        if (jsonObject.has("parameters")) {
            JSONArray parametersJSONArray = jsonObject.getJSONArray("parameters");
            return this.getParameters(parametersJSONArray);
        }
        return new HashMap<String, String>();
    }

    protected JSONObject getQueueItemJSONObject() throws IOException {
        JSONArray queueItemsJSONArray = this.getQueueItemsJSONArray();
        for (int i = 0; i < queueItemsJSONArray.length(); ++i) {
            JSONObject queueItemJSONObject = queueItemsJSONArray.getJSONObject(i);
            JSONObject taskJSONObject = queueItemJSONObject.getJSONObject("task");
            String queueItemName = taskJSONObject.getString("name");
            if (!queueItemName.equals(this.jobName) || !this._parameters.equals(this.getParameters(queueItemJSONObject))) continue;
            return queueItemJSONObject;
        }
        return null;
    }

    protected JSONArray getQueueItemsJSONArray() throws IOException {
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine("http://", this._jenkinsMaster.getName(), "/queue/api/json?tree=items[actions[parameters", "[name,value]],task[name,url]]"), false);
        return jsonObject.getJSONArray("items");
    }

    protected String getReinvokedMessage() {
        return "Reinvoked: " + this.getBuildURL();
    }

    protected JSONObject getRunningBuildJSONObject() throws IOException {
        JSONArray buildsJSONArray;
        int page = 0;
        while ((buildsJSONArray = this.getBuildsJSONArray(page)).length() != 0) {
            for (int i = 0; i < buildsJSONArray.length(); ++i) {
                JSONObject buildJSONObject = buildsJSONArray.getJSONObject(i);
                Map<String, String> parameters = this.getParameters();
                if (!parameters.equals(this.getParameters(buildJSONObject)) || this.badBuildNumbers.contains(buildJSONObject.getInt("number"))) continue;
                return buildJSONObject;
            }
            ++page;
        }
        return null;
    }

    protected String getStartPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/start.properties.json";
        }
        return this.getParameterValue("JSON_MAP_URL");
    }

    protected String getStopPropertiesTempMapURL() {
        return null;
    }

    protected Element getStopWatchRecordsExpanderAnchorElement() {
        StopWatchRecordsGroup stopWatchRecordsGroup = this.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup.isEmpty()) {
            return null;
        }
        Element stopWatchRecordsExpanderAnchorElement = Dom4JUtil.getNewAnchorElement("", "+ ");
        String hashCode = String.valueOf(this.hashCode());
        stopWatchRecordsExpanderAnchorElement.addAttribute("id", JenkinsResultsParserUtil.combine(hashCode, "-expander-anchor-"));
        stopWatchRecordsExpanderAnchorElement.addAttribute("onClick", JenkinsResultsParserUtil.combine("return toggleStopWatchRecordExpander('", hashCode, "', '')"));
        stopWatchRecordsExpanderAnchorElement.addAttribute("style", "font-family: monospace, monospace; text-decoration: none");
        return stopWatchRecordsExpanderAnchorElement;
    }

    protected StopWatchRecordsGroup getStopWatchRecordsGroup() {
        String consoleText = null;
        int consoleTextLength = 0;
        int retries = 0;
        try {
            consoleText = this.getConsoleText();
            consoleTextLength = consoleText.length();
            if (this.stopWatchRecordConsoleReadCursor > 0) {
                consoleText = consoleText.substring(this.stopWatchRecordConsoleReadCursor);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            if (retries == 2) {
                throw stringIndexOutOfBoundsException;
            }
            System.out.println(JenkinsResultsParserUtil.combine("Retrying. Console log length (", String.valueOf(consoleTextLength), ") is shorter than previous (", String.valueOf(this.stopWatchRecordConsoleReadCursor), ")."));
            ++retries;
            JenkinsResultsParserUtil.sleep(5000L);
        }
        for (String line : consoleText.split("\n")) {
            String stopWatchName;
            StopWatchRecord stopWatchRecord;
            String minutes;
            Matcher matcher = stopWatchStartTimestampPattern.matcher(line);
            if (matcher.matches()) {
                Date timestamp = null;
                try {
                    timestamp = stopWatchTimestampSimpleDateFormat.parse(matcher.group("timestamp"));
                }
                catch (ParseException parseException) {
                    throw new RuntimeException("Unable to parse timestamp in " + line, parseException);
                }
                String stopWatchName2 = matcher.group("name");
                this.stopWatchRecordsGroup.add(new StopWatchRecord(stopWatchName2, timestamp.getTime(), this));
                continue;
            }
            matcher = stopWatchPattern.matcher(line);
            if (!matcher.matches()) continue;
            long duration = Long.parseLong(matcher.group("milliseconds"));
            String seconds = matcher.group("seconds");
            if (seconds != null) {
                duration += Long.parseLong(seconds) * 1000L;
            }
            if ((minutes = matcher.group("minutes")) != null) {
                duration += Long.parseLong(minutes) * 60L * 1000L;
            }
            if ((stopWatchRecord = this.stopWatchRecordsGroup.get(stopWatchName = matcher.group("name"))) == null) continue;
            stopWatchRecord.setDuration(duration);
        }
        this.stopWatchRecordConsoleReadCursor = consoleTextLength;
        return this.stopWatchRecordsGroup;
    }

    protected Map<String, String> getTempMap(String tempMapName) {
        String tempMapURL = this.getTempMapURL(tempMapName);
        if (tempMapURL == null) {
            return this.getTempMapFromBuildDatabase(tempMapName);
        }
        JSONObject tempMapJSONObject = null;
        try {
            tempMapJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(tempMapURL), false, 0, 0, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (tempMapJSONObject == null || !tempMapJSONObject.has("properties")) {
            return this.getTempMapFromBuildDatabase(tempMapName);
        }
        JSONArray propertiesJSONArray = tempMapJSONObject.getJSONArray("properties");
        HashMap<String, String> tempMap = new HashMap<String, String>(propertiesJSONArray.length());
        for (int i = 0; i < propertiesJSONArray.length(); ++i) {
            JSONObject propertyJSONObject = propertiesJSONArray.getJSONObject(i);
            String key = propertyJSONObject.getString("name");
            String value = propertyJSONObject.optString("value");
            if (value == null || value.isEmpty()) continue;
            tempMap.put(key, value);
        }
        return tempMap;
    }

    protected Map<String, String> getTempMapFromBuildDatabase(String tempMapName) {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        if (!this.fromArchive) {
            BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase(this);
            Properties properties = buildDatabase.getProperties(tempMapName);
            for (String propertyName : properties.stringPropertyNames()) {
                tempMap.put(propertyName, properties.getProperty(propertyName));
            }
        }
        return tempMap;
    }

    protected String getTempMapURL(String tempMapName) {
        if (tempMapName.equals("start.properties")) {
            return this.getStartPropertiesTempMapURL();
        }
        if (tempMapName.equals("stop.properties")) {
            return this.getStopPropertiesTempMapURL();
        }
        return null;
    }

    protected int getTestCountByStatus(String status) {
        JSONObject testReportJSONObject = this.getTestReportJSONObject(false);
        if (testReportJSONObject == null) {
            return 0;
        }
        if (status.equals("FAILURE")) {
            return testReportJSONObject.getInt("failCount");
        }
        if (status.equals("SUCCESS")) {
            return testReportJSONObject.getInt("passCount");
        }
        throw new IllegalArgumentException("Invalid status: " + status);
    }

    protected boolean isParentBuildRoot() {
        if (this._parentBuild == null) {
            return false;
        }
        return this._parentBuild.getParentBuild() == null && this._parentBuild instanceof TopLevelBuild;
    }

    protected void loadParametersFromBuildJSONObject() {
        if (this.getBuildURL() == null) {
            return;
        }
        JSONObject buildJSONObject = this.getBuildJSONObject("actions[parameters[*]]");
        JSONArray actionsJSONArray = buildJSONObject.getJSONArray("actions");
        if (actionsJSONArray.length() == 0) {
            this._parameters = new HashMap<String, String>();
            return;
        }
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionJSONObject = actionsJSONArray.getJSONObject(i);
            if (!actionJSONObject.has("parameters")) continue;
            JSONArray parametersJSONArray = actionJSONObject.getJSONArray("parameters");
            this._parameters = new HashMap<String, String>(parametersJSONArray.length());
            for (int j = 0; j < parametersJSONArray.length(); ++j) {
                String valueString;
                JSONObject parameterJSONObject = parametersJSONArray.getJSONObject(j);
                Object value = parameterJSONObject.opt("value");
                if (!(value instanceof String) || (valueString = value.toString()).isEmpty()) continue;
                this._parameters.put(parameterJSONObject.getString("name"), value.toString());
            }
            return;
        }
        this._parameters = Collections.emptyMap();
    }

    protected void loadParametersFromQueryString(String queryString) {
        Map<String, String> defaultJobParameters = this._getDefaultJobParameters();
        this._parameters.putAll(defaultJobParameters);
        for (String parameter : queryString.split("&")) {
            String[] nameValueArray;
            if (!parameter.contains("=") || !defaultJobParameters.containsKey((nameValueArray = parameter.split("="))[0])) continue;
            if (nameValueArray.length == 2) {
                this._parameters.put(nameValueArray[0], nameValueArray[1]);
                continue;
            }
            if (nameValueArray.length != 1) continue;
            this._parameters.put(nameValueArray[0], "");
        }
    }

    protected void reset() {
        this.badBuildNumbers.add(this.getBuildNumber());
        this.setResult(null);
        this.setBuildNumber(-1);
        this.downstreamBuilds.clear();
    }

    protected void setBuildNumber(int buildNumber) {
        if (this._buildNumber != buildNumber) {
            int previousBuildNumber = this._buildNumber;
            this._buildNumber = buildNumber;
            this.consoleReadCursor = 0;
            if (this._buildNumber == -1) {
                this.setStatus("starting");
            } else if (!this.badBuildNumbers.contains(previousBuildNumber)) {
                this.setStatus("running");
            }
        }
    }

    protected void setBuildURL(String buildURL) {
        try {
            buildURL = JenkinsResultsParserUtil.decode(buildURL);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Unable to decode " + buildURL, unsupportedEncodingException);
        }
        Build parentBuild = this.getParentBuild();
        try {
            String archiveMarkerContent;
            this.fromArchive = parentBuild != null ? parentBuild.isFromArchive() : (archiveMarkerContent = JenkinsResultsParserUtil.toString(buildURL + "/archive-marker", false, 0, 0, 0)) != null && !archiveMarkerContent.isEmpty();
        }
        catch (IOException ioException) {
            this.fromArchive = false;
        }
        MultiPattern buildURLMultiPattern = this.getBuildURLMultiPattern();
        Matcher matcher = buildURLMultiPattern.find(buildURL);
        if (matcher == null) {
            Pattern archiveBuildURLPattern = this.getArchiveBuildURLPattern();
            matcher = archiveBuildURLPattern.matcher(buildURL);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Invalid build URL " + buildURL);
            }
            this.archiveName = matcher.group("archiveName");
        }
        this.extractBuildURLComponents(matcher);
        this.loadParametersFromBuildJSONObject();
        this.consoleReadCursor = 0;
        this.setStatus("running");
        if (parentBuild != null) {
            this.fromCompletedBuild = parentBuild.isFromCompletedBuild();
        } else {
            String consoleText = this.getConsoleText();
            this.fromCompletedBuild = consoleText.contains("stop-current-job:");
        }
    }

    protected void setInvocationURL(String invocationURL) {
        if (this.getBuildURL() != null) {
            return;
        }
        try {
            invocationURL = JenkinsResultsParserUtil.decode(invocationURL);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Unable to decode " + invocationURL, unsupportedEncodingException);
        }
        Matcher invocationURLMatcher = invocationURLPattern.matcher(invocationURL);
        if (!invocationURLMatcher.find()) {
            throw new RuntimeException("Invalid invocation URL");
        }
        this.setJobName(invocationURLMatcher.group("jobName"));
        this.setJenkinsMaster(new JenkinsMaster(invocationURLMatcher.group("master")));
        this.loadParametersFromQueryString(invocationURL);
        this.setStatus("starting");
        if (JenkinsResultsParserUtil.isCINode()) {
            invocationURL = JenkinsResultsParserUtil.getLocalURL(invocationURL);
        }
        try {
            JenkinsResultsParserUtil.toString(invocationURL, false);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected void setJenkinsMaster(JenkinsMaster jenkinsMaster) {
        this._jenkinsMaster = jenkinsMaster;
    }

    protected void setJobName(String jobName) {
        this.jobName = jobName;
        Matcher matcher = jobNamePattern.matcher(jobName);
        if (matcher.find()) {
            this.branchName = matcher.group("branchName");
            return;
        }
        this.branchName = "master";
    }

    protected void setResult(String result) {
        this._result = result;
        if (this._result == null || this.getDownstreamBuildCount("completed") < this.getDownstreamBuildCount(null)) {
            this.setStatus("running");
        } else {
            this.setStatus("completed");
        }
    }

    protected void setStatus(String status) {
        if (this._isDifferent(status, this._status)) {
            this._status = status;
            long previousStatusModifiedTime = this.statusModifiedTime;
            this.statusModifiedTime = System.currentTimeMillis();
            this.statusDurations.put(this._previousStatus, this.statusModifiedTime - previousStatusModifiedTime);
            if (this.isParentBuildRoot() && !this.badBuildNumbers.contains(this._buildNumber)) {
                System.out.println(this.getBuildMessage());
            }
        }
    }

    protected String toJenkinsReportDateString(Date date, String timeZoneName) {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        return JenkinsResultsParserUtil.toDateString(date, buildProperties.getProperty("jenkins.report.date.format"), timeZoneName);
    }

    protected void writeArchiveFile(String content, String path) throws IOException {
        JenkinsResultsParserUtil.write(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.URL_DEPENDENCIES_FILE.substring("file:".length()), "/", path), JenkinsResultsParserUtil.redact(this.replaceBuildURL(content)));
    }

    private Map<String, String> _getDefaultJobParameters() {
        HashMap<String, String> jobParameters = new HashMap<String, String>();
        JSONObject actionsJSONObject = null;
        JSONObject jobJSONObject = null;
        String jobURL = this.getJobURL();
        if (JenkinsResultsParserUtil.isCINode()) {
            jobURL = JenkinsResultsParserUtil.getLocalURL(jobURL);
        }
        try {
            jobJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(jobURL, "/api/json?tree=actions[parameterDefinitions[", "defaultParameterValue[value],name]]"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        JSONArray actionsJSONArray = jobJSONObject.getJSONArray("actions");
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject jsonObject = actionsJSONArray.getJSONObject(i);
            if (!jsonObject.has("parameterDefinitions")) continue;
            actionsJSONObject = jsonObject;
            break;
        }
        if (actionsJSONObject == null) {
            return jobParameters;
        }
        JSONArray parameterDefinitionsJSONArray = actionsJSONObject.getJSONArray("parameterDefinitions");
        for (int i = 0; i < parameterDefinitionsJSONArray.length(); ++i) {
            JSONObject parameterJSONObject = parameterDefinitionsJSONArray.getJSONObject(i);
            JSONObject defaultParameterValueJSONObject = parameterJSONObject.getJSONObject("defaultParameterValue");
            jobParameters.put(parameterJSONObject.getString("name"), defaultParameterValueJSONObject.getString("value"));
        }
        return jobParameters;
    }

    private boolean _isDifferent(String newValue, String oldValue) {
        if (oldValue == null) {
            return newValue != null;
        }
        return !oldValue.equals(newValue);
    }

    static {
        _TOKENS_HIGH_PRIORITY_CONTENT = new String[]{"compileJSP", "SourceFormatter.format", "Unable to compile JSPs"};
        _archiveBuildURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("(", Pattern.quote("${dependencies.url}"), "|", Pattern.quote(JenkinsResultsParserUtil.URL_DEPENDENCIES_FILE), "|", Pattern.quote(JenkinsResultsParserUtil.URL_DEPENDENCIES_HTTP), ")/*(?<archiveName>.*)/(?<master>[^/]+)/+(?<jobName>[^/]+)", ".*/(?<buildNumber>\\d+)/?"));
        _buildURLMultiPattern = new MultiPattern(JenkinsResultsParserUtil.combine("\\w+://(?<master>[^/]+)/+job/+(?<jobName>[^/]+).*/(?<buildNumber>", "\\d+)/?"));
        Properties properties = null;
        try {
            properties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        _NAME_JENKINS_REPORT_TIME_ZONE = properties.getProperty("jenkins.report.time.zone");
    }

    protected static class TimelineData {
        private final long _duration;
        private final long _startTime;
        private final TimelineDataPoint[] _timeline;

        protected TimelineData(int size, TopLevelBuild topLevelBuild) {
            if (topLevelBuild != topLevelBuild.getTopLevelBuild()) {
                throw new IllegalArgumentException("Nested TopLevelBuild objects are invalid");
            }
            if (size < 1) {
                throw new IllegalArgumentException("Invalid size " + size);
            }
            this._duration = topLevelBuild.getDuration();
            this._startTime = topLevelBuild.getStartTime();
            this._timeline = new TimelineDataPoint[size];
            for (int i = 0; i < size; ++i) {
                this._timeline[i] = new TimelineDataPoint((int)((long)i * (this._duration / (long)this._timeline.length)));
            }
            topLevelBuild.addTimelineData(this);
        }

        protected void addTimelineData(BaseBuild build) {
            int startIndex;
            Long buildInvokedTime = build.getInvokedTime();
            if (buildInvokedTime == null) {
                return;
            }
            this._timeline[this._getIndex(buildInvokedTime)]._invocationsCount++;
            Long buildStartTime = build.getStartTime();
            if (buildStartTime == null) {
                return;
            }
            int endIndex = this._getIndex(buildStartTime + build.getDuration());
            for (int i = startIndex = this._getIndex(buildStartTime); i <= endIndex; ++i) {
                this._timeline[i]._slaveUsageCount++;
            }
        }

        protected int[] getIndexData() {
            int[] indexes = new int[this._timeline.length];
            for (int i = 0; i < this._timeline.length; ++i) {
                indexes[i] = this._timeline[i]._index;
            }
            return indexes;
        }

        protected int[] getInvocationsData() {
            int[] invocationsData = new int[this._timeline.length];
            for (int i = 0; i < this._timeline.length; ++i) {
                invocationsData[i] = this._timeline[i]._invocationsCount;
            }
            return invocationsData;
        }

        protected int[] getSlaveUsageData() {
            int[] slaveUsageData = new int[this._timeline.length];
            for (int i = 0; i < this._timeline.length; ++i) {
                slaveUsageData[i] = this._timeline[i]._slaveUsageCount;
            }
            return slaveUsageData;
        }

        private int _getIndex(long timestamp) {
            int index = (int)((timestamp - this._startTime) * (long)this._timeline.length / this._duration);
            if (index >= this._timeline.length) {
                return this._timeline.length - 1;
            }
            if (index < 0) {
                return 0;
            }
            return index;
        }

        private static class TimelineDataPoint {
            private final int _index;
            private int _invocationsCount;
            private int _slaveUsageCount;

            private TimelineDataPoint(int index) {
                this._index = index;
            }
        }
    }

    public static class StopWatchRecordsGroup
    implements Iterable<StopWatchRecord> {
        private final Map<String, StopWatchRecord> _stopWatchRecordsMap = new HashMap<String, StopWatchRecord>();

        public void add(StopWatchRecord newStopWatchRecord) {
            this._stopWatchRecordsMap.put(newStopWatchRecord.getName(), newStopWatchRecord);
        }

        public StopWatchRecord get(String name) {
            return this._stopWatchRecordsMap.get(name);
        }

        public List<StopWatchRecord> getStopWatchRecords() {
            ArrayList<StopWatchRecord> allStopWatchRecords = new ArrayList<StopWatchRecord>(this._stopWatchRecordsMap.values());
            Collections.sort(allStopWatchRecords);
            ArrayList<StopWatchRecord> parentStopWatchRecords = new ArrayList<StopWatchRecord>();
            for (StopWatchRecord stopWatchRecord : allStopWatchRecords) {
                for (StopWatchRecord parentStopWatchRecord : parentStopWatchRecords) {
                    if (!parentStopWatchRecord.isParentOf(stopWatchRecord)) continue;
                    parentStopWatchRecord.addChildStopWatchRecord(stopWatchRecord);
                    break;
                }
                if (stopWatchRecord.getParentStopWatchRecord() != null) continue;
                parentStopWatchRecords.add(stopWatchRecord);
            }
            return parentStopWatchRecords;
        }

        public boolean isEmpty() {
            return this._stopWatchRecordsMap.isEmpty();
        }

        @Override
        public Iterator<StopWatchRecord> iterator() {
            List<StopWatchRecord> list = this.getStopWatchRecords();
            return list.iterator();
        }

        public int size() {
            List<StopWatchRecord> list = this.getStopWatchRecords();
            return list.size();
        }
    }

    public static class StopWatchRecord
    implements Comparable<StopWatchRecord> {
        private final BaseBuild _baseBuild;
        private Set<StopWatchRecord> _childStopWatchRecords;
        private Long _duration;
        private final String _name;
        private StopWatchRecord _parentStopWatchRecord;
        private final Long _startTimestamp;

        public StopWatchRecord(String name, long startTimestamp, BaseBuild baseBuild) {
            this._name = name;
            this._startTimestamp = startTimestamp;
            this._baseBuild = baseBuild;
        }

        public void addChildStopWatchRecord(StopWatchRecord newChildStopWatchRecord) {
            if (this._childStopWatchRecords == null) {
                this._childStopWatchRecords = new TreeSet<StopWatchRecord>();
            }
            for (StopWatchRecord childStopWatchRecord : this._childStopWatchRecords) {
                if (!childStopWatchRecord.isParentOf(newChildStopWatchRecord)) continue;
                childStopWatchRecord.addChildStopWatchRecord(newChildStopWatchRecord);
                return;
            }
            newChildStopWatchRecord.setParentStopWatchRecord(this);
            this._childStopWatchRecords.add(newChildStopWatchRecord);
        }

        @Override
        public int compareTo(StopWatchRecord stopWatchRecord) {
            int compareToValue = this._startTimestamp.compareTo(stopWatchRecord.getStartTimestamp());
            if (compareToValue != 0) {
                return compareToValue;
            }
            Long duration = this.getDuration();
            Long stopWatchRecordDuration = stopWatchRecord.getDuration();
            if (duration == null && stopWatchRecordDuration != null) {
                return -1;
            }
            if (duration != null && stopWatchRecordDuration == null) {
                return 1;
            }
            if (duration != null && stopWatchRecordDuration != null) {
                compareToValue = -1 * duration.compareTo(stopWatchRecordDuration);
            }
            if (compareToValue != 0) {
                return compareToValue;
            }
            return this._name.compareTo(stopWatchRecord.getName());
        }

        public int getDepth() {
            if (this._parentStopWatchRecord == null) {
                if (this._baseBuild == null) {
                    return 0;
                }
                return this._baseBuild.getDepth() + 1;
            }
            return this._parentStopWatchRecord.getDepth() + 1;
        }

        public Long getDuration() {
            return this._duration;
        }

        public String getName() {
            return this._name;
        }

        public StopWatchRecord getParentStopWatchRecord() {
            return this._parentStopWatchRecord;
        }

        public String getShortName() {
            String shortName = this.getName();
            StopWatchRecord parentStopWatchRecord = this.getParentStopWatchRecord();
            if (parentStopWatchRecord == null) {
                return shortName;
            }
            return shortName.replace(parentStopWatchRecord.getName(), "");
        }

        public Long getStartTimestamp() {
            return this._startTimestamp;
        }

        public boolean isParentOf(StopWatchRecord stopWatchRecord) {
            if (this == stopWatchRecord) {
                return false;
            }
            Long duration = this.getDuration();
            Long stopWatchRecordDuration = stopWatchRecord.getDuration();
            if (duration != null && stopWatchRecordDuration == null) {
                return false;
            }
            Long startTimestamp = this.getStartTimestamp();
            Long stopWatchRecordStartTimestamp = stopWatchRecord.getStartTimestamp();
            if (startTimestamp <= stopWatchRecordStartTimestamp) {
                if (duration == null) {
                    return true;
                }
                Long endTimestamp = startTimestamp + duration;
                Long stopWatchRecordEndTimestamp = stopWatchRecordStartTimestamp + stopWatchRecordDuration;
                if (endTimestamp >= stopWatchRecordEndTimestamp) {
                    return true;
                }
            }
            return false;
        }

        public void setDuration(long duration) {
            this._duration = duration;
        }

        public String toString() {
            return JenkinsResultsParserUtil.combine(this.getName(), " started at ", JenkinsResultsParserUtil.toDateString(new Date(this.getStartTimestamp()), "America/Los_Angeles"), " and ran for ", JenkinsResultsParserUtil.toDurationString(this.getDuration()), ".");
        }

        protected Element getExpanderAnchorElement(String namespace) {
            if (this._childStopWatchRecords == null) {
                return null;
            }
            Element expanderAnchorElement = Dom4JUtil.getNewAnchorElement("", "+ ");
            expanderAnchorElement.addAttribute("id", JenkinsResultsParserUtil.combine(namespace, "-expander-anchor-", this.getName()));
            expanderAnchorElement.addAttribute("onClick", JenkinsResultsParserUtil.combine("return toggleStopWatchRecordExpander('", namespace, "', '", this.getName(), "')"));
            expanderAnchorElement.addAttribute("style", "font-family: monospace, monospace; text-decoration: none");
            return expanderAnchorElement;
        }

        protected List<Element> getJenkinsReportTableRowElements() {
            Element buildInfoElement = Dom4JUtil.getNewElement("tr", null, new Object[0]);
            String baseBuildHashCode = "";
            if (this._baseBuild != null) {
                baseBuildHashCode = String.valueOf(this._baseBuild.hashCode());
            }
            buildInfoElement.addAttribute("id", baseBuildHashCode + "-" + this.getName());
            buildInfoElement.addAttribute("style", "display: none");
            Element expanderAnchorElement = this.getExpanderAnchorElement(baseBuildHashCode);
            Element nameElement = Dom4JUtil.getNewElement("td", buildInfoElement, expanderAnchorElement, this.getShortName());
            int indent = this.getDepth() * 35;
            if (expanderAnchorElement != null) {
                indent -= 20;
            }
            nameElement.addAttribute("style", JenkinsResultsParserUtil.combine("text-indent: ", String.valueOf(indent), "px"));
            Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
            Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
            Dom4JUtil.getNewElement("td", buildInfoElement, this._baseBuild.toJenkinsReportDateString(new Date(this.getStartTimestamp()), this._baseBuild.getJenkinsReportTimeZoneName()));
            if (this.getDuration() == null) {
                Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
            } else {
                Dom4JUtil.getNewElement("td", buildInfoElement, JenkinsResultsParserUtil.toDurationString(this.getDuration()));
            }
            Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
            Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
            ArrayList<Element> jenkinsReportTableRowElements = new ArrayList<Element>();
            jenkinsReportTableRowElements.add(buildInfoElement);
            if (this._childStopWatchRecords != null) {
                ArrayList<String> childStopWatchRecordNames = new ArrayList<String>(this._childStopWatchRecords.size());
                for (StopWatchRecord childStopWatchRecord : this._childStopWatchRecords) {
                    childStopWatchRecordNames.add(childStopWatchRecord.getName());
                    List<Element> childJenkinsReportTableRowElements = childStopWatchRecord.getJenkinsReportTableRowElements();
                    for (Element childJenkinsReportTableRowElement : childJenkinsReportTableRowElements) {
                        childJenkinsReportTableRowElement.addAttribute("style", "display: none");
                    }
                    jenkinsReportTableRowElements.addAll(childJenkinsReportTableRowElements);
                }
                buildInfoElement.addAttribute("child-stopwatch-rows", JenkinsResultsParserUtil.join(",", childStopWatchRecordNames));
            }
            return jenkinsReportTableRowElements;
        }

        protected void setParentStopWatchRecord(StopWatchRecord stopWatchRecord) {
            this._parentStopWatchRecord = stopWatchRecord;
        }
    }

    public static class DefaultBranchInformation
    implements Build.BranchInformation {
        private String _branchInformationString;
        private final Build _build;
        private final String _repositoryType;

        @Override
        public String getCachedRemoteGitRefName() {
            return JenkinsResultsParserUtil.combine("cache-", this.getReceiverUsername(), "-", this.getUpstreamBranchSHA(), "-", this.getOriginName(), "-", this.getSenderBranchSHA());
        }

        @Override
        public String getOriginName() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.origin.name=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public Integer getPullRequestNumber() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.pull.request.number=(\\d+)\\n[\\S\\s]*")) {
                return Integer.valueOf(branchInformationString.replaceAll(regex, "$1"));
            }
            return 0;
        }

        @Override
        public String getReceiverUsername() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.receiver.username=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public String getRepositoryName() {
            Properties buildProperties;
            try {
                buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            String repositoryType = this._repositoryType;
            if (repositoryType.equals("portal.base") || repositoryType.equals("portal.ee")) {
                repositoryType = "portal";
            }
            return JenkinsResultsParserUtil.getProperty(buildProperties, repositoryType + ".repository", this.getUpstreamBranchName());
        }

        @Override
        public String getSenderBranchName() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.sender.branch.name=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public String getSenderBranchSHA() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.sender.branch.sha=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public RemoteGitRef getSenderRemoteGitRef() {
            String remoteURL = JenkinsResultsParserUtil.combine("git@github.com:", this.getSenderUsername(), "/", this.getRepositoryName(), ".git");
            return GitUtil.getRemoteGitRef(this.getSenderBranchName(), new File("."), remoteURL);
        }

        @Override
        public String getSenderUsername() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.sender.username=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public String getUpstreamBranchName() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.upstream.branch.name=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public String getUpstreamBranchSHA() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.upstream.branch.sha=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        protected DefaultBranchInformation(Build build, String repositoryType) {
            this._build = build;
            this._repositoryType = repositoryType;
        }

        private String _getBranchInformationString() {
            if (this._branchInformationString != null) {
                return this._branchInformationString;
            }
            String consoleText = this._build.getConsoleText();
            int x = -1;
            Pattern pattern = Pattern.compile(JenkinsResultsParserUtil.combine("## (http://cloud-.*/)?git.", this._repositoryType, ".properties"));
            Matcher matcher = pattern.matcher(consoleText);
            if (matcher.find()) {
                x = matcher.start();
            }
            if (x == -1) {
                return "";
            }
            int y = consoleText.indexOf("prepare.repositories.", x);
            if (y == -1) {
                y = consoleText.indexOf("Deleting:", x);
            }
            if ((y = consoleText.indexOf("\n", y)) == -1) {
                return "";
            }
            this._branchInformationString = consoleText.substring(x, y);
            return this._branchInformationString;
        }
    }

    public static class BuildDisplayNameComparator
    implements Comparator<Build> {
        @Override
        public int compare(Build build1, Build build2) {
            String displayName1 = build1.getDisplayName();
            String displayName2 = build2.getDisplayName();
            return displayName1.compareTo(displayName2);
        }
    }
}

