/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.MultiPattern;
import com.liferay.jenkins.results.parser.PoshiJUnitTestResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.failure.message.generator.CIFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.CompileFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GenericFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GradleTaskFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.IntegrationTestTimeoutFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.LocalGitMirrorFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.ModulesCompilationFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PMDFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PluginFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PluginGitIDFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.SemanticVersioningFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.SourceFormatFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.StartupFailureMessageGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.json.JSONObject;

public class AxisBuild
extends BaseBuild {
    protected static final Pattern archiveBuildURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("(", Pattern.quote("${dependencies.url}"), "|", Pattern.quote(JenkinsResultsParserUtil.URL_DEPENDENCIES_FILE), "|", Pattern.quote(JenkinsResultsParserUtil.URL_DEPENDENCIES_HTTP), ")/*(?<archiveName>.*)/(?<master>[^/]+)/+(?<jobName>[^/]+)/", "(?<axisVariable>AXIS_VARIABLE=[^,]+,[^/]+)/", "(?<buildNumber>\\d+)/?"));
    protected static final MultiPattern buildURLMultiPattern = new MultiPattern(JenkinsResultsParserUtil.combine("\\w+://(?<master>[^/]+)/+job/+(?<jobName>[^/]+)/", "(?<buildNumber>\\d+)/", "(?<axisVariable>AXIS_VARIABLE=[^,]+,[^/]+)/?"), JenkinsResultsParserUtil.combine("\\w+://(?<master>[^/]+)/+job/+(?<jobName>[^/]+)/", "(?<axisVariable>AXIS_VARIABLE=[^,]+,[^/]+)/", "(?<buildNumber>\\d+)/?"));
    protected static final String defaultLogBaseURL = "https://testray.liferay.com/reports/production/logs";
    protected String axisVariable;
    private static final FailureMessageGenerator[] _FAILURE_MESSAGE_GENERATORS = new FailureMessageGenerator[]{new ModulesCompilationFailureMessageGenerator(), new CompileFailureMessageGenerator(), new IntegrationTestTimeoutFailureMessageGenerator(), new LocalGitMirrorFailureMessageGenerator(), new PMDFailureMessageGenerator(), new PluginFailureMessageGenerator(), new PluginGitIDFailureMessageGenerator(), new SemanticVersioningFailureMessageGenerator(), new SourceFormatFailureMessageGenerator(), new StartupFailureMessageGenerator(), new GradleTaskFailureMessageGenerator(), new CIFailureMessageGenerator(), new GenericFailureMessageGenerator()};
    private static final Pattern _axisStartTimestampPattern = Pattern.compile("\\s*\\[echo\\] startTime: (?<startTime>[^\\n]+)");
    private static final Pattern _axisVariablePattern = Pattern.compile("AXIS_VARIABLE=(?<axisNumber>[^,]+),.*");

    @Override
    public void addTimelineData(BaseBuild.TimelineData timelineData) {
        timelineData.addTimelineData(this);
    }

    @Override
    public void findDownstreamBuilds() {
    }

    @Override
    public String getAppServer() {
        Build parentBuild = this.getParentBuild();
        return parentBuild.getAppServer();
    }

    @Override
    public String getArchivePath() {
        if (this.archiveName == null) {
            System.out.println("Build URL " + this.getBuildURL() + " has a null archive name");
        }
        StringBuilder sb = new StringBuilder(this.archiveName);
        if (!this.archiveName.endsWith("/")) {
            sb.append("/");
        }
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        sb.append(jenkinsMaster.getName());
        sb.append("/");
        sb.append(this.getJobName());
        sb.append("/");
        sb.append(this.getAxisVariable());
        sb.append("/");
        sb.append(this.getBuildNumber());
        return sb.toString();
    }

    @Override
    public URL getArtifactsBaseURL() {
        BatchBuild batchBuild = this.getParentBatchBuild();
        StringBuilder sb = new StringBuilder();
        sb.append(batchBuild.getArtifactsBaseURL());
        sb.append("/");
        sb.append(this.getAxisNumber());
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getAxisNumber() {
        Matcher matcher = _axisVariablePattern.matcher(this.getAxisVariable());
        if (matcher.find()) {
            return matcher.group("axisNumber");
        }
        throw new RuntimeException("Invalid axis variable: " + this.getAxisVariable());
    }

    public String getAxisVariable() {
        return this.axisVariable;
    }

    public String getBatchName() {
        BatchBuild parentBatchBuild = this.getParentBatchBuild();
        return parentBatchBuild.getBatchName();
    }

    @Override
    public String getBrowser() {
        Build parentBuild = this.getParentBuild();
        return parentBuild.getBrowser();
    }

    public String getBuildDescriptionTestrayReports() {
        Element unorderedListElement = Dom4JUtil.getNewElement("ul");
        for (TestResult testResult : this.getTestResults(null)) {
            if (!(testResult instanceof PoshiJUnitTestResult)) continue;
            Element listItemElement = Dom4JUtil.getNewElement("li", unorderedListElement, new Object[0]);
            Dom4JUtil.getNewElement("strong", listItemElement, testResult.getDisplayName());
            Element reportLinksUnorderedListElement = Dom4JUtil.getNewElement("ul", listItemElement, new Object[0]);
            Element poshiReportListItemElement = Dom4JUtil.getNewElement("li", reportLinksUnorderedListElement, new Object[0]);
            PoshiJUnitTestResult poshiJUnitTestResult = (PoshiJUnitTestResult)testResult;
            Dom4JUtil.getNewAnchorElement(poshiJUnitTestResult.getPoshiReportURL(), poshiReportListItemElement, new Object[]{"Poshi Report"});
            Element poshiSummaryListItemElement = Dom4JUtil.getNewElement("li", reportLinksUnorderedListElement, new Object[0]);
            Dom4JUtil.getNewAnchorElement(poshiJUnitTestResult.getPoshiSummaryURL(), poshiSummaryListItemElement, new Object[]{"Poshi Summary"});
        }
        Dom4JUtil.addToElement(unorderedListElement, Dom4JUtil.getNewElement("br"));
        try {
            return Dom4JUtil.format(unorderedListElement, false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to generate html", ioException);
        }
    }

    @Override
    public String getBuildURL() {
        String jobURL = this.getJobURL();
        int buildNumber = this.getBuildNumber();
        if (jobURL == null || buildNumber == -1) {
            return null;
        }
        if (this.fromArchive) {
            return JenkinsResultsParserUtil.combine(jobURL, "/", this.axisVariable, "/", String.valueOf(buildNumber), "/");
        }
        try {
            jobURL = JenkinsResultsParserUtil.decode(jobURL);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to decode " + jobURL, unsupportedEncodingException);
        }
        String buildURL = JenkinsResultsParserUtil.combine(jobURL, "/", this.axisVariable, "/", String.valueOf(buildNumber), "/");
        try {
            return JenkinsResultsParserUtil.encode(buildURL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Could not encode " + buildURL, malformedURLException);
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new RuntimeException("Could not encode " + buildURL, uriSyntaxException);
        }
    }

    @Override
    public String getBuildURLRegex() {
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        StringBuffer sb = new StringBuffer();
        sb.append("http[s]*:\\/\\/");
        sb.append(JenkinsResultsParserUtil.getRegexLiteral(jenkinsMaster.getName()));
        sb.append("[^\\/]*");
        sb.append("[\\/]+job[\\/]+");
        String jobNameRegexLiteral = JenkinsResultsParserUtil.getRegexLiteral(this.getJobName());
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\(", "(\\(|%28)");
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\)", "(\\)|%29)");
        sb.append(jobNameRegexLiteral);
        sb.append("[\\/]+");
        sb.append(JenkinsResultsParserUtil.getRegexLiteral(this.getAxisVariable()));
        sb.append("[\\/]+");
        sb.append(this.getBuildNumber());
        sb.append("[\\/]*");
        return sb.toString();
    }

    @Override
    public String getDatabase() {
        Build parentBuild = this.getParentBuild();
        return parentBuild.getDatabase();
    }

    @Override
    public String getDisplayName() {
        return JenkinsResultsParserUtil.combine(this.getAxisVariable(), " #", String.valueOf(this.getBuildNumber()));
    }

    @Override
    public Element getGitHubMessageElement() {
        Element failureMessageElement;
        String status = this.getStatus();
        if (!status.equals("completed") && this.getParentBuild() != null) {
            return null;
        }
        String result = this.getResult();
        if (result.equals("SUCCESS")) {
            return null;
        }
        Element messageElement = Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "/consoleText", null, this.getDisplayName()));
        if (result.equals("ABORTED")) {
            messageElement.add(Dom4JUtil.toCodeSnippetElement("Build was aborted"));
        }
        if (result.equals("FAILURE") && (failureMessageElement = this.getFailureMessageElement()) != null) {
            messageElement.add(failureMessageElement);
        }
        if (result.equals("UNSTABLE")) {
            List<Element> failureElements = this.getTestResultGitHubElements(this.getUniqueFailureTestResults());
            List<Element> upstreamJobFailureElements = this.getTestResultGitHubElements(this.getUpstreamJobFailureTestResults());
            if (!upstreamJobFailureElements.isEmpty()) {
                this.upstreamJobFailureMessageElement = messageElement.createCopy();
                Dom4JUtil.getOrderedListElement(upstreamJobFailureElements, this.upstreamJobFailureMessageElement, 3);
            }
            Dom4JUtil.getOrderedListElement(failureElements, messageElement, 3);
            if (failureElements.isEmpty()) {
                return null;
            }
        }
        return messageElement;
    }

    @Override
    public Long getInvokedTime() {
        if (this.invokedTime != null) {
            return this.invokedTime;
        }
        Build parentBuild = this.getParentBuild();
        this.invokedTime = parentBuild.getStartTime();
        return this.invokedTime;
    }

    @Override
    public String getJDK() {
        Build parentBuild = this.getParentBuild();
        return parentBuild.getJDK();
    }

    @Override
    public String getOperatingSystem() {
        Build parentBuild = this.getParentBuild();
        return parentBuild.getOperatingSystem();
    }

    public BatchBuild getParentBatchBuild() {
        Build parentBuild = this.getParentBuild();
        if (parentBuild instanceof BatchBuild) {
            return (BatchBuild)parentBuild;
        }
        return null;
    }

    @Override
    public Long getStartTime() {
        if (this.startTime != null) {
            return this.startTime;
        }
        String consoleText = this.getConsoleText();
        for (String line : consoleText.split("\n")) {
            Matcher matcher = _axisStartTimestampPattern.matcher(line);
            if (!matcher.find()) continue;
            Properties buildProperties = null;
            try {
                buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to get build properties");
            }
            SimpleDateFormat sdf = new SimpleDateFormat(buildProperties.getProperty("jenkins.report.date.format"));
            Date date = null;
            try {
                date = sdf.parse(matcher.group("startTime"));
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Unable to get start time", parseException);
            }
            this.startTime = date.getTime();
            break;
        }
        return this.startTime;
    }

    @Override
    public List<TestResult> getTestResults(String testStatus) {
        String status = this.getStatus();
        if (!status.equals("completed")) {
            return Collections.emptyList();
        }
        JSONObject testReportJSONObject = this.getTestReportJSONObject(true);
        if (testReportJSONObject == null) {
            System.out.println("Unable to get test results for: " + this.getBuildURL());
            return Collections.emptyList();
        }
        return this.getTestResults(this, testReportJSONObject.getJSONArray("suites"), testStatus);
    }

    @Override
    public List<TestResult> getUniqueFailureTestResults() {
        ArrayList<TestResult> uniqueFailureTestResults = new ArrayList<TestResult>();
        for (TestResult testResult : this.getTestResults(null)) {
            if (!testResult.isFailing() || !testResult.isUniqueFailure()) continue;
            uniqueFailureTestResults.add(testResult);
        }
        return uniqueFailureTestResults;
    }

    @Override
    public List<TestResult> getUpstreamJobFailureTestResults() {
        ArrayList<TestResult> upstreamFailureTestResults = new ArrayList<TestResult>();
        for (TestResult testResult : this.getTestResults(null)) {
            if (!testResult.isFailing() || testResult.isUniqueFailure()) continue;
            upstreamFailureTestResults.add(testResult);
        }
        return upstreamFailureTestResults;
    }

    public List<String> getWarningMessages() {
        ArrayList<String> warningMessages = new ArrayList<String>();
        URL poshiWarningsURL = null;
        try {
            poshiWarningsURL = new URL(this.getArtifactsBaseURL() + "/poshi-warnings.xml.gz");
        }
        catch (IOException ioException) {
            return warningMessages;
        }
        StringBuilder sb = new StringBuilder();
        try (InputStream inputStream = poshiWarningsURL.openStream();
             GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);){
            int i = 0;
            while ((i = gzipInputStream.read()) > 0) {
                sb.append((char)i);
            }
        }
        catch (IOException ioException) {
            return warningMessages;
        }
        try {
            Document document = Dom4JUtil.parse(sb.toString());
            Element rootElement = document.getRootElement();
            for (Element valueElement : rootElement.elements("value")) {
                String liferayErrorText = "LIFERAY_ERROR: ";
                String valueElementText = StringEscapeUtils.escapeHtml((String)valueElement.getText());
                if (valueElementText.startsWith(liferayErrorText)) {
                    valueElementText = valueElementText.substring(liferayErrorText.length());
                }
                warningMessages.add(valueElementText);
            }
        }
        catch (DocumentException documentException) {
            warningMessages.add("Unable to parse Poshi warnings");
        }
        return warningMessages;
    }

    @Override
    public void reinvoke() {
        throw new RuntimeException("Axis builds cannot be reinvoked");
    }

    protected AxisBuild(String url) {
        this(url, null);
    }

    protected AxisBuild(String url, BatchBuild parentBatchBuild) {
        super(JenkinsResultsParserUtil.getLocalURL(url), parentBatchBuild);
    }

    @Override
    protected void checkForReinvocation(String consoleText) {
    }

    @Override
    protected void extractBuildURLComponents(Matcher matcher) {
        super.extractBuildURLComponents(matcher);
        this.axisVariable = matcher.group("axisVariable");
    }

    @Override
    protected Pattern getArchiveBuildURLPattern() {
        return archiveBuildURLPattern;
    }

    @Override
    protected MultiPattern getBuildURLMultiPattern() {
        return buildURLMultiPattern;
    }

    @Override
    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return _FAILURE_MESSAGE_GENERATORS;
    }

    @Override
    protected Element getGitHubMessageJobResultsElement() {
        return null;
    }

    @Override
    protected String getStopPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/stop-properties.json";
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        JenkinsMaster topLevelBuildJenkinsMaster = topLevelBuild.getJenkinsMaster();
        return JenkinsResultsParserUtil.combine("http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/", topLevelBuildJenkinsMaster.getName(), "/", topLevelBuild.getJobName(), "/", String.valueOf(topLevelBuild.getBuildNumber()), "/", this.getJobName(), "/", this.getAxisVariable(), "/", this.getParameterValue("JOB_VARIANT"), "/", "stop.properties");
    }

    protected List<Element> getTestResultGitHubElements(List<TestResult> testResults) {
        ArrayList<Element> testResultGitHubElements = new ArrayList<Element>();
        for (TestResult testResult : testResults) {
            testResultGitHubElements.add(testResult.getGitHubElement());
        }
        return testResultGitHubElements;
    }
}

