/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoadBalancerUtil {
    protected static long RECENT_BATCH_AGE = 120000L;
    private static final Map<String, List<BatchRecord>> _recentBatchRecordsMap = new HashMap<String, List<BatchRecord>>();
    private static final Pattern _urlPattern = Pattern.compile("http://(?<masterPrefix>.+-\\d?).liferay.com");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMostAvailableMasterURL(Properties properties) throws Exception {
        long start = System.currentTimeMillis();
        int retryCount = 0;
        String baseInvocationURL;
        String masterPrefix;
        while (!(masterPrefix = LoadBalancerUtil.getMasterPrefix(baseInvocationURL = properties.getProperty("base.invocation.url"))).equals(baseInvocationURL)) {
            List<String> masters = JenkinsResultsParserUtil.getMasters(properties, masterPrefix);
            masters.removeAll(LoadBalancerUtil.getBlacklist(properties));
            if (masters.size() == 1) {
                return "http://" + masterPrefix + "-1";
            }
            int maxAvailableSlaveCount = Integer.MIN_VALUE;
            int x = -1;
            try {
                ArrayList<FutureTask<Integer>> futureTasks = new ArrayList<FutureTask<Integer>>(masters.size());
                LoadBalancerUtil.startParallelTasks(futureTasks, masters, masterPrefix, properties);
                ArrayList<Integer> badIndices = new ArrayList<Integer>(futureTasks.size());
                ArrayList<Integer> maxIndices = new ArrayList<Integer>(futureTasks.size());
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < futureTasks.size(); ++i) {
                    Integer availableSlaveCount = null;
                    FutureTask futureTask = (FutureTask)futureTasks.get(i);
                    try {
                        availableSlaveCount = (Integer)futureTask.get(15L, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException te) {
                        System.out.println("Unable to assess master availability for " + masters.get(i) + ".");
                        availableSlaveCount = null;
                    }
                    if (availableSlaveCount == null) {
                        badIndices.add(i);
                        continue;
                    }
                    sb.append(masters.get(i));
                    sb.append(" : ");
                    sb.append(availableSlaveCount);
                    sb.append("\n");
                    if (availableSlaveCount > maxAvailableSlaveCount) {
                        maxAvailableSlaveCount = availableSlaveCount;
                        maxIndices.clear();
                    }
                    if (availableSlaveCount < maxAvailableSlaveCount) continue;
                    maxIndices.add(i);
                }
                if (maxAvailableSlaveCount == Integer.MIN_VALUE) {
                    if (retryCount == 3) {
                        throw new RuntimeException("Retry limit exceeded. Unable to communicate with masters.");
                    }
                    ++retryCount;
                    continue;
                }
                if (!maxIndices.isEmpty()) {
                    x = (Integer)maxIndices.get(JenkinsResultsParserUtil.getRandomValue(0, maxIndices.size() - 1));
                } else {
                    while (badIndices.contains(x = JenkinsResultsParserUtil.getRandomValue(0, masters.size() - 1))) {
                    }
                }
                sb.append("\nMost available master ");
                sb.append(masters.get(x));
                sb.append(" has ");
                sb.append(maxAvailableSlaveCount);
                sb.append(" available slaves.");
                System.out.println(sb);
                String string = "http://" + masters.get(x);
                return string;
            }
            finally {
                if (RECENT_BATCH_AGE > 0L) {
                    List<BatchRecord> recentBatchSizeRecords = _recentBatchRecordsMap.get(masters.get(x));
                    if (recentBatchSizeRecords == null) {
                        recentBatchSizeRecords = new ArrayList<BatchRecord>();
                        _recentBatchRecordsMap.put(masters.get(x), recentBatchSizeRecords);
                    }
                    int invokedBatchSize = 0;
                    try {
                        invokedBatchSize = Integer.parseInt(properties.getProperty("invoked.job.batch.size"));
                    }
                    catch (Exception e) {
                        invokedBatchSize = 1;
                    }
                    if (invokedBatchSize != 0) {
                        recentBatchSizeRecords.add(new BatchRecord(invokedBatchSize, System.currentTimeMillis()));
                    }
                }
                System.out.println("Got most available master URL in " + (float)(System.currentTimeMillis() - start) / 1000.0f + " seconds.");
                continue;
            }
            break;
        }
        return baseInvocationURL;
    }

    public static String getMostAvailableMasterURL(String ... overridePropertiesArray) throws Exception {
        return LoadBalancerUtil.getMostAvailableMasterURL(null, overridePropertiesArray);
    }

    public static String getMostAvailableMasterURL(String propertiesURL, String[] overridePropertiesArray) throws Exception {
        Properties properties = new Properties();
        if (propertiesURL == null) {
            properties = JenkinsResultsParserUtil.getBuildProperties();
        } else {
            properties = new Properties();
            String propertiesString = JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(propertiesURL), false);
            properties.load(new StringReader(propertiesString));
        }
        if (overridePropertiesArray != null && overridePropertiesArray.length > 0 && overridePropertiesArray.length % 2 == 0) {
            for (int i = 0; i < overridePropertiesArray.length; i += 2) {
                String overridePropertyName = overridePropertiesArray[i];
                String overridePropertyValue = overridePropertiesArray[i + 1];
                if (overridePropertyValue == null) continue;
                properties.setProperty(overridePropertyName, overridePropertyValue);
            }
        }
        return LoadBalancerUtil.getMostAvailableMasterURL(properties);
    }

    protected static List<String> getBlacklist(Properties properties) {
        String blacklistString = properties.getProperty("jenkins.load.balancer.blacklist", "");
        System.out.println("Blacklist: " + blacklistString);
        if (blacklistString.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> blacklist = new ArrayList<String>();
        for (String blacklistItem : blacklistString.split(",")) {
            blacklist.add(blacklistItem.trim());
        }
        return blacklist;
    }

    protected static String getMasterPrefix(String baseInvocationURL) {
        Matcher matcher = _urlPattern.matcher(baseInvocationURL);
        if (!matcher.find()) {
            return baseInvocationURL;
        }
        return matcher.group("masterPrefix");
    }

    protected static int getRecentBatchSizesTotal(String master) throws Exception {
        List<BatchRecord> recentBatchRecords = _recentBatchRecordsMap.get(master);
        if (recentBatchRecords == null || recentBatchRecords.isEmpty()) {
            return 0;
        }
        int recentBatchSizesTotal = 0;
        ArrayList<BatchRecord> oldBatchRecords = new ArrayList<BatchRecord>(recentBatchRecords.size());
        for (BatchRecord recentBatchRecord : recentBatchRecords) {
            if (recentBatchRecord.timestamp + RECENT_BATCH_AGE > System.currentTimeMillis()) {
                recentBatchSizesTotal += recentBatchRecord.size;
                continue;
            }
            oldBatchRecords.add(recentBatchRecord);
        }
        recentBatchRecords.removeAll(oldBatchRecords);
        return recentBatchSizesTotal;
    }

    protected static void startParallelTasks(List<FutureTask<Integer>> futureTasks, List<String> masters, String masterPrefix, Properties properties) throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(masters.size());
        for (String targetMaster : masters) {
            FutureTask<Integer> futureTask = new FutureTask<Integer>(new AvailableSlaveCallable(LoadBalancerUtil.getRecentBatchSizesTotal(targetMaster), properties.getProperty("jenkins.local.url[" + targetMaster + "]")));
            executorService.execute(futureTask);
            futureTasks.add(futureTask);
        }
        executorService.shutdown();
    }

    private static class BatchRecord {
        public int size;
        public long timestamp;

        private BatchRecord(int size, long timestamp) {
            this.size = size;
            this.timestamp = timestamp;
        }
    }

    private static class AvailableSlaveCallable
    implements Callable<Integer> {
        protected Integer recentBatchSizesTotal;
        protected String url;

        @Override
        public Integer call() throws Exception {
            long start = System.currentTimeMillis();
            JSONObject computerJSONObject = null;
            JSONObject queueJSONObject = null;
            try {
                computerJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(this.url + "/computer/api/json?tree=computer[displayName,idle,offline]"), false, 5000);
                queueJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(this.url + "/queue/api/json?tree=items[task[name],why]"), false, 5000);
            }
            catch (Exception e) {
                System.out.println("Unable to read " + this.url);
                return null;
            }
            int idleCount = 0;
            JSONArray computersJSONArray = computerJSONObject.getJSONArray("computer");
            for (int i = 0; i < computersJSONArray.length(); ++i) {
                String displayName;
                JSONObject curComputerJSONObject = computersJSONArray.getJSONObject(i);
                if (!curComputerJSONObject.getBoolean("idle") || curComputerJSONObject.getBoolean("offline") || (displayName = curComputerJSONObject.getString("displayName")).equals("master")) continue;
                ++idleCount;
            }
            int queueCount = 0;
            if (queueJSONObject.has("items")) {
                JSONArray itemsJSONArray = queueJSONObject.getJSONArray("items");
                for (int i = 0; i < itemsJSONArray.length(); ++i) {
                    JSONObject taskJSONObject;
                    String taskName;
                    String why;
                    JSONObject itemJSONObject = itemsJSONArray.getJSONObject(i);
                    if (itemJSONObject.has("why") && (why = itemJSONObject.getString("why")).endsWith("is offline") || itemJSONObject.has("task") && (taskName = (taskJSONObject = itemJSONObject.getJSONObject("task")).getString("name")).equals("verification-node")) continue;
                    ++queueCount;
                }
            }
            int availableSlaveCount = idleCount - queueCount;
            if (this.recentBatchSizesTotal != null) {
                availableSlaveCount -= this.recentBatchSizesTotal.intValue();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{available=");
            sb.append(availableSlaveCount);
            sb.append(", duration=");
            sb.append(System.currentTimeMillis() - start);
            sb.append("ms, idle=");
            sb.append(idleCount);
            sb.append(", queue=");
            sb.append(queueCount);
            sb.append(", recentBatchSizesTotal=");
            sb.append(this.recentBatchSizesTotal);
            sb.append(", url=");
            sb.append(this.url);
            sb.append("}");
            System.out.println(sb.toString());
            return availableSlaveCount;
        }

        protected AvailableSlaveCallable(Integer recentBatchSizesTotal, String url) {
            this.recentBatchSizesTotal = recentBatchSizesTotal;
            this.url = url;
        }
    }
}

