/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.jcraft.jsch.Session;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CleanCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.json.JSONObject;

public class GitWorkingDirectory {
    private static final List<RepositoryState> _rebaseRepositoryStates = Arrays.asList(RepositoryState.REBASING, RepositoryState.REBASING_INTERACTIVE, RepositoryState.REBASING_MERGE, RepositoryState.REBASING_REBASING);
    private final Git _git;
    private File _gitDirectory;
    private List<RemoteConfig> _remoteConfigs;
    private final Repository _repository;
    private final String _repositoryName;
    private final String _repositoryUsername;
    private final String _upstreamBranchName;
    private File _workingDirectory;

    public static String getGitHubUserName(RemoteConfig remoteConfig) throws GitAPIException {
        String remoteURL = GitWorkingDirectory.getRemoteURL(remoteConfig);
        if (!remoteURL.contains("github.com")) {
            throw new IllegalArgumentException(JenkinsResultsParserUtil.combine(remoteConfig.getName(), " does not point to a GitHub repository"));
        }
        String userName = null;
        userName = remoteURL.startsWith("https://github.com/") ? remoteURL.substring("https://github.com/".length()) : remoteURL.substring("git@github.com:".length());
        return userName.substring(0, userName.indexOf("/"));
    }

    public GitWorkingDirectory(String upstreamBranchName, String workingDirectory) throws GitAPIException, IOException {
        this._upstreamBranchName = upstreamBranchName;
        this.setWorkingDirectory(workingDirectory);
        this.waitForIndexLock();
        FileRepositoryBuilder fileRepositoryBuilder = new FileRepositoryBuilder();
        fileRepositoryBuilder.setGitDir(this._gitDirectory);
        fileRepositoryBuilder.setWorkTree(this._workingDirectory);
        this._repository = fileRepositoryBuilder.build();
        this._git = new Git(this._repository);
        this._repositoryName = this.loadRepositoryName();
        this._repositoryUsername = this.loadRepositoryUsername();
    }

    public RemoteConfig addRemote(boolean force, String remoteName, String remoteURL) throws GitAPIException {
        System.out.println(JenkinsResultsParserUtil.combine("Adding remote ", remoteName, " with url: ", remoteURL));
        RemoteConfig remoteConfig = this.getRemoteConfig(remoteName);
        if (remoteConfig != null) {
            if (force) {
                this.removeRemote(remoteConfig);
            } else {
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Remote ", remoteName, " already exists"));
            }
        }
        try {
            JenkinsResultsParserUtil.executeBashCommands(true, this._workingDirectory, JenkinsResultsParserUtil.combine("git remote add ", remoteName, " ", remoteURL));
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Unable to add remote " + remoteName, e);
        }
        this._remoteConfigs = null;
        return this.getRemoteConfig(remoteName);
    }

    public void checkoutBranch(String branchName) throws GitAPIException {
        this.checkoutBranch(branchName, "-f");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkoutBranch(String branchName, String options) throws GitAPIException {
        System.out.println("Checking out branch " + branchName);
        this.waitForIndexLock();
        StringBuilder sb = new StringBuilder();
        sb.append("git checkout ");
        if (options != null) {
            sb.append(options);
            sb.append(" ");
        }
        sb.append(branchName);
        try {
            JenkinsResultsParserUtil.executeBashCommands(true, this._workingDirectory, sb.toString());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Unable to checkout branch " + branchName, e);
        }
        int timeout = 0;
        File headFile = new File(this._gitDirectory, "HEAD");
        try {
            do {
                String remoteName;
                int i;
                String remoteBranchName;
                String gitHubBranchCommit;
                String headContent = JenkinsResultsParserUtil.read(headFile);
                headContent = headContent.trim();
                if (!branchName.contains("/") ? headContent.matches(JenkinsResultsParserUtil.combine("ref: refs/heads/", branchName)) : headContent.equals(gitHubBranchCommit = this.getRemoteBranchSha(remoteBranchName = branchName.substring((i = branchName.indexOf("/")) + 1), this.getRemoteConfig(remoteName = branchName.substring(0, i))))) return;
                System.out.println("Waiting for branch to be updated");
                JenkinsResultsParserUtil.sleep(5000L);
            } while (++timeout < 24);
            throw new RuntimeException("Unable to checkout branch " + branchName);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to read file " + headFile.getPath(), ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() throws GitAPIException {
        StoredConfig storedConfig = this._repository.getConfig();
        boolean requireForce = storedConfig.getBoolean("clean", "requireForce", true);
        if (requireForce) {
            this.updateConfig("clean", null, "requireForce", false);
        }
        try {
            CleanCommand cleanCommand = this._git.clean();
            cleanCommand.setCleanDirectories(true);
            cleanCommand.setIgnore(true);
            System.out.println("Cleaning repository");
            cleanCommand.call();
        }
        finally {
            if (requireForce) {
                this.updateConfig("clean", null, "requireForce", null);
            }
        }
    }

    public void commitFileToCurrentBranch(String fileName, String message) throws GitAPIException {
        System.out.println("Committing file to current branch " + fileName);
        this.stageFileInCurrentBranch(fileName);
        this.commitStagedFilesToCurrentBranch(message);
    }

    public void commitStagedFilesToCurrentBranch(String message) throws GitAPIException {
        System.out.println("Committing staged files to current branch");
        CommitCommand commitCommand = this._git.commit();
        commitCommand.setMessage(message);
        commitCommand.call();
    }

    public void createLocalBranch(String branchName) throws GitAPIException {
        this.createLocalBranch(branchName, false, "HEAD");
    }

    public void createLocalBranch(String branchName, boolean force, String startPoint) throws GitAPIException {
        System.out.println(JenkinsResultsParserUtil.combine("Creating branch ", branchName, " at starting point ", startPoint));
        CreateBranchCommand createBranchCommand = this._git.branchCreate();
        createBranchCommand.setForce(force);
        createBranchCommand.setName(branchName);
        if (startPoint != null) {
            createBranchCommand.setStartPoint(startPoint);
        }
        createBranchCommand.call();
    }

    public String createPullRequest(String body, String pullRequestBranchName, String receiverUserName, String title) throws IOException {
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("base", (Object)this._upstreamBranchName);
        requestJSONObject.put("body", (Object)body);
        requestJSONObject.put("head", (Object)(receiverUserName + ":" + pullRequestBranchName));
        requestJSONObject.put("title", (Object)title);
        String url = JenkinsResultsParserUtil.combine("https://api.github.com/repos/", receiverUserName, "/", this._repositoryName, "/pulls");
        JSONObject responseJSONObject = JenkinsResultsParserUtil.toJSONObject(url, requestJSONObject.toString());
        String pullRequestURL = responseJSONObject.getString("html_url");
        System.out.println("Created a pull request at " + pullRequestURL);
        return pullRequestURL;
    }

    public void deleteLocalBranch(String localBranchName) throws GitAPIException {
        System.out.println("Deleting local branch " + localBranchName);
        DeleteBranchCommand deleteBranchCommand = this._git.branchDelete();
        deleteBranchCommand.setBranchNames(new String[]{localBranchName});
        deleteBranchCommand.setForce(true);
        deleteBranchCommand.call();
    }

    public void fetch(RefSpec refSpec, RemoteConfig remoteConfig) throws GitAPIException {
        FetchCommand fetchCommand = this._git.fetch();
        if (refSpec != null) {
            fetchCommand.setRefSpecs(new RefSpec[]{refSpec});
        } else {
            fetchCommand.setRefSpecs(remoteConfig.getFetchRefSpecs());
        }
        OutputStreamWriter consoleWriter = new OutputStreamWriter(System.out);
        fetchCommand.setProgressMonitor((ProgressMonitor)new TextProgressMonitor((Writer)consoleWriter));
        fetchCommand.setRemote(GitWorkingDirectory.getRemoteURL(remoteConfig));
        fetchCommand.setTimeout(360);
        int retries = 0;
        long start = 0L;
        while (true) {
            try {
                if (refSpec == null) {
                    System.out.println(JenkinsResultsParserUtil.combine("Fetching from ", GitWorkingDirectory.getRemoteURL(remoteConfig)));
                } else {
                    System.out.println(JenkinsResultsParserUtil.combine("Fetching from  ", GitWorkingDirectory.getRemoteURL(remoteConfig), " ", refSpec.toString()));
                }
                start = System.currentTimeMillis();
                fetchCommand.call();
                System.out.println("Fetch completed in " + JenkinsResultsParserUtil.toDurationString(System.currentTimeMillis() - start));
                return;
            }
            catch (TransportException te) {
                if (retries < 3) {
                    System.out.println(JenkinsResultsParserUtil.combine("Fetch attempt ", Integer.toString(retries), " failed with a transport exception. ", te.getMessage(), "\nRetrying."));
                    ++retries;
                    JenkinsResultsParserUtil.sleep(30000L);
                    continue;
                }
                throw te;
            }
            break;
        }
    }

    public void fetch(String localBranchName, String remoteBranchName, RemoteConfig remoteConfig) throws GitAPIException {
        RefSpec refSpec = new RefSpec(JenkinsResultsParserUtil.combine("refs/heads/", remoteBranchName, ":", localBranchName));
        this.fetch(refSpec, remoteConfig);
    }

    public List<Ref> getBranchRefs() throws GitAPIException {
        ListBranchCommand listBranchCommand = this._git.branchList();
        listBranchCommand.setListMode(ListBranchCommand.ListMode.ALL);
        return listBranchCommand.call();
    }

    public String getCurrentBranch() {
        this.waitForIndexLock();
        try {
            return this._repository.getBranch();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get current branch name from repository", ioe);
        }
    }

    public Git getGit() {
        return this._git;
    }

    public File getGitDirectory() {
        return this._gitDirectory;
    }

    public String getGitHubBranchSha(String branchName, RemoteConfig remoteConfig) {
        String command = JenkinsResultsParserUtil.combine("git ls-remote ", GitWorkingDirectory.getRemoteURL(remoteConfig), " ", branchName);
        try {
            Process process = JenkinsResultsParserUtil.executeBashCommands(command);
            String output = JenkinsResultsParserUtil.readInputStream(process.getInputStream());
            for (String line : output.split("\n")) {
                if (!line.endsWith("refs/heads/" + branchName)) continue;
                return line.substring(0, line.indexOf("\t"));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public List<String> getLocalBranchNames() throws GitAPIException {
        ArrayList<Ref> allLocalBranchRefs = new ArrayList<Ref>();
        for (Ref branchRef : this.getBranchRefs()) {
            String branchName = branchRef.getName();
            if (!branchName.startsWith("refs/heads")) continue;
            allLocalBranchRefs.add(branchRef);
        }
        return this.toShortNameList(allLocalBranchRefs);
    }

    public List<String> getRemoteBranchNames(RemoteConfig remoteConfig) throws GitAPIException {
        LsRemoteCommand lsRemoteCommand = Git.lsRemoteRepository();
        lsRemoteCommand.setHeads(true);
        lsRemoteCommand.setRemote(GitWorkingDirectory.getRemoteURL(remoteConfig));
        lsRemoteCommand.setTags(false);
        List<String> remoteBranchNames = this.toShortNameList(lsRemoteCommand.call());
        Collections.sort(remoteBranchNames);
        return remoteBranchNames;
    }

    public String getRemoteBranchSha(String branchName, RemoteConfig remoteConfig) throws GitAPIException {
        String remoteURL = GitWorkingDirectory.getRemoteURL(remoteConfig);
        if (remoteURL.contains("git@github.com")) {
            return this.getGitHubBranchSha(branchName, remoteConfig);
        }
        LsRemoteCommand lsRemoteCommand = Git.lsRemoteRepository();
        lsRemoteCommand.setHeads(true);
        lsRemoteCommand.setRemote(remoteURL);
        lsRemoteCommand.setTags(false);
        Collection remoteRefs = lsRemoteCommand.call();
        for (Ref remoteRef : remoteRefs) {
            String completeBranchName = "refs/heads/" + branchName;
            if (!completeBranchName.equals(remoteRef.getName())) continue;
            return remoteRef.getObjectId().getName();
        }
        return null;
    }

    public RemoteConfig getRemoteConfig(String remoteName) throws GitAPIException {
        List<RemoteConfig> remoteConfigs = this.getRemoteConfigs();
        for (RemoteConfig remoteConfig : remoteConfigs) {
            if (!remoteName.equals(remoteConfig.getName())) continue;
            return remoteConfig;
        }
        return null;
    }

    public List<RemoteConfig> getRemoteConfigs() throws GitAPIException {
        if (this._remoteConfigs != null) {
            return this._remoteConfigs;
        }
        try {
            this._remoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)this._repository.getConfig());
        }
        catch (URISyntaxException urise) {
            throw new RuntimeException(urise);
        }
        return this._remoteConfigs;
    }

    public Set<String> getRemoteNames() throws GitAPIException {
        List<RemoteConfig> remoteConfigs = this.getRemoteConfigs();
        HashSet<String> remoteNames = new HashSet<String>(remoteConfigs.size());
        for (RemoteConfig remoteConfig : remoteConfigs) {
            remoteNames.add(remoteConfig.getName());
        }
        return remoteNames;
    }

    public String getRepositoryName() {
        return this._repositoryName;
    }

    public String getRepositoryUsername() {
        return this._repositoryUsername;
    }

    public String getUpstreamBranchName() {
        return this._upstreamBranchName;
    }

    public File getWorkingDirectory() {
        return this._workingDirectory;
    }

    public boolean localBranchExists(String branchName) throws GitAPIException {
        List<String> localBranchNames = this.getLocalBranchNames();
        return localBranchNames.contains(branchName);
    }

    public boolean pushToRemote(RemoteConfig remoteConfig) throws GitAPIException {
        return this.pushToRemote(this.getCurrentBranch(), remoteConfig);
    }

    public boolean pushToRemote(String remoteBranchName, RemoteConfig remoteConfig) throws GitAPIException {
        return this.pushToRemote(this.getCurrentBranch(), remoteBranchName, remoteConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushToRemote(String remoteBranchName, String remoteURL) throws GitAPIException {
        RemoteConfig remoteConfig = null;
        try {
            remoteConfig = this.addRemote(true, "temp", remoteURL);
            boolean bl = this.pushToRemote(remoteBranchName, remoteConfig);
            this.removeRemote(remoteConfig);
            return bl;
        }
        catch (Throwable throwable) {
            this.removeRemote(remoteConfig);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushToRemote(String localBranchName, String remoteBranchName, RemoteConfig remoteConfig) throws GitAPIException {
        String remoteURL = GitWorkingDirectory.getRemoteURL(remoteConfig);
        System.out.println(JenkinsResultsParserUtil.combine("Pushing ", localBranchName, " to ", remoteURL, " ", remoteBranchName));
        PushCommand pushCommand = null;
        Git git = this._git;
        synchronized (git) {
            pushCommand = this._git.push();
        }
        String remoteRefName = "refs/heads/" + remoteBranchName;
        RefSpec refSpec = new RefSpec(JenkinsResultsParserUtil.combine(localBranchName, ":", remoteRefName));
        PushCommand pushCommand2 = pushCommand;
        synchronized (pushCommand2) {
            pushCommand.setRefSpecs(new RefSpec[]{refSpec});
            pushCommand.setRemote(remoteURL);
            for (PushResult pushResult : pushCommand.call()) {
                for (RemoteRefUpdate remoteRefUpdate : pushResult.getRemoteUpdates()) {
                    if (remoteRefUpdate == null || remoteRefUpdate.getStatus() == RemoteRefUpdate.Status.OK) continue;
                    System.out.println(JenkinsResultsParserUtil.combine("Unable to push ", localBranchName, " to ", GitWorkingDirectory.getRemoteURL(remoteConfig), ".\nPush response: ", remoteRefUpdate.toString()));
                    return false;
                }
            }
            return true;
        }
    }

    public boolean rebase(boolean abortOnFail, String branchName, String sha) throws GitAPIException, IOException {
        if (!branchName.equals(this.getCurrentBranch())) {
            this.checkoutBranch(branchName);
        }
        RebaseCommand rebaseCommand = this._git.rebase();
        rebaseCommand.setOperation(RebaseCommand.Operation.BEGIN);
        rebaseCommand.setUpstream(sha);
        System.out.println(JenkinsResultsParserUtil.combine("Rebasing ", this.getCurrentBranch(), " to ", sha));
        RebaseResult result = rebaseCommand.call();
        RebaseResult.Status status = result.getStatus();
        if (!status.isSuccessful()) {
            System.out.println("Rebase failed. " + status.toString());
            if (abortOnFail) {
                this.rebaseAbort();
            }
            return false;
        }
        return true;
    }

    public void rebaseAbort() throws GitAPIException {
        if (!_rebaseRepositoryStates.contains(this._repository.getRepositoryState())) {
            return;
        }
        RebaseCommand rebaseCommand = this._git.rebase();
        rebaseCommand.setOperation(RebaseCommand.Operation.ABORT);
        System.out.println("Aborting rebase " + RebaseCommand.Operation.ABORT.toString());
        rebaseCommand.call();
    }

    public boolean remoteExists(String remoteName) throws GitAPIException {
        Set<String> remoteNames = this.getRemoteNames();
        return remoteNames.contains(remoteName);
    }

    public void removeRemote(RemoteConfig remoteConfig) {
        try {
            if (!this.remoteExists(remoteConfig.getName())) {
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to remove remote ", remoteConfig.getName(), " because it does not exist"));
            }
            System.out.println("Removing remote " + remoteConfig.getName());
            try {
                JenkinsResultsParserUtil.executeBashCommands(true, this._workingDirectory, "git remote remove " + remoteConfig.getName());
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Unable to remove remote " + remoteConfig.getName(), e);
            }
            if (this._remoteConfigs.contains(remoteConfig)) {
                this._remoteConfigs.remove(remoteConfig);
            } else {
                this._remoteConfigs = null;
            }
        }
        catch (GitAPIException gapie) {
            gapie.printStackTrace();
        }
    }

    public void removeRemotes(List<RemoteConfig> remoteConfigs) {
        for (RemoteConfig remoteConfig : remoteConfigs) {
            this.removeRemote(remoteConfig);
        }
    }

    public void reset(String ref, ResetCommand.ResetType resetType) throws GitAPIException {
        if (ref.equalsIgnoreCase("HEAD")) {
            ref = null;
        }
        ResetCommand resetCommand = this._git.reset();
        resetCommand.setMode(resetType);
        if (ref != null) {
            resetCommand.setRef(ref);
        } else {
            ref = "HEAD";
        }
        System.out.println(JenkinsResultsParserUtil.combine("Resetting ", resetType.toString(), " to ", ref));
        resetCommand.call();
    }

    public void stageFileInCurrentBranch(String fileName) throws GitAPIException {
        AddCommand addCommand = this._git.add();
        addCommand.addFilepattern(fileName);
        System.out.println("Staging file in current branch " + fileName);
        addCommand.call();
    }

    public void updateConfig(String section, String subsection, String name, Object value) {
        StoredConfig storedConfig = this._repository.getConfig();
        if (value == null) {
            storedConfig.unset(section, subsection, name);
        }
        if (value instanceof Boolean) {
            storedConfig.setBoolean(section, subsection, name, ((Boolean)value).booleanValue());
        }
        if (value instanceof String) {
            storedConfig.setString(section, subsection, name, (String)value);
        }
        try {
            storedConfig.save();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to save configuration change");
        }
    }

    protected static String getRemoteURL(RemoteConfig remoteConfig) {
        List uris = remoteConfig.getURIs();
        URIish uri = (URIish)uris.get(0);
        return uri.toString();
    }

    protected String loadRepositoryName() throws GitAPIException {
        int y;
        int x;
        String remoteURL = GitWorkingDirectory.getRemoteURL(this.getRemoteConfig("upstream"));
        String repositoryName = remoteURL.substring(x = remoteURL.lastIndexOf("/") + 1, y = remoteURL.indexOf(".git"));
        if (repositoryName.equals("liferay-jenkins-tools-private")) {
            return repositoryName;
        }
        if ((repositoryName.equals("liferay-plugins-ee") || repositoryName.equals("liferay-portal-ee")) && !this._upstreamBranchName.contains("ee-") && !this._upstreamBranchName.contains("-private")) {
            repositoryName = repositoryName.replace("-ee", "");
        }
        if (repositoryName.contains("-private") && !this._upstreamBranchName.contains("-private")) {
            repositoryName = repositoryName.replace("-private", "");
        }
        return repositoryName;
    }

    protected String loadRepositoryUsername() throws GitAPIException {
        String remoteURL = GitWorkingDirectory.getRemoteURL(this.getRemoteConfig("upstream"));
        int x = remoteURL.indexOf(":") + 1;
        int y = remoteURL.indexOf("/");
        return remoteURL.substring(x, y);
    }

    protected void setWorkingDirectory(String workingDirectory) throws GitAPIException, IOException {
        this._workingDirectory = new File(workingDirectory);
        if (!this._workingDirectory.exists()) {
            throw new FileNotFoundException(this._workingDirectory.getPath() + " is unavailable");
        }
        this._gitDirectory = new File(workingDirectory, ".git");
        if (!this._gitDirectory.exists()) {
            throw new FileNotFoundException(this._gitDirectory.getPath() + " is unavailable");
        }
    }

    protected List<String> toShortNameList(Collection<Ref> refs) {
        ArrayList<String> shortNames = new ArrayList<String>(refs.size());
        for (Ref ref : refs) {
            String refName = ref.getName();
            shortNames.add(refName.substring(refName.lastIndexOf("/") + 1));
        }
        return shortNames;
    }

    protected void waitForIndexLock() {
        int retries = 0;
        File file = new File(this._gitDirectory, "index.lock");
        while (file.exists()) {
            System.out.println("Waiting for index.lock to be cleared.");
            JenkinsResultsParserUtil.sleep(5000L);
            if (++retries < 24) continue;
            file.delete();
        }
    }

    static {
        JschConfigSessionFactory jschConfigSessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host host, Session session) {
                session.setConfig("StrictHostKeyChecking", "no");
            }
        };
        SshSessionFactory.setInstance((SshSessionFactory)jschConfigSessionFactory);
    }
}

