/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class CentralSubrepository {
    private Boolean _centralPullRequestCandidate;
    private final String _centralUpstreamBranchName;
    private final Properties _gitrepoProperties;
    private final String _subrepositoryName;
    private final String _subrepositoryUpstreamBranchName;
    private String _subrepositoryUpstreamCommit;
    private final String _subrepositoryUsername;

    public CentralSubrepository(File gitrepoFile, String centralUpstreamBranchName) throws IOException {
        this._centralUpstreamBranchName = centralUpstreamBranchName;
        this._gitrepoProperties = new Properties();
        this._gitrepoProperties.load(new FileInputStream(gitrepoFile));
        this._subrepositoryName = this._getSubrepositoryName();
        this._subrepositoryUpstreamBranchName = this._getSubrepositoryUpstreamBranchName();
        this._subrepositoryUsername = this._getSubrepositoryUsername();
    }

    public String getSubrepositoryName() {
        return this._subrepositoryName;
    }

    public String getSubrepositoryUpstreamCommit() throws IOException {
        if (this._subrepositoryUpstreamCommit == null) {
            this._subrepositoryUpstreamCommit = this._getSubrepositoryUpstreamCommit();
        }
        return this._subrepositoryUpstreamCommit;
    }

    public Boolean isCentralPullRequestCandidate() throws IOException {
        if (this._centralPullRequestCandidate == null) {
            this._centralPullRequestCandidate = this._isCentralPullRequestCandidate();
        }
        return this._centralPullRequestCandidate;
    }

    private String _getMergePullRequestURL() throws IOException {
        String subrepositoryUpstreamCommit = this.getSubrepositoryUpstreamCommit();
        String url = JenkinsResultsParserUtil.combine("https://api.github.com/repos/", this._subrepositoryUsername, "/", this._subrepositoryName, "/commits/", subrepositoryUpstreamCommit, "/statuses");
        JSONArray statusesJSONArray = new JSONArray(JenkinsResultsParserUtil.toString(url, true));
        if (statusesJSONArray != null) {
            for (int i = 0; i < statusesJSONArray.length(); ++i) {
                JSONObject statusesJSONObject = statusesJSONArray.getJSONObject(i);
                String context = statusesJSONObject.getString("context");
                if (!context.equals("liferay/central-pull-request")) continue;
                return statusesJSONObject.getString("target_url");
            }
        }
        return null;
    }

    private String _getSubrepositoryName() {
        String remote = this._gitrepoProperties.getProperty("remote");
        int x = remote.indexOf("/") + 1;
        int y = remote.indexOf(".git");
        return remote.substring(x, y);
    }

    private String _getSubrepositoryUpstreamBranchName() {
        String remote = this._gitrepoProperties.getProperty("remote");
        String subrepositoryUpstreamBranchName = this._centralUpstreamBranchName;
        if (subrepositoryUpstreamBranchName.contains("7.0")) {
            subrepositoryUpstreamBranchName = "7.0.x";
        }
        if (remote.contains("-private")) {
            subrepositoryUpstreamBranchName = subrepositoryUpstreamBranchName + "-private";
        }
        return subrepositoryUpstreamBranchName;
    }

    private String _getSubrepositoryUpstreamCommit() throws IOException {
        String url = JenkinsResultsParserUtil.combine("https://api.github.com/repos/", this._subrepositoryUsername, "/", this._subrepositoryName, "/git/refs/heads/", this._subrepositoryUpstreamBranchName);
        JSONObject branchJSONObject = JenkinsResultsParserUtil.toJSONObject(url, false);
        JSONObject objectJSONObject = branchJSONObject.getJSONObject("object");
        return objectJSONObject.getString("sha");
    }

    private String _getSubrepositoryUsername() {
        String remote = this._gitrepoProperties.getProperty("remote");
        int x = remote.indexOf(":") + 1;
        int y = remote.indexOf("/");
        return remote.substring(x, y);
    }

    private Boolean _isCentralPullRequestCandidate() throws IOException {
        String subrepositoryUpstreamCommit;
        String mode = this._gitrepoProperties.getProperty("mode", "push");
        if (!mode.equals("pull")) {
            return false;
        }
        String autopull = this._gitrepoProperties.getProperty("autopull", "false");
        if (!autopull.equals("true")) {
            return false;
        }
        String subrepositoryMergedCommit = this._gitrepoProperties.getProperty("commit", "");
        if (subrepositoryMergedCommit.equals(subrepositoryUpstreamCommit = this.getSubrepositoryUpstreamCommit())) {
            System.out.println(JenkinsResultsParserUtil.combine("SKIPPED: ", this._subrepositoryName, " contains merged commit https://github.com/", this._subrepositoryUsername, "/", this._subrepositoryName, "/commit/", subrepositoryUpstreamCommit));
            return false;
        }
        String mergePullRequestURL = this._getMergePullRequestURL();
        if (mergePullRequestURL != null) {
            System.out.println(JenkinsResultsParserUtil.combine("SKIPPED: ", this._subrepositoryName, " contains an open merge pull request ", mergePullRequestURL));
            return false;
        }
        return true;
    }
}

