/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;

public class BatchBuild
extends BaseBuild {
    protected final Pattern majorVersionPattern = Pattern.compile("((\\d+)\\.?(\\d+?)).*");

    @Override
    public String getAppServer() {
        return this.getEnvironment("app.server");
    }

    @Override
    public String getBrowser() {
        return this.getEnvironment("browser");
    }

    @Override
    public String getDatabase() {
        return this.getEnvironment("database");
    }

    @Override
    public Element getGitHubMessageElement() {
        Collections.sort(this.downstreamBuilds, new BaseBuild.BuildDisplayNameComparator());
        Element messageElement = super.getGitHubMessageElement();
        if (messageElement == null) {
            return messageElement;
        }
        String result = this.getResult();
        if (result.equals("ABORTED") && this.getDownstreamBuildCount(null) == 0) {
            return messageElement;
        }
        Element downstreamBuildOrderedListElement = Dom4JUtil.getNewElement("ol", messageElement, new Object[0]);
        ArrayList<Element> failureElements = new ArrayList<Element>();
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            String downstreamBuildResult = downstreamBuild.getResult();
            if (downstreamBuildResult.equals("SUCCESS")) continue;
            Element failureElement = downstreamBuild.getGitHubMessageElement();
            if (BatchBuild.isHighPriorityBuildFailureElement(failureElement)) {
                failureElements.add(0, failureElement);
                continue;
            }
            failureElements.add(failureElement);
        }
        int failCount = 0;
        for (Element failureElement : failureElements) {
            if (++failCount < 4) {
                Dom4JUtil.getNewElement("li", downstreamBuildOrderedListElement, failureElement);
                continue;
            }
            Dom4JUtil.getNewElement("li", downstreamBuildOrderedListElement, "...");
            break;
        }
        if (failureElements.size() >= 4) {
            Dom4JUtil.getNewElement("strong", messageElement, "Click ", Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "testReport", "here"), " for more failures.");
        }
        return messageElement;
    }

    @Override
    public String getJDK() {
        return this.getEnvironment("java.jdk");
    }

    @Override
    public String getOperatingSystem() {
        return this.getEnvironment("operating.system");
    }

    @Override
    public List<TestResult> getTestResults(String testStatus) {
        String status = this.getStatus();
        if (!status.equals("completed")) {
            return null;
        }
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        JSONObject testReportJSONObject = this.getTestReportJSONObject();
        JSONArray childReportsJSONArray = testReportJSONObject.getJSONArray("childReports");
        for (int i = 0; i < childReportsJSONArray.length(); ++i) {
            JSONObject childReportJSONObject = childReportsJSONArray.getJSONObject(i);
            JSONObject childJSONObject = childReportJSONObject.getJSONObject("child");
            String axisBuildURL = childJSONObject.getString("url");
            Matcher axisBuildURLMatcher = null;
            axisBuildURLMatcher = this.fromArchive ? AxisBuild.archiveBuildURLPattern.matcher(axisBuildURL) : AxisBuild.buildURLPattern.matcher(axisBuildURL);
            axisBuildURLMatcher.find();
            String axisVariable = axisBuildURLMatcher.group("axisVariable");
            JSONObject resultJSONObject = childReportJSONObject.getJSONObject("result");
            JSONArray suitesJSONArray = resultJSONObject.getJSONArray("suites");
            testResults.addAll(TestResult.getTestResults(this.getAxisBuild(axisVariable), suitesJSONArray, testStatus));
        }
        return testResults;
    }

    protected BatchBuild(String url) {
        this(url, null);
    }

    protected BatchBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    protected List<String> findDownstreamBuildsInConsoleText(String consoleText) {
        return Collections.emptyList();
    }

    protected AxisBuild getAxisBuild(String axisVariable) {
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            AxisBuild downstreamAxisBuild = (AxisBuild)downstreamBuild;
            if (!axisVariable.equals(downstreamAxisBuild.getAxisVariable())) continue;
            return downstreamAxisBuild;
        }
        return null;
    }

    protected String getBatchComponent(String batchName, String environmentOption) {
        int x = batchName.indexOf(environmentOption);
        int y = batchName.indexOf("-", x);
        if (y == -1) {
            y = batchName.length();
        }
        return batchName.substring(x, y);
    }

    protected String getEnvironment(String environmentType) {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get build properties", ioe);
        }
        ArrayList<String> environmentOptions = new ArrayList<String>(Arrays.asList(StringUtils.split((String)buildProperties.getProperty(environmentType + ".types"), (String)",")));
        String batchName = this.getJobVariant();
        for (String environmentOption : environmentOptions) {
            if (!batchName.contains(environmentOption)) continue;
            String batchComponent = this.getBatchComponent(batchName, environmentOption);
            return buildProperties.getProperty("env.option." + environmentType + "." + batchComponent);
        }
        String name = buildProperties.getProperty(environmentType + ".type");
        String environmentVersion = (String)buildProperties.get(environmentType + "." + name + ".version");
        Matcher matcher = this.majorVersionPattern.matcher(buildProperties.getProperty(environmentType + "." + name + ".version"));
        String environmentMajorVersion = matcher.matches() ? matcher.group(1) : environmentVersion;
        if (environmentType.equals("java.jdk")) {
            return buildProperties.getProperty("env.option." + environmentType + "." + name + "." + environmentMajorVersion.replace(".", ""));
        }
        return buildProperties.getProperty("env.option." + environmentType + "." + name + environmentMajorVersion.replace(".", ""));
    }

    @Override
    protected Element getFailureMessageElement() {
        return null;
    }

    @Override
    protected Element getGitHubMessageJobResultsElement() {
        String result = this.getResult();
        int failCount = this.getDownstreamBuildCountByResult("FAILURE");
        int successCount = this.getDownstreamBuildCountByResult("SUCCESS");
        if (result.equals("UNSTABLE")) {
            failCount = this.getTestCountByStatus("FAILURE");
            successCount = this.getTestCountByStatus("SUCCESS");
        }
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("h6", null, "Job Results:"), Dom4JUtil.getNewElement("p", null, Integer.toString(successCount), JenkinsResultsParserUtil.getNounForm(successCount, " Tests", " Test"), " Passed.", Dom4JUtil.getNewElement("br"), Integer.toString(failCount), JenkinsResultsParserUtil.getNounForm(failCount, " Tests", " Test"), " Failed.", this.getFailureMessageElement()));
    }

    protected int getTestCountByStatus(String status) {
        JSONObject testReportJSONObject = this.getTestReportJSONObject();
        int failCount = testReportJSONObject.getInt("failCount");
        int skipCount = testReportJSONObject.getInt("skipCount");
        int totalCount = testReportJSONObject.getInt("totalCount");
        if (status.equals("SUCCESS")) {
            return totalCount - skipCount - failCount;
        }
        if (status.equals("FAILURE")) {
            return failCount;
        }
        throw new IllegalArgumentException("Invalid status: " + status);
    }
}

