/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutoCloseRule {
    protected int maxFailCount = -1;
    protected float maxFailPercentage = -1.0f;
    protected String ruleData;
    protected Pattern rulePattern;

    public AutoCloseRule(String ruleData) {
        this.ruleData = ruleData;
        String[] ruleDataArray = ruleData.split("\\|");
        this.rulePattern = Pattern.compile(ruleDataArray[0]);
        if (ruleDataArray[1].endsWith("%")) {
            String percentageRule = ruleDataArray[1];
            this.maxFailPercentage = Integer.parseInt(percentageRule.substring(0, percentageRule.length() - 1)) / 100;
        } else {
            this.maxFailCount = Integer.parseInt(ruleDataArray[1]);
        }
    }

    public List<Build> evaluate(List<Build> downstreamBuilds) {
        if ((downstreamBuilds = this.getMatchingBuilds(downstreamBuilds)).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Build> failedDownstreamBuilds = new ArrayList<Build>(downstreamBuilds.size());
        int failLimit = 0;
        if (this.maxFailPercentage != -1.0f) {
            failLimit = (int)(this.maxFailPercentage * (float)downstreamBuilds.size());
            if (failLimit > 0) {
                --failLimit;
            }
        } else {
            failLimit = this.maxFailCount;
        }
        for (Build downstreamBuild : downstreamBuilds) {
            String result;
            String status = downstreamBuild.getStatus();
            if (!status.equals("completed") || (result = downstreamBuild.getResult()) == null || result.equals("SUCCESS")) continue;
            failedDownstreamBuilds.add(downstreamBuild);
        }
        if (failedDownstreamBuilds.size() > failLimit) {
            return failedDownstreamBuilds;
        }
        return Collections.emptyList();
    }

    public String toString() {
        return this.ruleData;
    }

    protected String getBatchName(Build build) {
        String batchName = build.getParameterValue("JOB_VARIANT");
        if (batchName == null || batchName.isEmpty()) {
            batchName = build.getParameterValue("JENKINS_JOB_VARIANT");
        }
        return batchName;
    }

    protected List<Build> getMatchingBuilds(List<Build> downstreamBuilds) {
        ArrayList<Build> filteredDownstreamBuilds = new ArrayList<Build>(downstreamBuilds.size());
        for (Build downstreamBuild : downstreamBuilds) {
            Matcher matcher;
            String batchName = this.getBatchName(downstreamBuild);
            if (batchName == null || batchName.isEmpty() || !(matcher = this.rulePattern.matcher(this.getBatchName(downstreamBuild))).matches()) continue;
            filteredDownstreamBuilds.add(downstreamBuild);
        }
        return filteredDownstreamBuilds;
    }
}

