/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JenkinsPerformanceDataUtil {
    private static boolean _broken;
    private static final List<Result> _results;

    public static List<Result> getSlowestResults() {
        if (_broken) {
            return null;
        }
        return _results;
    }

    public static void processPerformanceData(String jobName, String url, int size) {
        if (_broken) {
            return;
        }
        try {
            JSONObject jsonObject = null;
            if (url.contains("-source")) {
                jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(url + "/api/json"), false);
                _results.add(new Result(jobName, jsonObject));
                Collections.sort(_results);
                JenkinsPerformanceDataUtil._truncate(_results, size);
                return;
            }
            int retryCount = 0;
            while (true) {
                try {
                    jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(url + "/testReport/api/json"), false);
                }
                catch (FileNotFoundException fnfe) {
                    jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(url + "/api/json"), false);
                    _results.add(new Result(jobName, jsonObject));
                    break;
                }
                try {
                    _results.addAll(JenkinsPerformanceDataUtil._getSlowestResults(jobName, jsonObject, size));
                }
                catch (IllegalArgumentException iae) {
                    if (++retryCount > 5) {
                        System.out.println("Exceeded max retries");
                        throw iae;
                    }
                    System.out.println("Retry in 60 seconds: " + iae.getMessage());
                    Thread.sleep(60000L);
                    continue;
                }
                break;
            }
            Collections.sort(_results);
            JenkinsPerformanceDataUtil._truncate(_results, size);
        }
        catch (Exception e) {
            System.out.println("Unable to parse performance data.");
            e.printStackTrace();
            _broken = true;
        }
    }

    public static void reset() {
        _broken = false;
        _results.clear();
    }

    private static List<Result> _getSlowestResults(String name, JSONObject jobJSONObject, int maxSize) throws Exception {
        ArrayList<Result> results = new ArrayList<Result>();
        JSONArray childReportsJSONArray = jobJSONObject.getJSONArray("childReports");
        for (int i = 0; i < childReportsJSONArray.length(); ++i) {
            JSONObject childReportJSONObject = childReportsJSONArray.getJSONObject(i);
            if (!childReportJSONObject.has("child") || childReportJSONObject.isNull("child")) {
                throw new IllegalArgumentException("Child element is missing");
            }
            JSONObject childJSONObject = childReportJSONObject.getJSONObject("child");
            if (!childReportJSONObject.has("result") || childReportJSONObject.isNull("result")) {
                throw new IllegalArgumentException("Result element is missing for " + childJSONObject.getString("url"));
            }
            JSONObject childResultJSONObject = childReportJSONObject.getJSONObject("result");
            JSONArray suitesJSONArray = childResultJSONObject.getJSONArray("suites");
            for (int j = 0; j < suitesJSONArray.length(); ++j) {
                JSONObject suiteJSONObject = suitesJSONArray.getJSONObject(j);
                JSONArray casesJSONArray = suiteJSONObject.getJSONArray("cases");
                for (int k = 0; k < casesJSONArray.length(); ++k) {
                    JSONObject caseJSONObject = casesJSONArray.getJSONObject(k);
                    Result result = new Result(caseJSONObject, childJSONObject, name);
                    results.add(result);
                }
            }
        }
        Collections.sort(results);
        JenkinsPerformanceDataUtil._truncate(results, maxSize);
        return results;
    }

    private static void _truncate(List<?> list, int maxSize) {
        if (list.size() < maxSize) {
            return;
        }
        List<?> subList = list.subList(maxSize, list.size());
        subList.clear();
    }

    static {
        _results = new ArrayList<Result>();
    }

    public static class Result
    implements Comparable<Result> {
        private String _axis;
        private final String _className;
        private final int _duration;
        private final String _jobName;
        private final String _name;
        private final String _status;
        private String _url;

        public Result(JSONObject caseJSONObject, JSONObject childJSONObject, String jobName) throws Exception {
            this._jobName = jobName;
            this._className = caseJSONObject.getString("className");
            this._duration = caseJSONObject.getInt("duration");
            this._name = caseJSONObject.getString("name");
            this._status = caseJSONObject.getString("status");
            this._setAxis(childJSONObject);
            this._setUrl(childJSONObject);
        }

        public Result(String jobName, JSONObject sourceJSONObject) throws Exception {
            this._axis = "";
            this._className = "";
            this._duration = sourceJSONObject.getInt("duration") / 1000;
            this._jobName = jobName;
            this._name = sourceJSONObject.getString("fullDisplayName");
            this._status = sourceJSONObject.getString("result");
            this._url = sourceJSONObject.getString("url");
        }

        @Override
        public int compareTo(Result result) {
            return -1 * Float.compare(this.getDuration(), result.getDuration());
        }

        public String getAxis() {
            return this._axis;
        }

        public String getClassName() {
            return this._className;
        }

        public float getDuration() {
            return this._duration;
        }

        public String getJobName() {
            return this._jobName;
        }

        public String getName() {
            return this._name;
        }

        public String getStatus() {
            return this._status;
        }

        public String getUrl() {
            return this._url;
        }

        private void _setAxis(JSONObject childJSONObject) throws Exception {
            String _url = childJSONObject.getString("url");
            _url = URLDecoder.decode(_url, "UTF-8");
            int x = _url.indexOf("AXIS_VARIABLE");
            _url = _url.substring(x);
            int y = _url.indexOf(",");
            this._axis = _url.substring(0, y);
        }

        private void _setUrl(JSONObject childJSONObject) throws Exception {
            String urlString = URLDecoder.decode(childJSONObject.getString("url"), "UTF-8");
            StringBuilder sb = new StringBuilder(urlString);
            sb.append("testReport/");
            int x = this._className.lastIndexOf(".");
            sb.append(this._className.substring(0, x));
            sb.append("/");
            sb.append(this._className.substring(x + 1));
            sb.append("/");
            if (this._className.contains("poshi")) {
                String poshiName = this._name;
                poshiName = poshiName.replaceAll("\\[", "_");
                poshiName = poshiName.replaceAll("\\]", "_");
                poshiName = poshiName.replaceAll("#", "_");
                sb.append(poshiName);
                sb.append("/");
            } else {
                sb.append(this._name);
            }
            URL url = JenkinsResultsParserUtil.createURL(sb.toString());
            URI uri = url.toURI();
            this._url = uri.toASCIIString();
        }
    }
}

