/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayS3Object;
import com.liferay.jenkins.results.parser.testray.TestrayS3ObjectFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class TestrayS3Bucket {
    protected static final String DEFAULT_BUCKET_NAME = "testray-results";
    private static final Pattern _fileNamePattern = Pattern.compile(".*\\.(?!gz)(?<fileExtension>([^\\.]+))(?<gzipFileExtension>\\.gz)?");
    private static Boolean _hasGoogleApplicationCredentials;
    private static final Map<String, TestrayS3Bucket> _testrayS3Buckets;
    private final String _name;

    public static TestrayS3Bucket getInstance() {
        String name = null;
        try {
            name = JenkinsResultsParserUtil.getBuildProperty("testray.s3.bucket");
        }
        catch (IOException ioException) {
            System.out.println("WARNING: Unable to get bucket name from mirrors.");
        }
        return TestrayS3Bucket.getInstance(name);
    }

    public static TestrayS3Bucket getInstance(String name) {
        TestrayS3Bucket testrayS3Bucket;
        if (JenkinsResultsParserUtil.isNullOrEmpty(name)) {
            name = DEFAULT_BUCKET_NAME;
        }
        if ((testrayS3Bucket = _testrayS3Buckets.get(name)) == null) {
            testrayS3Bucket = new TestrayS3Bucket(name);
            _testrayS3Buckets.put(name, testrayS3Bucket);
        }
        return testrayS3Bucket;
    }

    public static boolean hasGoogleApplicationCredentials() {
        return TestrayS3Bucket.hasGoogleApplicationCredentials(null);
    }

    public static boolean hasGoogleApplicationCredentials(String name) {
        if (_hasGoogleApplicationCredentials != null) {
            return _hasGoogleApplicationCredentials;
        }
        String googleApplicationCredentials = System.getenv("GOOGLE_APPLICATION_CREDENTIALS");
        if (JenkinsResultsParserUtil.isNullOrEmpty(googleApplicationCredentials)) {
            System.out.println("WARNING: GOOGLE_APPLICATION_CREDENTIALS is not set");
            _hasGoogleApplicationCredentials = false;
            return _hasGoogleApplicationCredentials;
        }
        File googleApplicationCredentialsFile = new File(googleApplicationCredentials);
        if (!googleApplicationCredentialsFile.exists()) {
            System.out.println(JenkinsResultsParserUtil.combine("WARNING: GOOGLE_APPLICATION_CREDENTIALS=", googleApplicationCredentials, " does not exist"));
            _hasGoogleApplicationCredentials = false;
            return _hasGoogleApplicationCredentials;
        }
        try {
            TestrayS3Bucket testrayS3Bucket = TestrayS3Bucket.getInstance(name);
            testrayS3Bucket._getBucket();
            System.out.println(JenkinsResultsParserUtil.combine("INFO: Using GOOGLE_APPLICATION_CREDENTIALS=", googleApplicationCredentials));
            _hasGoogleApplicationCredentials = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(JenkinsResultsParserUtil.combine("WARNING: GOOGLE_APPLICATION_CREDENTIALS=", googleApplicationCredentials, " is configured incorrectly"));
            _hasGoogleApplicationCredentials = false;
        }
        return _hasGoogleApplicationCredentials;
    }

    public TestrayS3Object createTestrayS3Object(String key, File file) {
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        BlobId blobId = BlobId.of((String)this.getName(), (String)key);
        String fileName = file.getName();
        Matcher matcher = _fileNamePattern.matcher(fileName);
        BlobInfo.Builder blobInfoBuilder = BlobInfo.newBuilder((BlobId)blobId);
        if (matcher.find()) {
            String fileExtension = matcher.group("fileExtension");
            if (fileExtension.equals("html")) {
                blobInfoBuilder.setContentType("text/html");
            } else if (fileExtension.equals("jpg")) {
                blobInfoBuilder.setContentType("image/jpeg");
            } else if (fileExtension.equals("json") || fileExtension.equals("txt")) {
                blobInfoBuilder.setContentType("text/plain");
            } else if (fileExtension.equals("xml")) {
                blobInfoBuilder.setContentType("text/xml");
            }
            String gzipFileExtension = matcher.group("gzipFileExtension");
            if (!JenkinsResultsParserUtil.isNullOrEmpty(gzipFileExtension)) {
                blobInfoBuilder.setContentEncoding("gzip");
            }
        }
        BlobInfo blobInfo = blobInfoBuilder.build();
        try {
            Storage storage = this._getStorage();
            Blob blob = storage.create(blobInfo, FileUtils.readFileToByteArray((File)file), new Storage.BlobTargetOption[0]);
            TestrayS3Object testrayS3Object = TestrayS3ObjectFactory.newTestrayS3Object(this, blob);
            System.out.println(JenkinsResultsParserUtil.combine("Created S3 Object ", testrayS3Object.getURLString(), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
            return testrayS3Object;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public TestrayS3Object createTestrayS3Object(String key, String value) {
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        BlobId blobId = BlobId.of((String)this.getName(), (String)key);
        BlobInfo.Builder blobInfoBuilder = BlobInfo.newBuilder((BlobId)blobId);
        BlobInfo blobInfo = blobInfoBuilder.build();
        Storage storage = this._getStorage();
        Blob blob = storage.create(blobInfo, value.getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]);
        TestrayS3Object testrayS3Object = TestrayS3ObjectFactory.newTestrayS3Object(this, blob);
        System.out.println(JenkinsResultsParserUtil.combine("Created S3 Object ", testrayS3Object.getURLString(), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
        return testrayS3Object;
    }

    public List<TestrayS3Object> createTestrayS3Objects(File dir) {
        ArrayList<TestrayS3Object> testrayS3Objects = new ArrayList<TestrayS3Object>();
        if (dir == null || !dir.isDirectory()) {
            return testrayS3Objects;
        }
        for (File file : JenkinsResultsParserUtil.findFiles(dir, ".*")) {
            TestrayS3Object testrayS3Object = this.createTestrayS3Object(JenkinsResultsParserUtil.getPathRelativeTo(file, dir), file);
            testrayS3Objects.add(testrayS3Object);
        }
        return testrayS3Objects;
    }

    public void deleteTestrayS3Object(String key) {
        this.deleteTestrayS3Object(this.getTestrayS3Object(key));
    }

    public void deleteTestrayS3Object(TestrayS3Object testrayS3Object) {
        testrayS3Object.delete();
    }

    public void deleteTestrayS3Objects(List<TestrayS3Object> testrayS3Objects) {
        for (TestrayS3Object testrayS3Object : testrayS3Objects) {
            this.deleteTestrayS3Object(testrayS3Object);
        }
    }

    public String getName() {
        return this._name;
    }

    public String getTestrayS3BaseURL() {
        return JenkinsResultsParserUtil.combine("https://storage.cloud.google.com/", this.getName());
    }

    public TestrayS3Object getTestrayS3Object(String key) {
        Bucket bucket = this._getBucket();
        Blob blob = bucket.get(key, new Storage.BlobGetOption[0]);
        if (blob == null) {
            return null;
        }
        return TestrayS3ObjectFactory.newTestrayS3Object(this, blob);
    }

    public List<TestrayS3Object> getTestrayS3Objects() {
        ArrayList<TestrayS3Object> testrayS3Objects = new ArrayList<TestrayS3Object>();
        Storage storage = this._getStorage();
        Page blobPage = storage.list(this.getName(), new Storage.BlobListOption[0]);
        for (Blob blob : blobPage.iterateAll()) {
            testrayS3Objects.add(TestrayS3ObjectFactory.newTestrayS3Object(this, blob));
        }
        return testrayS3Objects;
    }

    public URL getURL() {
        try {
            return new URL(JenkinsResultsParserUtil.combine("https://console.cloud.google.com/storage/browser/", this.getName(), "?authuser=0"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private TestrayS3Bucket(String name) {
        this._name = name;
    }

    private Bucket _getBucket() {
        Storage storage = this._getStorage();
        return storage.get(this.getName(), new Storage.BucketGetOption[0]);
    }

    private Storage _getStorage() {
        StorageOptions storageOptions = StorageOptions.getDefaultInstance();
        return (Storage)storageOptions.getService();
    }

    static {
        _testrayS3Buckets = new HashMap<String, TestrayS3Bucket>();
    }
}

