/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestrayRun {
    private static final String _PROPERTY_KEY_FACTOR_NAME = "testray.environment.factor.name";
    private static final String _PROPERTY_KEY_FACTOR_VALUE = "testray.environment.factor.value";
    private static final Pattern _factorNamePattern = Pattern.compile("testray.environment.factor.name\\[(?<nameKey>[^\\]]+)\\]");
    private static final Pattern _factorValuePattern = Pattern.compile("testray.environment.factor.value\\[(?<nameKey>[^\\]]+)\\](\\[(?<valueKey>[^\\]]+)\\])?");
    private final String _batchName;
    private final Properties _properties = new Properties();
    private final TestrayBuild _testrayBuild;

    public TestrayRun(TestrayBuild testrayBuild, String batchName, List<File> propertiesFiles) {
        this._testrayBuild = testrayBuild;
        this._batchName = batchName;
        try {
            this._properties.putAll((Map<?, ?>)JenkinsResultsParserUtil.getBuildProperties());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        for (int i = propertiesFiles.size() - 1; i >= 0; --i) {
            this._properties.putAll((Map<?, ?>)JenkinsResultsParserUtil.getProperties(propertiesFiles.get(i)));
        }
    }

    public String getBatchName() {
        return this._batchName;
    }

    public List<Factor> getFactors() {
        ArrayList<Factor> factors = new ArrayList<Factor>();
        for (String factorNameKey : this._getFactorNameKeys()) {
            String factoryName = this._getFactorName(factorNameKey);
            String factoryValue = this._getFactorValue(factorNameKey);
            if (JenkinsResultsParserUtil.isNullOrEmpty(factoryName) || JenkinsResultsParserUtil.isNullOrEmpty(factoryValue)) continue;
            factors.add(new Factor(factoryName, factoryValue));
        }
        return factors;
    }

    public String getRunIDString() {
        ArrayList<String> factorValues = new ArrayList<String>();
        for (Factor factor : this.getFactors()) {
            factorValues.add(factor.getValue());
        }
        return JenkinsResultsParserUtil.join("|", factorValues);
    }

    public TestrayBuild getTestrayBuild() {
        return this._testrayBuild;
    }

    private String _getFactorName(String factorNameKey) {
        String factorName = JenkinsResultsParserUtil.getProperty(this._properties, JenkinsResultsParserUtil.combine(_PROPERTY_KEY_FACTOR_NAME, "[", factorNameKey, "]"));
        if (!JenkinsResultsParserUtil.isNullOrEmpty(factorName)) {
            return factorName;
        }
        return null;
    }

    private Set<String> _getFactorNameKeys() {
        TreeSet<String> factorNameKeys = new TreeSet<String>();
        for (String propertyName : this._properties.stringPropertyNames()) {
            Matcher matcher = _factorNamePattern.matcher(propertyName);
            if (!matcher.find()) continue;
            factorNameKeys.add(matcher.group("nameKey"));
        }
        return factorNameKeys;
    }

    private String _getFactorValue(String factorNameKey) {
        String matchingValueKey = null;
        String matchingPropertyName = null;
        for (String propertyName : this._properties.stringPropertyNames()) {
            String valueKey;
            String nameKey;
            Matcher matcher = _factorValuePattern.matcher(propertyName);
            if (!matcher.find() || !(nameKey = matcher.group("nameKey")).equals(factorNameKey) || (valueKey = matcher.group("valueKey")) == null || !this._batchName.contains(valueKey) || matchingValueKey != null && valueKey.length() <= matchingValueKey.length()) continue;
            matchingValueKey = valueKey;
            matchingPropertyName = propertyName;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(matchingPropertyName)) {
            return JenkinsResultsParserUtil.getProperty(this._properties, matchingPropertyName);
        }
        String factorValue = JenkinsResultsParserUtil.getProperty(this._properties, JenkinsResultsParserUtil.combine(_PROPERTY_KEY_FACTOR_VALUE, "[", factorNameKey, "]"));
        if (JenkinsResultsParserUtil.isNullOrEmpty(factorValue)) {
            return null;
        }
        return factorValue;
    }

    public static class Factor {
        private final String _name;
        private final String _value;

        public Factor(String name, String value) {
            this._name = name;
            this._value = value;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this.getName() + "=" + this.getValue();
        }
    }
}

