/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayProductVersion;
import com.liferay.jenkins.results.parser.testray.TestrayProject;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class TestrayRoutine {
    private static final int _DELTA = 200;
    private static final Log _log = LogFactory.getLog(TestrayRoutine.class);
    private static final Pattern _testrayRoutineURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("(?<serverURL>https://[^/]+)/home/-/testray/builds\\?", "testrayRoutineId=(?<routineID>\\d+)"));
    private final JSONObject _jsonObject;
    private final Map<Integer, TestrayBuild> _testrayBuildsByID = new TreeMap(Collections.reverseOrder());
    private final Map<String, TestrayBuild> _testrayBuildsByName = new HashMap<String, TestrayBuild>();
    private final TestrayProject _testrayProject;
    private final TestrayServer _testrayServer;
    private final URL _url;

    public TestrayRoutine(TestrayProject testrayProject, JSONObject jsonObject) {
        this._testrayProject = testrayProject;
        this._jsonObject = jsonObject;
        this._testrayServer = testrayProject.getTestrayServer();
        String urlString = JenkinsResultsParserUtil.combine(String.valueOf(this._testrayServer.getURL()), "/home/-/testray/builds?testrayRoutineId=", String.valueOf(this.getID()));
        try {
            this._url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Invalid Testray project URL " + urlString, malformedURLException);
        }
    }

    public TestrayRoutine(URL testrayRoutineURL) {
        Matcher matcher = _testrayRoutineURLPattern.matcher(testrayRoutineURL.toString());
        if (!matcher.find()) {
            throw new RuntimeException("Invalid Routine URL " + testrayRoutineURL);
        }
        this._url = testrayRoutineURL;
        String serverURL = matcher.group("serverURL");
        this._testrayServer = TestrayFactory.newTestrayServer(matcher.group("serverURL"));
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(serverURL, "/home/-/testray/routines/", matcher.group("routineID"), ".json"), this._testrayServer.getHTTPAuthorization());
            this._jsonObject = jsonObject.getJSONObject("data");
            this._testrayProject = this._testrayServer.getTestrayProjectByID(Integer.parseInt(this._jsonObject.getString("testrayProjectId")));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public TestrayBuild createTestrayBuild(TestrayProductVersion testrayProductVersion, String buildName) {
        return this.createTestrayBuild(testrayProductVersion, buildName, null, null, null);
    }

    public TestrayBuild createTestrayBuild(TestrayProductVersion testrayProductVersion, String buildName, Date buildDate, String buildDescription, String buildSHA) {
        block9: {
            if (testrayProductVersion == null) {
                throw new RuntimeException("Please set a Testray product version");
            }
            if (JenkinsResultsParserUtil.isNullOrEmpty(buildName)) {
                throw new RuntimeException("Please set a Testray build name");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("name=");
            sb.append(buildName);
            sb.append("&testrayProductVersionId=");
            sb.append(testrayProductVersion.getID());
            sb.append("&testrayRoutineId=");
            sb.append(this.getID());
            if (buildDate != null) {
                String buildDateString = JenkinsResultsParserUtil.toDateString(buildDate, "MM-dd'T'HH:mm:ss.SSS'Z'", "America/Los_Angeles");
                sb.append("&createDate=");
                sb.append(buildDateString);
                sb.append("&dueDate=");
                sb.append(buildDateString);
                sb.append("&modifiedDate=");
                sb.append(buildDateString);
            }
            if (!JenkinsResultsParserUtil.isNullOrEmpty(buildDescription)) {
                sb.append("&description=");
                sb.append(buildDescription);
            }
            if (!JenkinsResultsParserUtil.isNullOrEmpty(buildSHA)) {
                sb.append("&gitHash=");
                sb.append(buildSHA);
            }
            String buildAddURL = JenkinsResultsParserUtil.combine(String.valueOf(this._testrayServer.getURL()), "/web/guest/home/-/testray/builds/add.json");
            try {
                JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(buildAddURL, 2, 5, sb.toString(), this._testrayServer.getHTTPAuthorization());
                if (jsonObject.has("data")) {
                    return new TestrayBuild(this, jsonObject.getJSONObject("data"));
                }
                String message = jsonObject.optString("message", "");
                if (!message.equals("The build name already exists.")) {
                    throw new RuntimeException("Failed to create a Testray build");
                }
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) break block9;
                _log.debug((Object)ioException);
            }
        }
        return this.getTestrayBuildByName(buildName, new String[0]);
    }

    public int getID() {
        return this._jsonObject.getInt("testrayRoutineId");
    }

    public String getName() {
        return this._jsonObject.getString("name");
    }

    public TestrayBuild getTestrayBuildByID(int buildID) {
        if (this._testrayBuildsByID.containsKey(buildID)) {
            return this._testrayBuildsByID.get(buildID);
        }
        String buildAPIURL = JenkinsResultsParserUtil.combine(String.valueOf(this._testrayServer.getURL()), "/web/guest/home/-/testray/builds/view.json?id=", String.valueOf(buildID));
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(buildAPIURL, true, this._testrayServer.getHTTPAuthorization());
            if (!jsonObject.has("data")) {
                return null;
            }
            JSONObject dataJSONObject = jsonObject.getJSONObject("data");
            TestrayBuild testrayBuild = new TestrayBuild(this, dataJSONObject);
            this._addToTestrayBuildMaps(testrayBuild);
            return testrayBuild;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public TestrayBuild getTestrayBuildByName(String buildName, String ... names) {
        if (this._testrayBuildsByName.containsKey(buildName)) {
            return this._testrayBuildsByName.get(buildName);
        }
        int current = 1;
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            sb.append("&name=");
            sb.append(JenkinsResultsParserUtil.fixURL(name));
        }
        try {
            String buildAPIURL;
            JSONObject jsonObject;
            JSONArray dataJSONArray;
            while ((dataJSONArray = (jsonObject = JenkinsResultsParserUtil.toJSONObject(buildAPIURL = JenkinsResultsParserUtil.combine(String.valueOf(this._testrayServer.getURL()), "/home/-/testray/builds.json?cur=", String.valueOf(current), "&delta=", String.valueOf(200), sb.toString(), "&orderByCol=testrayBuildId&testrayRoutineId=", String.valueOf(this.getID())), true, this._testrayServer.getHTTPAuthorization())).getJSONArray("data")).length() != 0) {
                for (int i = 0; i < dataJSONArray.length(); ++i) {
                    JSONObject dataJSONObject = dataJSONArray.getJSONObject(i);
                    TestrayBuild testrayBuild = new TestrayBuild(this, dataJSONObject);
                    this._addToTestrayBuildMaps(testrayBuild);
                    if (!this._testrayBuildsByName.containsKey(buildName)) continue;
                    return this._testrayBuildsByName.get(buildName);
                }
                ++current;
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return null;
    }

    public List<TestrayBuild> getTestrayBuilds() {
        return this.getTestrayBuilds(200, new String[0]);
    }

    public List<TestrayBuild> getTestrayBuilds(int maxSize, String ... nameFilters) {
        int current = 1;
        StringBuilder sb = new StringBuilder();
        if (nameFilters != null && nameFilters.length > 0) {
            for (String nameFilter : nameFilters) {
                if (JenkinsResultsParserUtil.isNullOrEmpty(nameFilter)) continue;
                sb.append("&name=");
                if (nameFilter.contains("-")) {
                    sb.append("%22");
                    sb.append(nameFilter);
                    sb.append("%22");
                    continue;
                }
                sb.append(nameFilter);
            }
        }
        while (current * 200 <= maxSize) {
            try {
                JSONObject dataJSONObject;
                TestrayBuild testrayBuild;
                String buildAPIURL = JenkinsResultsParserUtil.combine(String.valueOf(this._testrayServer.getURL()), "/home/-/testray/builds.json?cur=", String.valueOf(current), "&delta=", String.valueOf(200), sb.toString(), "&orderByCol=testrayBuildId&testrayRoutineId=", String.valueOf(this.getID()));
                JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(buildAPIURL, true, this._testrayServer.getHTTPAuthorization());
                JSONArray dataJSONArray = jsonObject.getJSONArray("data");
                if (dataJSONArray.length() == 0) break;
                for (int i = 0; i < dataJSONArray.length() && !this._testrayBuildsByID.containsKey((testrayBuild = new TestrayBuild(this, dataJSONObject = dataJSONArray.getJSONObject(i))).getID()); ++i) {
                    this._addToTestrayBuildMaps(testrayBuild);
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            finally {
                ++current;
            }
        }
        ArrayList<TestrayBuild> testrayBuilds = new ArrayList<TestrayBuild>();
        for (TestrayBuild testrayBuild : this._testrayBuildsByID.values()) {
            String testrayBuildName = testrayBuild.getName();
            if (nameFilters != null && nameFilters.length > 0) {
                boolean matches = true;
                for (String nameFilter : nameFilters) {
                    if (JenkinsResultsParserUtil.isNullOrEmpty(nameFilter) || testrayBuildName.contains(nameFilter)) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
            }
            testrayBuilds.add(testrayBuild);
        }
        return testrayBuilds;
    }

    public TestrayProject getTestrayProject() {
        return this._testrayProject;
    }

    public TestrayServer getTestrayServer() {
        return this._testrayServer;
    }

    public URL getURL() {
        return this._url;
    }

    private void _addToTestrayBuildMaps(TestrayBuild testrayBuild) {
        this._testrayBuildsByID.put(testrayBuild.getID(), testrayBuild);
        this._testrayBuildsByName.put(testrayBuild.getName(), testrayBuild);
    }
}

