/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.NotificationUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.PluginsBranchInformationBuild;
import com.liferay.jenkins.results.parser.PluginsTopLevelBuild;
import com.liferay.jenkins.results.parser.PortalAppReleaseTopLevelBuild;
import com.liferay.jenkins.results.parser.PortalBranchInformationBuild;
import com.liferay.jenkins.results.parser.PortalFixpackRelease;
import com.liferay.jenkins.results.parser.PortalFixpackReleaseBuild;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalHotfixRelease;
import com.liferay.jenkins.results.parser.PortalHotfixReleaseBuild;
import com.liferay.jenkins.results.parser.PortalRelease;
import com.liferay.jenkins.results.parser.PortalReleaseBuild;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.PullRequestBuild;
import com.liferay.jenkins.results.parser.PullRequestSubrepositoryTopLevelBuild;
import com.liferay.jenkins.results.parser.QAWebsitesBranchInformationBuild;
import com.liferay.jenkins.results.parser.QAWebsitesGitRepositoryJob;
import com.liferay.jenkins.results.parser.QAWebsitesTopLevelBuild;
import com.liferay.jenkins.results.parser.Retryable;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceBuild;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.job.property.JobPropertyFactory;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalAxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JUnitAxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayProductVersion;
import com.liferay.jenkins.results.parser.testray.TestrayProject;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import com.liferay.jenkins.results.parser.testray.TestrayRun;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import com.liferay.jenkins.results.parser.testray.TopLevelBuildTestrayCaseResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class TestrayImporter {
    private static final ExecutorService _executorService = JenkinsResultsParserUtil.getNewThreadPoolExecutor(10, true);
    private static final Pattern _releaseArtifactURLPattern = Pattern.compile("https?://.+/(?<releaseName>[^/]+)(.7z|.tar.gz|.war|.zip)");
    private Job _job;
    private final Map<File, TestrayBuild> _testrayBuilds = Collections.synchronizedMap(new HashMap());
    private final Map<File, TestrayProductVersion> _testrayProductVersions = Collections.synchronizedMap(new HashMap());
    private final Map<File, TestrayProject> _testrayProjects = Collections.synchronizedMap(new HashMap());
    private final Map<File, TestrayRoutine> _testrayRoutines = Collections.synchronizedMap(new HashMap());
    private final Map<File, TestrayServer> _testrayServers = Collections.synchronizedMap(new HashMap());
    private final TopLevelBuild _topLevelBuild;

    public TestrayImporter(Build build) {
        if (build == null) {
            throw new RuntimeException("Please provide a valid build");
        }
        this._topLevelBuild = build.getTopLevelBuild();
        if (this._topLevelBuild == null) {
            throw new RuntimeException("Please provide a build with a top level build");
        }
    }

    public String getJenkinsBuildDescription() {
        Document document = DocumentHelper.createDocument();
        Element rootElement = document.addElement("div");
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        Dom4JUtil.addToElement(rootElement, this._getJenkinsBuildDescriptionElement("Jenkins Build", JenkinsResultsParserUtil.combine(topLevelBuild.getJobName(), "#", String.valueOf(topLevelBuild.getBuildNumber())), topLevelBuild.getBuildURL()), this._getJenkinsBuildDescriptionElement("Jenkins Report", "jenkins-report.html", topLevelBuild.getJenkinsReportURL()), this._getJenkinsBuildDescriptionElement("Jenkins Suite", topLevelBuild.getTestSuiteName()));
        PullRequest pullRequest = this.getPullRequest();
        if (pullRequest != null) {
            Dom4JUtil.addToElement(rootElement, this._getJenkinsBuildDescriptionElement("Pull Request", JenkinsResultsParserUtil.combine(pullRequest.getReceiverUsername(), "#", pullRequest.getNumber()), pullRequest.getHtmlURL()));
        }
        HashMap<Integer, TestrayBuild> testrayBuildMap = new HashMap<Integer, TestrayBuild>();
        for (TestrayBuild testrayBuild : this._testrayBuilds.values()) {
            testrayBuildMap.put(testrayBuild.getID(), testrayBuild);
        }
        int i = 0;
        for (Map.Entry entry : testrayBuildMap.entrySet()) {
            String testrayBuildTitle = "Testray Build";
            if (i > 0) {
                testrayBuildTitle = JenkinsResultsParserUtil.combine(testrayBuildTitle, " (", String.valueOf(i), ")");
            }
            String testrayRoutineTitle = "Testray Routine";
            if (i > 0) {
                testrayRoutineTitle = JenkinsResultsParserUtil.combine(testrayRoutineTitle, " (", String.valueOf(i), ")");
            }
            TestrayBuild testrayBuild = (TestrayBuild)entry.getValue();
            TestrayRoutine testrayRoutine = testrayBuild.getTestrayRoutine();
            Dom4JUtil.addToElement(rootElement, this._getJenkinsBuildDescriptionElement(testrayRoutineTitle, testrayRoutine.getName(), String.valueOf(testrayRoutine.getURL())), this._getJenkinsBuildDescriptionElement(testrayBuildTitle, testrayBuild.getName(), String.valueOf(testrayBuild.getURL())));
            ++i;
        }
        String string = System.getenv("JOB_NAME");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(string)) {
            Dom4JUtil.addToElement(rootElement, this._getJenkinsBuildDescriptionElement("Testray Importer", JenkinsResultsParserUtil.combine(string, "#", System.getenv("BUILD_NUMBER")), System.getenv("BUILD_URL")));
        }
        try {
            String string2 = Dom4JUtil.format(rootElement, false);
            return string2.replaceAll("\n", "<br />");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Job getJob() {
        if (this._job != null) {
            return this._job;
        }
        this._job = this._topLevelBuild.getJob();
        return this._job;
    }

    public PortalFixpackRelease getPortalFixpackRelease() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (!(topLevelBuild instanceof PortalFixpackReleaseBuild)) {
            return null;
        }
        PortalFixpackReleaseBuild portalFixpackReleaseBuild = (PortalFixpackReleaseBuild)((Object)topLevelBuild);
        return portalFixpackReleaseBuild.getPortalFixpackRelease();
    }

    public PortalHotfixRelease getPortalHotfixRelease() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (!(topLevelBuild instanceof PortalHotfixReleaseBuild)) {
            return null;
        }
        PortalHotfixReleaseBuild portalHotfixReleaseBuild = (PortalHotfixReleaseBuild)((Object)topLevelBuild);
        return portalHotfixReleaseBuild.getPortalHotfixRelease();
    }

    public PortalRelease getPortalRelease() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (!(topLevelBuild instanceof PortalReleaseBuild)) {
            return null;
        }
        PortalReleaseBuild portalReleaseBuild = (PortalReleaseBuild)((Object)topLevelBuild);
        return portalReleaseBuild.getPortalRelease();
    }

    public PullRequest getPullRequest() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (!(topLevelBuild instanceof PullRequestBuild)) {
            return null;
        }
        PullRequestBuild pullRequestBuild = (PullRequestBuild)((Object)topLevelBuild);
        return pullRequestBuild.getPullRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TestrayBuild getTestrayBuild(File testBaseDir) {
        block10: {
            TestrayBuild testrayBuild = this._testrayBuilds.get(testBaseDir);
            if (testrayBuild != null) {
                return testrayBuild;
            }
            long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
            Date testrayBuildDate = this.getTestrayBuildDate();
            String testrayBuildDescription = this.getTestrayBuildDescription();
            String testrayBuildSHA = this.getTestrayBuildSHA();
            try {
                JobProperty jobProperty;
                String testrayBuildID = System.getenv("TESTRAY_BUILD_ID");
                TestrayRoutine testrayRoutine = this.getTestrayRoutine(testBaseDir);
                TestrayProductVersion testrayProductVersion = this.getTestrayProductVersion(testBaseDir);
                if (testrayBuildID != null && testrayBuildID.matches("\\d+")) {
                    testrayBuild = testrayRoutine.getTestrayBuildByID(Integer.parseInt(testrayBuildID));
                }
                String testrayBuildName = System.getenv("TESTRAY_BUILD_NAME");
                if (testrayBuild == null && !JenkinsResultsParserUtil.isNullOrEmpty(testrayBuildName)) {
                    testrayBuild = testrayRoutine.createTestrayBuild(testrayProductVersion, this._replaceEnvVars(testrayBuildName), testrayBuildDate, testrayBuildDescription, testrayBuildSHA);
                }
                testrayBuildID = this._getBuildParameter("TESTRAY_BUILD_ID");
                if (testrayBuild == null && testrayBuildID != null && testrayBuildID.matches("\\d+")) {
                    testrayBuild = testrayRoutine.getTestrayBuildByID(Integer.parseInt(testrayBuildID));
                }
                testrayBuildName = this._getBuildParameter("TESTRAY_BUILD_NAME");
                if (testrayBuild == null && !JenkinsResultsParserUtil.isNullOrEmpty(testrayBuildName)) {
                    testrayBuild = testrayRoutine.createTestrayBuild(testrayProductVersion, this._replaceEnvVars(testrayBuildName), testrayBuildDate, testrayBuildDescription, testrayBuildSHA);
                }
                if (testrayBuild == null && (testrayBuildID = (jobProperty = this._getJobProperty("testray.build.id", testBaseDir)).getValue()) != null && testrayBuildID.matches("\\d+")) {
                    testrayBuild = testrayRoutine.getTestrayBuildByID(Integer.parseInt(testrayBuildID));
                }
                if (testrayBuild == null && !JenkinsResultsParserUtil.isNullOrEmpty(testrayBuildName = (jobProperty = this._getJobProperty("testray.build.name", testBaseDir)).getValue())) {
                    testrayBuild = testrayRoutine.createTestrayBuild(testrayProductVersion, this._replaceEnvVars(testrayBuildName), testrayBuildDate, testrayBuildDescription, testrayBuildSHA);
                }
                if (testrayBuild == null) break block10;
                this._testrayBuilds.put(testBaseDir, testrayBuild);
            }
            catch (Throwable throwable) {
                if (testrayBuild != null) {
                    this._testrayBuilds.put(testBaseDir, testrayBuild);
                    System.out.println(JenkinsResultsParserUtil.combine("Testray Build ", String.valueOf(testrayBuild.getURL()), " created in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
                    return testrayBuild;
                }
                throw throwable;
            }
            System.out.println(JenkinsResultsParserUtil.combine("Testray Build ", String.valueOf(testrayBuild.getURL()), " created in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
            return testrayBuild;
        }
        throw new RuntimeException("Please set TESTRAY_BUILD_NAME");
    }

    public Date getTestrayBuildDate() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        Build controllerBuild = topLevelBuild.getControllerBuild();
        if (controllerBuild != null) {
            return new Date(controllerBuild.getStartTime());
        }
        return new Date(topLevelBuild.getStartTime());
    }

    public String getTestrayBuildDescription() {
        QAWebsitesBranchInformationBuild qaWebsitesBranchInformationBuild;
        Build.BranchInformation qaWebsitesBranchInformation;
        PluginsBranchInformationBuild pluginsBranchInformationBuild;
        Build.BranchInformation pluginsBranchInformation;
        PortalBranchInformationBuild portalBranchInformationBuild;
        Build.BranchInformation portalBranchInformation;
        TopLevelBuild topLevelBuild;
        PortalHotfixRelease portalHotfixRelease;
        PortalFixpackRelease portalFixpackRelease;
        StringBuilder sb = new StringBuilder();
        PortalRelease portalRelease = this.getPortalRelease();
        if (portalRelease != null) {
            sb.append("Portal Release: ");
            sb.append(portalRelease.getPortalVersion());
            sb.append(";\n");
        }
        if ((portalFixpackRelease = this.getPortalFixpackRelease()) != null) {
            sb.append("Portal Fixpack: ");
            sb.append(portalFixpackRelease.getPortalFixpackVersion());
            sb.append(";\n");
        }
        if ((portalHotfixRelease = this.getPortalHotfixRelease()) != null) {
            sb.append("Portal Hotfix: ");
            sb.append(portalHotfixRelease.getPortalHotfixReleaseVersion());
            sb.append(";\n");
        }
        if ((topLevelBuild = this.getTopLevelBuild()) instanceof PortalBranchInformationBuild && (portalBranchInformation = (portalBranchInformationBuild = (PortalBranchInformationBuild)((Object)topLevelBuild)).getPortalBranchInformation()) != null) {
            sb.append("Portal Branch: ");
            sb.append(portalBranchInformation.getUpstreamBranchName());
            sb.append(";\n");
            sb.append("Portal SHA: ");
            sb.append(portalBranchInformation.getSenderBranchSHA());
            sb.append(";\n");
        }
        if (topLevelBuild instanceof PluginsBranchInformationBuild && (pluginsBranchInformation = (pluginsBranchInformationBuild = (PluginsBranchInformationBuild)((Object)topLevelBuild)).getPluginsBranchInformation()) != null) {
            sb.append("Plugins Branch: ");
            sb.append(pluginsBranchInformation.getUpstreamBranchName());
            sb.append(";\n");
            sb.append("Plugins SHA: ");
            sb.append(pluginsBranchInformation.getSenderBranchSHA());
            sb.append(";\n");
        }
        if (topLevelBuild instanceof QAWebsitesBranchInformationBuild && (qaWebsitesBranchInformation = (qaWebsitesBranchInformationBuild = (QAWebsitesBranchInformationBuild)((Object)topLevelBuild)).getQAWebsitesBranchInformation()) != null) {
            sb.append("QA Websites Branch: ");
            sb.append(qaWebsitesBranchInformation.getUpstreamBranchName());
            sb.append(";\n");
            sb.append("QA Websites SHA: ");
            sb.append(qaWebsitesBranchInformation.getSenderBranchSHA());
            sb.append(";\n");
        }
        return sb.toString();
    }

    public String getTestrayBuildSHA() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild instanceof PortalBranchInformationBuild) {
            PortalBranchInformationBuild portalBranchInformationBuild = (PortalBranchInformationBuild)((Object)topLevelBuild);
            Build.BranchInformation portalBranchInformation = portalBranchInformationBuild.getPortalBranchInformation();
            return portalBranchInformation.getSenderBranchSHA();
        }
        if (topLevelBuild instanceof PluginsBranchInformationBuild) {
            PluginsBranchInformationBuild pluginsBranchInformationBuild = (PluginsBranchInformationBuild)((Object)topLevelBuild);
            Build.BranchInformation pluginsBranchInformation = pluginsBranchInformationBuild.getPluginsBranchInformation();
            return pluginsBranchInformation.getSenderBranchSHA();
        }
        if (topLevelBuild instanceof QAWebsitesBranchInformationBuild) {
            QAWebsitesBranchInformationBuild qaWebsitesBranchInformationBuild = (QAWebsitesBranchInformationBuild)((Object)topLevelBuild);
            Build.BranchInformation qaWebsitesBranchInformation = qaWebsitesBranchInformationBuild.getQAWebsitesBranchInformation();
            return qaWebsitesBranchInformation.getSenderBranchSHA();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TestrayProductVersion getTestrayProductVersion(File testBaseDir) {
        block11: {
            TestrayProductVersion testrayProductVersion = this._testrayProductVersions.get(testBaseDir);
            if (testrayProductVersion != null) {
                return testrayProductVersion;
            }
            long start = System.currentTimeMillis();
            try {
                JobProperty jobProperty;
                TestrayProject testrayProject = this.getTestrayProject(testBaseDir);
                String testrayProductVersionID = System.getenv("TESTRAY_PRODUCT_VERSION_ID");
                if (testrayProductVersionID != null && testrayProductVersionID.matches("\\d+")) {
                    testrayProductVersion = testrayProject.getTestrayProductVersionByID(Integer.parseInt(testrayProductVersionID));
                }
                String testrayProductVersionName = System.getenv("TESTRAY_PRODUCT_VERSION_NAME");
                if (testrayProductVersion == null && !JenkinsResultsParserUtil.isNullOrEmpty(testrayProductVersionName)) {
                    testrayProductVersion = testrayProject.createTestrayProductVersion(this._replaceEnvVars(testrayProductVersionName));
                }
                testrayProductVersionID = this._getBuildParameter("TESTRAY_PRODUCT_VERSION_ID");
                if (testrayProductVersion == null && testrayProductVersionID != null && testrayProductVersionID.matches("\\d+")) {
                    testrayProductVersion = testrayProject.getTestrayProductVersionByID(Integer.parseInt(testrayProductVersionID));
                }
                testrayProductVersionName = this._getBuildParameter("TESTRAY_PRODUCT_VERSION_NAME");
                if (testrayProductVersion == null && !JenkinsResultsParserUtil.isNullOrEmpty(testrayProductVersionName)) {
                    testrayProductVersion = testrayProject.createTestrayProductVersion(this._replaceEnvVars(testrayProductVersionName));
                }
                if (testrayProductVersion == null && (testrayProductVersionID = (jobProperty = this._getJobProperty("testray.product.version.id", testBaseDir)).getValue()) != null && testrayProductVersionID.matches("\\d+")) {
                    testrayProductVersion = testrayProject.getTestrayProductVersionByID(Integer.parseInt(testrayProductVersionID));
                }
                if (testrayProductVersion == null && !JenkinsResultsParserUtil.isNullOrEmpty(testrayProductVersionName = (jobProperty = this._getJobProperty("testray.product.version.name", testBaseDir)).getValue())) {
                    testrayProductVersion = testrayProject.createTestrayProductVersion(this._replaceEnvVars(testrayProductVersionName));
                }
                Job job = this.getJob();
                String jobName = job.getJobName();
                if (testrayProductVersion == null && (jobName.equals("test-qa-websites-functional-daily") || jobName.equals("test-qa-websites-functional-weekly"))) {
                    testrayProductVersion = testrayProject.createTestrayProductVersion("1.x");
                }
                if (testrayProductVersion == null) break block11;
                this._testrayProductVersions.put(testBaseDir, testrayProductVersion);
            }
            catch (Throwable throwable) {
                if (testrayProductVersion != null) {
                    this._testrayProductVersions.put(testBaseDir, testrayProductVersion);
                    System.out.println(JenkinsResultsParserUtil.combine("Testray Product Version ", String.valueOf(testrayProductVersion.getURL()), " created in ", JenkinsResultsParserUtil.toDurationString(System.currentTimeMillis() - start)));
                    return testrayProductVersion;
                }
                throw throwable;
            }
            System.out.println(JenkinsResultsParserUtil.combine("Testray Product Version ", String.valueOf(testrayProductVersion.getURL()), " created in ", JenkinsResultsParserUtil.toDurationString(System.currentTimeMillis() - start)));
            return testrayProductVersion;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TestrayProject getTestrayProject(File testBaseDir) {
        block10: {
            TestrayProject testrayProject = this._testrayProjects.get(testBaseDir);
            if (testrayProject != null) {
                return testrayProject;
            }
            long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
            try {
                JobProperty jobProperty;
                String testrayProjectID = System.getenv("TESTRAY_PROJECT_ID");
                TestrayServer testrayServer = this.getTestrayServer(testBaseDir);
                if (testrayProjectID != null && testrayProjectID.matches("\\d+")) {
                    testrayProject = testrayServer.getTestrayProjectByID(Integer.parseInt(testrayProjectID));
                }
                String testrayProjectName = System.getenv("TESTRAY_PROJECT_NAME");
                if (testrayProject == null && !JenkinsResultsParserUtil.isNullOrEmpty(testrayProjectName)) {
                    testrayProject = testrayServer.getTestrayProjectByName(this._replaceEnvVars(testrayProjectName));
                }
                testrayProjectID = this._getBuildParameter("TESTRAY_PROJECT_ID");
                if (testrayProject == null && testrayProjectID != null && testrayProjectID.matches("\\d+")) {
                    testrayProject = testrayServer.getTestrayProjectByID(Integer.parseInt(testrayProjectID));
                }
                testrayProjectName = this._getBuildParameter("TESTRAY_PROJECT_NAME");
                if (testrayProject == null && !JenkinsResultsParserUtil.isNullOrEmpty(testrayProjectName)) {
                    testrayProject = testrayServer.getTestrayProjectByName(this._replaceEnvVars(testrayProjectName));
                }
                if (testrayProject == null && (testrayProjectID = (jobProperty = this._getJobProperty("testray.project.id", testBaseDir)).getValue()) != null && testrayProjectID.matches("\\d+")) {
                    testrayProject = testrayServer.getTestrayProjectByID(Integer.parseInt(testrayProjectID));
                }
                if (testrayProject == null && !JenkinsResultsParserUtil.isNullOrEmpty(testrayProjectName = (jobProperty = this._getJobProperty("testray.project.name", testBaseDir)).getValue())) {
                    testrayProject = testrayServer.getTestrayProjectByName(this._replaceEnvVars(testrayProjectName));
                }
                if (testrayProject == null) break block10;
                this._testrayProjects.put(testBaseDir, testrayProject);
            }
            catch (Throwable throwable) {
                if (testrayProject != null) {
                    this._testrayProjects.put(testBaseDir, testrayProject);
                    System.out.println(JenkinsResultsParserUtil.combine("Testray Project ", String.valueOf(testrayProject.getURL()), " created in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
                    return testrayProject;
                }
                throw throwable;
            }
            System.out.println(JenkinsResultsParserUtil.combine("Testray Project ", String.valueOf(testrayProject.getURL()), " created in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
            return testrayProject;
        }
        throw new RuntimeException("Please set TESTRAY_PROJECT_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TestrayRoutine getTestrayRoutine(File testBaseDir) {
        block11: {
            TestrayRoutine testrayRoutine = this._testrayRoutines.get(testBaseDir);
            if (testrayRoutine != null) {
                return testrayRoutine;
            }
            long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
            try {
                JobProperty jobProperty;
                String testrayRoutineID = System.getenv("TESTRAY_ROUTINE_ID");
                TestrayProject testrayProject = this.getTestrayProject(testBaseDir);
                if (testrayRoutineID != null && testrayRoutineID.matches("\\d+")) {
                    testrayRoutine = testrayProject.getTestrayRoutineByID(Integer.parseInt(testrayRoutineID));
                }
                String testrayRoutineName = System.getenv("TESTRAY_ROUTINE_NAME");
                if (testrayRoutine == null && !JenkinsResultsParserUtil.isNullOrEmpty(testrayRoutineName)) {
                    testrayRoutine = testrayProject.createTestrayRoutine(this._replaceEnvVars(testrayRoutineName));
                }
                testrayRoutineID = this._getBuildParameter("TESTRAY_ROUTINE_ID");
                if (testrayRoutine == null && testrayRoutineID != null && testrayRoutineID.matches("\\d+")) {
                    testrayRoutine = testrayProject.getTestrayRoutineByID(Integer.parseInt(testrayRoutineID));
                }
                testrayRoutineName = this._getBuildParameter("TESTRAY_ROUTINE_NAME");
                if (testrayRoutine == null && !JenkinsResultsParserUtil.isNullOrEmpty(testrayRoutineName)) {
                    testrayRoutine = testrayProject.createTestrayRoutine(this._replaceEnvVars(testrayRoutineName));
                }
                testrayRoutineName = this._getBuildParameter("TESTRAY_BUILD_TYPE");
                if (testrayRoutine == null && !JenkinsResultsParserUtil.isNullOrEmpty(testrayRoutineName)) {
                    testrayRoutine = testrayProject.createTestrayRoutine(this._replaceEnvVars(testrayRoutineName));
                }
                if (testrayRoutine == null && (testrayRoutineID = (jobProperty = this._getJobProperty("testray.routine.id", testBaseDir)).getValue()) != null && testrayRoutineID.matches("\\d+")) {
                    testrayRoutine = testrayProject.getTestrayRoutineByID(Integer.parseInt(testrayRoutineID));
                }
                if (testrayRoutine == null && !JenkinsResultsParserUtil.isNullOrEmpty(testrayRoutineName = (jobProperty = this._getJobProperty("testray.routine.name", testBaseDir)).getValue())) {
                    testrayRoutine = testrayProject.createTestrayRoutine(this._replaceEnvVars(testrayRoutineName));
                }
                if (testrayRoutine == null) break block11;
                this._testrayRoutines.put(testBaseDir, testrayRoutine);
            }
            catch (Throwable throwable) {
                if (testrayRoutine != null) {
                    this._testrayRoutines.put(testBaseDir, testrayRoutine);
                    System.out.println(JenkinsResultsParserUtil.combine("Testray Routine ", String.valueOf(testrayRoutine.getURL()), " created in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
                    return testrayRoutine;
                }
                throw throwable;
            }
            System.out.println(JenkinsResultsParserUtil.combine("Testray Routine ", String.valueOf(testrayRoutine.getURL()), " created in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
            return testrayRoutine;
        }
        throw new RuntimeException("Please set TESTRAY_ROUTINE_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TestrayServer getTestrayServer(File testBaseDir) {
        block7: {
            TestrayServer testrayServer = this._testrayServers.get(testBaseDir);
            if (testrayServer != null) {
                return testrayServer;
            }
            long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
            try {
                JobProperty jobProperty;
                String testrayServerURL = System.getenv("TESTRAY_SERVER_URL");
                if (testrayServerURL != null && testrayServerURL.matches("https?://.*")) {
                    testrayServer = TestrayFactory.newTestrayServer(testrayServerURL);
                }
                testrayServerURL = this._getBuildParameter("TESTRAY_SERVER_URL");
                if (testrayServer == null && testrayServerURL != null && testrayServerURL.matches("https?://.*")) {
                    testrayServer = TestrayFactory.newTestrayServer(testrayServerURL);
                }
                if (testrayServer == null && (testrayServerURL = (jobProperty = this._getJobProperty("testray.server.url", testBaseDir)).getValue()) != null && testrayServerURL.matches("https?://.*")) {
                    testrayServer = TestrayFactory.newTestrayServer(testrayServerURL);
                }
                if (testrayServer == null) break block7;
                this._testrayServers.put(testBaseDir, testrayServer);
            }
            catch (Throwable throwable) {
                if (testrayServer != null) {
                    this._testrayServers.put(testBaseDir, testrayServer);
                    System.out.println(JenkinsResultsParserUtil.combine("Testray Server ", String.valueOf(testrayServer.getURL()), " created in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
                    return testrayServer;
                }
                throw throwable;
            }
            System.out.println(JenkinsResultsParserUtil.combine("Testray Server ", String.valueOf(testrayServer.getURL()), " created in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
            return testrayServer;
        }
        throw new RuntimeException("Please set TESTRAY_SERVER_URL");
    }

    public TopLevelBuild getTopLevelBuild() {
        return this._topLevelBuild;
    }

    public void postSlackNotification() {
        ArrayList<Integer> testrayBuildIDs = new ArrayList<Integer>();
        for (Map.Entry<File, TestrayBuild> testrayBuildEntry : this._testrayBuilds.entrySet()) {
            File testBaseDir = testrayBuildEntry.getKey();
            TestrayBuild testrayBuild = testrayBuildEntry.getValue();
            if (testrayBuildIDs.contains(testrayBuild.getID())) continue;
            testrayBuildIDs.add(testrayBuild.getID());
            String slackChannels = this._getSlackChannels(testBaseDir);
            if (JenkinsResultsParserUtil.isNullOrEmpty(slackChannels)) continue;
            for (String slackChannel : slackChannels.split(",")) {
                NotificationUtil.sendSlackNotification(this._getSlackBody(testBaseDir), slackChannel, this._getSlackIconEmoji(testBaseDir), this._getSlackSubject(testBaseDir), this._getSlackUsername(testBaseDir));
            }
        }
    }

    public void recordTestrayCaseResults() {
        final Job job = this.getJob();
        TopLevelBuildTestrayCaseResult topLevelBuildTestrayCaseResult = TestrayFactory.newTopLevelBuildTestrayCaseResult(this.getTestrayBuild(null), this.getTopLevelBuild());
        topLevelBuildTestrayCaseResult.recordTestrayCaseResult(job);
        ArrayList<AxisTestClassGroup> axisTestClassGroups = new ArrayList<AxisTestClassGroup>(job.getAxisTestClassGroups());
        axisTestClassGroups.addAll(job.getDependentAxisTestClassGroups());
        ArrayList callables = new ArrayList();
        for (final AxisTestClassGroup axisTestClassGroup : axisTestClassGroups) {
            callables.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TestrayBuild testrayBuild = TestrayImporter.this.getTestrayBuild(axisTestClassGroup.getTestBaseDir());
                    TestrayRun testrayRun = new TestrayRun(testrayBuild, axisTestClassGroup.getBatchName(), job.getJobPropertiesFiles());
                    long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
                    Document document = DocumentHelper.createDocument();
                    Element rootElement = document.addElement("testsuite");
                    Element environmentsElement = rootElement.addElement("environments");
                    for (TestrayRun.Factor factor : testrayRun.getFactors()) {
                        Element environmentElement = environmentsElement.addElement("environment");
                        environmentElement.addAttribute("type", factor.getName());
                        environmentElement.addAttribute("option", factor.getValue());
                    }
                    HashMap<String, String> propertiesMap = new HashMap<String, String>();
                    propertiesMap.put("testray.build.name", testrayBuild.getName());
                    TestrayRoutine testrayRoutine = testrayBuild.getTestrayRoutine();
                    propertiesMap.put("testray.build.type", testrayRoutine.getName());
                    TestrayProductVersion testrayProductVersion = testrayBuild.getTestrayProductVersion();
                    if (testrayProductVersion != null) {
                        propertiesMap.put("testray.product.version", testrayProductVersion.getName());
                    }
                    TestrayProject testrayProject = testrayBuild.getTestrayProject();
                    propertiesMap.put("testray.project.name", testrayProject.getName());
                    propertiesMap.put("testray.run.id", testrayRun.getRunIDString());
                    TestrayImporter.this._addPropertyElements(rootElement.addElement("properties"), propertiesMap);
                    ArrayList<TestrayCaseResult> testrayCaseResults = new ArrayList<TestrayCaseResult>();
                    if (axisTestClassGroup instanceof FunctionalAxisTestClassGroup || axisTestClassGroup instanceof JUnitAxisTestClassGroup) {
                        for (TestClass testClass : axisTestClassGroup.getTestClasses()) {
                            testrayCaseResults.add(TestrayFactory.newTestrayCaseResult(testrayBuild, TestrayImporter.this.getTopLevelBuild(), axisTestClassGroup, testClass));
                        }
                    } else {
                        testrayCaseResults.add(TestrayFactory.newTestrayCaseResult(testrayBuild, TestrayImporter.this.getTopLevelBuild(), axisTestClassGroup, null));
                    }
                    for (TestrayCaseResult testrayCaseResult : testrayCaseResults) {
                        Element testcaseElement = rootElement.addElement("testcase");
                        HashMap<String, String> testcasePropertiesMap = new HashMap<String, String>();
                        testcasePropertiesMap.put("testray.case.type.name", testrayCaseResult.getType());
                        testcasePropertiesMap.put("testray.component.names", testrayCaseResult.getSubcomponentNames());
                        testcasePropertiesMap.put("testray.main.component.name", testrayCaseResult.getComponentName());
                        testcasePropertiesMap.put("testray.team.name", testrayCaseResult.getTeamName());
                        String testrayCaseName = testrayCaseResult.getName();
                        if (testrayCaseName.length() > 150) {
                            testrayCaseName = testrayCaseName.substring(0, 150);
                        }
                        testcasePropertiesMap.put("testray.testcase.name", testrayCaseName);
                        testcasePropertiesMap.put("testray.testcase.priority", String.valueOf(testrayCaseResult.getPriority()));
                        TestrayCaseResult.Status testrayCaseStatus = testrayCaseResult.getStatus();
                        testcasePropertiesMap.put("testray.testcase.status", testrayCaseStatus.getName());
                        Element propertiesElement = testcaseElement.addElement("properties");
                        TestrayImporter.this._addPropertyElements(propertiesElement, testcasePropertiesMap);
                        String[] warnings = testrayCaseResult.getWarnings();
                        if (warnings != null && warnings.length > 0) {
                            Element warningsPropertyElement = propertiesElement.addElement("property");
                            warningsPropertyElement.addAttribute("name", "testray.testcase.warnings");
                            warningsPropertyElement.addAttribute("value", String.valueOf(warnings.length));
                            for (String warning : warnings) {
                                Element warningPropertyElement = warningsPropertyElement.addElement("value");
                                warningPropertyElement.addText(StringEscapeUtils.escapeHtml((String)warning));
                            }
                        }
                        Element attachmentsElement = testcaseElement.addElement("attachments");
                        for (TestrayAttachment testrayAttachment : testrayCaseResult.getTestrayAttachments()) {
                            Element attachmentFileElement = attachmentsElement.addElement("file");
                            attachmentFileElement.addAttribute("name", testrayAttachment.getName());
                            attachmentFileElement.addAttribute("url", testrayAttachment.getURL() + "?authuser=0");
                            attachmentFileElement.addAttribute("value", testrayAttachment.getKey() + "?authuser=0");
                        }
                        String errors = testrayCaseResult.getErrors();
                        if (JenkinsResultsParserUtil.isNullOrEmpty(errors)) continue;
                        Element failureElement = testcaseElement.addElement("failure");
                        failureElement.addAttribute("message", errors);
                    }
                    TestrayServer testrayServer = testrayBuild.getTestrayServer();
                    TopLevelBuild topLevelBuild = TestrayImporter.this.getTopLevelBuild();
                    JenkinsMaster jenkinsMaster = topLevelBuild.getJenkinsMaster();
                    try {
                        String axisName = axisTestClassGroup.getAxisName();
                        testrayServer.writeCaseResult(JenkinsResultsParserUtil.combine("TESTS-", jenkinsMaster.getName(), "_", topLevelBuild.getJobName(), "_", String.valueOf(topLevelBuild.getBuildNumber()), "_", axisName.replace("/", "_"), ".xml"), Dom4JUtil.format(rootElement));
                    }
                    catch (IOException ioException) {
                        throw new RuntimeException(ioException);
                    }
                    long currentTimeMillis = JenkinsResultsParserUtil.getCurrentTimeMillis();
                    System.out.println(JenkinsResultsParserUtil.combine("Recorded ", String.valueOf(testrayCaseResults.size()), " case results for ", axisTestClassGroup.getAxisName(), " in ", JenkinsResultsParserUtil.toDurationString(currentTimeMillis - start)));
                    return null;
                }
            });
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _executorService);
        parallelExecutor.execute();
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        ArrayList<Integer> testrayBuildIDs = new ArrayList<Integer>();
        for (TestrayBuild testrayBuild : this._testrayBuilds.values()) {
            if (testrayBuildIDs.contains(testrayBuild.getID())) continue;
            testrayBuildIDs.add(testrayBuild.getID());
            TestrayServer testrayServer = testrayBuild.getTestrayServer();
            testrayServer.importCaseResults(topLevelBuild);
        }
        this._sendPullRequestNotification();
    }

    public void setup() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild instanceof WorkspaceBuild) {
            WorkspaceBuild workspaceBuild = (WorkspaceBuild)((Object)topLevelBuild);
            Workspace workspace = workspaceBuild.getWorkspace();
            for (WorkspaceGitRepository workspaceGitRepository : workspace.getWorkspaceGitRepositories()) {
                PortalRelease portalRelease;
                if (workspaceGitRepository == null) continue;
                workspaceGitRepository.addPropertyOption(String.valueOf((Object)topLevelBuild.getBuildProfile()));
                workspaceGitRepository.addPropertyOption(topLevelBuild.getJobName());
                workspaceGitRepository.addPropertyOption(workspaceGitRepository.getUpstreamBranchName());
                String dockerEnabled = System.getenv("DOCKER_ENABLED");
                if (dockerEnabled != null && dockerEnabled.equals("true")) {
                    workspaceGitRepository.addPropertyOption("docker");
                }
                if (JenkinsResultsParserUtil.isWindows()) {
                    workspaceGitRepository.addPropertyOption("windows");
                } else {
                    workspaceGitRepository.addPropertyOption("unix");
                }
                if ((portalRelease = this.getPortalRelease()) == null) continue;
                workspaceGitRepository.addPropertyOption(portalRelease.getPortalVersion());
            }
            workspace.setUp();
            this._setupPortalBundle();
            return;
        }
        this._checkoutPortalBranch();
        this._setupProfileDXP();
        this._setupPortalBundle();
        this._callPrepareTCK();
        this._checkoutPluginsBranch();
        this._checkoutQAWebsitesBranch();
    }

    private void _addPropertyElements(Element propertiesElement, Map<String, String> propertiesMap) {
        for (Map.Entry<String, String> propertyEntry : propertiesMap.entrySet()) {
            Element propertyElement = propertiesElement.addElement("property");
            String propertyName = propertyEntry.getKey();
            String propertyValue = propertyEntry.getValue();
            if (JenkinsResultsParserUtil.isNullOrEmpty(propertyName) || JenkinsResultsParserUtil.isNullOrEmpty(propertyValue)) continue;
            propertyElement.addAttribute("name", propertyName);
            propertyElement.addAttribute("value", propertyValue);
        }
    }

    private void _callPrepareTCK() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this._getPortalGitWorkingDirectory();
        HashMap<String, String> parameters = new HashMap<String, String>();
        String portalUpstreamBranchName = portalGitWorkingDirectory.getUpstreamBranchName();
        if (!portalUpstreamBranchName.contains("ee-")) {
            GitWorkingDirectory jenkinsGitWorkingDirectory = this._getJenkinsGitWorkingDirectory();
            Properties testProperties = JenkinsResultsParserUtil.getProperties(new File(jenkinsGitWorkingDirectory.getWorkingDirectory(), "commands/dependencies/test.properties"));
            parameters.put("tck.home", JenkinsResultsParserUtil.getProperty(testProperties, "tck.home"));
        }
        try {
            AntUtil.callTarget(portalGitWorkingDirectory.getWorkingDirectory(), "build-test-tck.xml", "prepare-tck", parameters);
        }
        catch (AntException antException) {
            throw new RuntimeException(antException);
        }
    }

    private void _checkoutPluginsBranch() {
        Properties buildProperties;
        if (!(this._topLevelBuild instanceof PluginsBranchInformationBuild)) {
            return;
        }
        PluginsBranchInformationBuild pluginsBranchInformationBuild = (PluginsBranchInformationBuild)((Object)this._topLevelBuild);
        Build.BranchInformation branchInformation = pluginsBranchInformationBuild.getPluginsBranchInformation();
        if (branchInformation == null) {
            return;
        }
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String upstreamBranchName = branchInformation.getUpstreamBranchName();
        String upstreamDirPath = JenkinsResultsParserUtil.getProperty(buildProperties, "plugins.dir", upstreamBranchName);
        String upstreamRepository = JenkinsResultsParserUtil.getProperty(buildProperties, "plugins.repository", upstreamBranchName);
        GitWorkingDirectory pluginsGitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(upstreamBranchName, upstreamDirPath, upstreamRepository);
        pluginsGitWorkingDirectory.clean();
        pluginsGitWorkingDirectory.checkoutLocalGitBranch(branchInformation);
        pluginsGitWorkingDirectory.displayLog();
        PortalGitWorkingDirectory portalGitWorkingDirectory = this._getPortalGitWorkingDirectory();
        File releasePropertiesFile = new File(portalGitWorkingDirectory.getWorkingDirectory(), JenkinsResultsParserUtil.combine("release.", System.getenv("HOSTNAME"), ".properties"));
        try {
            JenkinsResultsParserUtil.write(releasePropertiesFile, JenkinsResultsParserUtil.combine("lp.plugins.dir=", JenkinsResultsParserUtil.getCanonicalPath(pluginsGitWorkingDirectory.getWorkingDirectory())));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void _checkoutPortalBranch() {
        if (!(this._topLevelBuild instanceof PortalBranchInformationBuild)) {
            return;
        }
        PortalBranchInformationBuild portalBranchInformationBuild = (PortalBranchInformationBuild)((Object)this._topLevelBuild);
        PortalGitWorkingDirectory portalGitWorkingDirectory = this._getPortalGitWorkingDirectory();
        portalGitWorkingDirectory.clean();
        portalGitWorkingDirectory.checkoutLocalGitBranch(portalBranchInformationBuild.getPortalBranchInformation());
        portalGitWorkingDirectory.displayLog();
        try {
            JenkinsResultsParserUtil.write(new File(portalGitWorkingDirectory.getWorkingDirectory(), JenkinsResultsParserUtil.combine("app.server.", System.getenv("HOSTNAME"), ".properties")), JenkinsResultsParserUtil.combine("app.server.parent.dir=", JenkinsResultsParserUtil.getCanonicalPath(portalGitWorkingDirectory.getWorkingDirectory()), "/bundles"));
            JenkinsResultsParserUtil.write(new File(portalGitWorkingDirectory.getWorkingDirectory(), JenkinsResultsParserUtil.combine("build.", System.getenv("HOSTNAME"), ".properties")), JenkinsResultsParserUtil.combine("liferay.home=", JenkinsResultsParserUtil.getCanonicalPath(portalGitWorkingDirectory.getWorkingDirectory()), "/bundles"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void _checkoutQAWebsitesBranch() {
        Properties buildProperties;
        if (!(this._topLevelBuild instanceof QAWebsitesBranchInformationBuild)) {
            return;
        }
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        QAWebsitesBranchInformationBuild qaWebsitesBranchInformationBuild = (QAWebsitesBranchInformationBuild)((Object)this._topLevelBuild);
        Build.BranchInformation branchInformation = qaWebsitesBranchInformationBuild.getQAWebsitesBranchInformation();
        String upstreamBranchName = branchInformation.getUpstreamBranchName();
        String upstreamDirPath = JenkinsResultsParserUtil.getProperty(buildProperties, "qa.websites.dir", upstreamBranchName);
        String upstreamRepository = JenkinsResultsParserUtil.getProperty(buildProperties, "qa.websites.repository", upstreamBranchName);
        GitWorkingDirectory qaWebsitesGitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(upstreamBranchName, upstreamDirPath, upstreamRepository);
        qaWebsitesGitWorkingDirectory.clean();
        qaWebsitesGitWorkingDirectory.checkoutLocalGitBranch(qaWebsitesBranchInformationBuild.getQAWebsitesBranchInformation());
        qaWebsitesGitWorkingDirectory.displayLog();
    }

    private String _fixSlackString(String string) {
        string = string.replace("*", "&#42;");
        string = string.replace(">", "&gt;");
        string = string.replace("<", "&lt;");
        return string.replace("|", "&vert;");
    }

    private String _getBuildParameter(String buildParameterName) {
        HashMap<String, String> buildParameters = new HashMap<String, String>();
        Build controllerBuild = this._topLevelBuild.getControllerBuild();
        if (controllerBuild != null) {
            buildParameters.putAll(controllerBuild.getParameters());
        }
        buildParameters.putAll(this._topLevelBuild.getParameters());
        return (String)buildParameters.get(buildParameterName);
    }

    private Element _getJenkinsBuildDescriptionElement(String title, String name) {
        return this._getJenkinsBuildDescriptionElement(title, name, null);
    }

    private Element _getJenkinsBuildDescriptionElement(String title, String name, String url) {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("div");
        Element titleElement = element.addElement("strong");
        titleElement.addText(title + ":");
        Element spaceElement = element.addElement("span");
        spaceElement.addText(" ");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(url)) {
            Element linkElement = element.addElement("a");
            linkElement.addAttribute("href", url);
            linkElement.addText(name);
        } else {
            element.addText(name);
        }
        element.addElement("br");
        return element;
    }

    private GitWorkingDirectory _getJenkinsGitWorkingDirectory() {
        Properties buildProperties;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String upstreamBranchName = "master";
        String upstreamDirPath = JenkinsResultsParserUtil.getProperty(buildProperties, "jenkins.dir", upstreamBranchName);
        String upstreamRepository = JenkinsResultsParserUtil.getProperty(buildProperties, "jenkins.repository", upstreamBranchName);
        return GitWorkingDirectoryFactory.newGitWorkingDirectory(upstreamBranchName, upstreamDirPath, upstreamRepository);
    }

    private JobProperty _getJobProperty(String basePropertyName, File testBaseDir) {
        JobProperty jobProperty;
        Job job = this.getJob();
        if (job instanceof QAWebsitesGitRepositoryJob && !JenkinsResultsParserUtil.isNullOrEmpty((jobProperty = JobPropertyFactory.newJobProperty(basePropertyName, job, testBaseDir, JobProperty.Type.QA_WEBSITES_TEST_DIR)).getValue())) {
            return jobProperty;
        }
        return JobPropertyFactory.newJobProperty(basePropertyName, job);
    }

    private PortalGitWorkingDirectory _getPortalGitWorkingDirectory() {
        String portalUpstreamBranchName = this._topLevelBuild.getBranchName();
        if (this._topLevelBuild instanceof PullRequestSubrepositoryTopLevelBuild) {
            PullRequestSubrepositoryTopLevelBuild pullRequestSubrepositoryTopLevelBuild = (PullRequestSubrepositoryTopLevelBuild)this._topLevelBuild;
            portalUpstreamBranchName = pullRequestSubrepositoryTopLevelBuild.getPortalUpstreamBranchName();
        }
        return GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(portalUpstreamBranchName);
    }

    private String _getSlackBody(File testBaseDir) {
        JobProperty jobProperty = this._getJobProperty("testray.slack.body", testBaseDir);
        String slackBody = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(slackBody)) {
            StringBuilder sb = new StringBuilder();
            sb.append("*Jenkins Testray Importer:* ");
            sb.append("<$(testray.importer.build.url)|");
            sb.append("$(testray.importer.job.name)#");
            sb.append("$(testray.importer.build.number)>\n");
            sb.append("*Testray Build:* ");
            sb.append("<$(testray.build.url)|$(testray.build.name)>");
            slackBody = sb.toString();
        }
        return this._replaceSlackEnvVars(slackBody, testBaseDir);
    }

    private String _getSlackChannels(File testBaseDir) {
        JobProperty jobProperty = this._getJobProperty("testray.slack.channels", testBaseDir);
        String slackChannels = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(slackChannels)) {
            slackChannels = "testray-reports";
        }
        return this._replaceSlackEnvVars(slackChannels, testBaseDir);
    }

    private String _getSlackIconEmoji(File testBaseDir) {
        JobProperty jobProperty = this._getJobProperty("testray.slack.icon.emoji", testBaseDir);
        String slackIconEmoji = jobProperty.getValue();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(slackIconEmoji)) {
            return this._replaceSlackEnvVars(slackIconEmoji, testBaseDir);
        }
        return ":liferay-ci:";
    }

    private String _getSlackSubject(File testBaseDir) {
        JobProperty jobProperty = this._getJobProperty("testray.slack.subject", testBaseDir);
        String slackSubject = jobProperty.getValue();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(slackSubject)) {
            return this._replaceSlackEnvVars(slackSubject, testBaseDir);
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        return JenkinsResultsParserUtil.combine(topLevelBuild.getJobName(), "#", String.valueOf(topLevelBuild.getBuildNumber()));
    }

    private String _getSlackUsername(File testBaseDir) {
        JobProperty jobProperty = this._getJobProperty("testray.slack.username", testBaseDir);
        String slackUsername = jobProperty.getValue();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(slackUsername)) {
            return this._replaceSlackEnvVars(slackUsername, testBaseDir);
        }
        return "Liferay CI";
    }

    private String _replaceEnvVars(String string) {
        string = this._replaceEnvVarsControllerBuild(string);
        string = this._replaceEnvVarsPluginsBranchInformationBuild(string);
        string = this._replaceEnvVarsPluginsTopLevelBuild(string);
        string = this._replaceEnvVarsPortalAppReleaseTopLevelBuild(string);
        string = this._replaceEnvVarsPortalBranchInformationBuild(string);
        string = this._replaceEnvVarsPortalRelease(string);
        string = this._replaceEnvVarsPullRequestBuild(string);
        string = this._replaceEnvVarsQAWebsitesTopLevelBuild(string);
        string = this._replaceEnvVarsTopLevelBuild(string);
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        String jobName = topLevelBuild.getJobName();
        if (jobName.contains("subrepository")) {
            string = this._replaceEnvVarsSubrepository(string);
        }
        return string;
    }

    private String _replaceEnvVarsControllerBuild(String string) {
        Build controllerBuild = this._topLevelBuild.getControllerBuild();
        if (controllerBuild == null) {
            return string;
        }
        string = string.replace("$(jenkins.controller.build.url)", controllerBuild.getBuildURL());
        string = string.replace("$(jenkins.controller.build.number)", String.valueOf(controllerBuild.getBuildNumber()));
        string = string.replace("$(jenkins.controller.build.start)", JenkinsResultsParserUtil.toDateString(new Date(controllerBuild.getStartTime()), "yyyy-MM-dd[HH:mm:ss]", "America/Los_Angeles"));
        string = string.replace("$(jenkins.controller.job.name)", controllerBuild.getJobName());
        JenkinsMaster jenkinsMaster = controllerBuild.getJenkinsMaster();
        return string.replace("$(jenkins.controller.master.hostname)", jenkinsMaster.getName());
    }

    private String _replaceEnvVarsPluginsBranchInformationBuild(String string) {
        if (!(this._topLevelBuild instanceof PluginsBranchInformationBuild)) {
            return string;
        }
        PluginsBranchInformationBuild pluginsBranchInformationBuild = (PluginsBranchInformationBuild)((Object)this._topLevelBuild);
        Build.BranchInformation pluginsBranchInformation = pluginsBranchInformationBuild.getPluginsBranchInformation();
        if (pluginsBranchInformation == null) {
            return string;
        }
        string = string.replace("$(plugins.branch.name)", pluginsBranchInformation.getUpstreamBranchName());
        string = string.replace("$(plugins.custom.branch.name)", pluginsBranchInformation.getSenderBranchName());
        string = string.replace("$(plugins.custom.branch.username)", pluginsBranchInformation.getSenderUsername());
        string = string.replace("$(plugins.repository)", pluginsBranchInformation.getRepositoryName());
        return string.replace("$(plugins.sha)", pluginsBranchInformation.getSenderBranchSHA());
    }

    private String _replaceEnvVarsPluginsTopLevelBuild(String string) {
        if (!(this._topLevelBuild instanceof PluginsTopLevelBuild)) {
            return string;
        }
        PluginsTopLevelBuild pluginsTopLevelBuild = (PluginsTopLevelBuild)this._topLevelBuild;
        String pluginName = pluginsTopLevelBuild.getPluginName();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(pluginName)) {
            string = string.replace("$(plugin.name)", pluginName);
        }
        return string;
    }

    private String _replaceEnvVarsPortalAppReleaseTopLevelBuild(String string) {
        if (!(this._topLevelBuild instanceof PortalAppReleaseTopLevelBuild)) {
            return string;
        }
        PortalAppReleaseTopLevelBuild portalAppReleaseTopLevelBuild = (PortalAppReleaseTopLevelBuild)this._topLevelBuild;
        return string.replace("$(portal.app.name)", portalAppReleaseTopLevelBuild.getPortalAppName());
    }

    private String _replaceEnvVarsPortalBranchInformationBuild(String string) {
        Job.BuildProfile buildProfile = this._topLevelBuild.getBuildProfile();
        string = string.replace("$(portal.profile)", buildProfile.toDisplayString());
        string = buildProfile == Job.BuildProfile.PORTAL ? string.replace("$(portal.type)", "CE") : string.replace("$(portal.type)", "EE");
        PortalGitWorkingDirectory portalGitWorkingDirectory = this._getPortalGitWorkingDirectory();
        string = string.replace("$(portal.version)", portalGitWorkingDirectory.getMajorPortalVersion());
        if (!(this._topLevelBuild instanceof PortalBranchInformationBuild)) {
            return string;
        }
        PortalBranchInformationBuild portalBranchInformationBuild = (PortalBranchInformationBuild)((Object)this._topLevelBuild);
        Build.BranchInformation portalBranchInformation = portalBranchInformationBuild.getPortalBranchInformation();
        if (portalBranchInformation == null) {
            return string;
        }
        string = string.replace("$(portal.branch.name)", portalBranchInformation.getUpstreamBranchName());
        string = string.replace("$(portal.repository)", portalBranchInformation.getRepositoryName());
        return string.replace("$(portal.sha)", portalBranchInformation.getSenderBranchSHA());
    }

    private String _replaceEnvVarsPortalRelease(String string) {
        PortalHotfixRelease portalHotfixRelease;
        PortalFixpackRelease portalFixpackRelease;
        PortalRelease portalRelease = this.getPortalRelease();
        if (portalRelease != null) {
            String portalReleaseBuildVersion;
            String portalBundleTomcatURLString = String.valueOf(portalRelease.getPortalBundleTomcatURL());
            string = string.replace("$(portal.release.tomcat.url)", portalBundleTomcatURLString);
            string = string.replace("$(portal.release.version)", portalRelease.getPortalVersion());
            Matcher matcher = _releaseArtifactURLPattern.matcher(portalBundleTomcatURLString);
            if (matcher.find()) {
                string = string.replace("$(portal.release.tomcat.name)", matcher.group("releaseName"));
            }
            if (!JenkinsResultsParserUtil.isNullOrEmpty(portalReleaseBuildVersion = this._topLevelBuild.getParameterValue("TEST_PORTAL_RELEASE_VERSION"))) {
                string = string.replace("$(portal.release.build.version)", portalReleaseBuildVersion);
            }
        }
        if ((portalFixpackRelease = this.getPortalFixpackRelease()) != null) {
            String portalFixpackURL = String.valueOf(portalFixpackRelease.getPortalFixpackURL());
            string = string.replace("$(portal.fixpack.release.url)", portalFixpackURL);
            string = string.replace("$(portal.fixpack.release.version)", portalFixpackRelease.getPortalFixpackVersion());
            Matcher matcher = _releaseArtifactURLPattern.matcher(portalFixpackURL);
            if (matcher.find()) {
                string = string.replace("$(portal.fixpack.release.name)", matcher.group("releaseName"));
            }
        }
        if ((portalHotfixRelease = this.getPortalHotfixRelease()) != null) {
            String portalHotfixURL = String.valueOf(portalHotfixRelease.getPortalHotfixReleaseURL());
            string = string.replace("$(portal.hotfix.release.url)", portalHotfixURL);
            string = string.replace("$(portal.hotfix.release.version)", portalHotfixRelease.getPortalHotfixReleaseVersion());
            Matcher matcher = _releaseArtifactURLPattern.matcher(portalHotfixURL);
            if (matcher.find()) {
                string = string.replace("$(portal.hotfix.release.name)", matcher.group("releaseName"));
            }
        }
        StringBuilder sb = new StringBuilder();
        if (portalRelease == null) {
            PortalGitWorkingDirectory portalGitWorkingDirectory = this._getPortalGitWorkingDirectory();
            sb.append(portalGitWorkingDirectory.getMajorPortalVersion());
            sb.append(".x");
        } else {
            sb.append(portalRelease.getPortalVersion());
            if (portalFixpackRelease != null) {
                sb.append(" FP");
                sb.append(portalFixpackRelease.getPortalFixpackVersion());
            }
            if (portalHotfixRelease != null) {
                sb.append(" HF");
                sb.append(portalHotfixRelease.getPortalHotfixReleaseVersion());
            }
        }
        return string.replace("$(portal.release.name)", sb.toString());
    }

    private String _replaceEnvVarsPullRequestBuild(String string) {
        PullRequest pullRequest = this.getPullRequest();
        if (pullRequest == null) {
            return string;
        }
        string = string.replace("$(pull.request.number)", pullRequest.getNumber());
        string = string.replace("$(pull.request.url)", pullRequest.getHtmlURL());
        string = string.replace("$(pull.request.receiver.username)", pullRequest.getReceiverUsername());
        return string.replace("$(pull.request.sender.username)", pullRequest.getSenderUsername());
    }

    private String _replaceEnvVarsQAWebsitesTopLevelBuild(String string) {
        if (!(this._topLevelBuild instanceof QAWebsitesTopLevelBuild)) {
            return string;
        }
        QAWebsitesTopLevelBuild qaWebsitesTopLevelBuild = (QAWebsitesTopLevelBuild)this._topLevelBuild;
        return string.replace("$(qa.websites.project.name)", JenkinsResultsParserUtil.join(",", qaWebsitesTopLevelBuild.getProjectNames()));
    }

    private String _replaceEnvVarsSubrepository(String string) {
        string = string.replace("$(github.upstream.branch.name)", this._topLevelBuild.getParameterValue("GITHUB_UPSTREAM_BRANCH_NAME"));
        return string.replace("$(repository.name)", this._topLevelBuild.getParameterValue("REPOSITORY_NAME"));
    }

    private String _replaceEnvVarsTopLevelBuild(String string) {
        string = string.replace("$(ci.test.suite)", this._topLevelBuild.getTestSuiteName());
        string = string.replace("$(jenkins.build.number)", String.valueOf(this._topLevelBuild.getBuildNumber()));
        string = string.replace("$(jenkins.build.start)", JenkinsResultsParserUtil.toDateString(new Date(this._topLevelBuild.getStartTime()), "yyyy-MM-dd[HH:mm:ss]", "America/Los_Angeles"));
        string = string.replace("$(jenkins.build.url)", this._topLevelBuild.getBuildURL());
        string = string.replace("$(jenkins.job.name)", this._topLevelBuild.getJobName());
        JenkinsMaster jenkinsMaster = this._topLevelBuild.getJenkinsMaster();
        string = string.replace("$(jenkins.master.hostname)", jenkinsMaster.getName());
        return string.replace("$(jenkins.report.url)", this._topLevelBuild.getJenkinsReportURL());
    }

    private String _replaceSlackEnvVars(String string, File testBaseDir) {
        string = this._replaceEnvVars(string);
        string = this._replaceSlackEnvVarsTestrayInformation(string, testBaseDir);
        string = this._replaceSlackEnvVarsTestrayImporter(string);
        return string;
    }

    private String _replaceSlackEnvVarsTestrayImporter(String string) {
        String jobName;
        String buildURL;
        String buildNumber = System.getenv("BUILD_NUMBER");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(buildNumber)) {
            string = string.replace("$(testray.importer.build.number)", buildNumber);
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(buildURL = System.getenv("BUILD_URL"))) {
            string = string.replace("$(testray.importer.build.url)", buildURL);
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(jobName = System.getenv("JOB_NAME"))) {
            string = string.replace("$(testray.importer.job.name)", jobName);
        }
        return string;
    }

    private String _replaceSlackEnvVarsTestrayInformation(String string, File testBaseDir) {
        TestrayBuild testrayBuild;
        TestrayRoutine testrayRoutine;
        TestrayProductVersion testrayProductVersion;
        TestrayProject testrayProject;
        TestrayServer testrayServer = this.getTestrayServer(testBaseDir);
        if (testrayServer != null) {
            string = string.replace("$(testray.server.url)", String.valueOf(testrayServer.getURL()));
        }
        if ((testrayProject = this.getTestrayProject(testBaseDir)) != null) {
            string = string.replace("$(testray.project.name)", this._fixSlackString(testrayProject.getName()));
            string = string.replace("$(testray.project.url)", String.valueOf(testrayProject.getURL()));
        }
        if ((testrayProductVersion = this.getTestrayProductVersion(testBaseDir)) != null) {
            string = string.replace("$(testray.product.version.name)", this._fixSlackString(testrayProductVersion.getName()));
            string = string.replace("$(testray.product.version.url)", String.valueOf(testrayProductVersion.getURL()));
        }
        if ((testrayRoutine = this.getTestrayRoutine(testBaseDir)) != null) {
            string = string.replace("$(testray.routine.name)", this._fixSlackString(testrayRoutine.getName()));
            string = string.replace("$(testray.routine.url)", String.valueOf(testrayRoutine.getURL()));
        }
        if ((testrayBuild = this.getTestrayBuild(testBaseDir)) != null) {
            string = string.replace("$(testray.build.name)", this._fixSlackString(testrayBuild.getName()));
            string = string.replace("$(testray.build.url)", String.valueOf(testrayBuild.getURL()));
        }
        return string;
    }

    private void _sendPullRequestNotification() {
        PullRequest pullRequest = this.getPullRequest();
        if (pullRequest == null) {
            return;
        }
        pullRequest.addComment(this.getJenkinsBuildDescription());
    }

    private void _setupPortalBundle() {
        final PortalGitWorkingDirectory portalGitWorkingDirectory = this._getPortalGitWorkingDirectory();
        if (portalGitWorkingDirectory == null) {
            return;
        }
        PortalRelease portalRelease = this.getPortalRelease();
        if (portalRelease == null) {
            return;
        }
        final HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("liferay.portal.bundle", portalRelease.getPortalVersion());
        String portalBundleTomcatURLString = String.valueOf(portalRelease.getPortalBundleTomcatURL());
        if (portalBundleTomcatURLString.startsWith("https://release.liferay.com")) {
            try {
                portalBundleTomcatURLString = portalBundleTomcatURLString.replaceAll("https://(release\\.liferay\\.com.*)", JenkinsResultsParserUtil.combine("https://", JenkinsResultsParserUtil.getBuildProperty("jenkins.admin.user.name"), ":", JenkinsResultsParserUtil.getBuildProperty("jenkins.admin.user.password"), "@$1"));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        parameters.put("test.build.bundle.zip.url", portalBundleTomcatURLString);
        PortalFixpackRelease portalFixpackRelease = this.getPortalFixpackRelease();
        PortalHotfixRelease portalHotfixRelease = this.getPortalHotfixRelease();
        if (portalFixpackRelease != null || portalHotfixRelease != null) {
            try {
                parameters.put("test.fix.pack.base.url", JenkinsResultsParserUtil.getBuildProperty("portal.test.properties[test.fix.pack.base.url]"));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            if (portalHotfixRelease != null) {
                parameters.put("test.build.fix.pack.zip.url", String.valueOf(portalHotfixRelease.getPortalHotfixReleaseURL()));
            } else {
                parameters.put("test.build.fix.pack.zip.url", String.valueOf(portalFixpackRelease.getPortalFixpackURL()));
            }
        }
        final File workingDirectory = portalGitWorkingDirectory.getWorkingDirectory();
        Retryable<Object> retryable = new Retryable<Object>(true, 3, 15, true){

            @Override
            public Object execute() {
                try {
                    AntUtil.callTarget(workingDirectory, "build-test.xml", "set-tomcat-version-number", parameters);
                    String upstreamBranchName = portalGitWorkingDirectory.getUpstreamBranchName();
                    if (upstreamBranchName.contains("6.1") || upstreamBranchName.contains("6.2")) {
                        parameters.put("test.app.server.bin.dir", JenkinsResultsParserUtil.getProperty(portalGitWorkingDirectory.getAppServerProperties(), "app.server.tomcat.bin.dir"));
                    }
                    AntUtil.callTarget(workingDirectory, "build-test.xml", "prepare-test-bundle", parameters);
                }
                catch (AntException antException) {
                    throw new RuntimeException(antException);
                }
                return null;
            }
        };
        retryable.execute();
    }

    private void _setupProfileDXP() {
        String portalBuildProfile;
        boolean setupProfileDXP = false;
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        String branchName = topLevelBuild.getBranchName();
        String jobName = topLevelBuild.getJobName();
        if (!branchName.startsWith("ee-") && !branchName.endsWith("-private") && jobName.contains("environment")) {
            setupProfileDXP = true;
        }
        if (!branchName.startsWith("ee-") && (jobName.contains("fixpack") || jobName.contains("hotfix"))) {
            setupProfileDXP = true;
        }
        if ((portalBuildProfile = topLevelBuild.getParameterValue("TEST_PORTAL_BUILD_PROFILE")) != null && portalBuildProfile.equals("dxp")) {
            setupProfileDXP = true;
        }
        if (!setupProfileDXP) {
            return;
        }
        PortalGitWorkingDirectory portalGitWorkingDirectory = this._getPortalGitWorkingDirectory();
        try {
            AntUtil.callTarget(portalGitWorkingDirectory.getWorkingDirectory(), "build.xml", "setup-profile-dxp");
        }
        catch (AntException antException) {
            throw new RuntimeException(antException);
        }
    }
}

