/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.SourceFormatBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalAxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JUnitAxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.BatchBuildTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.DefaultTestrayAttachment;
import com.liferay.jenkins.results.parser.testray.DefaultTestrayServer;
import com.liferay.jenkins.results.parser.testray.FunctionalBatchBuildTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.JUnitBatchBuildTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.RsyncTestrayAttachmentUploader;
import com.liferay.jenkins.results.parser.testray.S3TestrayAttachmentUploader;
import com.liferay.jenkins.results.parser.testray.SFBatchBuildTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayAttachmentRecorder;
import com.liferay.jenkins.results.parser.testray.TestrayAttachmentUploader;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import com.liferay.jenkins.results.parser.testray.TopLevelBuildTestrayCaseResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class TestrayFactory {
    private static final Map<Build, TestrayAttachmentRecorder> _testrayAttachmentRecorders = new HashMap<Build, TestrayAttachmentRecorder>();
    private static final Map<String, TestrayAttachmentUploader> _testrayAttachmentUploaders = new HashMap<String, TestrayAttachmentUploader>();
    private static final Map<String, TestrayBuild> _testrayBuilds = new HashMap<String, TestrayBuild>();
    private static final Map<String, TestrayRoutine> _testrayRoutines = new HashMap<String, TestrayRoutine>();
    private static final Map<String, TestrayServer> _testrayServers = new HashMap<String, TestrayServer>();
    private static final Map<Integer, TopLevelBuildTestrayCaseResult> _topLevelBuildTestrayCaseResults = new HashMap<Integer, TopLevelBuildTestrayCaseResult>();

    public static TestrayAttachment newTestrayAttachment(TestrayCaseResult testrayCaseResult, String name, String key) {
        return new DefaultTestrayAttachment(testrayCaseResult, name, key);
    }

    public static TestrayAttachmentRecorder newTestrayAttachmentRecorder(Build build) {
        TestrayAttachmentRecorder testrayAttachmentRecorder = _testrayAttachmentRecorders.get(build);
        if (testrayAttachmentRecorder != null) {
            return testrayAttachmentRecorder;
        }
        testrayAttachmentRecorder = new TestrayAttachmentRecorder(build);
        _testrayAttachmentRecorders.put(build, testrayAttachmentRecorder);
        return testrayAttachmentRecorder;
    }

    public static TestrayAttachmentUploader newTestrayAttachmentUploader(Build build, URL testrayServerURL, TestrayAttachmentUploader.Type type) {
        String key;
        TestrayAttachmentUploader testrayAttachmentUploader;
        String testrayServerURLString = "";
        if (testrayServerURL != null) {
            testrayServerURLString = String.valueOf(testrayServerURL);
        }
        if ((testrayAttachmentUploader = _testrayAttachmentUploaders.get(key = JenkinsResultsParserUtil.combine(build.getBuildURL(), "_", testrayServerURLString, "_", type.toString()))) != null) {
            return testrayAttachmentUploader;
        }
        testrayAttachmentUploader = type == TestrayAttachmentUploader.Type.RSYNC ? new RsyncTestrayAttachmentUploader(build, testrayServerURL) : new S3TestrayAttachmentUploader(build, testrayServerURL);
        _testrayAttachmentUploaders.put(key, testrayAttachmentUploader);
        return testrayAttachmentUploader;
    }

    public static TestrayBuild newTestrayBuild(String testrayBuildURL) {
        TestrayBuild testrayBuild = _testrayBuilds.get(testrayBuildURL);
        if (testrayBuild != null) {
            return testrayBuild;
        }
        try {
            testrayBuild = new TestrayBuild(new URL(testrayBuildURL));
            _testrayBuilds.put(testrayBuildURL, testrayBuild);
            return testrayBuild;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public static TestrayCaseResult newTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup, TestClass testClass) {
        if (testrayBuild == null) {
            throw new RuntimeException("Testray build is null");
        }
        if (topLevelBuild == null) {
            throw new RuntimeException("Top level build is null");
        }
        if (axisTestClassGroup == null) {
            throw new RuntimeException("Axis test class group is null");
        }
        if (testClass != null) {
            if (axisTestClassGroup instanceof FunctionalAxisTestClassGroup) {
                return new FunctionalBatchBuildTestrayCaseResult(testrayBuild, topLevelBuild, axisTestClassGroup, testClass);
            }
            if (axisTestClassGroup instanceof JUnitAxisTestClassGroup) {
                return new JUnitBatchBuildTestrayCaseResult(testrayBuild, topLevelBuild, axisTestClassGroup, testClass);
            }
        }
        if (topLevelBuild instanceof SourceFormatBuild) {
            return new SFBatchBuildTestrayCaseResult(testrayBuild, topLevelBuild, axisTestClassGroup);
        }
        return new BatchBuildTestrayCaseResult(testrayBuild, topLevelBuild, axisTestClassGroup);
    }

    public static TestrayRoutine newTestrayRoutine(String testrayRoutineURL) {
        TestrayRoutine testrayRoutine = _testrayRoutines.get(testrayRoutineURL);
        if (testrayRoutine != null) {
            return testrayRoutine;
        }
        try {
            testrayRoutine = new TestrayRoutine(new URL(testrayRoutineURL));
            _testrayRoutines.put(testrayRoutineURL, testrayRoutine);
            return testrayRoutine;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public static TestrayServer newTestrayServer(String testrayServerURL) {
        TestrayServer testrayServer = _testrayServers.get(testrayServerURL);
        if (testrayServer != null) {
            return testrayServer;
        }
        testrayServer = new DefaultTestrayServer(testrayServerURL);
        _testrayServers.put(testrayServerURL, testrayServer);
        return testrayServer;
    }

    public static TopLevelBuildTestrayCaseResult newTopLevelBuildTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild) {
        Integer testrayBuildID = testrayBuild.getID();
        if (_topLevelBuildTestrayCaseResults.containsKey(testrayBuildID)) {
            return _topLevelBuildTestrayCaseResults.get(testrayBuildID);
        }
        if (testrayBuild == null) {
            throw new RuntimeException("Please set a Testray build");
        }
        if (topLevelBuild == null) {
            throw new RuntimeException("Please set a top level build");
        }
        _topLevelBuildTestrayCaseResults.put(testrayBuildID, new TopLevelBuildTestrayCaseResult(testrayBuild, topLevelBuild));
        return _topLevelBuildTestrayCaseResults.get(testrayBuildID);
    }
}

