/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.BuildReportFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuildReport;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayProductVersion;
import com.liferay.jenkins.results.parser.testray.TestrayProject;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class TestrayBuild
implements Comparable<TestrayBuild> {
    private static final Pattern _portalSHAPattern = Pattern.compile("Portal SHA: (?<portalSHA>[^;]+);");
    private static final Pattern _testrayAttachmentURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("https://testray.liferay.com/reports/production/logs/", "(?<startYearMonth>\\d{4}-\\d{2})/", "(?<topLevelMasterHostname>test-\\d+-\\d+)/", "(?<topLevelJobName>[^/]+)/(?<topLevelBuildNumber>\\d+)/.*"));
    private static final Pattern _testrayBuildURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("(?<serverURL>https://[^/]+)/home/-/testray/runs\\?", "testrayBuildId=(?<buildID>\\d+)"));
    private final JSONObject _jsonObject;
    private Matcher _testrayAttachmentURLMatcher;
    private final TestrayProductVersion _testrayProductVersion;
    private final TestrayProject _testrayProject;
    private final TestrayRoutine _testrayRoutine;
    private final TestrayServer _testrayServer;
    private TopLevelBuildReport _topLevelBuildReport;

    public TestrayBuild(TestrayRoutine testrayRoutine, JSONObject jsonObject) {
        this._testrayRoutine = testrayRoutine;
        this._jsonObject = jsonObject;
        this._testrayProject = this._testrayRoutine.getTestrayProject();
        this._testrayServer = this._testrayRoutine.getTestrayServer();
        this._testrayProductVersion = this._testrayProject.getTestrayProductVersionByID(this._jsonObject.getInt("testrayProductVersionId"));
    }

    @Override
    public int compareTo(TestrayBuild testrayBuild) {
        if (testrayBuild == null) {
            throw new NullPointerException("Testray build is null");
        }
        Integer id = testrayBuild.getID();
        return id.compareTo(this.getID());
    }

    public String getDescription() {
        return this._jsonObject.getString("description");
    }

    public int getID() {
        return this._jsonObject.getInt("testrayBuildId");
    }

    public String getName() {
        return this._jsonObject.getString("name");
    }

    public String getPortalSHA() {
        Matcher matcher = _portalSHAPattern.matcher(this._jsonObject.optString("description"));
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("portalSHA");
    }

    public String getStartYearMonth() {
        Matcher matcher = this._getTestrayAttachmentURLMatcher();
        if (matcher == null) {
            return null;
        }
        return matcher.group("startYearMonth");
    }

    public List<TestrayCaseResult> getTestrayCaseResults() {
        return this.getTestrayCaseResults(null);
    }

    public List<TestrayCaseResult> getTestrayCaseResults(String nameFilter) {
        ArrayList<TestrayCaseResult> testrayCaseResults = new ArrayList<TestrayCaseResult>();
        String urlString = String.valueOf(this.getURL());
        String caseResultsAPIURLString = urlString.replace("runs", "case_results.json");
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(caseResultsAPIURLString, this._testrayServer.getHTTPAuthorization());
            JSONArray dataJSONArray = jsonObject.getJSONArray("data");
            for (int i = 0; i < dataJSONArray.length(); ++i) {
                JSONObject dataJSONObject = dataJSONArray.getJSONObject(i);
                TestrayCaseResult testrayCaseResult = new TestrayCaseResult(this, dataJSONObject);
                testrayCaseResults.add(testrayCaseResult);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return testrayCaseResults;
    }

    public TestrayProductVersion getTestrayProductVersion() {
        return this._testrayProductVersion;
    }

    public TestrayProject getTestrayProject() {
        return this._testrayProject;
    }

    public TestrayRoutine getTestrayRoutine() {
        return this._testrayRoutine;
    }

    public TestrayServer getTestrayServer() {
        return this._testrayServer;
    }

    public TopLevelBuildReport getTopLevelBuildReport() {
        if (this._topLevelBuildReport != null) {
            return this._topLevelBuildReport;
        }
        URL topLevelBuildReportURL = this.getTopLevelBuildReportURL();
        if (topLevelBuildReportURL == null || !JenkinsResultsParserUtil.exists(topLevelBuildReportURL)) {
            return null;
        }
        this._topLevelBuildReport = BuildReportFactory.newTopLevelBuildReport(this);
        return this._topLevelBuildReport;
    }

    public URL getTopLevelBuildReportURL() {
        Matcher matcher = this._getTestrayAttachmentURLMatcher();
        if (matcher == null) {
            return null;
        }
        try {
            return new URL(JenkinsResultsParserUtil.combine("http://", matcher.group("topLevelMasterHostname"), "/userContent/jobs/", matcher.group("topLevelJobName"), "/builds/", matcher.group("topLevelBuildNumber"), "/build-report.json.gz"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public URL getTopLevelBuildURL() {
        Matcher matcher = this._getTestrayAttachmentURLMatcher();
        if (matcher == null) {
            return null;
        }
        try {
            return new URL(JenkinsResultsParserUtil.combine("https://", matcher.group("topLevelMasterHostname"), ".liferay.com/job/", matcher.group("topLevelJobName"), "/", matcher.group("topLevelBuildNumber"), "/"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public TestrayCaseResult getTopLevelTestrayCaseResult() {
        List<TestrayCaseResult> testrayCaseResults = this.getTestrayCaseResults("Top");
        for (TestrayCaseResult testrayCaseResult : testrayCaseResults) {
            if (!Objects.equals(testrayCaseResult.getName(), "Top Level Build")) continue;
            return testrayCaseResult;
        }
        return null;
    }

    public URL getURL() {
        try {
            return new URL(this._jsonObject.getString("htmlURL"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    protected TestrayBuild(URL testrayBuildURL) {
        Matcher matcher = _testrayBuildURLPattern.matcher(testrayBuildURL.toString());
        if (!matcher.find()) {
            throw new RuntimeException("Invalid Build URL " + testrayBuildURL);
        }
        String serverURL = matcher.group("serverURL");
        this._testrayServer = TestrayFactory.newTestrayServer(matcher.group("serverURL"));
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(serverURL, "/home/-/testray/builds/", matcher.group("buildID"), ".json"), this._testrayServer.getHTTPAuthorization());
            this._jsonObject = jsonObject.getJSONObject("data");
            this._testrayRoutine = TestrayFactory.newTestrayRoutine(JenkinsResultsParserUtil.combine(String.valueOf(this._testrayServer.getURL()), "/home/-/testray/builds?testrayRoutineId=", this._jsonObject.getString("testrayRoutineId")));
            this._testrayProject = this._testrayRoutine.getTestrayProject();
            this._testrayProductVersion = this._testrayProject.getTestrayProductVersionByID(this._jsonObject.getInt("testrayProductVersionId"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private Matcher _getTestrayAttachmentURLMatcher() {
        List<TestrayCaseResult> testrayCaseResults;
        if (this._testrayAttachmentURLMatcher != null) {
            return this._testrayAttachmentURLMatcher;
        }
        TestrayCaseResult topLevelTestrayCaseResult = this.getTopLevelTestrayCaseResult();
        if (topLevelTestrayCaseResult != null) {
            for (TestrayAttachment testrayAttachment : topLevelTestrayCaseResult.getTestrayAttachments()) {
                Matcher testrayAttachmentURLMatcher = _testrayAttachmentURLPattern.matcher(String.valueOf(testrayAttachment.getURL()));
                if (!testrayAttachmentURLMatcher.find()) continue;
                this._testrayAttachmentURLMatcher = testrayAttachmentURLMatcher;
                return this._testrayAttachmentURLMatcher;
            }
        }
        if ((testrayCaseResults = this.getTestrayCaseResults()).isEmpty()) {
            return null;
        }
        int count = 0;
        for (TestrayCaseResult testrayCaseResult : testrayCaseResults) {
            if (++count >= 5) break;
            for (TestrayAttachment testrayAttachment : testrayCaseResult.getTestrayAttachments()) {
                Matcher testrayAttachmentURLMatcher = _testrayAttachmentURLPattern.matcher(String.valueOf(testrayAttachment.getURL()));
                if (!testrayAttachmentURLMatcher.find()) continue;
                this._testrayAttachmentURLMatcher = testrayAttachmentURLMatcher;
                return this._testrayAttachmentURLMatcher;
            }
        }
        return null;
    }
}

