/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.RemoteExecutor;
import com.liferay.jenkins.results.parser.testray.BaseTestrayAttachmentUploader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;

public class RsyncTestrayAttachmentUploader
extends BaseTestrayAttachmentUploader {
    private boolean _uploaded;

    @Override
    public File getPreparedFilesBaseDir() {
        String workspace = System.getenv("WORKSPACE");
        if (JenkinsResultsParserUtil.isNullOrEmpty(workspace)) {
            throw new RuntimeException("Please set WORKSPACE");
        }
        return new File(workspace, "testray/prepared_rsync_logs");
    }

    @Override
    public URL getTestrayServerLogsURL() {
        try {
            return new URL(JenkinsResultsParserUtil.combine(String.valueOf(this.getTestrayServerURL()), "/reports/production/logs"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    @Override
    public void upload() {
        if (this._uploaded) {
            return;
        }
        this.prepareFiles();
        this._rsyncDirs();
        this._rsyncFiles();
        this._uploaded = true;
    }

    protected RsyncTestrayAttachmentUploader(Build build, URL testrayServerURL) {
        super(build, testrayServerURL);
    }

    private String _getMasterHostname() {
        Build build = this.getBuild();
        JenkinsMaster jenkinsMaster = build.getJenkinsMaster();
        return jenkinsMaster.getName();
    }

    private String _getTestrayMountDirPath() {
        try {
            return JenkinsResultsParserUtil.getBuildProperty("testray.server.mount.dir[testray-1]");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void _rsyncDirs() {
        RemoteExecutor remoteExecutor = new RemoteExecutor();
        ArrayList<String> commands = new ArrayList<String>();
        ArrayList<File> preparedParentDirs = new ArrayList<File>();
        for (File preparedFile : this.getPreparedFiles()) {
            File preparedParentDir = preparedFile.getParentFile();
            if (preparedParentDir == null || !preparedParentDir.isDirectory() || preparedParentDirs.contains(preparedParentDir)) continue;
            preparedParentDirs.add(preparedParentDir);
            commands.add(JenkinsResultsParserUtil.combine("mkdir -p \"", this._getTestrayMountDirPath(), "/jenkins/testray-results/production/logs/", JenkinsResultsParserUtil.getPathRelativeTo(preparedParentDir, this.getPreparedFilesBaseDir()), "\""));
        }
        remoteExecutor.execute(1, new String[]{"root@" + this._getMasterHostname()}, commands.toArray(new String[0]));
    }

    private void _rsyncFiles() {
        this._rsyncDirs();
        String[] commands = null;
        commands = JenkinsResultsParserUtil.isWindows() ? new String[]{JenkinsResultsParserUtil.combine("cd ", JenkinsResultsParserUtil.getCanonicalPath(this.getPreparedFilesBaseDir())), JenkinsResultsParserUtil.combine("rsync -aqz --chmod=go=rx ./* \"root@", this._getMasterHostname(), "::testray-results/production/logs/\"")} : new String[]{JenkinsResultsParserUtil.combine("rsync -aqz --chmod=go=rx \"", JenkinsResultsParserUtil.getCanonicalPath(this.getPreparedFilesBaseDir()), "\"/* \"", this._getMasterHostname(), "::testray-results/production/logs/\"")};
        try {
            JenkinsResultsParserUtil.executeBashCommands(commands);
        }
        catch (IOException | TimeoutException exception) {
            throw new RuntimeException(exception);
        }
        for (File preparedFile : this.getPreparedFiles()) {
            System.out.println(JenkinsResultsParserUtil.combine("Uploaded ", String.valueOf(this.getTestrayServerLogsURL()), "/", JenkinsResultsParserUtil.getPathRelativeTo(preparedFile, this.getPreparedFilesBaseDir())));
        }
    }
}

