/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.test.clazz.JUnitTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.BatchBuildTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JUnitBatchBuildTestrayCaseResult
extends BatchBuildTestrayCaseResult {
    private final JUnitTestClass _jUnitTestClass;
    private List<TestClassResult> _testClassResults;

    public JUnitBatchBuildTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup, TestClass testClass) {
        super(testrayBuild, topLevelBuild, axisTestClassGroup);
        this._jUnitTestClass = (JUnitTestClass)testClass;
    }

    @Override
    public String getComponentName() {
        String componentName = this._jUnitTestClass.getTestrayMainComponentName();
        if (JenkinsResultsParserUtil.isNullOrEmpty(componentName)) {
            return super.getComponentName();
        }
        return componentName;
    }

    @Override
    public String getErrors() {
        List<TestClassResult> testClassResults = this._getTestClassResults();
        if (testClassResults == null || testClassResults.isEmpty()) {
            Build build = this.getBuild();
            if (build == null) {
                return "Failed to run build on CI";
            }
            String result = build.getResult();
            if (result == null) {
                return "Failed to finish build on CI";
            }
            if (result.equals("ABORTED")) {
                return "Aborted prior to running test";
            }
            if (result.equals("SUCCESS") || result.equals("UNSTABLE")) {
                return "Failed to run test on CI";
            }
            return "Failed prior to running test";
        }
        if (!this._isTestClassResultsFailing()) {
            return null;
        }
        HashMap<String, String> errorMessages = new HashMap<String, String>();
        for (TestResult testResult : this._getTestResults()) {
            if (testResult == null || !testResult.isFailing()) continue;
            String errorMessage = testResult.getErrorDetails();
            if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage)) {
                errorMessage = "Failed for unknown reason";
            }
            if (errorMessage.contains("\n")) {
                errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n"));
            }
            if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage = errorMessage.trim())) {
                errorMessage = "Failed for unknown reason";
            }
            String testName = testResult.getDisplayName();
            errorMessages.put(testName, JenkinsResultsParserUtil.combine(testName, ": ", errorMessage));
        }
        if (errorMessages.size() > 1) {
            return JenkinsResultsParserUtil.combine("Failed tests: ", JenkinsResultsParserUtil.join(", ", new ArrayList<String>(errorMessages.keySet())));
        }
        if (errorMessages.size() == 1) {
            ArrayList values = new ArrayList(errorMessages.values());
            return (String)values.get(0);
        }
        return "Failed for unknown reason";
    }

    @Override
    public String getName() {
        String testClassName = JenkinsResultsParserUtil.getCanonicalPath(this._jUnitTestClass.getTestClassFile());
        testClassName = testClassName.replaceAll(".*/(com/.*)\\.java", "$1");
        return testClassName.replace("/", ".");
    }

    @Override
    public TestrayCaseResult.Status getStatus() {
        Build build = this.getBuild();
        if (build == null) {
            return TestrayCaseResult.Status.UNTESTED;
        }
        List<TestClassResult> testClassResults = this._getTestClassResults();
        if (testClassResults == null || testClassResults.isEmpty()) {
            String result = build.getResult();
            if (result == null || result.equals("SUCCESS") || result.equals("UNSTABLE")) {
                return TestrayCaseResult.Status.UNTESTED;
            }
            return TestrayCaseResult.Status.FAILED;
        }
        if (this._isTestClassResultsFailing()) {
            return TestrayCaseResult.Status.FAILED;
        }
        return TestrayCaseResult.Status.PASSED;
    }

    private List<TestClassResult> _getTestClassResults() {
        if (this._testClassResults != null) {
            return this._testClassResults;
        }
        Build build = this.getBuild();
        if (build == null) {
            return null;
        }
        this._testClassResults = new ArrayList<TestClassResult>();
        for (TestClassResult testClassResult : build.getTestClassResults()) {
            String testClassName = testClassResult.getClassName();
            if (!testClassName.equals(this.getName()) && !testClassName.startsWith(this.getName() + "$")) continue;
            this._testClassResults.add(testClassResult);
        }
        return this._testClassResults;
    }

    private List<TestResult> _getTestResults() {
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (TestClassResult testClassResult : this._getTestClassResults()) {
            testResults.addAll(testClassResult.getTestResults());
        }
        return testResults;
    }

    private boolean _isTestClassResultsFailing() {
        for (TestClassResult testClassResult : this._getTestClassResults()) {
            if (!testClassResult.isFailing()) continue;
            return true;
        }
        return false;
    }
}

