/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.RemoteExecutor;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.testray.DefaultTestrayAttachment;
import com.liferay.jenkins.results.parser.testray.S3TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayS3Bucket;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;

public abstract class BuildTestrayCaseResult
extends TestrayCaseResult {
    private static final Map<String, TestrayAttachment> _testrayAttachments = new HashMap<String, TestrayAttachment>();
    private final File _testrayUploadBaseDir;

    public BuildTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild) {
        super(testrayBuild, topLevelBuild);
        String workspace = System.getenv("WORKSPACE");
        if (JenkinsResultsParserUtil.isNullOrEmpty(workspace)) {
            throw new RuntimeException("Please set WORKSPACE");
        }
        this._testrayUploadBaseDir = new File(workspace, "testray/" + JenkinsResultsParserUtil.getDistinctTimeStamp());
    }

    @Override
    public TestrayCaseResult.Status getStatus() {
        Build build = this.getBuild();
        if (build == null) {
            return TestrayCaseResult.Status.UNTESTED;
        }
        if (build.isFailing()) {
            return TestrayCaseResult.Status.FAILED;
        }
        return TestrayCaseResult.Status.PASSED;
    }

    protected abstract Build getBuild();

    protected TestrayAttachment getTestrayAttachment(Build build, String name, String key) {
        if (_testrayAttachments.containsKey(key)) {
            return _testrayAttachments.get(key);
        }
        if (build == null || JenkinsResultsParserUtil.isNullOrEmpty(key) || JenkinsResultsParserUtil.isNullOrEmpty(name)) {
            return null;
        }
        for (URL testrayAttachmentURL : build.getTestrayAttachmentURLs()) {
            String testrayAttachmentURLString = String.valueOf(testrayAttachmentURL);
            if (!testrayAttachmentURLString.contains(key)) continue;
            DefaultTestrayAttachment testrayAttachment = new DefaultTestrayAttachment(this, name, key, testrayAttachmentURL);
            _testrayAttachments.put(key, testrayAttachment);
            return _testrayAttachments.get(key);
        }
        if (TestrayS3Bucket.hasGoogleApplicationCredentials()) {
            for (URL testrayS3AttachmentURL : build.getTestrayS3AttachmentURLs()) {
                String testrayS3AttachmentURLString = String.valueOf(testrayS3AttachmentURL);
                if (!testrayS3AttachmentURLString.contains(key)) continue;
                S3TestrayAttachment testrayAttachment = new S3TestrayAttachment(this, name, key);
                _testrayAttachments.put(key, testrayAttachment);
                return _testrayAttachments.get(key);
            }
        }
        return null;
    }

    protected File getTestrayUploadBaseDir() {
        return this._testrayUploadBaseDir;
    }

    protected String getTopLevelBuildReportKey() {
        return this.getTopLevelBuildURLPath() + "/build-report.json.gz";
    }

    protected String getTopLevelBuildReportName() {
        return "Build Report (Top Level)";
    }

    protected TestrayAttachment getTopLevelBuildReportTestrayAttachment() {
        return this.getTestrayAttachment(this.getTopLevelBuild(), this.getTopLevelBuildReportName(), this.getTopLevelBuildReportKey());
    }

    protected String getTopLevelBuildURLPath() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Date date = new Date(topLevelBuild.getStartTime());
        sb.append(JenkinsResultsParserUtil.toDateString(date, "yyyy-MM", "America/Los_Angeles"));
        sb.append("/");
        JenkinsMaster jenkinsMaster = topLevelBuild.getJenkinsMaster();
        sb.append(jenkinsMaster.getName());
        sb.append("/");
        sb.append(topLevelBuild.getJobName());
        sb.append("/");
        sb.append(topLevelBuild.getBuildNumber());
        return sb.toString();
    }

    protected String getTopLevelJenkinsConsoleKey() {
        return this.getTopLevelBuildURLPath() + "/jenkins-console.txt.gz";
    }

    protected String getTopLevelJenkinsConsoleName() {
        return "Jenkins Console (Top Level)";
    }

    protected TestrayAttachment getTopLevelJenkinsConsoleTestrayAttachment() {
        return this.getTestrayAttachment(this.getTopLevelBuild(), this.getTopLevelJenkinsConsoleName(), this.getTopLevelJenkinsConsoleKey());
    }

    protected String getTopLevelJenkinsReportKey() {
        return this.getTopLevelBuildURLPath() + "/jenkins-report.html.gz";
    }

    protected String getTopLevelJenkinsReportName() {
        return "Jenkins Report (Top Level)";
    }

    protected TestrayAttachment getTopLevelJenkinsReportTestrayAttachment() {
        return this.getTestrayAttachment(this.getTopLevelBuild(), this.getTopLevelJenkinsReportName(), this.getTopLevelJenkinsReportKey());
    }

    protected String getTopLevelJobSummaryKey() {
        return this.getTopLevelBuildURLPath() + "/job-summary/index.html.gz";
    }

    protected String getTopLevelJobSummaryName() {
        return "Job Summary (Top Level)";
    }

    protected TestrayAttachment getTopLevelJobSummaryTestrayAttachment() {
        return this.getTestrayAttachment(this.getTopLevelBuild(), this.getTopLevelJobSummaryName(), this.getTopLevelJobSummaryKey());
    }

    protected TestrayAttachment uploadTestrayAttachment(String name, String key, Callable<File> callable) {
        File file = null;
        try {
            file = callable.call();
        }
        catch (Exception exception) {
            return null;
        }
        if (file == null || !file.exists()) {
            return null;
        }
        TestrayAttachment testrayAttachment = this._uploadDefaultTestrayAttachment(name, key, file);
        if (testrayAttachment == null) {
            testrayAttachment = this._uploadS3TestrayAttachment(name, key, file);
        }
        if (testrayAttachment == null) {
            return testrayAttachment;
        }
        _testrayAttachments.put(key, testrayAttachment);
        return testrayAttachment;
    }

    private String _getMasterHostname() {
        Build build = this.getBuild();
        JenkinsMaster jenkinsMaster = build.getJenkinsMaster();
        return jenkinsMaster.getName();
    }

    private String _getTestrayMountDirPath() {
        try {
            return JenkinsResultsParserUtil.getBuildProperty("testray.server.mount.dir[testray-1]");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private TestrayAttachment _uploadDefaultTestrayAttachment(String name, String key, File file) {
        if (!file.exists()) {
            return null;
        }
        String parentKey = key.replaceAll("(.+)/[^/]+", "$1");
        RemoteExecutor remoteExecutor = new RemoteExecutor();
        try {
            remoteExecutor.execute(1, new String[]{"root@" + this._getMasterHostname()}, new String[]{JenkinsResultsParserUtil.combine("mkdir -p \"", this._getTestrayMountDirPath(), "/jenkins/testray-results/production/logs/", parentKey, "\"")});
        }
        catch (Exception exception) {
            return null;
        }
        try {
            JenkinsResultsParserUtil.executeBashCommands(JenkinsResultsParserUtil.combine("rsync -aqz --chmod=go=rx \"", JenkinsResultsParserUtil.getCanonicalPath(file), "\" \"", this._getMasterHostname(), "::testray-results/production/logs/", parentKey, "/\""));
        }
        catch (IOException | TimeoutException exception) {
            return null;
        }
        try {
            TestrayServer testrayServer = this.getTestrayServer();
            URL url = new URL(JenkinsResultsParserUtil.combine(String.valueOf(testrayServer.getURL()), "/reports/production/logs/", key));
            System.out.println("Uploaded " + url);
            return new DefaultTestrayAttachment(this, name, key, url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private TestrayAttachment _uploadS3TestrayAttachment(String name, String key, File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            TestrayS3Bucket testrayS3Bucket = TestrayS3Bucket.getInstance();
            testrayS3Bucket.createTestrayS3Object(key, file);
            return new S3TestrayAttachment(this, name, key);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

