/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.QAWebsitesGitRepositoryJob;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.job.property.JobPropertyFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.BuildTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TopLevelBuildTestrayCaseResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.WordUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class BatchBuildTestrayCaseResult
extends BuildTestrayCaseResult {
    private final AxisTestClassGroup _axisTestClassGroup;
    private TopLevelBuildTestrayCaseResult _topLevelBuildTestrayCaseResult;

    public BatchBuildTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup) {
        super(testrayBuild, topLevelBuild);
        this._axisTestClassGroup = axisTestClassGroup;
    }

    public String getAxisName() {
        return this._axisTestClassGroup.getAxisName();
    }

    public String getBatchName() {
        return this._axisTestClassGroup.getBatchName();
    }

    @Override
    public Build getBuild() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        DownstreamBuild downstreamBuild = topLevelBuild.getDownstreamBuild(this.getAxisName());
        if (downstreamBuild != null) {
            return downstreamBuild;
        }
        return topLevelBuild.getDownstreamAxisBuild(this.getAxisName());
    }

    @Override
    public String getComponentName() {
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.component", this.getBatchName());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String getErrors() {
        Build build = this.getBuild();
        if (build == null) {
            return "Failed to run on CI";
        }
        if (!build.isFailing()) {
            return null;
        }
        String result = build.getResult();
        if (result == null) {
            return "Failed to finish build on CI";
        }
        if (result.equals("ABORTED")) {
            return "Aborted prior to running test";
        }
        String errorMessage = build.getFailureMessage();
        if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage)) {
            return "Failed for unknown reason";
        }
        if (errorMessage.contains("\n")) {
            errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n"));
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage = errorMessage.trim())) {
            return "Failed for unknown reason";
        }
        return errorMessage;
    }

    @Override
    public String getName() {
        return this.getAxisName();
    }

    @Override
    public int getPriority() {
        try {
            String testrayCasePriority = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.priority", this.getBatchName());
            if (testrayCasePriority != null && testrayCasePriority.matches("\\d+")) {
                return Integer.parseInt(testrayCasePriority);
            }
            return 5;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String getTeamName() {
        JobProperty teamNamesJobProperty = this._getJobProperty("testray.team.names");
        String teamNames = teamNamesJobProperty.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(teamNames)) {
            try {
                return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.team", this.getBatchName());
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        String componentName = this.getComponentName();
        for (String teamName : teamNames.split(",")) {
            String teamComponentNames;
            JobProperty teamComponentNamesJobProperty = this._getJobProperty("testray.team." + teamName + ".component.names");
            if (teamComponentNamesJobProperty == null || JenkinsResultsParserUtil.isNullOrEmpty(teamComponentNames = teamComponentNamesJobProperty.getValue())) continue;
            for (String teamComponentName : teamComponentNames.split(",")) {
                if (!teamComponentName.equals(componentName)) continue;
                teamName = teamName.replace("-", " ");
                return WordUtils.capitalize((String)teamName);
            }
        }
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.team", this.getBatchName());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public List<TestrayAttachment> getTestrayAttachments() {
        ArrayList<TestrayAttachment> testrayAttachments = new ArrayList<TestrayAttachment>();
        testrayAttachments.add(this._getJenkinsConsoleTestrayAttachment());
        testrayAttachments.add(this.getTopLevelBuildReportTestrayAttachment());
        testrayAttachments.add(this.getTopLevelJenkinsConsoleTestrayAttachment());
        testrayAttachments.add(this.getTopLevelJenkinsReportTestrayAttachment());
        testrayAttachments.add(this.getTopLevelJobSummaryTestrayAttachment());
        testrayAttachments.add(this._getWarningsTestrayAttachment());
        testrayAttachments.removeAll(Collections.singleton(null));
        return testrayAttachments;
    }

    @Override
    public String getType() {
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.type", this.getBatchName());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String[] getWarnings() {
        TestrayAttachment testrayAttachment = this._getWarningsTestrayAttachment();
        if (testrayAttachment == null) {
            return null;
        }
        String testrayAttachmentValue = testrayAttachment.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(testrayAttachmentValue)) {
            return null;
        }
        try {
            Document document = Dom4JUtil.parse(testrayAttachmentValue);
            Element rootElement = document.getRootElement();
            ArrayList<String> warnings = new ArrayList<String>();
            for (Element valueElement : rootElement.elements()) {
                String warning = valueElement.getText();
                if (JenkinsResultsParserUtil.isNullOrEmpty(warning = warning.trim())) continue;
                warnings.add(warning);
            }
            if (!warnings.isEmpty()) {
                return warnings.toArray(new String[0]);
            }
        }
        catch (DocumentException documentException) {
            return null;
        }
        return null;
    }

    protected String getAxisBuildURLPath() {
        return JenkinsResultsParserUtil.combine(this.getTopLevelBuildURLPath(), "/", this.getAxisName());
    }

    protected AxisTestClassGroup getAxisTestClassGroup() {
        return this._axisTestClassGroup;
    }

    @Override
    protected TestrayAttachment getTopLevelBuildReportTestrayAttachment() {
        TopLevelBuildTestrayCaseResult topLevelBuildTestrayCaseResult = this.getTopLevelBuildTestrayCaseResult();
        if (topLevelBuildTestrayCaseResult == null) {
            return null;
        }
        return topLevelBuildTestrayCaseResult.getTopLevelBuildReportTestrayAttachment();
    }

    protected TopLevelBuildTestrayCaseResult getTopLevelBuildTestrayCaseResult() {
        if (this._topLevelBuildTestrayCaseResult != null) {
            return this._topLevelBuildTestrayCaseResult;
        }
        this._topLevelBuildTestrayCaseResult = TestrayFactory.newTopLevelBuildTestrayCaseResult(this.getTestrayBuild(), this.getTopLevelBuild());
        return this._topLevelBuildTestrayCaseResult;
    }

    @Override
    protected TestrayAttachment getTopLevelJenkinsConsoleTestrayAttachment() {
        TopLevelBuildTestrayCaseResult topLevelBuildTestrayCaseResult = this.getTopLevelBuildTestrayCaseResult();
        if (topLevelBuildTestrayCaseResult == null) {
            return null;
        }
        return topLevelBuildTestrayCaseResult.getTopLevelJenkinsConsoleTestrayAttachment();
    }

    @Override
    protected TestrayAttachment getTopLevelJenkinsReportTestrayAttachment() {
        TopLevelBuildTestrayCaseResult topLevelBuildTestrayCaseResult = this.getTopLevelBuildTestrayCaseResult();
        if (topLevelBuildTestrayCaseResult == null) {
            return null;
        }
        return topLevelBuildTestrayCaseResult.getTopLevelJenkinsReportTestrayAttachment();
    }

    @Override
    protected TestrayAttachment getTopLevelJobSummaryTestrayAttachment() {
        TopLevelBuildTestrayCaseResult topLevelBuildTestrayCaseResult = this.getTopLevelBuildTestrayCaseResult();
        if (topLevelBuildTestrayCaseResult == null) {
            return null;
        }
        return topLevelBuildTestrayCaseResult.getTopLevelJobSummaryTestrayAttachment();
    }

    private TestrayAttachment _getJenkinsConsoleTestrayAttachment() {
        String name = "Jenkins Console";
        String key = this.getAxisBuildURLPath() + "/jenkins-console.txt.gz";
        TestrayAttachment testrayAttachment = this.getTestrayAttachment(this.getBuild(), name, key);
        if (testrayAttachment != null) {
            return testrayAttachment;
        }
        final Build build = this.getBuild();
        if (build == null) {
            return null;
        }
        return this.uploadTestrayAttachment(name, key, new Callable<File>(){

            @Override
            public File call() throws Exception {
                File jenkinsConsoleFile = new File(BatchBuildTestrayCaseResult.this.getTestrayUploadBaseDir(), "jenkins-console.txt");
                File jenkinsConsoleGzFile = new File(BatchBuildTestrayCaseResult.this.getTestrayUploadBaseDir(), "jenkins-console.txt.gz");
                try {
                    JenkinsResultsParserUtil.write(jenkinsConsoleFile, build.getConsoleText());
                    JenkinsResultsParserUtil.gzip(jenkinsConsoleFile, jenkinsConsoleGzFile);
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
                finally {
                    JenkinsResultsParserUtil.delete(jenkinsConsoleFile);
                }
                if (jenkinsConsoleGzFile.exists()) {
                    return jenkinsConsoleGzFile;
                }
                return null;
            }
        });
    }

    private JobProperty _getJobProperty(String basePropertyName) {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        Job job = topLevelBuild.getJob();
        if (job instanceof QAWebsitesGitRepositoryJob) {
            AxisTestClassGroup axisTestClassGroup = this.getAxisTestClassGroup();
            return JobPropertyFactory.newJobProperty(basePropertyName, job, axisTestClassGroup.getTestBaseDir(), JobProperty.Type.QA_WEBSITES_TEST_DIR);
        }
        return JobPropertyFactory.newJobProperty(basePropertyName, job);
    }

    private TestrayAttachment _getWarningsTestrayAttachment() {
        return this.getTestrayAttachment(this.getBuild(), "Warnings", this.getAxisBuildURLPath() + "/warnings.html.gz");
    }
}

