/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestrayResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.testray.TestrayProject;
import com.liferay.jenkins.results.parser.testray.TestrayS3Bucket;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseTestrayServer
implements TestrayServer {
    private static final int _DELTA = 50;
    private JenkinsResultsParserUtil.HTTPAuthorization _httpAuthorization;
    private Map<Integer, TestrayProject> _testrayProjectsByID;
    private Map<String, TestrayProject> _testrayProjectsByName;
    private final URL _url;

    @Override
    public JenkinsResultsParserUtil.HTTPAuthorization getHTTPAuthorization() {
        return this._httpAuthorization;
    }

    @Override
    public TestrayProject getTestrayProjectByID(int projectID) {
        this._initTestrayProjects();
        return this._testrayProjectsByID.get(projectID);
    }

    @Override
    public TestrayProject getTestrayProjectByName(String projectName) {
        this._initTestrayProjects();
        return this._testrayProjectsByName.get(projectName);
    }

    @Override
    public List<TestrayProject> getTestrayProjects() {
        this._initTestrayProjects();
        return new ArrayList<TestrayProject>(this._testrayProjectsByName.values());
    }

    @Override
    public URL getURL() {
        return this._url;
    }

    @Override
    public void importCaseResults(TopLevelBuild topLevelBuild) {
        TestrayResultsParserUtil.processTestrayResultFiles(this.getResultsDir());
        if (JenkinsResultsParserUtil.isCINode()) {
            this._importCaseResultsFromCI(topLevelBuild);
        }
        if (TestrayS3Bucket.hasGoogleApplicationCredentials()) {
            this._importCaseResultsToGCP(topLevelBuild);
        }
    }

    @Override
    public void setHTTPAuthorization(JenkinsResultsParserUtil.HTTPAuthorization httpAuthorization) {
        this._httpAuthorization = httpAuthorization;
    }

    @Override
    public void writeCaseResult(String fileName, String fileContent) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(fileName) || JenkinsResultsParserUtil.isNullOrEmpty(fileContent)) {
            return;
        }
        try {
            JenkinsResultsParserUtil.write(new File(this.getResultsDir(), fileName), fileContent);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected BaseTestrayServer(String urlString) {
        try {
            this._url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Invalid Testray server URL " + urlString, malformedURLException);
        }
    }

    protected File getResultsDir() {
        String workspace = System.getenv("WORKSPACE");
        if (JenkinsResultsParserUtil.isNullOrEmpty(workspace)) {
            throw new RuntimeException("Please set WORKSPACE");
        }
        return new File(workspace, "testray/results");
    }

    private void _importCaseResultsFromCI(TopLevelBuild topLevelBuild) {
        if (!JenkinsResultsParserUtil.isCINode()) {
            return;
        }
        JenkinsMaster jenkinsMaster = topLevelBuild.getJenkinsMaster();
        String command = JenkinsResultsParserUtil.combine("rsync -aqz --chmod=go=rx \"", JenkinsResultsParserUtil.getCanonicalPath(this.getResultsDir()), "\"/* \"", jenkinsMaster.getName(), "::testray-results/production/\"");
        try {
            JenkinsResultsParserUtil.executeBashCommands(command);
        }
        catch (IOException | TimeoutException exception) {
            throw new RuntimeException(exception);
        }
        for (File resultFile : JenkinsResultsParserUtil.findFiles(this.getResultsDir(), ".*.xml")) {
            System.out.println(JenkinsResultsParserUtil.combine("Uploaded ", JenkinsResultsParserUtil.getCanonicalPath(resultFile), " by Rsync"));
        }
    }

    private void _importCaseResultsToGCP(TopLevelBuild topLevelBuild) {
        if (!TestrayS3Bucket.hasGoogleApplicationCredentials()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        JenkinsMaster jenkinsMaster = topLevelBuild.getJenkinsMaster();
        sb.append(jenkinsMaster.getName());
        sb.append("-");
        String jobName = topLevelBuild.getJobName();
        sb.append(jobName.replaceAll("[\\(\\)]", "_"));
        sb.append("-");
        sb.append(topLevelBuild.getBuildNumber());
        sb.append("-results.tar.gz");
        File resultsDir = this.getResultsDir();
        File gcpResultsDir = new File(resultsDir.getParentFile(), "gcp-results");
        try {
            JenkinsResultsParserUtil.copy(resultsDir, gcpResultsDir);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        for (File gcpResultFile : JenkinsResultsParserUtil.findFiles(gcpResultsDir, ".*.xml")) {
            try {
                Document document = Dom4JUtil.parse(JenkinsResultsParserUtil.read(gcpResultFile));
                Element rootElement = document.getRootElement();
                for (Element testcaseElement : rootElement.elements("testcase")) {
                    Element propertiesElement = testcaseElement.element("properties");
                    for (Element propertyElement : propertiesElement.elements("property")) {
                        String propertyName = propertyElement.attributeValue("name");
                        if (propertyName == null || !propertyName.equals("testray.testcase.warnings")) continue;
                        for (Element element : propertyElement.elements()) {
                            propertyElement.remove(element);
                        }
                    }
                }
                String gcpResultFileContent = Dom4JUtil.format(rootElement, false);
                gcpResultFileContent = gcpResultFileContent.replaceAll("(<property name=\"testray.testcase.warnings\" value=\"\\d+\")>\\s+<\\/property>", "$1/>");
                JenkinsResultsParserUtil.write(gcpResultFile, gcpResultFileContent);
            }
            catch (IOException | DocumentException throwable) {}
        }
        File resultsTarGzFile = new File(gcpResultsDir.getParentFile(), sb.toString());
        JenkinsResultsParserUtil.tarGzip(gcpResultsDir, resultsTarGzFile);
        TestrayS3Bucket testrayS3Bucket = TestrayS3Bucket.getInstance();
        testrayS3Bucket.createTestrayS3Object("inbox/" + resultsTarGzFile.getName(), resultsTarGzFile);
    }

    private synchronized void _initTestrayProjects() {
        if (this._testrayProjectsByID != null && this._testrayProjectsByName != null) {
            return;
        }
        this._testrayProjectsByID = new HashMap<Integer, TestrayProject>();
        this._testrayProjectsByName = new HashMap<String, TestrayProject>();
        int current = 1;
        block6: while (true) {
            try {
                String projectAPIURL = JenkinsResultsParserUtil.combine(String.valueOf(this.getURL()), "/home/-/testray/projects.json?cur=", String.valueOf(current), "&delta=", String.valueOf(50), "&orderByCol=testrayProjectId");
                JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(projectAPIURL, true, this.getHTTPAuthorization());
                JSONArray dataJSONArray = jsonObject.getJSONArray("data");
                if (dataJSONArray.length() == 0) break;
                int i = 0;
                while (true) {
                    if (i >= dataJSONArray.length()) continue block6;
                    JSONObject dataJSONObject = dataJSONArray.getJSONObject(i);
                    TestrayProject testrayProject = new TestrayProject(this, dataJSONObject);
                    this._testrayProjectsByID.put(testrayProject.getID(), testrayProject);
                    this._testrayProjectsByName.put(testrayProject.getName(), testrayProject);
                    ++i;
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            finally {
                ++current;
                continue;
            }
            break;
        }
    }
}

