/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.PathMatcher;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class RESTBuilderModulesBatchTestClassGroup
extends ModulesBatchTestClassGroup {
    private BuildType _buildType;

    @Override
    public int getAxisCount() {
        if (!this.isStableTestSuiteBatch() && this.testRelevantIntegrationUnitOnly) {
            return 0;
        }
        if (this._buildType == BuildType.FULL || this.testClasses.isEmpty()) {
            return 1;
        }
        return super.getAxisCount();
    }

    public BuildType getBuildType() {
        return this._buildType;
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("build_type", (Object)this._buildType);
        return this.jsonObject;
    }

    protected RESTBuilderModulesBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
        this._buildType = BuildType.valueOf(jsonObject.optString("build_type", "FULL"));
    }

    protected RESTBuilderModulesBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    @Override
    protected void setAxisTestClassGroups() {
        int testClassCount = this.testClasses.size();
        int axisCount = this.getAxisCount();
        if (testClassCount == 0 && axisCount == 1) {
            this.axisTestClassGroups.add(0, TestClassGroupFactory.newAxisTestClassGroup(this));
            return;
        }
        super.setAxisTestClassGroups();
    }

    @Override
    protected void setTestClasses() throws IOException {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        File portalModulesBaseDir = new File(portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        List<PathMatcher> excludesPathMatchers = this.getPathMatchers(this.getExcludesJobProperties());
        List<PathMatcher> includesPathMatchers = this.getPathMatchers(this.getIncludesJobProperties());
        if (!(!this.testRelevantChanges || this.includeStableTestSuite && this.isStableTestSuiteBatch())) {
            List<File> modifiedFiles = portalGitWorkingDirectory.getModifiedFilesList();
            List<File> modifiedPortalToolsRESTBuilderFiles = JenkinsResultsParserUtil.getIncludedFiles(null, this.getPathMatchers("util/portal-tools-rest-builder/**", portalModulesBaseDir), modifiedFiles);
            if (!modifiedPortalToolsRESTBuilderFiles.isEmpty()) {
                this._buildType = BuildType.FULL;
                return;
            }
            this.moduleDirsList.addAll(portalGitWorkingDirectory.getModifiedModuleDirsList(excludesPathMatchers, includesPathMatchers));
        } else {
            this._buildType = BuildType.FULL;
            this.moduleDirsList.addAll(portalGitWorkingDirectory.getModuleDirsList(excludesPathMatchers, includesPathMatchers));
        }
        for (File moduleDir : this.moduleDirsList) {
            TestClass testClass = TestClassFactory.newTestClass((BatchTestClassGroup)this, moduleDir);
            if (!testClass.hasTestClassMethods()) continue;
            this.testClasses.add(testClass);
        }
        Collections.sort(this.testClasses);
    }

    public static enum BuildType {
        FULL;

    }
}

