/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.QAWebsitesGitRepositoryJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.util.GetterUtil;
import com.liferay.poshi.core.util.MathUtil;
import com.liferay.poshi.core.util.PropsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.json.JSONObject;

public class QAWebsitesFunctionalBatchTestClassGroup
extends FunctionalBatchTestClassGroup {
    @Override
    public List<File> getTestBaseDirs() {
        ArrayList<File> testBaseDirs = new ArrayList<File>();
        GitWorkingDirectory qaWebsitesGitWorkingDirectory = this._getQAWebsitesGitWorkingDirectory();
        QAWebsitesGitRepositoryJob qaWebsitesGitRepositoryJob = this._getQAWebsitesGitRepositoryJob();
        for (String projectName : qaWebsitesGitRepositoryJob.getProjectNames()) {
            testBaseDirs.add(new File(qaWebsitesGitWorkingDirectory.getWorkingDirectory(), projectName));
        }
        return testBaseDirs;
    }

    protected QAWebsitesFunctionalBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
    }

    protected QAWebsitesFunctionalBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    protected int getAxisMaxSize(File testBaseDir) {
        JobProperty jobProperty = this.getJobProperty("test.batch.axis.max.size", this.testSuiteName, testBaseDir, JobProperty.Type.QA_WEBSITES_TEST_DIR);
        String jobPropertyValue = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isInteger(jobPropertyValue)) {
            this.recordJobProperty(jobProperty);
            return Integer.parseInt(jobPropertyValue);
        }
        return 5000;
    }

    @Override
    protected String getDefaultTestBatchRunPropertyQuery(File testBaseDir, String testSuiteName) {
        String query = System.getenv("TEST_QA_WEBSITES_PROPERTY_QUERY");
        if (JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            query = this.getBuildStartProperty("TEST_QA_WEBSITES_PROPERTY_QUERY");
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return query;
        }
        JobProperty jobProperty = this.getJobProperty("test.batch.property.query", testSuiteName, testBaseDir, JobProperty.Type.QA_WEBSITES_TEST_DIR);
        this.recordJobProperty(jobProperty);
        return jobProperty.getValue();
    }

    @Override
    protected List<List<String>> getPoshiTestClassGroups(File testBaseDir) {
        String query = this.getTestBatchRunPropertyQuery(testBaseDir);
        if (JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return new ArrayList<List<String>>();
        }
        PortalTestClassJob portalTestClassJob = this.portalTestClassJob;
        synchronized (portalTestClassJob) {
            String testBaseDirPath = null;
            if (testBaseDir != null && testBaseDir.exists()) {
                testBaseDirPath = JenkinsResultsParserUtil.getCanonicalPath(testBaseDir);
            }
            Properties properties = JenkinsResultsParserUtil.getProperties(new File(testBaseDir.getParentFile(), "test.properties"), new File(testBaseDir, "poshi-ext.properties"), new File(testBaseDir, "poshi.properties"), new File(testBaseDir, "test.properties"));
            if (!JenkinsResultsParserUtil.isNullOrEmpty(testBaseDirPath)) {
                properties.setProperty("test.base.dir.name", testBaseDirPath);
            }
            PropsUtil.clear();
            PropsUtil.setProperties((Properties)properties);
            try {
                PoshiContext.clear();
                PoshiContext.readFiles();
                JobProperty jobProperty = this.getJobProperty("test.batch.axis.count", this.testSuiteName, testBaseDir, JobProperty.Type.QA_WEBSITES_TEST_DIR);
                if (jobProperty.getValue() != null) {
                    return this._getTestBatchGroupsByAxisCount(query, GetterUtil.getInteger((String)jobProperty.getValue()));
                }
                return PoshiContext.getTestBatchGroups((String)query, (long)this.getAxisMaxSize(testBaseDir));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private QAWebsitesGitRepositoryJob _getQAWebsitesGitRepositoryJob() {
        if (!(this.portalTestClassJob instanceof QAWebsitesGitRepositoryJob)) {
            throw new RuntimeException("Invalid job type " + this.portalTestClassJob);
        }
        return (QAWebsitesGitRepositoryJob)this.portalTestClassJob;
    }

    private GitWorkingDirectory _getQAWebsitesGitWorkingDirectory() {
        QAWebsitesGitRepositoryJob qaWebsitesGitRepositoryJob = this._getQAWebsitesGitRepositoryJob();
        return qaWebsitesGitRepositoryJob.getGitWorkingDirectory();
    }

    private List<List<String>> _getTestBatchGroupsByAxisCount(String pqlQuery, long axisCount) throws Exception {
        List classCommandNames = PoshiContext.executePQLQuery((String)pqlQuery, (boolean)false);
        long testCount = classCommandNames.size();
        long groupSize = MathUtil.quotient((Long)testCount, (Long)axisCount, (boolean)true);
        return Lists.partition((List)classCommandNames, (int)GetterUtil.getInteger((Object)groupSize));
    }
}

