/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PluginsGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class PluginsGulpBatchTestClassGroup
extends BatchTestClassGroup {
    private final List<File> _modifiedFilesList;

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("modified_files_list", this._modifiedFilesList);
        return this.jsonObject;
    }

    public List<File> getTestBaseDirNames() {
        ArrayList<File> testBaseDirNames = new ArrayList<File>();
        for (File modifiedFile : this._modifiedFilesList) {
            for (File parentDir = new File(modifiedFile.getPath()); parentDir != null; parentDir = parentDir.getParentFile()) {
                File gulpFile = new File(parentDir, "gulpfile.js");
                if (!gulpFile.exists()) continue;
                testBaseDirNames.add(gulpFile.getParentFile());
            }
        }
        return testBaseDirNames;
    }

    protected PluginsGulpBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
        this._modifiedFilesList = new ArrayList<File>();
        JSONArray modifiedFilesJSONArray = jsonObject.optJSONArray("modified_files_list");
        if (modifiedFilesJSONArray == null || modifiedFilesJSONArray.isEmpty()) {
            return;
        }
        for (int i = 0; i < modifiedFilesJSONArray.length(); ++i) {
            String modifiedFilePath = modifiedFilesJSONArray.getString(i);
            if (JenkinsResultsParserUtil.isNullOrEmpty(modifiedFilePath)) continue;
            this._modifiedFilesList.add(new File(modifiedFilePath));
        }
    }

    protected PluginsGulpBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        this._modifiedFilesList = this.portalGitWorkingDirectory.getModifiedFilesList();
        PluginsGitWorkingDirectory pluginsGitWorkingDirectory = this.portalGitWorkingDirectory.getPluginsGitWorkingDirectory();
        this._modifiedFilesList.addAll(pluginsGitWorkingDirectory.getModifiedFilesList());
        this._setTestClasses();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    @Override
    protected int getAxisMaxSize() {
        return 1;
    }

    @Override
    protected int getSegmentMaxChildren() {
        return 1;
    }

    private void _setTestClasses() {
        for (File testBaseDirName : this.getTestBaseDirNames()) {
            this.testClasses.add(TestClassFactory.newTestClass((BatchTestClassGroup)this, testBaseDirName));
        }
        Collections.sort(this.testClasses);
    }
}

