/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PluginsGitRepositoryJob;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.util.PropsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.json.JSONObject;

public class PluginsFunctionalBatchTestClassGroup
extends FunctionalBatchTestClassGroup {
    @Override
    public List<File> getTestBaseDirs() {
        if (!(this.portalTestClassJob instanceof PluginsGitRepositoryJob)) {
            return new ArrayList<File>();
        }
        PluginsGitRepositoryJob pluginsGitRepositoryJob = (PluginsGitRepositoryJob)this.portalTestClassJob;
        return pluginsGitRepositoryJob.getPluginsTestBaseDirs();
    }

    protected PluginsFunctionalBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
    }

    protected PluginsFunctionalBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    @Override
    protected String getDefaultTestBatchRunPropertyQuery(File testBaseDir, String testSuiteName) {
        String query = System.getenv("TEST_BATCH_RUN_PROPERTY_QUERY");
        if (JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            query = this.getBuildStartProperty("TEST_BATCH_RUN_PROPERTY_QUERY");
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return query;
        }
        JobProperty jobProperty = this.getJobProperty("test.batch.run.property.query", testBaseDir, JobProperty.Type.PLUGIN_TEST_DIR);
        this.recordJobProperty(jobProperty);
        return jobProperty.getValue();
    }

    @Override
    protected List<List<String>> getPoshiTestClassGroups(File testBaseDir) {
        String query = this.getTestBatchRunPropertyQuery(testBaseDir);
        if (JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return new ArrayList<List<String>>();
        }
        PortalTestClassJob portalTestClassJob = this.portalTestClassJob;
        synchronized (portalTestClassJob) {
            PortalGitWorkingDirectory portalGitWorkingDirectory = this.portalTestClassJob.getPortalGitWorkingDirectory();
            File portalWorkingDirectory = portalGitWorkingDirectory.getWorkingDirectory();
            HashMap<String, String> parameters = new HashMap<String, String>();
            String testBaseDirPath = null;
            if (testBaseDir != null && testBaseDir.exists()) {
                testBaseDirPath = JenkinsResultsParserUtil.getCanonicalPath(testBaseDir);
                parameters.put("test.base.dir.name", testBaseDirPath);
            }
            try {
                AntUtil.callTarget(portalWorkingDirectory, "build-test.xml", "prepare-poshi-runner-properties", parameters);
            }
            catch (AntException antException) {
                throw new RuntimeException(antException);
            }
            Properties properties = JenkinsResultsParserUtil.getProperties(new File(portalWorkingDirectory, "portal-web/poshi.properties"), new File(portalWorkingDirectory, "portal-web/poshi-ext.properties"), new File(testBaseDir, "test.properties"));
            if (!JenkinsResultsParserUtil.isNullOrEmpty(testBaseDirPath)) {
                properties.setProperty("test.base.dir.name", testBaseDirPath);
            }
            PropsUtil.clear();
            PropsUtil.setProperties((Properties)properties);
            try {
                PoshiContext.clear();
                PoshiContext.readFiles();
                return PoshiContext.getTestBatchGroups((String)query, (long)this.getAxisMaxSize());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

