/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.clazz.group.JUnitBatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class ModulesJUnitBatchTestClassGroup
extends JUnitBatchTestClassGroup {
    private static final Pattern _singleModuleBatchNamePattern = Pattern.compile("modules-unit-(?<moduleName>\\S+)-jdk\\d+");

    protected ModulesJUnitBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
    }

    protected ModulesJUnitBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    @Override
    protected List<JobProperty> getDefaultExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.addAll(super.getDefaultExcludesJobProperties());
        for (File modulePullSubrepoDir : this.portalGitWorkingDirectory.getModulePullSubrepoDirs()) {
            excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes.subrepo", modulePullSubrepoDir, JobProperty.Type.EXCLUDE_GLOB));
        }
        return excludesJobProperties;
    }

    @Override
    protected List<JobProperty> getReleaseIncludesJobProperties() {
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        Set<File> releaseModuleAppDirs = this._getReleaseModuleAppDirs();
        if (releaseModuleAppDirs == null) {
            return includesJobProperties;
        }
        for (File releaseModuleAppDir : releaseModuleAppDirs) {
            includesJobProperties.add(this.getJobProperty("test.batch.class.names.includes.modules", releaseModuleAppDir, JobProperty.Type.INCLUDE_GLOB));
        }
        return includesJobProperties;
    }

    @Override
    protected List<JobProperty> getRelevantExcludesJobProperties() {
        HashSet<File> modifiedModuleDirsList = new HashSet<File>();
        try {
            modifiedModuleDirsList.addAll(this.portalGitWorkingDirectory.getModifiedModuleDirsList());
        }
        catch (IOException ioException) {
            File workingDirectory = this.portalGitWorkingDirectory.getWorkingDirectory();
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get relevant module group directories in ", workingDirectory.getPath()), ioException);
        }
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.addAll(this.getDefaultExcludesJobProperties());
        for (File modifiedFile : this.portalGitWorkingDirectory.getModifiedFilesList()) {
            if (JenkinsResultsParserUtil.isPoshiFile(modifiedFile)) continue;
            excludesJobProperties.addAll(this._getJobProperties(modifiedFile, "modules.includes.required.test.batch.class.names.excludes", JobProperty.Type.MODULE_EXCLUDE_GLOB, null));
        }
        return excludesJobProperties;
    }

    @Override
    protected List<JobProperty> getRelevantIncludesJobProperties() {
        if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            return super.getRelevantIncludesJobProperties();
        }
        HashSet<File> modifiedModuleDirsSet = new HashSet<File>();
        List<Object> modifiedNonposhiModulesList = new ArrayList();
        List<Object> modifiedPoshiModulesList = new ArrayList();
        try {
            modifiedModuleDirsSet.addAll(this.portalGitWorkingDirectory.getModifiedModuleDirsList());
            modifiedNonposhiModulesList = this.portalGitWorkingDirectory.getModifiedNonposhiModules();
            modifiedPoshiModulesList = this.portalGitWorkingDirectory.getModifiedPoshiModules();
        }
        catch (IOException ioException) {
            File workingDirectory = this.portalGitWorkingDirectory.getWorkingDirectory();
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get relevant module group directories in ", workingDirectory.getPath()), ioException);
        }
        if (this.testRelevantChanges) {
            modifiedModuleDirsSet.addAll(this.getRequiredModuleDirs(Lists.newArrayList(modifiedModuleDirsSet)));
        }
        HashSet<JobProperty> includesJobProperties = new HashSet<JobProperty>();
        String moduleName = null;
        Matcher matcher = _singleModuleBatchNamePattern.matcher(this.batchName);
        if (matcher.find()) {
            moduleName = matcher.group("moduleName");
        }
        for (File modifiedModuleDir : modifiedModuleDirsSet) {
            if (modifiedPoshiModulesList.contains(modifiedModuleDir) && !modifiedNonposhiModulesList.contains(modifiedModuleDir)) continue;
            String modifiedModuleAbsolutePath = JenkinsResultsParserUtil.getCanonicalPath(modifiedModuleDir);
            String modifiedModuleRelativePath = modifiedModuleAbsolutePath.substring(modifiedModuleAbsolutePath.indexOf("modules/"));
            if (moduleName != null && !modifiedModuleRelativePath.contains("/" + moduleName)) continue;
            includesJobProperties.add(this.getJobProperty("test.batch.class.names.includes.modules", modifiedModuleDir, JobProperty.Type.INCLUDE_GLOB));
            includesJobProperties.add(this.getJobProperty("modules.includes.required.test.batch.class.names.includes", modifiedModuleDir, JobProperty.Type.MODULE_INCLUDE_GLOB));
        }
        for (File modifiedFile : this.portalGitWorkingDirectory.getModifiedFilesList()) {
            if (JenkinsResultsParserUtil.isPoshiFile(modifiedFile)) continue;
            String modifiedFileCanonicalPath = JenkinsResultsParserUtil.getCanonicalPath(modifiedFile);
            if (modifiedFileCanonicalPath.contains("modules")) {
                includesJobProperties.addAll(this._getJobProperties(modifiedFile, "test.batch.class.names.includes.modules", JobProperty.Type.MODULE_INCLUDE_GLOB, null));
            }
            includesJobProperties.addAll(this._getJobProperties(modifiedFile, "modules.includes.required.test.batch.class.names.includes", JobProperty.Type.MODULE_INCLUDE_GLOB, null));
        }
        return new ArrayList<JobProperty>(includesJobProperties);
    }

    private String _getAppTitle(File appBndFile) {
        Properties appBndProperties = JenkinsResultsParserUtil.getProperties(appBndFile);
        String appTitle = appBndProperties.getProperty("Liferay-Releng-App-Title");
        return appTitle.replace("${liferay.releng.app.title.prefix}", this._getAppTitlePrefix());
    }

    private String _getAppTitlePrefix() {
        Job job = this.getJob();
        if (job.getBuildProfile() == Job.BuildProfile.DXP) {
            return "Liferay";
        }
        return "Liferay CE";
    }

    private Set<String> _getBundledAppNames() {
        HashSet<String> bundledAppNames = new HashSet<String>();
        File liferayHome = this._getLiferayHome();
        if (liferayHome == null || !liferayHome.exists()) {
            return bundledAppNames;
        }
        List<File> bundledApps = JenkinsResultsParserUtil.findFiles(liferayHome, ".*\\.lpkg");
        for (File bundledApp : bundledApps) {
            String bundledAppName = bundledApp.getName();
            bundledAppNames.add(bundledAppName);
        }
        return bundledAppNames;
    }

    private List<JobProperty> _getJobProperties(File file, String basePropertyName, JobProperty.Type jobType, Set<File> traversedPropertyFileSet) {
        JobProperty ignoreParentsJobProperty;
        boolean ignoreParents;
        ArrayList<JobProperty> jobPropertiesList = new ArrayList<JobProperty>();
        File modulesBaseDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        if (file == null || file.equals(modulesBaseDir) || JenkinsResultsParserUtil.isPoshiFile(file)) {
            return jobPropertiesList;
        }
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        File testPropertiesFile = new File(file, "test.properties");
        if (traversedPropertyFileSet == null) {
            traversedPropertyFileSet = new HashSet<File>();
        }
        if (testPropertiesFile.exists() && !traversedPropertyFileSet.contains(testPropertiesFile)) {
            JobProperty jobProperty = this.getJobProperty(basePropertyName, file, jobType);
            String jobPropertyValue = jobProperty.getValue();
            if (!JenkinsResultsParserUtil.isNullOrEmpty(jobPropertyValue) && !jobPropertiesList.contains(jobProperty)) {
                jobPropertiesList.add(jobProperty);
            }
            traversedPropertyFileSet.add(testPropertiesFile);
        }
        if (ignoreParents = Boolean.valueOf((ignoreParentsJobProperty = this.getJobProperty("ignoreParents[" + this.getTestSuiteName() + "]", file, JobProperty.Type.MODULE_TEST_DIR)).getValue()).booleanValue()) {
            return jobPropertiesList;
        }
        jobPropertiesList.addAll(this._getJobProperties(file.getParentFile(), basePropertyName, jobType, traversedPropertyFileSet));
        return jobPropertiesList;
    }

    private File _getLiferayHome() {
        Properties buildProperties = JenkinsResultsParserUtil.getProperties(new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "build.properties"));
        String liferayHomePath = buildProperties.getProperty("liferay.home");
        if (liferayHomePath == null) {
            return null;
        }
        return new File(liferayHomePath);
    }

    private Set<File> _getReleaseModuleAppDirs() {
        Set<String> bundledAppNames = this._getBundledAppNames();
        HashSet<File> releaseModuleAppDirs = new HashSet<File>();
        for (File moduleAppDir : this.portalGitWorkingDirectory.getModuleAppDirs()) {
            File appBndFile = new File(moduleAppDir, "app.bnd");
            String appTitle = this._getAppTitle(appBndFile);
            for (String bundledAppName : bundledAppNames) {
                String regex = JenkinsResultsParserUtil.combine("((.* - )?", Pattern.quote(appTitle), " -.*|", Pattern.quote(appTitle), ")\\.lpkg");
                if (!bundledAppName.matches(regex)) continue;
                List<File> skipTestIntegrationCheckFiles = JenkinsResultsParserUtil.findFiles(moduleAppDir, ".lfrbuild-ci-skip-test-integration-check");
                if (!skipTestIntegrationCheckFiles.isEmpty()) {
                    System.out.println("Ignoring " + moduleAppDir);
                    continue;
                }
                releaseModuleAppDirs.add(moduleAppDir);
            }
        }
        return releaseModuleAppDirs;
    }
}

