/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalAcceptancePullRequestJob;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.clazz.JUnitTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JUnitBatchTestClassGroup
extends BatchTestClassGroup {
    private final List<File> _autoBalanceTestFiles = new ArrayList<File>();
    private boolean _includeAutoBalanceTests;
    private final boolean _includeUnstagedTestClassFiles;

    @Override
    public int getAxisCount() {
        int axisCount = super.getAxisCount();
        if (axisCount == 0 && this._includeAutoBalanceTests) {
            return 1;
        }
        return axisCount;
    }

    public List<JobProperty> getExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.addAll(this.getRequiredExcludesJobProperties());
        if (this.testReleaseBundle) {
            excludesJobProperties.addAll(this.getReleaseExcludesJobProperties());
        } else if (this.testRelevantChanges) {
            excludesJobProperties.addAll(this.getRelevantExcludesJobProperties());
        } else {
            excludesJobProperties.addAll(this.getDefaultExcludesJobProperties());
        }
        if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            excludesJobProperties.addAll(this.getStableDefaultExcludesJobProperties());
            excludesJobProperties.addAll(this.getStableRequiredExcludesJobProperties());
        }
        excludesJobProperties.removeAll(Collections.singleton(null));
        this.recordJobProperties(excludesJobProperties);
        return excludesJobProperties;
    }

    public List<JobProperty> getFilterJobProperties() {
        ArrayList<JobProperty> filterJobProperties = new ArrayList<JobProperty>();
        filterJobProperties.add(this.getJobProperty("test.batch.class.names.filter", JobProperty.Type.FILTER_GLOB));
        this.recordJobProperties(filterJobProperties);
        return filterJobProperties;
    }

    public List<JobProperty> getIncludesJobProperties() {
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        includesJobProperties.addAll(this.getRequiredIncludesJobProperties());
        if (this.testReleaseBundle) {
            includesJobProperties.addAll(this.getReleaseIncludesJobProperties());
        } else if (this.testRelevantChanges) {
            includesJobProperties.addAll(this.getRelevantIncludesJobProperties());
        } else {
            includesJobProperties.addAll(this.getDefaultIncludesJobProperties());
        }
        if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            includesJobProperties.addAll(this.getStableDefaultIncludesJobProperties());
            includesJobProperties.addAll(this.getStableRequiredIncludesJobProperties());
        }
        includesJobProperties.removeAll(Collections.singleton(null));
        this.recordJobProperties(includesJobProperties);
        return includesJobProperties;
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("auto_balance_test_files", this._autoBalanceTestFiles);
        this.jsonObject.put("exclude_globs", this.getGlobs(this.getExcludesJobProperties()));
        this.jsonObject.put("filter_globs", this.getGlobs(this.getFilterJobProperties()));
        this.jsonObject.put("include_auto_balance_tests", this._includeAutoBalanceTests);
        this.jsonObject.put("include_globs", this.getGlobs(this.getIncludesJobProperties()));
        this.jsonObject.put("include_unstaged_test_class_files", this._includeUnstagedTestClassFiles);
        this.jsonObject.put("target_duration", this.getTargetAxisDuration());
        return this.jsonObject;
    }

    public void writeTestCSVReportFile() throws Exception {
        BatchTestClassGroup.CSVReport csvReport = new BatchTestClassGroup.CSVReport(new BatchTestClassGroup.CSVReport.Row("Class Name", "Method Name", "Ignored", "File Path"));
        for (JUnitTestClass jUnitTestClass : TestClassFactory.getJUnitTestClasses()) {
            File testClassFile = jUnitTestClass.getTestClassFile();
            String testClassFileRelativePath = JenkinsResultsParserUtil.getPathRelativeTo(testClassFile, this.portalGitWorkingDirectory.getWorkingDirectory());
            String className = testClassFile.getName();
            className = className.replace(".class", "");
            List<TestClassMethod> testClassMethods = jUnitTestClass.getTestClassMethods();
            for (TestClassMethod testClassMethod : testClassMethods) {
                BatchTestClassGroup.CSVReport.Row csvReportRow = new BatchTestClassGroup.CSVReport.Row();
                csvReportRow.add(className);
                csvReportRow.add(testClassMethod.getName());
                if (testClassMethod.isIgnored()) {
                    csvReportRow.add("TRUE");
                } else {
                    csvReportRow.add("");
                }
                csvReportRow.add(testClassFileRelativePath);
                csvReport.addRow(csvReportRow);
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy");
        File csvReportFile = new File(JenkinsResultsParserUtil.combine("Report_junit_", simpleDateFormat.format(new Date()), ".csv"));
        try {
            JenkinsResultsParserUtil.write(csvReportFile, csvReport.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected JUnitBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
        JSONArray autoBalanceTestFilesJSONArray = jsonObject.getJSONArray("auto_balance_test_files");
        if (autoBalanceTestFilesJSONArray != null && !autoBalanceTestFilesJSONArray.isEmpty()) {
            for (int i = 0; i < autoBalanceTestFilesJSONArray.length(); ++i) {
                String autoBalanceTestFilePath = autoBalanceTestFilesJSONArray.getString(i);
                if (JenkinsResultsParserUtil.isNullOrEmpty(autoBalanceTestFilePath)) continue;
                this._autoBalanceTestFiles.add(new File(autoBalanceTestFilePath));
            }
        }
        this._includeAutoBalanceTests = jsonObject.getBoolean("include_auto_balance_tests");
        this._includeUnstagedTestClassFiles = jsonObject.getBoolean("include_unstaged_test_class_files");
    }

    protected JUnitBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        if (portalTestClassJob instanceof PortalAcceptancePullRequestJob) {
            PortalAcceptancePullRequestJob portalAcceptancePullRequestJob = (PortalAcceptancePullRequestJob)portalTestClassJob;
            this._includeUnstagedTestClassFiles = portalAcceptancePullRequestJob.isCentralMergePullRequest();
        } else {
            this._includeUnstagedTestClassFiles = false;
        }
        this.setTestClasses();
        this._setAutoBalanceTestFiles();
        this._setIncludeAutoBalanceTests();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    protected List<JobProperty> getDefaultExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes", JobProperty.Type.EXCLUDE_GLOB));
        return excludesJobProperties;
    }

    protected List<JobProperty> getDefaultIncludesJobProperties() {
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        includesJobProperties.add(this.getJobProperty("test.batch.class.names.includes", JobProperty.Type.INCLUDE_GLOB));
        return includesJobProperties;
    }

    protected List<JobProperty> getReleaseExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.addAll(this.getDefaultExcludesJobProperties());
        excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes.release", JobProperty.Type.EXCLUDE_GLOB));
        return excludesJobProperties;
    }

    protected List<JobProperty> getReleaseIncludesJobProperties() {
        return this.getDefaultIncludesJobProperties();
    }

    protected List<JobProperty> getRelevantExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.addAll(this.getDefaultExcludesJobProperties());
        excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes.relevant", JobProperty.Type.EXCLUDE_GLOB));
        return excludesJobProperties;
    }

    protected List<JobProperty> getRelevantIncludesJobProperties() {
        List<File> moduleDirsList = null;
        try {
            moduleDirsList = this.portalGitWorkingDirectory.getModuleDirsList();
        }
        catch (IOException ioException) {
            File workingDirectory = this.portalGitWorkingDirectory.getWorkingDirectory();
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get module directories in ", workingDirectory.getPath()), ioException);
        }
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        List<File> modifiedFilesList = this.portalGitWorkingDirectory.getModifiedFilesList();
        for (File modifiedFile : modifiedFilesList) {
            boolean foundModuleFile = false;
            for (File moduleDir : moduleDirsList) {
                if (!JenkinsResultsParserUtil.isFileInDirectory(moduleDir, modifiedFile)) continue;
                foundModuleFile = true;
                break;
            }
            if (foundModuleFile) continue;
            includesJobProperties.addAll(this.getDefaultIncludesJobProperties());
            break;
        }
        return includesJobProperties;
    }

    protected List<JobProperty> getRequiredExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes.required", JobProperty.Type.EXCLUDE_GLOB));
        return excludesJobProperties;
    }

    protected List<JobProperty> getRequiredIncludesJobProperties() {
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        includesJobProperties.add(this.getJobProperty("test.batch.class.names.includes.required", JobProperty.Type.INCLUDE_GLOB));
        return includesJobProperties;
    }

    protected List<JobProperty> getStableDefaultExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        String batchName = this.getBatchName();
        if (!batchName.endsWith("_stable")) {
            batchName = batchName + "_stable";
        }
        excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes", "stable", batchName, JobProperty.Type.EXCLUDE_GLOB));
        return excludesJobProperties;
    }

    protected List<JobProperty> getStableDefaultIncludesJobProperties() {
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        String batchName = this.getBatchName();
        if (!batchName.endsWith("_stable")) {
            batchName = batchName + "_stable";
        }
        includesJobProperties.add(this.getJobProperty("test.batch.class.names.includes", "stable", batchName, JobProperty.Type.INCLUDE_GLOB));
        return includesJobProperties;
    }

    protected List<JobProperty> getStableRequiredExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        String batchName = this.getBatchName();
        if (!batchName.endsWith("_stable")) {
            batchName = batchName + "_stable";
        }
        excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes.required", "stable", batchName, JobProperty.Type.EXCLUDE_GLOB));
        return excludesJobProperties;
    }

    protected List<JobProperty> getStableRequiredIncludesJobProperties() {
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        String batchName = this.getBatchName();
        if (!batchName.endsWith("_stable")) {
            batchName = batchName + "_stable";
        }
        includesJobProperties.add(this.getJobProperty("test.batch.class.names.includes.required", "stable", batchName, JobProperty.Type.INCLUDE_GLOB));
        return includesJobProperties;
    }

    @Override
    protected void setAxisTestClassGroups() {
        long targetAxisDuration = this.getTargetAxisDuration();
        if (targetAxisDuration > 0L) {
            List<TestClass> testClasses = this.getTestClasses();
            if (testClasses.isEmpty()) {
                if (!this._includeAutoBalanceTests) {
                    return;
                }
                this.axisTestClassGroups.add(0, TestClassGroupFactory.newAxisTestClassGroup(this));
            } else {
                AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
                this.axisTestClassGroups.add(axisTestClassGroup);
                for (TestClass testClass : testClasses) {
                    if (!axisTestClassGroup.hasTestClasses()) {
                        axisTestClassGroup.addTestClass(testClass);
                        continue;
                    }
                    long estimatedAxisDuration = axisTestClassGroup.getAverageDuration() + testClass.getAverageDuration() + testClass.getAverageOverheadDuration();
                    if (estimatedAxisDuration < targetAxisDuration) {
                        axisTestClassGroup.addTestClass(testClass);
                        continue;
                    }
                    axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
                    axisTestClassGroup.addTestClass(testClass);
                    this.axisTestClassGroups.add(axisTestClassGroup);
                }
            }
        } else {
            int axisCount = this.getAxisCount();
            if (axisCount == 0) {
                return;
            }
            int testClassCount = this.testClasses.size();
            if (testClassCount == 0) {
                if (!this._includeAutoBalanceTests) {
                    return;
                }
                this.axisTestClassGroups.add(0, TestClassGroupFactory.newAxisTestClassGroup(this));
            } else {
                int axisSize = (int)Math.ceil((double)testClassCount / (double)axisCount);
                for (List axisTestClasses : Lists.partition((List)this.testClasses, (int)axisSize)) {
                    AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
                    for (TestClass axisTestClass : axisTestClasses) {
                        axisTestClassGroup.addTestClass(axisTestClass);
                    }
                    this.axisTestClassGroups.add(axisTestClassGroup);
                }
            }
        }
        if (!this._includeAutoBalanceTests) {
            return;
        }
        for (AxisTestClassGroup axisTestClassGroup : this.axisTestClassGroups) {
            for (File file : this._autoBalanceTestFiles) {
                String filePath = file.getPath();
                TestClass testClass = TestClassFactory.newTestClass((BatchTestClassGroup)this, new File(filePath = filePath.replace(".class", ".java")));
                if (!testClass.hasTestClassMethods()) continue;
                axisTestClassGroup.addTestClass(testClass);
            }
        }
    }

    protected void setTestClasses() {
        final List<PathMatcher> includesPathMatchers = this.getPathMatchers(this.getIncludesJobProperties());
        if (includesPathMatchers.isEmpty()) {
            return;
        }
        final List<PathMatcher> filterPathMatchers = this.getPathMatchers(this.getFilterJobProperties());
        final List<PathMatcher> excludesPathMatchers = this.getPathMatchers(this.getExcludesJobProperties());
        final JUnitBatchTestClassGroup batchTestClassGroup = this;
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        File workingDirectory = portalGitWorkingDirectory.getWorkingDirectory();
        try {
            Files.walkFileTree(workingDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (JenkinsResultsParserUtil.isFileExcluded((List<PathMatcher>)excludesPathMatchers, filePath.toFile())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (!JenkinsResultsParserUtil.isFileIncluded((List<PathMatcher>)excludesPathMatchers, (List<PathMatcher>)includesPathMatchers, filePath) || !JenkinsResultsParserUtil.isFileIncluded(null, (List<PathMatcher>)filterPathMatchers, filePath)) {
                        return FileVisitResult.CONTINUE;
                    }
                    TestClass testClass = TestClassFactory.newTestClass(batchTestClassGroup, filePath.toFile());
                    if (testClass != null && !testClass.isIgnored() && testClass.hasTestClassMethods()) {
                        JUnitBatchTestClassGroup.this.testClasses.add(testClass);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to search for test file names in " + workingDirectory.getPath(), ioException);
        }
        Collections.sort(this.testClasses);
    }

    private void _setAutoBalanceTestFiles() {
        JobProperty jobProperty = this.getJobProperty("test.class.names.auto.balance");
        String jobPropertyValue = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(jobPropertyValue)) {
            return;
        }
        this.recordJobProperty(jobProperty);
        for (String autoBalanceTestName : jobPropertyValue.split(",")) {
            String fullClassName = autoBalanceTestName.replaceAll(".*\\/?(com\\/.*)\\.(class|java)", "$1");
            fullClassName = fullClassName.replaceAll("/", "\\.");
            File javaTestClassFile = this.portalGitWorkingDirectory.getJavaFileFromFullClassName(fullClassName);
            if (!JenkinsResultsParserUtil.isFileIncluded(null, this.getPathMatchers(this.getFilterJobProperties()), javaTestClassFile)) continue;
            this._autoBalanceTestFiles.add(javaTestClassFile);
        }
    }

    private void _setIncludeAutoBalanceTests() {
        if (!this.testClasses.isEmpty()) {
            this._includeAutoBalanceTests = true;
            return;
        }
        List<File> modifiedJavaFilesList = this.portalGitWorkingDirectory.getModifiedFilesList(this._includeUnstagedTestClassFiles, null, JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.combine("**", File.separator, "*.java"), new String[0]));
        if (!this._autoBalanceTestFiles.isEmpty() && !modifiedJavaFilesList.isEmpty()) {
            this._includeAutoBalanceTests = true;
            return;
        }
        this._includeAutoBalanceTests = false;
    }
}

