/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.util.PropsUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class FunctionalBatchTestClassGroup
extends BatchTestClassGroup {
    private static final Pattern _poshiTestCasePattern = Pattern.compile("(?<namespace>[^\\.]+)\\.(?<className>[^\\#]+)\\#(?<methodName>.*)");
    private final Map<File, String> _testBatchRunPropertyQueries = new HashMap<File, String>();
    private final Set<File> _traversedPropertyFiles = new HashSet<File>();

    @Override
    public int getAxisCount() {
        return this.axisTestClassGroups.size();
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.getTestBatchRunPropertyQuery());
        sb.append(") AND (ignored == null)");
        String testRunEnvironment = PropsUtil.get((String)"test.run.environment");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testRunEnvironment)) {
            sb.append(" AND (test.run.environment == \"");
            sb.append(testRunEnvironment);
            sb.append("\" OR test.run.environment == null)");
        }
        this.jsonObject.put("pql_query", (Object)sb.toString());
        this.jsonObject.put("target_duration", this.getTargetAxisDuration());
        this.jsonObject.put("test_batch_run_property_queries", this._testBatchRunPropertyQueries);
        return this.jsonObject;
    }

    public List<File> getTestBaseDirs() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        return Arrays.asList(new File(portalGitWorkingDirectory.getWorkingDirectory(), "portal-web/test/functional/portalweb"));
    }

    public String getTestBatchRunPropertyQuery() {
        List<File> testBaseDirs = this.getTestBaseDirs();
        if (testBaseDirs.isEmpty()) {
            return null;
        }
        return this.getTestBatchRunPropertyQuery(testBaseDirs.get(0));
    }

    public String getTestBatchRunPropertyQuery(File testBaseDir) {
        return this._testBatchRunPropertyQueries.get(testBaseDir);
    }

    @Override
    public List<TestClass> getTestClasses() {
        ArrayList<TestClass> testClasses = new ArrayList<TestClass>();
        for (AxisTestClassGroup axisTestClassGroup : this.axisTestClassGroups) {
            testClasses.addAll(axisTestClassGroup.getTestClasses());
        }
        return testClasses;
    }

    protected FunctionalBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
        JSONObject testBatchRunPropertyQueriesJSONObject = jsonObject.optJSONObject("test_batch_run_property_queries");
        if (testBatchRunPropertyQueriesJSONObject == null) {
            return;
        }
        for (String key : testBatchRunPropertyQueriesJSONObject.keySet()) {
            this._testBatchRunPropertyQueries.put(new File(key), testBatchRunPropertyQueriesJSONObject.getString(key));
        }
    }

    protected FunctionalBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        this._setTestBatchRunPropertyQueries();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    @Override
    protected int getAxisMaxSize() {
        long targetAxisDuration = this.getTargetAxisDuration();
        if (targetAxisDuration > 0L) {
            return 5000;
        }
        return super.getAxisMaxSize();
    }

    protected String getDefaultTestBatchRunPropertyQuery(File testBaseDir, String testSuiteName) {
        String query = System.getenv("TEST_BATCH_RUN_PROPERTY_QUERY");
        if (JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            query = this.getBuildStartProperty("TEST_BATCH_RUN_PROPERTY_QUERY");
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return query;
        }
        JobProperty jobProperty = this.getJobProperty("test.batch.run.property.query", testSuiteName, this.batchName);
        this.recordJobProperty(jobProperty);
        return jobProperty.getValue();
    }

    protected List<List<String>> getPoshiTestClassGroups(File testBaseDir) {
        String query = this.getTestBatchRunPropertyQuery(testBaseDir);
        if (JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return new ArrayList<List<String>>();
        }
        Pattern pattern = _poshiTestCasePattern;
        synchronized (pattern) {
            PortalGitWorkingDirectory portalGitWorkingDirectory = this.portalTestClassJob.getPortalGitWorkingDirectory();
            File portalWorkingDirectory = portalGitWorkingDirectory.getWorkingDirectory();
            HashMap<String, String> parameters = new HashMap<String, String>();
            String testBaseDirPath = null;
            if (testBaseDir != null && testBaseDir.exists()) {
                testBaseDirPath = JenkinsResultsParserUtil.getCanonicalPath(testBaseDir);
                parameters.put("test.base.dir.name", testBaseDirPath);
            }
            try {
                AntUtil.callTarget(portalWorkingDirectory, "build-test.xml", "prepare-poshi-runner-properties", parameters);
            }
            catch (AntException antException) {
                throw new RuntimeException(antException);
            }
            Properties properties = JenkinsResultsParserUtil.getProperties(new File(portalWorkingDirectory, "portal-web/poshi.properties"), new File(portalWorkingDirectory, "portal-web/poshi-ext.properties"));
            if (!JenkinsResultsParserUtil.isNullOrEmpty(testBaseDirPath)) {
                properties.setProperty("test.base.dir.name", testBaseDirPath);
            }
            PropsUtil.clear();
            PropsUtil.setProperties((Properties)properties);
            try {
                PoshiContext.clear();
                PoshiContext.readFiles();
                return PoshiContext.getTestBatchGroups((String)query, (long)this.getAxisMaxSize());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @Override
    protected void setAxisTestClassGroups() {
        if (!this.axisTestClassGroups.isEmpty()) {
            return;
        }
        for (File testBaseDir : this.getTestBaseDirs()) {
            String query = this.getTestBatchRunPropertyQuery(testBaseDir);
            if (query == null) continue;
            List<List<String>> poshiTestClassGroups = this.getPoshiTestClassGroups(testBaseDir);
            long targetAxisDuration = this.getTargetAxisDuration();
            for (List<String> poshiTestClassGroup : poshiTestClassGroups) {
                AxisTestClassGroup axisTestClassGroup;
                if (poshiTestClassGroup.isEmpty()) continue;
                if (targetAxisDuration > 0L) {
                    axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this, testBaseDir);
                    this.axisTestClassGroups.add(axisTestClassGroup);
                    for (String testClassMethodName : poshiTestClassGroup) {
                        TestClass testClass = TestClassFactory.newTestClass((BatchTestClassGroup)this, testClassMethodName);
                        if (!axisTestClassGroup.hasTestClasses()) {
                            axisTestClassGroup.addTestClass(testClass);
                            continue;
                        }
                        long estimatedAxisDuration = axisTestClassGroup.getAverageDuration() + testClass.getAverageDuration() + testClass.getAverageOverheadDuration();
                        if (estimatedAxisDuration < targetAxisDuration) {
                            axisTestClassGroup.addTestClass(testClass);
                            continue;
                        }
                        axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this, testBaseDir);
                        axisTestClassGroup.addTestClass(testClass);
                        this.axisTestClassGroups.add(axisTestClassGroup);
                    }
                    continue;
                }
                axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this, testBaseDir);
                for (String testClassMethodName : poshiTestClassGroup) {
                    Matcher matcher = _poshiTestCasePattern.matcher(testClassMethodName);
                    if (!matcher.find()) {
                        throw new RuntimeException("Invalid test class method name " + testClassMethodName);
                    }
                    axisTestClassGroup.addTestClass(TestClassFactory.newTestClass((BatchTestClassGroup)this, testClassMethodName));
                }
                this.axisTestClassGroups.add(axisTestClassGroup);
            }
        }
    }

    private String _concatPQL(File file, String concatedPQL) {
        Properties testProperties;
        boolean ignoreParents;
        if (file == null) {
            return null;
        }
        if (JenkinsResultsParserUtil.isPoshiFile(file)) {
            return "";
        }
        File canonicalFile = JenkinsResultsParserUtil.getCanonicalFile(file);
        File parentFile = canonicalFile.getParentFile();
        if (parentFile == null || !parentFile.exists()) {
            return "";
        }
        File modulesBaseDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        Path modulesBaseDirPath = modulesBaseDir.toPath();
        Path parentFilePath = parentFile.toPath();
        File testPropertiesFile = new File(canonicalFile, "test.properties");
        if (modulesBaseDirPath.equals(parentFilePath) && !testPropertiesFile.exists()) {
            return concatedPQL;
        }
        if (!canonicalFile.isDirectory() || !testPropertiesFile.exists()) {
            return this._concatPQL(parentFile, concatedPQL);
        }
        if (this._traversedPropertyFiles.contains(testPropertiesFile)) {
            return concatedPQL;
        }
        this._traversedPropertyFiles.add(testPropertiesFile);
        JobProperty jobProperty = this.getJobProperty("test.batch.run.property.query", this.getTestSuiteName(), this.batchName, canonicalFile, JobProperty.Type.MODULE_TEST_DIR);
        String testBatchPropertyQuery = jobProperty.getValue();
        if (!(JenkinsResultsParserUtil.isNullOrEmpty(testBatchPropertyQuery) || testBatchPropertyQuery.equals("false") || concatedPQL.contains(testBatchPropertyQuery))) {
            this.recordJobProperty(jobProperty);
            concatedPQL = !concatedPQL.isEmpty() ? concatedPQL + JenkinsResultsParserUtil.combine(" OR (", testBatchPropertyQuery, ")") : concatedPQL + testBatchPropertyQuery;
        }
        if ((ignoreParents = Boolean.valueOf(JenkinsResultsParserUtil.getProperty(testProperties = JenkinsResultsParserUtil.getProperties(testPropertiesFile), "ignoreParents", false, this.getTestSuiteName())).booleanValue()) || parentFile.equals(this.portalGitWorkingDirectory.getWorkingDirectory())) {
            return concatedPQL;
        }
        if (!parentFilePath.equals(modulesBaseDirPath)) {
            return this._concatPQL(parentFile, concatedPQL);
        }
        return concatedPQL;
    }

    private String _getTestBatchRunPropertyQuery(File testBaseDir) {
        JobProperty jobProperty;
        String jobPropertyValue;
        if (!this.testRelevantChanges) {
            return this.getDefaultTestBatchRunPropertyQuery(testBaseDir, this.testSuiteName);
        }
        StringBuilder sb = new StringBuilder();
        for (File modifiedFile : this.portalGitWorkingDirectory.getModifiedFilesList()) {
            String testBatchPQL = this._concatPQL(modifiedFile, "");
            if (JenkinsResultsParserUtil.isNullOrEmpty(testBatchPQL) || testBatchPQL.equals("false") || sb.indexOf(testBatchPQL) != -1) continue;
            if (!JenkinsResultsParserUtil.isNullOrEmpty(sb.toString())) {
                sb.append(" OR ");
            }
            sb.append("(");
            sb.append(testBatchPQL);
            sb.append(")");
        }
        String defaultPQL = this.getDefaultTestBatchRunPropertyQuery(testBaseDir, this.testSuiteName);
        if (!JenkinsResultsParserUtil.isNullOrEmpty(defaultPQL) && sb.indexOf(defaultPQL) == -1) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("(");
            sb.append(defaultPQL);
            sb.append(")");
        }
        if (!"stable".equals(this.getTestSuiteName())) {
            String batchName = this.getBatchName();
            if (!batchName.endsWith("_stable")) {
                batchName = batchName + "_stable";
            }
            if ((jobPropertyValue = (jobProperty = this.getJobProperty("test.batch.run.property.query", "stable", batchName)).getValue()) != null && this.includeStableTestSuite && this.isStableTestSuiteBatch(batchName) && sb.indexOf(jobPropertyValue) == -1) {
                this.recordJobProperty(jobProperty);
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append("(");
                sb.append(jobPropertyValue);
                sb.append(")");
            }
        }
        String testBatchRunPropertyQuery = sb.toString();
        jobProperty = this.getJobProperty("test.batch.run.property.global.query");
        jobPropertyValue = jobProperty.getValue();
        if (jobPropertyValue != null) {
            this.recordJobProperty(jobProperty);
            testBatchRunPropertyQuery = JenkinsResultsParserUtil.combine("(", jobPropertyValue, ") AND (", testBatchRunPropertyQuery, ")");
        }
        return testBatchRunPropertyQuery;
    }

    private void _setTestBatchRunPropertyQueries() {
        for (File testBaseDir : this.getTestBaseDirs()) {
            String testBatchRunPropertyQuery = this._getTestBatchRunPropertyQuery(testBaseDir);
            if (JenkinsResultsParserUtil.isNullOrEmpty(testBatchRunPropertyQuery)) continue;
            this._testBatchRunPropertyQueries.put(testBaseDir, testBatchRunPropertyQuery);
        }
    }
}

