/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.test.clazz.FunctionalTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.json.JSONObject;

public class FunctionalAxisTestClassGroup
extends AxisTestClassGroup {
    private final File _testBaseDir;

    public List<FunctionalTestClass> getFunctionalTestClasses() {
        ArrayList<FunctionalTestClass> functionalTestClasses = new ArrayList<FunctionalTestClass>();
        for (TestClass testClass : this.getTestClasses()) {
            if (!(testClass instanceof FunctionalTestClass)) continue;
            functionalTestClasses.add((FunctionalTestClass)testClass);
        }
        return functionalTestClasses;
    }

    @Override
    public JSONObject getJSONObject() {
        JSONObject jsonObject = super.getJSONObject();
        jsonObject.put("test_base_dir", (Object)JenkinsResultsParserUtil.getCanonicalPath(this._testBaseDir));
        return jsonObject;
    }

    @Override
    public Integer getMinimumSlaveRAM() {
        Properties poshiProperties = this.getPoshiProperties();
        String minimumSlaveRAM = poshiProperties.getProperty("minimum.slave.ram");
        if (minimumSlaveRAM != null && minimumSlaveRAM.matches("\\d+")) {
            return Integer.valueOf(minimumSlaveRAM);
        }
        return super.getMinimumSlaveRAM();
    }

    public Properties getPoshiProperties() {
        List<FunctionalTestClass> functionalTestClasses = this.getFunctionalTestClasses();
        FunctionalTestClass functionalTestClass = functionalTestClasses.get(0);
        return functionalTestClass.getPoshiProperties();
    }

    @Override
    public String getSlaveLabel() {
        String slaveLabel = JenkinsResultsParserUtil.getProperty(this.getPoshiProperties(), "slave.label");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(slaveLabel)) {
            return slaveLabel;
        }
        return super.getSlaveLabel();
    }

    @Override
    public File getTestBaseDir() {
        return this._testBaseDir;
    }

    public List<String> getTestClassMethodNames() {
        ArrayList<String> testClassMethodNames = new ArrayList<String>();
        for (FunctionalTestClass functionalTestClass : this.getFunctionalTestClasses()) {
            testClassMethodNames.add(functionalTestClass.getTestClassMethodName());
        }
        return testClassMethodNames;
    }

    protected FunctionalAxisTestClassGroup(FunctionalBatchTestClassGroup functionalBatchTestClassGroup, File testBaseDir) {
        super(functionalBatchTestClassGroup);
        this._testBaseDir = testBaseDir;
    }

    protected FunctionalAxisTestClassGroup(JSONObject jsonObject, SegmentTestClassGroup segmentTestClassGroup) {
        super(jsonObject, segmentTestClassGroup);
        this._testBaseDir = new File(jsonObject.getString("test_base_dir"));
    }
}

