/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.job.property.GlobJobProperty;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.job.property.JobPropertyFactory;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BatchTestClassGroup
extends BaseTestClassGroup {
    protected static final int AXES_SIZE_MAX_DEFAULT = 5000;
    protected static final String NAME_STABLE_TEST_SUITE = "stable";
    protected static final String SLAVE_LABEL_DEFAULT = "!master";
    protected final List<AxisTestClassGroup> axisTestClassGroups = new ArrayList<AxisTestClassGroup>();
    protected final String batchName;
    protected boolean includeStableTestSuite;
    protected JSONObject jsonObject;
    protected final PortalGitWorkingDirectory portalGitWorkingDirectory;
    protected final PortalTestClassJob portalTestClassJob;
    protected boolean testReleaseBundle;
    protected boolean testRelevantChanges;
    protected boolean testRelevantIntegrationUnitOnly;
    protected final String testSuiteName;
    private static final int _SEGMENT_MAX_CHILDREN_DEFAULT = 25;
    private static final Pattern _jobNamePattern = Pattern.compile("(?<jobBaseName>.*)(?<jobVariant>\\([^\\)]+\\))");
    private final List<JobProperty> _jobProperties = new ArrayList<JobProperty>();
    private final List<SegmentTestClassGroup> _segmentTestClassGroups = new ArrayList<SegmentTestClassGroup>();

    public void addAxisTestClassGroup(AxisTestClassGroup axisTestClassGroup) {
        this.axisTestClassGroups.add(axisTestClassGroup);
    }

    public long getAverageDuration() {
        Job job = this.getJob();
        Long averageDuration = job.getAverageBatchDuration(this.getBatchName());
        if (averageDuration == null) {
            return 0L;
        }
        return averageDuration;
    }

    public long getAverageOverheadDuration() {
        Job job = this.getJob();
        Long averageOverheadDuration = job.getAverageBatchOverheadDuration(this.getBatchName());
        if (averageOverheadDuration == null) {
            return 0L;
        }
        return averageOverheadDuration;
    }

    public long getAverageTestDuration(String testName) {
        Job job = this.getJob();
        Long averageDuration = job.getAverageTestDuration(this.getBatchName(), testName);
        if (averageDuration != null) {
            return averageDuration;
        }
        return this._getDefaultTestDuration();
    }

    public long getAverageTestOverheadDuration(String testName) {
        Job job = this.getJob();
        Long averageOverheadDuration = job.getAverageTestOverheadDuration(this.getBatchName(), testName);
        if (averageOverheadDuration != null) {
            return averageOverheadDuration;
        }
        return 0L;
    }

    public int getAxisCount() {
        JobProperty jobProperty = this.getJobProperty("test.batch.axis.count");
        String jobPropertyValue = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isInteger(jobPropertyValue)) {
            this.recordJobProperty(jobProperty);
            return Integer.parseInt(jobPropertyValue);
        }
        int testClassCount = this.testClasses.size();
        if (testClassCount == 0) {
            return 0;
        }
        int axisMaxSize = this.getAxisMaxSize();
        if (axisMaxSize <= 0) {
            throw new RuntimeException("'test.batch.axis.max.size' cannot be 0 or less");
        }
        return (int)Math.ceil((double)testClassCount / (double)axisMaxSize);
    }

    public AxisTestClassGroup getAxisTestClassGroup(int axisId) {
        return this.axisTestClassGroups.get(axisId);
    }

    public List<AxisTestClassGroup> getAxisTestClassGroups() {
        return this.axisTestClassGroups;
    }

    public String getBatchJobName() {
        String topLevelJobName = this.portalTestClassJob.getJobName();
        Matcher jobNameMatcher = _jobNamePattern.matcher(topLevelJobName);
        String batchJobSuffix = "-batch";
        String slaveLabel = this.getSlaveLabel();
        if (slaveLabel.contains("win")) {
            batchJobSuffix = "-windows-batch";
        }
        if (jobNameMatcher.find()) {
            return JenkinsResultsParserUtil.combine(jobNameMatcher.group("jobBaseName"), batchJobSuffix, jobNameMatcher.group("jobVariant"));
        }
        return topLevelJobName + batchJobSuffix;
    }

    public String getBatchName() {
        return this.batchName;
    }

    public String getCohortName() {
        JobProperty jobProperty = this.getJobProperty("test.batch.cohort.name");
        String jobPropertyValue = jobProperty.getValue();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(jobPropertyValue)) {
            this.recordJobProperty(jobProperty);
            return jobPropertyValue;
        }
        jobPropertyValue = JenkinsResultsParserUtil.getCohortName();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(jobPropertyValue)) {
            return jobPropertyValue;
        }
        return "test-1";
    }

    public String getDownstreamJobName() {
        String topLevelJobName = this.portalTestClassJob.getJobName();
        Matcher jobNameMatcher = _jobNamePattern.matcher(topLevelJobName);
        String batchJobSuffix = "-downstream";
        String slaveLabel = this.getSlaveLabel();
        if (slaveLabel.contains("win")) {
            batchJobSuffix = "-windows-downstream";
        }
        if (jobNameMatcher.find()) {
            return JenkinsResultsParserUtil.combine(jobNameMatcher.group("jobBaseName"), batchJobSuffix, jobNameMatcher.group("jobVariant"));
        }
        return topLevelJobName + batchJobSuffix;
    }

    @Override
    public Job getJob() {
        return this.portalTestClassJob;
    }

    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = new JSONObject();
        this.jsonObject.put("average_duration", this.getAverageDuration());
        this.jsonObject.put("average_overhead_duration", this.getAverageOverheadDuration());
        this.jsonObject.put("batch_name", (Object)this.getBatchName());
        this.jsonObject.put("include_stable_test_suite", this.includeStableTestSuite);
        this.jsonObject.put("job_properties", this._getJobPropertiesMap());
        JSONArray segmentJSONArray = new JSONArray();
        for (SegmentTestClassGroup segmentTestClassGroup : this.getSegmentTestClassGroups()) {
            segmentJSONArray.put((Object)segmentTestClassGroup.getJSONObject());
        }
        this.jsonObject.put("segments", (Object)segmentJSONArray);
        this.jsonObject.put("test_release_bundle", this.testReleaseBundle);
        this.jsonObject.put("test_relevant_changes", this.testRelevantChanges);
        this.jsonObject.put("test_relevant_integration_unit_only", this.testRelevantIntegrationUnitOnly);
        return this.jsonObject;
    }

    public Integer getMaximumSlavesPerHost() {
        JobProperty jobProperty = this.getJobProperty("test.batch.maximum.slaves.per.host");
        String jobPropertyValue = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isInteger(jobPropertyValue)) {
            this.recordJobProperty(jobProperty);
            return Integer.valueOf(jobPropertyValue);
        }
        return JenkinsMaster.getSlavesPerHostDefault();
    }

    public Integer getMinimumSlaveRAM() {
        JobProperty jobProperty = this.getJobProperty("test.batch.minimum.slave.ram");
        String jobPropertyValue = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isInteger(jobPropertyValue)) {
            this.recordJobProperty(jobProperty);
            return Integer.valueOf(jobPropertyValue);
        }
        return JenkinsMaster.getSlaveRAMMinimumDefault();
    }

    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return this.portalGitWorkingDirectory;
    }

    public int getSegmentCount() {
        return this._segmentTestClassGroups.size();
    }

    public SegmentTestClassGroup getSegmentTestClassGroup(int segmentId) {
        if (this._segmentTestClassGroups.size() - 1 < segmentId) {
            return null;
        }
        return this._segmentTestClassGroups.get(segmentId);
    }

    public List<SegmentTestClassGroup> getSegmentTestClassGroups() {
        return this._segmentTestClassGroups;
    }

    public String getSlaveLabel() {
        JobProperty jobProperty = this.getJobProperty("test.batch.slave.label");
        String jobPropertyValue = jobProperty.getValue();
        if (jobPropertyValue != null) {
            this.recordJobProperty(jobProperty);
            return jobPropertyValue;
        }
        return SLAVE_LABEL_DEFAULT;
    }

    public String getTestCasePropertiesContent() {
        StringBuilder sb = new StringBuilder();
        for (SegmentTestClassGroup segmentTestClassGroup : this.getSegmentTestClassGroups()) {
            sb.append(segmentTestClassGroup.getTestCasePropertiesContent());
            sb.append("\n");
        }
        return sb.toString();
    }

    protected BatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        this.jsonObject = jsonObject;
        this.portalTestClassJob = portalTestClassJob;
        this.batchName = jsonObject.getString("batch_name");
        this.includeStableTestSuite = jsonObject.getBoolean("include_stable_test_suite");
        this.portalGitWorkingDirectory = portalTestClassJob.getPortalGitWorkingDirectory();
        JSONArray segmentsJSONArray = jsonObject.optJSONArray("segments");
        if (segmentsJSONArray != null && !segmentsJSONArray.isEmpty()) {
            for (int i = 0; i < segmentsJSONArray.length(); ++i) {
                JSONObject segmentJSONObject = segmentsJSONArray.getJSONObject(i);
                this._segmentTestClassGroups.add(TestClassGroupFactory.newSegmentTestClassGroup(this, segmentJSONObject));
            }
        }
        this.testRelevantChanges = jsonObject.getBoolean("test_relevant_changes");
        this.testReleaseBundle = jsonObject.getBoolean("test_release_bundle");
        this.testRelevantIntegrationUnitOnly = jsonObject.getBoolean("test_relevant_integration_unit_only");
        if (portalTestClassJob instanceof TestSuiteJob) {
            TestSuiteJob testSuiteJob = (TestSuiteJob)((Object)portalTestClassJob);
            this.testSuiteName = testSuiteJob.getTestSuiteName();
        } else {
            this.testSuiteName = null;
        }
    }

    protected BatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        this.batchName = batchName;
        this.portalTestClassJob = portalTestClassJob;
        this.portalGitWorkingDirectory = portalTestClassJob.getPortalGitWorkingDirectory();
        if (portalTestClassJob instanceof TestSuiteJob) {
            TestSuiteJob testSuiteJob = (TestSuiteJob)((Object)portalTestClassJob);
            this.testSuiteName = testSuiteJob.getTestSuiteName();
        } else {
            this.testSuiteName = null;
        }
        this._setTestReleaseBundle();
        this._setTestRelevantChanges();
        this._setTestRelevantIntegrationUnitOnly();
        this._setIncludeStableTestSuite();
    }

    protected int getAxisMaxSize() {
        JobProperty jobProperty = this.getJobProperty("test.batch.axis.max.size");
        String jobPropertyValue = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isInteger(jobPropertyValue)) {
            this.recordJobProperty(jobProperty);
            return Integer.parseInt(jobPropertyValue);
        }
        return 5000;
    }

    protected List<String> getGlobs(List<JobProperty> jobProperties) {
        ArrayList<String> globs = new ArrayList<String>();
        for (JobProperty jobProperty : jobProperties) {
            if (!(jobProperty instanceof GlobJobProperty)) continue;
            GlobJobProperty globJobProperty = (GlobJobProperty)jobProperty;
            for (String relativeGlob : globJobProperty.getRelativeGlobs()) {
                if (relativeGlob == null || globs.contains(relativeGlob)) continue;
                globs.add(relativeGlob);
            }
        }
        Collections.sort(globs);
        return globs;
    }

    protected JobProperty getJobProperty(String basePropertyName) {
        return this._getJobProperty(basePropertyName, null, null, null, null, true);
    }

    protected JobProperty getJobProperty(String basePropertyName, File testBaseDir, JobProperty.Type type) {
        return this._getJobProperty(basePropertyName, null, null, testBaseDir, type, true);
    }

    protected JobProperty getJobProperty(String basePropertyName, File testBaseDir, JobProperty.Type type, boolean useBasePropertyName) {
        return this._getJobProperty(basePropertyName, null, null, testBaseDir, type, useBasePropertyName);
    }

    protected JobProperty getJobProperty(String basePropertyName, JobProperty.Type type) {
        return this._getJobProperty(basePropertyName, null, null, null, type, true);
    }

    protected JobProperty getJobProperty(String basePropertyName, String testSuiteName, File testBaseDir, JobProperty.Type type) {
        return this._getJobProperty(basePropertyName, testSuiteName, null, testBaseDir, type, true);
    }

    protected JobProperty getJobProperty(String basePropertyName, String testSuiteName, String testBatchName) {
        return this._getJobProperty(basePropertyName, testSuiteName, testBatchName, null, null, true);
    }

    protected JobProperty getJobProperty(String basePropertyName, String testSuiteName, String testBatchName, File testBaseDir, JobProperty.Type type) {
        return this._getJobProperty(basePropertyName, testSuiteName, testBatchName, testBaseDir, type, true);
    }

    protected JobProperty getJobProperty(String basePropertyName, String testSuiteName, String testBatchName, JobProperty.Type type) {
        return this._getJobProperty(basePropertyName, testSuiteName, testBatchName, null, type, true);
    }

    protected List<PathMatcher> getPathMatchers(List<JobProperty> jobProperties) {
        ArrayList<PathMatcher> pathMatchers = new ArrayList<PathMatcher>();
        for (JobProperty jobProperty : jobProperties) {
            GlobJobProperty globJobProperty;
            List<PathMatcher> globPathMatchers;
            if (!(jobProperty instanceof GlobJobProperty) || (globPathMatchers = (globJobProperty = (GlobJobProperty)jobProperty).getPathMatchers()) == null) continue;
            for (PathMatcher globPathMatcher : globPathMatchers) {
                if (globPathMatcher == null || pathMatchers.contains(globPathMatcher)) continue;
                pathMatchers.add(globPathMatcher);
            }
        }
        return pathMatchers;
    }

    protected List<PathMatcher> getPathMatchers(String relativeGlobs, File workingDirectory) {
        if (relativeGlobs == null || relativeGlobs.isEmpty()) {
            return Collections.emptyList();
        }
        return JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.getCanonicalPath(workingDirectory) + File.separator, JenkinsResultsParserUtil.getGlobsFromProperty(relativeGlobs));
    }

    protected List<String> getRelevantIntegrationUnitBatchNames() {
        ArrayList<String> relevantIntegrationUnitBatchNames = new ArrayList<String>();
        if (!this.testSuiteName.equals("relevant")) {
            return relevantIntegrationUnitBatchNames;
        }
        JobProperty jobProperty = this.getJobProperty("test.batch.names");
        String jobPropertyValue = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(jobPropertyValue)) {
            return relevantIntegrationUnitBatchNames;
        }
        for (String relevantTestBatchName : jobPropertyValue.split(",")) {
            if (!relevantTestBatchName.startsWith("integration-") && !relevantTestBatchName.startsWith("modules-integration") && !relevantTestBatchName.startsWith("modules-unit") && !relevantTestBatchName.startsWith("unit-")) continue;
            relevantIntegrationUnitBatchNames.add(relevantTestBatchName);
        }
        return relevantIntegrationUnitBatchNames;
    }

    protected List<PathMatcher> getRelevantIntegrationUnitIncludePathMatchers() {
        ArrayList<PathMatcher> relevantIntegrationUnitIncludePathMatchers = new ArrayList<PathMatcher>();
        for (String relevantIntegrationUnitBatchName : this.getRelevantIntegrationUnitBatchNames()) {
            String jobPropertyValue;
            JobProperty jobProperty = this.getJobProperty("test.batch.class.names.includes", this.getTestSuiteName(), relevantIntegrationUnitBatchName, JobProperty.Type.INCLUDE_GLOB);
            if (!(jobProperty instanceof GlobJobProperty) || (jobPropertyValue = jobProperty.getValue()) == null) continue;
            GlobJobProperty globJobProperty = (GlobJobProperty)jobProperty;
            relevantIntegrationUnitIncludePathMatchers.addAll(globJobProperty.getPathMatchers());
        }
        return relevantIntegrationUnitIncludePathMatchers;
    }

    protected List<File> getRequiredModuleDirs(List<File> moduleDirs) {
        return this._getRequiredModuleDirs(moduleDirs, new ArrayList<File>(moduleDirs));
    }

    protected int getSegmentMaxChildren() {
        JobProperty jobProperty = this.getJobProperty("test.batch.segment.max.children");
        String jobPropertyValue = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isInteger(jobPropertyValue)) {
            this.recordJobProperty(jobProperty);
            return Integer.valueOf(jobPropertyValue);
        }
        return 25;
    }

    protected long getTargetAxisDuration() {
        JobProperty jobProperty = this.getJobProperty("test.batch.target.axis.duration");
        String jobPropertyValue = jobProperty.getValue();
        if (jobPropertyValue == null || !jobPropertyValue.matches("\\d+")) {
            return 0L;
        }
        this.recordJobProperty(jobProperty);
        return Long.parseLong(jobPropertyValue);
    }

    protected String getTestSuiteName() {
        return this.testSuiteName;
    }

    protected boolean isIntegrationUnitTestFileModifiedOnly() {
        List<PathMatcher> relevantIntegrationUnitIncludePathMatchers = this.getRelevantIntegrationUnitIncludePathMatchers();
        List<File> modifiedFilesList = this.portalGitWorkingDirectory.getModifiedFilesList();
        if (relevantIntegrationUnitIncludePathMatchers.isEmpty() || modifiedFilesList.isEmpty()) {
            return false;
        }
        for (File modifiedFile : modifiedFilesList) {
            if (JenkinsResultsParserUtil.isFileIncluded(null, relevantIntegrationUnitIncludePathMatchers, modifiedFile)) continue;
            return false;
        }
        return true;
    }

    protected boolean isStableTestSuiteBatch() {
        return this.isStableTestSuiteBatch(this.batchName);
    }

    protected boolean isStableTestSuiteBatch(String batchName) {
        ArrayList testBatchNames = new ArrayList();
        JobProperty jobProperty = this.getJobProperty("test.batch.names[stable]");
        String jobPropertyValue = jobProperty.getValue();
        if (jobPropertyValue != null) {
            Collections.addAll(testBatchNames, jobPropertyValue.split(","));
        }
        return testBatchNames.contains(batchName);
    }

    protected void recordJobProperties(List<JobProperty> jobProperties) {
        for (JobProperty jobProperty : jobProperties) {
            this.recordJobProperty(jobProperty);
        }
    }

    protected void recordJobProperty(JobProperty jobProperty) {
        if (jobProperty == null || jobProperty.getValue() == null || this._jobProperties.contains(jobProperty)) {
            return;
        }
        this._jobProperties.add(jobProperty);
    }

    protected void setAxisTestClassGroups() {
        int testClassCount = this.testClasses.size();
        if (testClassCount == 0) {
            return;
        }
        int axisCount = this.getAxisCount();
        int axisSize = (int)Math.ceil((double)testClassCount / (double)axisCount);
        for (List axisTestClasses : Lists.partition((List)this.testClasses, (int)axisSize)) {
            AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
            for (TestClass axisTestClass : axisTestClasses) {
                axisTestClassGroup.addTestClass(axisTestClass);
            }
            this.axisTestClassGroups.add(axisTestClassGroup);
        }
    }

    protected void setSegmentTestClassGroups() {
        if (!this._segmentTestClassGroups.isEmpty() || this.axisTestClassGroups.isEmpty()) {
            return;
        }
        List<List<AxisTestClassGroup>> axisTestClassGroupsList = new ArrayList<List<AxisTestClassGroup>>();
        axisTestClassGroupsList.add(this.axisTestClassGroups);
        axisTestClassGroupsList = this._partitionByMinimumSlaveRAM(axisTestClassGroupsList);
        axisTestClassGroupsList = this._partitionBySlaveLabel(axisTestClassGroupsList);
        axisTestClassGroupsList = this._partitionByTestBaseDir(axisTestClassGroupsList);
        axisTestClassGroupsList = this._partitionByMaxChildren(axisTestClassGroupsList);
        for (List<AxisTestClassGroup> axisTestClassGroups : axisTestClassGroupsList) {
            SegmentTestClassGroup segmentTestClassGroup = TestClassGroupFactory.newSegmentTestClassGroup(this);
            for (AxisTestClassGroup axisTestClassGroup : axisTestClassGroups) {
                segmentTestClassGroup.addAxisTestClassGroup(axisTestClassGroup);
            }
            this._segmentTestClassGroups.add(segmentTestClassGroup);
        }
    }

    private long _getDefaultTestDuration() {
        JobProperty jobProperty = this.getJobProperty("test.batch.default.test.duration");
        if (jobProperty == null) {
            return 0L;
        }
        String jobPropertyValue = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(jobPropertyValue)) {
            return 0L;
        }
        this.recordJobProperty(jobProperty);
        return Long.valueOf(jobPropertyValue);
    }

    private Map<String, Properties> _getJobPropertiesMap() {
        TreeMap<String, Properties> batchProperties = new TreeMap<String, Properties>();
        for (JobProperty jobProperty : this._jobProperties) {
            String jobPropertyValue = jobProperty.getValue();
            if (jobPropertyValue == null) continue;
            String propertiesFilePath = jobProperty.getPropertiesFilePath();
            Properties properties = (Properties)batchProperties.get(propertiesFilePath);
            if (properties == null) {
                properties = new Properties();
            }
            properties.setProperty(jobProperty.getName(), jobPropertyValue);
            batchProperties.put(propertiesFilePath, properties);
        }
        return batchProperties;
    }

    private JobProperty _getJobProperty(String basePropertyName, String testSuiteName, String testBatchName, File testBaseDir, JobProperty.Type type, boolean useBasePropertyName) {
        if (testBatchName == null) {
            testBatchName = this.getBatchName();
        }
        return JobPropertyFactory.newJobProperty(basePropertyName, testSuiteName, testBatchName, this.getJob(), testBaseDir, type, useBasePropertyName);
    }

    private List<File> _getRequiredModuleDirs(List<File> moduleDirs, List<File> requiredModuleDirs) {
        List<Object> modifiedPoshiModulesList = new ArrayList();
        List<Object> modifiedNonposhiModulesList = new ArrayList();
        try {
            modifiedPoshiModulesList = this.portalGitWorkingDirectory.getModifiedPoshiModules();
            modifiedNonposhiModulesList = this.portalGitWorkingDirectory.getModifiedNonposhiModules();
        }
        catch (IOException ioException) {
            File workingDirectory = this.portalGitWorkingDirectory.getWorkingDirectory();
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get modified modules with non poshi and poshi changes directories in ", workingDirectory.getPath()), ioException);
        }
        File modulesBaseDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        for (File moduleDir : moduleDirs) {
            JobProperty jobProperty;
            String jobPropertyValue;
            if (this.testRelevantChanges && modifiedPoshiModulesList.contains(moduleDir) && !modifiedNonposhiModulesList.contains(moduleDir) || (jobPropertyValue = (jobProperty = this.getJobProperty("modules.includes.required[" + this.getTestSuiteName() + "]", moduleDir, JobProperty.Type.MODULE_TEST_DIR)).getValue()) == null) continue;
            this.recordJobProperty(jobProperty);
            for (String requiredModuleDirPath : jobPropertyValue.split(",")) {
                File requiredModuleDir = new File(modulesBaseDir, requiredModuleDirPath);
                if (!requiredModuleDir.exists() || requiredModuleDirs.contains(requiredModuleDir)) continue;
                requiredModuleDirs.add(requiredModuleDir);
            }
        }
        return new ArrayList<File>(requiredModuleDirs);
    }

    private List<List<AxisTestClassGroup>> _partitionByMaxChildren(List<List<AxisTestClassGroup>> axisTestClassGroupsList) {
        ArrayList<List<AxisTestClassGroup>> partitionedAxisTestClassGroupsList = new ArrayList<List<AxisTestClassGroup>>();
        for (List<AxisTestClassGroup> axisTestClassGroups : axisTestClassGroupsList) {
            partitionedAxisTestClassGroupsList.addAll(Lists.partition(axisTestClassGroups, (int)this.getSegmentMaxChildren()));
        }
        return partitionedAxisTestClassGroupsList;
    }

    private List<List<AxisTestClassGroup>> _partitionByMinimumSlaveRAM(List<List<AxisTestClassGroup>> axisTestClassGroupsList) {
        ArrayList<List<AxisTestClassGroup>> partitionedAxisTestClassGroupsList = new ArrayList<List<AxisTestClassGroup>>();
        for (List<AxisTestClassGroup> axisTestClassGroups : axisTestClassGroupsList) {
            HashMap<Integer, ArrayList<AxisTestClassGroup>> axisTestClassGroupsMap = new HashMap<Integer, ArrayList<AxisTestClassGroup>>();
            for (AxisTestClassGroup axisTestClassGroup : axisTestClassGroups) {
                Integer minimumSlaveRAM = axisTestClassGroup.getMinimumSlaveRAM();
                ArrayList<AxisTestClassGroup> minimumSlaveRAMAxisTestClassGroups = (ArrayList<AxisTestClassGroup>)axisTestClassGroupsMap.get(minimumSlaveRAM);
                if (minimumSlaveRAMAxisTestClassGroups == null) {
                    minimumSlaveRAMAxisTestClassGroups = new ArrayList<AxisTestClassGroup>();
                }
                minimumSlaveRAMAxisTestClassGroups.add(axisTestClassGroup);
                axisTestClassGroupsMap.put(minimumSlaveRAM, minimumSlaveRAMAxisTestClassGroups);
            }
            partitionedAxisTestClassGroupsList.addAll(axisTestClassGroupsMap.values());
        }
        return partitionedAxisTestClassGroupsList;
    }

    private List<List<AxisTestClassGroup>> _partitionBySlaveLabel(List<List<AxisTestClassGroup>> axisTestClassGroupsList) {
        ArrayList<List<AxisTestClassGroup>> partitionedAxisTestClassGroupsList = new ArrayList<List<AxisTestClassGroup>>();
        for (List<AxisTestClassGroup> axisTestClassGroups : axisTestClassGroupsList) {
            HashMap<String, ArrayList<AxisTestClassGroup>> axisTestClassGroupsMap = new HashMap<String, ArrayList<AxisTestClassGroup>>();
            for (AxisTestClassGroup axisTestClassGroup : axisTestClassGroups) {
                String slaveLabel = axisTestClassGroup.getSlaveLabel();
                ArrayList<AxisTestClassGroup> slaveLabelAxisTestClassGroups = (ArrayList<AxisTestClassGroup>)axisTestClassGroupsMap.get(slaveLabel);
                if (slaveLabelAxisTestClassGroups == null) {
                    slaveLabelAxisTestClassGroups = new ArrayList<AxisTestClassGroup>();
                }
                slaveLabelAxisTestClassGroups.add(axisTestClassGroup);
                axisTestClassGroupsMap.put(slaveLabel, slaveLabelAxisTestClassGroups);
            }
            partitionedAxisTestClassGroupsList.addAll(axisTestClassGroupsMap.values());
        }
        return partitionedAxisTestClassGroupsList;
    }

    private List<List<AxisTestClassGroup>> _partitionByTestBaseDir(List<List<AxisTestClassGroup>> axisTestClassGroupsList) {
        ArrayList<List<AxisTestClassGroup>> partitionedAxisTestClassGroupsList = new ArrayList<List<AxisTestClassGroup>>();
        for (List<AxisTestClassGroup> axisTestClassGroups : axisTestClassGroupsList) {
            HashMap<File, ArrayList<AxisTestClassGroup>> axisTestClassGroupsMap = new HashMap<File, ArrayList<AxisTestClassGroup>>();
            for (AxisTestClassGroup axisTestClassGroup : axisTestClassGroups) {
                File testBaseDir = axisTestClassGroup.getTestBaseDir();
                ArrayList<AxisTestClassGroup> testBaseDirAxisTestClassGroups = (ArrayList<AxisTestClassGroup>)axisTestClassGroupsMap.get(testBaseDir);
                if (testBaseDirAxisTestClassGroups == null) {
                    testBaseDirAxisTestClassGroups = new ArrayList<AxisTestClassGroup>();
                }
                testBaseDirAxisTestClassGroups.add(axisTestClassGroup);
                axisTestClassGroupsMap.put(testBaseDir, testBaseDirAxisTestClassGroups);
            }
            partitionedAxisTestClassGroupsList.addAll(axisTestClassGroupsMap.values());
        }
        return partitionedAxisTestClassGroupsList;
    }

    private void _setIncludeStableTestSuite() {
        this.includeStableTestSuite = this.testRelevantChanges;
    }

    private void _setTestReleaseBundle() {
        Job job = this.getJob();
        this.testReleaseBundle = job.testReleaseBundle();
    }

    private void _setTestRelevantChanges() {
        Job job = this.getJob();
        this.testRelevantChanges = job.testRelevantChanges();
    }

    private void _setTestRelevantIntegrationUnitOnly() {
        if (this.testRelevantChanges && this.isIntegrationUnitTestFileModifiedOnly()) {
            this.testRelevantIntegrationUnitOnly = true;
            return;
        }
        this.testRelevantIntegrationUnitOnly = false;
    }

    protected static final class CSVReport {
        private List<Row> _csvReportRows = new ArrayList<Row>();

        public CSVReport(Row headerRow) {
            if (headerRow == null) {
                throw new IllegalArgumentException("headerRow is null");
            }
            this._csvReportRows.add(headerRow);
        }

        public void addRow(Row csvReportRow) {
            Row headerRow = this._csvReportRows.get(0);
            if (csvReportRow.size() != headerRow.size()) {
                throw new IllegalArgumentException("Row length does not match headers length");
            }
            this._csvReportRows.add(csvReportRow);
        }

        public String toString() {
            StringBuilder sb = null;
            for (Row csvReportRow : this._csvReportRows) {
                if (sb == null) {
                    sb = new StringBuilder();
                } else {
                    sb.append("\n");
                }
                sb.append(csvReportRow.toString());
            }
            return sb.toString();
        }

        protected static final class Row
        extends ArrayList<String> {
            public Row() {
            }

            public Row(String ... strings) {
                for (String string : strings) {
                    this.add(string);
                }
            }

            @Override
            public String toString() {
                return StringUtils.join(this.iterator(), (String)",");
            }
        }
    }
}

