/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.test.clazz.BaseTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class NPMTestClass
extends BaseTestClass {
    private static final String _TOKEN_CLASS_METHOD_SEPARATOR = "::";
    private static final Pattern _itPattern = Pattern.compile("\\s+(?<xit>x)?it\\s*\\(\\s*\\'(?<description>[\\s\\S]*?)\\'");
    private final GitWorkingDirectory _gitWorkingDirectory;
    private final List<TestClassMethod> _jsTestClassMethods = new ArrayList<TestClassMethod>();
    private final File _moduleFile;

    public List<TestClassMethod> getJSTestClassMethods() {
        return this._jsTestClassMethods;
    }

    protected NPMTestClass(BatchTestClassGroup batchTestClassGroup, File testClassFile) {
        super(batchTestClassGroup, testClassFile);
        this.addTestClassMethod(batchTestClassGroup.getBatchName());
        this._gitWorkingDirectory = batchTestClassGroup.getPortalGitWorkingDirectory();
        this._moduleFile = testClassFile;
        this.initJSTestClassMethods();
    }

    protected NPMTestClass(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        super(batchTestClassGroup, jsonObject);
        this.addTestClassMethod(batchTestClassGroup.getBatchName());
        this._gitWorkingDirectory = batchTestClassGroup.getPortalGitWorkingDirectory();
        this._moduleFile = new File(jsonObject.getString("test_class_file"));
    }

    protected void initJSTestClassMethods() {
        List<File> jsFiles = JenkinsResultsParserUtil.findFiles(this._moduleFile, ".*\\.(js|ts|tsx)");
        String workingDirectoryPath = JenkinsResultsParserUtil.getCanonicalPath(this._gitWorkingDirectory.getWorkingDirectory());
        for (File jsFile : jsFiles) {
            try {
                String jsFileRelativePath = JenkinsResultsParserUtil.getCanonicalPath(jsFile);
                jsFileRelativePath = jsFileRelativePath.replace(workingDirectoryPath, "");
                String jsFileContent = JenkinsResultsParserUtil.read(jsFile);
                Matcher matcher = _itPattern.matcher(jsFileContent);
                while (matcher.find()) {
                    String methodName = matcher.group("description");
                    String xit = matcher.group("xit");
                    boolean methodIgnored = false;
                    if (xit != null) {
                        methodIgnored = true;
                    }
                    this._jsTestClassMethods.add(TestClassFactory.newTestClassMethod(methodIgnored, jsFileRelativePath + _TOKEN_CLASS_METHOD_SEPARATOR + methodName, this));
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
    }
}

