/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.test.clazz.BaseTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.poshi.core.PoshiContext;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class FunctionalTestClass
extends BaseTestClass {
    private static final Pattern _poshiTestCasePattern = Pattern.compile("(?<namespace>[^\\.]+)\\.(?<className>[^\\#]+)\\#(?<methodName>.*)");
    private final Properties _poshiProperties;
    private final String _testClassMethodName;

    @Override
    public int compareTo(TestClass testClass) {
        if (testClass == null) {
            throw new NullPointerException("Test class is null");
        }
        if (!(testClass instanceof FunctionalTestClass)) {
            throw new NullPointerException("Test class is not an instance of FunctionalTestClass");
        }
        FunctionalTestClass functionalTestClass = (FunctionalTestClass)testClass;
        return this._testClassMethodName.compareTo(functionalTestClass.getTestClassMethodName());
    }

    @Override
    public long getAverageDuration() {
        BatchTestClassGroup batchTestClassGroup = this.getBatchTestClassGroup();
        return batchTestClassGroup.getAverageTestDuration(this.getTestClassMethodName());
    }

    @Override
    public long getAverageOverheadDuration() {
        BatchTestClassGroup batchTestClassGroup = this.getBatchTestClassGroup();
        return batchTestClassGroup.getAverageTestOverheadDuration(this.getTestClassMethodName());
    }

    @Override
    public JSONObject getJSONObject() {
        JSONObject jsonObject = super.getJSONObject();
        jsonObject.put("poshi_properties", (Map)this._poshiProperties);
        jsonObject.put("test_class_method_name", (Object)this._testClassMethodName);
        return jsonObject;
    }

    @Override
    public String getName() {
        String name = super.getName();
        String testClassMethodName = this.getTestClassMethodName();
        return JenkinsResultsParserUtil.combine(name.replaceAll("(.+/)[^/]+", "$1"), testClassMethodName.replaceAll("([^\\.]+\\.)?(.*)", "$2"));
    }

    public Properties getPoshiProperties() {
        return this._poshiProperties;
    }

    public String getTestClassMethodName() {
        return this._testClassMethodName;
    }

    protected FunctionalTestClass(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        super(batchTestClassGroup, jsonObject);
        this._testClassMethodName = jsonObject.getString("test_class_method_name");
        this._poshiProperties = new Properties();
        JSONObject poshiPropertiesJSONObject = jsonObject.getJSONObject("poshi_properties");
        if (poshiPropertiesJSONObject == null) {
            return;
        }
        for (String key : poshiPropertiesJSONObject.keySet()) {
            this._poshiProperties.setProperty(key, poshiPropertiesJSONObject.getString(key));
        }
    }

    protected FunctionalTestClass(BatchTestClassGroup batchTestClassGroup, String testClassMethodName) {
        super(batchTestClassGroup, FunctionalTestClass._getTestClassFile(testClassMethodName));
        this.addTestClassMethod(testClassMethodName);
        this._testClassMethodName = testClassMethodName;
        this._poshiProperties = PoshiContext.getNamespacedClassCommandNameProperties((String)this.getTestClassMethodName());
    }

    private static File _getTestClassFile(String testClassMethodName) {
        Matcher matcher = _poshiTestCasePattern.matcher(testClassMethodName);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid test class method name " + testClassMethodName);
        }
        String className = matcher.group("className");
        String namespace = matcher.group("namespace");
        File testClassFile = null;
        try {
            testClassFile = new File(PoshiContext.getFilePathFromFileName((String)(className + ".testcase"), (String)namespace));
        }
        catch (Exception exception) {
            testClassFile = new File(PoshiContext.getFilePathFromFileName((String)(className + ".prose"), (String)namespace));
        }
        return testClassFile;
    }
}

