/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.job.property;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.job.property.DefaultGlobJobProperty;
import com.liferay.jenkins.results.parser.job.property.DefaultJobProperty;
import com.liferay.jenkins.results.parser.job.property.DefaultTestDirProperty;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.job.property.ModuleGlobJobProperty;
import com.liferay.jenkins.results.parser.job.property.ModuleTestDirJobProperty;
import com.liferay.jenkins.results.parser.job.property.PluginTestDirProperty;
import com.liferay.jenkins.results.parser.job.property.QAWebsitesTestDirJobProperty;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class JobPropertyFactory {
    private static final Map<String, JobProperty> _jobProperties = new HashMap<String, JobProperty>();

    public static JobProperty newJobProperty(String basePropertyName, Job job) {
        return JobPropertyFactory.newJobProperty(basePropertyName, null, null, job, null, null, true);
    }

    public static JobProperty newJobProperty(String basePropertyName, Job job, File testBaseDir, JobProperty.Type type) {
        return JobPropertyFactory.newJobProperty(basePropertyName, null, null, job, testBaseDir, type, true);
    }

    public static JobProperty newJobProperty(String basePropertyName, String testSuiteName, String testBatchName, Job job, File testBaseDir, JobProperty.Type type, boolean useBasePropertyName) {
        StringBuilder sb = new StringBuilder();
        sb.append(basePropertyName);
        sb.append("_");
        if (JenkinsResultsParserUtil.isNullOrEmpty(testSuiteName) && job instanceof TestSuiteJob) {
            TestSuiteJob testSuiteJob = (TestSuiteJob)job;
            testSuiteName = testSuiteJob.getTestSuiteName();
        }
        sb.append(testSuiteName);
        sb.append("_");
        sb.append(testBatchName);
        sb.append("_");
        sb.append(job.getJobName());
        if (testBaseDir != null) {
            sb.append("_");
            sb.append(JenkinsResultsParserUtil.getCanonicalPath(testBaseDir));
        }
        if (type == null) {
            type = testBaseDir != null ? JobProperty.Type.DEFAULT_TEST_DIR : JobProperty.Type.DEFAULT;
        }
        sb.append("_");
        sb.append((Object)type);
        sb.append("_");
        sb.append(useBasePropertyName);
        String key = sb.toString();
        JobProperty jobProperty = _jobProperties.get(key);
        if (jobProperty != null) {
            return jobProperty;
        }
        jobProperty = type == JobProperty.Type.DEFAULT_TEST_DIR ? new DefaultTestDirProperty(job, type, testBaseDir, basePropertyName, useBasePropertyName, testSuiteName, testBatchName) : (type == JobProperty.Type.EXCLUDE_GLOB || type == JobProperty.Type.FILTER_GLOB || type == JobProperty.Type.INCLUDE_GLOB ? new DefaultGlobJobProperty(job, type, testBaseDir, basePropertyName, useBasePropertyName, testSuiteName, testBatchName) : (type == JobProperty.Type.MODULE_EXCLUDE_GLOB || type == JobProperty.Type.MODULE_INCLUDE_GLOB ? new ModuleGlobJobProperty(job, type, testBaseDir, basePropertyName, useBasePropertyName, testSuiteName, testBatchName) : (type == JobProperty.Type.MODULE_TEST_DIR ? new ModuleTestDirJobProperty(job, type, testBaseDir, basePropertyName, useBasePropertyName, testSuiteName, testBatchName) : (type == JobProperty.Type.PLUGIN_TEST_DIR ? new PluginTestDirProperty(job, type, testBaseDir, basePropertyName, useBasePropertyName, testSuiteName, testBatchName) : (type == JobProperty.Type.QA_WEBSITES_TEST_DIR ? new QAWebsitesTestDirJobProperty(job, type, testBaseDir, basePropertyName, useBasePropertyName, testSuiteName, testBatchName) : new DefaultJobProperty(job, type, basePropertyName, useBasePropertyName, testSuiteName, testBatchName))))));
        _jobProperties.put(key, jobProperty);
        return _jobProperties.get(key);
    }
}

