/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.DefaultWorkspace;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PluginsWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.SubrepositoryWorkspace;
import com.liferay.jenkins.results.parser.Workspace;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class WorkspaceFactory {
    private static final Map<String, Workspace> _workspaces = new HashMap<String, Workspace>();

    public static Workspace newWorkspace() {
        return WorkspaceFactory.newWorkspace("liferay-jenkins-ee", "master");
    }

    public static Workspace newWorkspace(JSONObject workspaceJSONObject) {
        String primaryRepositoryName = workspaceJSONObject.getString("primary_repository_name");
        String primaryRepositoryDirName = workspaceJSONObject.getString("primary_repository_dir_name");
        if (JenkinsResultsParserUtil.isNullOrEmpty(primaryRepositoryName) || JenkinsResultsParserUtil.isNullOrEmpty(primaryRepositoryDirName)) {
            throw new RuntimeException("Invalid JSONObject");
        }
        Workspace workspace = _workspaces.get(primaryRepositoryDirName);
        if (workspace != null) {
            return workspace;
        }
        workspace = primaryRepositoryName.matches("com-liferay-.*") ? new SubrepositoryWorkspace(workspaceJSONObject) : (primaryRepositoryName.matches("liferay-plugins(-ee)?") ? new PluginsWorkspace(workspaceJSONObject) : (primaryRepositoryName.matches("liferay-portal(-ee)?") ? new PortalWorkspace(workspaceJSONObject) : new DefaultWorkspace(workspaceJSONObject)));
        _workspaces.put(primaryRepositoryDirName, workspace);
        return workspace;
    }

    public static Workspace newWorkspace(String repositoryName, String upstreamBranchName) {
        return WorkspaceFactory.newWorkspace(repositoryName, upstreamBranchName, null);
    }

    public static Workspace newWorkspace(String repositoryName, String upstreamBranchName, String jobName) {
        String gitDirectoryName = JenkinsResultsParserUtil.getGitDirectoryName(repositoryName, upstreamBranchName);
        BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
        Workspace workspace = _workspaces.get(gitDirectoryName);
        if (workspace != null) {
            buildDatabase.putWorkspace(gitDirectoryName, workspace);
            return workspace;
        }
        if (buildDatabase.hasWorkspace(gitDirectoryName)) {
            workspace = buildDatabase.getWorkspace(gitDirectoryName);
            _workspaces.put(gitDirectoryName, workspace);
            return workspace;
        }
        workspace = repositoryName.matches("com-liferay-.*") ? new SubrepositoryWorkspace(repositoryName, upstreamBranchName, jobName) : (repositoryName.matches("liferay-plugins(-ee)?") ? new PluginsWorkspace(repositoryName, upstreamBranchName, jobName) : (repositoryName.matches("liferay-portal(-ee)?") ? new PortalWorkspace(repositoryName, upstreamBranchName, jobName) : new DefaultWorkspace(repositoryName, upstreamBranchName, jobName)));
        _workspaces.put(gitDirectoryName, workspace);
        buildDatabase.putWorkspace(gitDirectoryName, workspace);
        return workspace;
    }
}

