/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.DownstreamBuildReport;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JobReport;
import com.liferay.jenkins.results.parser.PortalBranchInformationBuild;
import com.liferay.jenkins.results.parser.PullRequestSubrepositoryTopLevelBuild;
import com.liferay.jenkins.results.parser.TestReport;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.TopLevelBuildReport;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONObject;

public class UpstreamFailureUtil {
    private static boolean _upstreamComparisonAvailable = true;
    private static final Map<String, List<String>> _upstreamFailures = new HashMap<String, List<String>>();
    private static String _upstreamJobFailuresSHA;
    private static TestrayBuild _upstreamTestrayBuild;
    private static TestrayRoutine _upstreamTestrayRoutine;
    private static TopLevelBuildReport _upstreamTopLevelBuildReport;

    public static int getUpstreamJobFailuresBuildNumber(TopLevelBuild topLevelBuild) {
        TopLevelBuildReport topLevelBuildReport = UpstreamFailureUtil.getUpstreamTopLevelBuildReport(topLevelBuild);
        if (topLevelBuildReport == null) {
            return 0;
        }
        return topLevelBuildReport.getBuildNumber();
    }

    public static int getUpstreamJobFailuresBuildNumber(TopLevelBuild topLevelBuild, String upstreamBranchSHA) {
        TopLevelBuildReport topLevelBuildReport = UpstreamFailureUtil.getUpstreamTopLevelBuildReport(topLevelBuild, upstreamBranchSHA);
        if (topLevelBuildReport == null) {
            return 0;
        }
        return topLevelBuildReport.getBuildNumber();
    }

    public static String getUpstreamJobFailuresSHA(TopLevelBuild topLevelBuild) {
        return UpstreamFailureUtil._getUpstreamJobFailuresSHA(UpstreamFailureUtil.getUpstreamTopLevelBuildReport(topLevelBuild));
    }

    public static TestrayBuild getUpstreamTestrayBuild(TopLevelBuild topLevelBuild) {
        if (_upstreamTestrayBuild != null) {
            return _upstreamTestrayBuild;
        }
        if (!_upstreamComparisonAvailable) {
            return null;
        }
        TestrayRoutine testrayRoutine = UpstreamFailureUtil._getUpstreamTestrayRoutine(topLevelBuild);
        if (testrayRoutine == null || !(topLevelBuild instanceof PortalBranchInformationBuild)) {
            _upstreamComparisonAvailable = false;
            return null;
        }
        String upstreamBranchName = topLevelBuild.getBranchName();
        if (topLevelBuild instanceof PullRequestSubrepositoryTopLevelBuild) {
            PullRequestSubrepositoryTopLevelBuild pullRequestSubrepositoryTopLevelBuild = (PullRequestSubrepositoryTopLevelBuild)topLevelBuild;
            upstreamBranchName = pullRequestSubrepositoryTopLevelBuild.getPortalUpstreamBranchName();
        }
        GitWorkingDirectory gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(upstreamBranchName, (File)null, "liferay-portal");
        for (TestrayBuild testrayBuild : testrayRoutine.getTestrayBuilds()) {
            if (!gitWorkingDirectory.refContainsSHA("HEAD", testrayBuild.getPortalSHA())) continue;
            _upstreamTestrayBuild = testrayBuild;
            TopLevelBuildReport topLevelBuildReport = testrayBuild.getTopLevelBuildReport();
            if (topLevelBuildReport == null) continue;
            System.out.println(JenkinsResultsParserUtil.combine("Comparing with test results from ", String.valueOf(topLevelBuildReport.getBuildURL()), " at SHA ", UpstreamFailureUtil._getUpstreamJobFailuresSHA(topLevelBuildReport)));
            return _upstreamTestrayBuild;
        }
        _upstreamComparisonAvailable = false;
        return null;
    }

    public static TestrayBuild getUpstreamTestrayBuild(TopLevelBuild topLevelBuild, String upstreamBranchSHA) {
        TestrayRoutine testrayRoutine = UpstreamFailureUtil._getUpstreamTestrayRoutine(topLevelBuild);
        if (testrayRoutine == null) {
            return null;
        }
        for (TestrayBuild testrayBuild : testrayRoutine.getTestrayBuilds()) {
            if (!Objects.equals(upstreamBranchSHA, testrayBuild.getPortalSHA())) continue;
            return testrayBuild;
        }
        return null;
    }

    public static TopLevelBuildReport getUpstreamTopLevelBuildReport(TopLevelBuild topLevelBuild) {
        if (_upstreamTopLevelBuildReport != null) {
            return _upstreamTopLevelBuildReport;
        }
        if (!_upstreamComparisonAvailable) {
            return null;
        }
        TestrayBuild upstreamTestrayBuild = UpstreamFailureUtil.getUpstreamTestrayBuild(topLevelBuild);
        if (upstreamTestrayBuild == null) {
            return null;
        }
        _upstreamTopLevelBuildReport = upstreamTestrayBuild.getTopLevelBuildReport();
        return _upstreamTopLevelBuildReport;
    }

    public static TopLevelBuildReport getUpstreamTopLevelBuildReport(TopLevelBuild topLevelBuild, String upstreamBranchSHA) {
        JobReport jobReport = JobReport.getInstance(topLevelBuild.getAcceptanceUpstreamJobURL());
        for (TopLevelBuildReport topLevelBuildReport : jobReport.getTopLevelBuildReports(25)) {
            String portalGitCommit = JenkinsResultsParserUtil.getBuildParameter(String.valueOf(topLevelBuildReport.getBuildURL()), "PORTAL_GIT_COMMIT");
            if (!upstreamBranchSHA.equals(portalGitCommit)) continue;
            return topLevelBuildReport;
        }
        return null;
    }

    public static boolean isBuildFailingInUpstreamJob(Build build) {
        if (!_upstreamComparisonAvailable || !build.isCompareToUpstream()) {
            return false;
        }
        try {
            ArrayList<TestResult> testResults = new ArrayList<TestResult>();
            testResults.addAll(build.getTestResults("FAILED"));
            testResults.addAll(build.getTestResults("REGRESSION"));
            if (testResults.isEmpty()) {
                return UpstreamFailureUtil._isBuildFailingInUpstreamJob(build);
            }
            for (TestResult testResult : testResults) {
                if (!testResult.isUniqueFailure()) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println("Unable to get upstream acceptance failure data.");
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isTestFailingInUpstreamJob(TestResult testResult) {
        Build build = testResult.getBuild();
        if (!_upstreamComparisonAvailable || !build.isCompareToUpstream()) {
            return false;
        }
        TopLevelBuild topLevelBuild = build.getTopLevelBuild();
        try {
            String batchName = UpstreamFailureUtil._getBatchName(build.getJobVariant());
            for (String failure : UpstreamFailureUtil._getUpstreamJobFailures("test", topLevelBuild)) {
                if (!failure.equals(UpstreamFailureUtil._formatUpstreamTestFailure(batchName, testResult.getDisplayName()))) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("Unable to get upstream acceptance failure data.");
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isUpstreamComparisonAvailable(TopLevelBuild topLevelBuild) {
        UpstreamFailureUtil.getUpstreamTopLevelBuildReport(topLevelBuild);
        return _upstreamComparisonAvailable;
    }

    public static void reset() {
        _upstreamComparisonAvailable = true;
        _upstreamJobFailuresSHA = null;
        _upstreamTestrayBuild = null;
        _upstreamTestrayRoutine = null;
        _upstreamTopLevelBuildReport = null;
    }

    public static void resetUpstreamJobFailuresJSONObject() {
        UpstreamFailureUtil.reset();
    }

    private static String _formatUpstreamBuildFailure(String batchName, String testResult) {
        return JenkinsResultsParserUtil.combine(batchName, ",", testResult);
    }

    private static String _formatUpstreamTestFailure(String jobVariant, String testName) {
        return JenkinsResultsParserUtil.combine(testName, ",", jobVariant);
    }

    private static String _getBatchName(String jobVariant) {
        jobVariant = jobVariant.replaceAll("(.*)/.*", "$1");
        return jobVariant.replaceAll("_stable$", "");
    }

    private static List<String> _getUpstreamJobFailures(String type, TopLevelBuild topLevelBuild) {
        if (_upstreamFailures.containsKey(type)) {
            return _upstreamFailures.get(type);
        }
        ArrayList<String> upstreamFailures = new ArrayList<String>();
        _upstreamFailures.put(type, upstreamFailures);
        TopLevelBuildReport topLevelBuildReport = UpstreamFailureUtil.getUpstreamTopLevelBuildReport(topLevelBuild);
        if (topLevelBuildReport == null) {
            return upstreamFailures;
        }
        for (DownstreamBuildReport downstreamBuildReport : topLevelBuildReport.getDownstreamBuildReports()) {
            String result = downstreamBuildReport.getResult();
            if (!result.equals("FAILURE") && !result.equals("REGRESSION") && !result.equals("UNSTABLE")) continue;
            String batchName = UpstreamFailureUtil._getBatchName(downstreamBuildReport.getBatchName());
            if (type.equals("build")) {
                upstreamFailures.add(UpstreamFailureUtil._formatUpstreamBuildFailure(batchName, result));
                continue;
            }
            if (!type.equals("test")) continue;
            for (TestReport testReport : downstreamBuildReport.getTestReports()) {
                upstreamFailures.add(UpstreamFailureUtil._formatUpstreamTestFailure(batchName, testReport.getTestName()));
            }
        }
        return upstreamFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _getUpstreamJobFailuresSHA(TopLevelBuildReport upstreamTopLevelBuildReport) {
        if (!JenkinsResultsParserUtil.isNullOrEmpty(_upstreamJobFailuresSHA)) {
            return _upstreamJobFailuresSHA;
        }
        if (upstreamTopLevelBuildReport == null) {
            System.out.println("Unable to get upstream acceptance failure data");
            _upstreamJobFailuresSHA = "";
            return _upstreamJobFailuresSHA;
        }
        Map<String, String> buildParameters = upstreamTopLevelBuildReport.getBuildParameters();
        _upstreamJobFailuresSHA = buildParameters.get("PORTAL_GIT_COMMIT");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(_upstreamJobFailuresSHA)) {
            return _upstreamJobFailuresSHA;
        }
        _upstreamJobFailuresSHA = JenkinsResultsParserUtil.getBuildParameter(String.valueOf(upstreamTopLevelBuildReport.getBuildURL()), "PORTAL_GIT_COMMIT");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(_upstreamJobFailuresSHA)) {
            return _upstreamJobFailuresSHA;
        }
        File testResultsJSONFile = new File(System.getenv("WORKSPACE"), "test.results.json");
        try {
            JenkinsResultsParserUtil.toFile(upstreamTopLevelBuildReport.getTestResultsJSONUserContentURL(), testResultsJSONFile);
            JSONObject upstreamJobFailuresJSONObject = new JSONObject(JenkinsResultsParserUtil.read(testResultsJSONFile));
            String string = _upstreamJobFailuresSHA = upstreamJobFailuresJSONObject.getString("SHA");
            return string;
        }
        catch (Exception exception) {
            System.out.println("Unable to get upstream acceptance failure data");
            String string = _upstreamJobFailuresSHA = "";
            return string;
        }
        finally {
            if (testResultsJSONFile.exists()) {
                JenkinsResultsParserUtil.delete(testResultsJSONFile);
            }
        }
    }

    private static TestrayRoutine _getUpstreamTestrayRoutine(TopLevelBuild topLevelBuild) {
        if (_upstreamTestrayRoutine != null) {
            return _upstreamTestrayRoutine;
        }
        if (!(topLevelBuild instanceof PortalBranchInformationBuild)) {
            return null;
        }
        PortalBranchInformationBuild portalBranchInformationBuild = (PortalBranchInformationBuild)((Object)topLevelBuild);
        Build.BranchInformation branchInformation = portalBranchInformationBuild.getPortalBranchInformation();
        try {
            _upstreamTestrayRoutine = TestrayFactory.newTestrayRoutine(JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "test.history.routine.url", branchInformation.getUpstreamBranchName()));
            return _upstreamTestrayRoutine;
        }
        catch (IOException ioException) {
            return null;
        }
    }

    private static boolean _isBuildFailingInUpstreamJob(Build build) {
        String jobVariant = build.getJobVariant();
        if (jobVariant == null) {
            return false;
        }
        String result = build.getResult();
        if (result == null) {
            return false;
        }
        String batchName = UpstreamFailureUtil._getBatchName(jobVariant);
        TopLevelBuild topLevelBuild = build.getTopLevelBuild();
        for (String upstreamJobFailure : UpstreamFailureUtil._getUpstreamJobFailures("build", topLevelBuild)) {
            if (!upstreamJobFailure.equals(UpstreamFailureUtil._formatUpstreamBuildFailure(batchName, result))) continue;
            return true;
        }
        return false;
    }
}

