/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseTopLevelBuildReport;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JobReport;
import com.liferay.jenkins.results.parser.testray.TestrayS3Object;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public class URLTopLevelBuildReport
extends BaseTopLevelBuildReport {
    private File _jenkinsConsoleLocalFile;

    @Override
    public JSONObject getBuildReportJSONObject() {
        TestrayS3Object buildResultTestrayS3Object;
        TestrayS3Object buildReportTestrayS3Object;
        if (this.buildReportJSONObject != null) {
            return this.buildReportJSONObject;
        }
        this.buildReportJSONObject = this.getJSONObjectFromURL(this.getBuildReportJSONUserContentURL());
        if (this.buildReportJSONObject == null) {
            this.buildReportJSONObject = this.getJSONObjectFromURL(this.getBuildReportJSONTestrayURL());
        }
        if (this.buildReportJSONObject == null && (buildReportTestrayS3Object = this.getBuildReportTestrayS3Object()) != null) {
            this.buildReportJSONObject = new JSONObject(buildReportTestrayS3Object.getValue());
        }
        if (this.buildReportJSONObject == null) {
            this.buildReportJSONObject = this.getBuildReportJSONObject(this.getJSONObjectFromURL(this.getBuildResultJSONTestrayURL()));
        }
        if (this.buildReportJSONObject == null && (buildResultTestrayS3Object = this.getBuildResultTestrayS3Object()) != null) {
            this.buildReportJSONObject = this.getBuildReportJSONObject(new JSONObject(buildResultTestrayS3Object.getValue()));
        }
        this._addTestResultsFromBuildResults();
        return this.buildReportJSONObject;
    }

    protected URLTopLevelBuildReport(JSONObject buildJSONObject, JobReport jobReport) {
        super(buildJSONObject, jobReport);
    }

    protected URLTopLevelBuildReport(URL buildURL) {
        super(buildURL);
    }

    @Override
    protected File getJenkinsConsoleLocalFile() {
        if (this._jenkinsConsoleLocalFile != null) {
            return this._jenkinsConsoleLocalFile;
        }
        JobReport jobReport = this.getJobReport();
        JenkinsMaster jenkinsMaster = jobReport.getJenkinsMaster();
        try {
            URL jenkinsConsoleURL = new URL(JenkinsResultsParserUtil.combine("https://testray.liferay.com/reports/production/logs/", this.getStartYearMonth(), "/", jenkinsMaster.getName(), "/", jobReport.getJobName(), "/", String.valueOf(this.getBuildNumber()), "/jenkins-console.txt.gz"));
            File jenkinsConsoleLocalGzipFile = new File(System.getenv("WORKSPACE"), JenkinsResultsParserUtil.getDistinctTimeStamp() + ".gz");
            JenkinsResultsParserUtil.toFile(jenkinsConsoleURL, jenkinsConsoleLocalGzipFile);
            File jenkinsConsoleLocalFile = new File(System.getenv("WORKSPACE"), JenkinsResultsParserUtil.getDistinctTimeStamp());
            JenkinsResultsParserUtil.unGzip(jenkinsConsoleLocalGzipFile, jenkinsConsoleLocalFile);
            this._jenkinsConsoleLocalFile = jenkinsConsoleLocalFile;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return this._jenkinsConsoleLocalFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject getJSONObjectFromURL(URL url) {
        if (!JenkinsResultsParserUtil.exists(url)) {
            return null;
        }
        String urlString = String.valueOf(url);
        if (!urlString.endsWith(".gz")) {
            try {
                return JenkinsResultsParserUtil.toJSONObject(urlString);
            }
            catch (IOException ioException) {
                return null;
            }
        }
        File file = new File(System.getenv("WORKSPACE"), JenkinsResultsParserUtil.getDistinctTimeStamp() + ".gz");
        try {
            JenkinsResultsParserUtil.toFile(url, file);
            String fileContent = JenkinsResultsParserUtil.read(file);
            if (JenkinsResultsParserUtil.isNullOrEmpty(fileContent)) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject jSONObject = new JSONObject(fileContent);
            return jSONObject;
        }
        catch (Exception exception) {
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            if (file.exists()) {
                JenkinsResultsParserUtil.delete(file);
            }
        }
    }

    private void _addTestResultsFromBuildResults() {
        JSONObject buildReportJSONObject = this.getBuildReportJSONObject();
        if (buildReportJSONObject == null) {
            return;
        }
        Map<String, List<JSONObject>> testResultsJSONObjectsMap = this._getTestResultsJSONObjectsMap();
        if (testResultsJSONObjectsMap.isEmpty()) {
            return;
        }
        JSONArray batchesJSONArray = buildReportJSONObject.getJSONArray("batches");
        for (int i = 0; i < batchesJSONArray.length(); ++i) {
            JSONObject batchJSONObject = batchesJSONArray.getJSONObject(i);
            List<JSONObject> testResultsJSONObjects = testResultsJSONObjectsMap.get(batchJSONObject.getString("batchName"));
            JSONArray buildsJSONArray = batchJSONObject.getJSONArray("builds");
            for (int j = 0; j < buildsJSONArray.length(); ++j) {
                JSONObject buildJSONObject = buildsJSONArray.getJSONObject(j);
                for (JSONObject testResultJSONObject : testResultsJSONObjects) {
                    if (!Objects.equals(buildJSONObject.getString("buildURL"), testResultJSONObject.getString("buildURL"))) continue;
                    JSONArray testResultsJSONArray = buildJSONObject.getJSONArray("testResults");
                    if (testResultsJSONArray == null) {
                        testResultsJSONArray = new JSONArray();
                    }
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("duration", testResultJSONObject.get("duration"));
                    jsonObject.put("errorDetails", testResultJSONObject.opt("errorDetails"));
                    jsonObject.put("name", testResultJSONObject.get("name"));
                    jsonObject.put("status", testResultJSONObject.get("status"));
                    testResultsJSONArray.put((Object)jsonObject);
                }
            }
        }
    }

    private Map<String, List<JSONObject>> _getTestResultsJSONObjectsMap() {
        HashMap<String, List<JSONObject>> testResultsJSONObjectsMap = new HashMap<String, List<JSONObject>>();
        JSONObject buildResultJSONObject = this.getJSONObjectFromURL(this.getBuildResultJSONUserContentURL());
        if (buildResultJSONObject == null) {
            return testResultsJSONObjectsMap;
        }
        JSONArray batchResultsJSONArray = buildResultJSONObject.getJSONArray("batchResults");
        for (int i = 0; i < batchResultsJSONArray.length(); ++i) {
            JSONObject batchResultJSONObject = batchResultsJSONArray.getJSONObject(i);
            String batchName = batchResultJSONObject.getString("jobVariant");
            ArrayList<JSONObject> testResultsJSONObjects = (ArrayList<JSONObject>)testResultsJSONObjectsMap.get(batchName = batchName.replaceAll("([^/]+)/.*", "$1"));
            if (testResultsJSONObjects == null) {
                testResultsJSONObjects = new ArrayList<JSONObject>();
            }
            JSONArray testResultsJSONArray = batchResultJSONObject.getJSONArray("testResults");
            for (int j = 0; j < testResultsJSONArray.length(); ++j) {
                testResultsJSONObjects.add(testResultsJSONArray.getJSONObject(j));
            }
            testResultsJSONObjectsMap.put(batchName, testResultsJSONObjects);
        }
        return testResultsJSONObjectsMap;
    }
}

