/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.CIJobSummaryReportUtil;
import com.liferay.jenkins.results.parser.DatagramRequestUtil;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.SlaveOfflineRule;
import com.liferay.jenkins.results.parser.StatsDMetricsUtil;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuildReport;
import com.liferay.jenkins.results.parser.UpstreamFailureUtil;
import com.liferay.jenkins.results.parser.ValidationBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceBuild;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import com.liferay.jenkins.results.parser.failure.message.generator.CIFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.CITestSuiteValidationFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.CompileFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.DownstreamFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.FormatFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GenericFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GitLPushFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GradleTaskFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.InvalidGitCommitSHAFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.InvalidSenderSHAFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.JenkinsRegenFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.JenkinsSourceFormatFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PoshiTestFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PoshiValidationFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.RebaseFailureMessageGenerator;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class TopLevelBuild
extends BaseBuild {
    protected static final Pattern gitRepositoryTempMapNamePattern = Pattern.compile("git\\.(?<gitRepositoryType>.*)\\.properties");
    private static final FailureMessageGenerator[] _FAILURE_MESSAGE_GENERATORS = new FailureMessageGenerator[]{new CITestSuiteValidationFailureMessageGenerator(), new CompileFailureMessageGenerator(), new FormatFailureMessageGenerator(), new GitLPushFailureMessageGenerator(), new JenkinsRegenFailureMessageGenerator(), new JenkinsSourceFormatFailureMessageGenerator(), new InvalidGitCommitSHAFailureMessageGenerator(), new InvalidSenderSHAFailureMessageGenerator(), new RebaseFailureMessageGenerator(), new PoshiValidationFailureMessageGenerator(), new PoshiTestFailureMessageGenerator(), new GradleTaskFailureMessageGenerator(), new DownstreamFailureMessageGenerator(), new CIFailureMessageGenerator(), new GenericFailureMessageGenerator()};
    private static final int _MAX_JOB_SUMMARY_LIST_SIZE = 500;
    private static final long _MILLIS_DOWNSTREAM_BUILDS_LISTING_INTERVAL = 300000L;
    private static final String _URL_CHART_JS = "https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.5.0/Chart.min.js";
    private static final String _URL_CI_SYSTEM_STATUS = "http://test-1-0.liferay.com/userContent/reports/ci-system-status/index.html";
    private static final Pattern _downstreamBuildURLPattern = Pattern.compile("[\\'\\\"](?<jobVariant>[^\\'\\\"]+)[\\'\\\"] (completed|started) at (?<url>.+/job/(?<jobName>[^/]+)/.+)\\.");
    private static final ExecutorService _executorService = JenkinsResultsParserUtil.getNewThreadPoolExecutor(10, true);
    private boolean _compareToUpstream;
    private Build _controllerBuild;
    private final Map<String, AxisBuild> _downstreamAxisBuilds = new ConcurrentHashMap<String, AxisBuild>();
    private boolean _downstreamAxisBuildsPopulated;
    private final Map<String, BatchBuild> _downstreamBatchBuilds = new ConcurrentHashMap<String, BatchBuild>();
    private boolean _downstreamBatchBuildsPopulated;
    private long _lastDownstreamBuildsListingTimestamp = -1L;
    private String _metricsHostName;
    private int _metricsHostPort;
    private final boolean _sendBuildMetrics;
    private long _updateDuration;

    @Override
    public void addDownstreamBuilds(String ... urls) {
        super.addDownstreamBuilds(urls);
        if (this.getDownstreamBuildCount("completed") < this.getDownstreamBuildCount(null)) {
            this.setResult(null);
        }
    }

    @Override
    public void addTimelineData(BaseBuild.TimelineData timelineData) {
        timelineData.addTimelineData(this);
        if (this.getTopLevelBuild() == this) {
            this.addDownstreamBuildsTimelineData(timelineData);
        }
    }

    public String getAcceptanceUpstreamJobName() {
        String jobName = this.getJobName();
        if (jobName.contains("pullrequest")) {
            String branchName = this.getBranchName();
            if (branchName.startsWith("ee-")) {
                return jobName.replace("pullrequest", "upstream");
            }
            return jobName.replace("pullrequest", "upstream-dxp");
        }
        return "";
    }

    public String getAcceptanceUpstreamJobURL() {
        String jobName = this.getJobName();
        if (jobName.contains("pullrequest")) {
            String acceptanceUpstreamJobURL = JenkinsResultsParserUtil.combine("https://test-1-1.liferay.com/job/", this.getAcceptanceUpstreamJobName());
            try {
                JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(acceptanceUpstreamJobURL), false, 0, 0, 0);
            }
            catch (IOException ioException) {
                return null;
            }
            return acceptanceUpstreamJobURL;
        }
        return null;
    }

    @Override
    public List<Callable<Object>> getArchiveCallables() {
        List<Callable<Object>> archiveCallables = super.getArchiveCallables();
        archiveCallables.add(new Callable<Object>(){

            @Override
            public Object call() {
                TopLevelBuild.this._archiveBuildDatabase();
                return null;
            }
        });
        archiveCallables.add(new Callable<Object>(){

            @Override
            public Object call() {
                TopLevelBuild.this._archiveJenkinsReport();
                return null;
            }
        });
        archiveCallables.add(new Callable<Object>(){

            @Override
            public Object call() {
                TopLevelBuild.this._archiveProperties();
                return null;
            }
        });
        return archiveCallables;
    }

    @Override
    public URL getArtifactsBaseURL() {
        StringBuilder sb = new StringBuilder();
        try {
            URL buildBaseArtifactURL = new URL(JenkinsResultsParserUtil.getBuildProperty("build.base.artifact.url"));
            sb.append(buildBaseArtifactURL);
        }
        catch (IOException ioException) {
            return null;
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        sb.append("/");
        sb.append(JenkinsResultsParserUtil.toDateString(new Date(topLevelBuild.getStartTime()), "yyyy-MM", "America/Los_Angeles"));
        JenkinsMaster jenkinsMaster = topLevelBuild.getJenkinsMaster();
        sb.append("/");
        sb.append(jenkinsMaster.getName());
        sb.append("/");
        sb.append(topLevelBuild.getJobName());
        sb.append("/");
        sb.append(topLevelBuild.getBuildNumber());
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Map<String, String> getBaseGitRepositoryDetailsTempMap() {
        String gitRepositoryType = this.getBaseGitRepositoryType();
        String tempMapName = "git." + gitRepositoryType + ".properties";
        return this.getTempMap(tempMapName);
    }

    @Override
    public JSONObject getBuildResultsJSONObject(String[] buildResults, String[] testStatuses, String[] dataTypes) {
        StopWatchRecordsGroup stopWatchRecordsGroup;
        JSONArray stopWatchRecordsGroupJSONArray;
        if (dataTypes == null) {
            dataTypes = new String[]{"name", "status"};
        }
        List<String> dataTypesList = Arrays.asList(dataTypes);
        JSONObject buildResultsJSONObject = new JSONObject();
        JSONArray downstreamBuildJSONArray = new JSONArray();
        List<Object> buildResultsList = Collections.emptyList();
        if (buildResults != null) {
            buildResultsList = Arrays.asList(buildResults);
        }
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            if (!buildResultsList.isEmpty() && !buildResultsList.contains(downstreamBuild.getResult())) continue;
            downstreamBuildJSONArray.put((Object)downstreamBuild.getBuildResultsJSONObject(buildResults, testStatuses, dataTypes));
        }
        buildResultsJSONObject.put("batchResults", (Object)downstreamBuildJSONArray);
        buildResultsJSONObject.put("buildNumber", this.getBuildNumber());
        if (dataTypesList.contains("duration")) {
            buildResultsJSONObject.put("duration", this.getDuration());
        }
        buildResultsJSONObject.put("jobURL", (Object)this.getJobURL());
        buildResultsJSONObject.put("result", (Object)this.getResult());
        buildResultsJSONObject.put("startTime", (Object)this.getStartTime());
        if (dataTypesList.contains("stopWatchRecords") && (stopWatchRecordsGroupJSONArray = (stopWatchRecordsGroup = this.getStopWatchRecordsGroup()).getJSONArray()).length() > 0) {
            buildResultsJSONObject.put("stopWatchRecords", (Object)stopWatchRecordsGroupJSONArray);
        }
        buildResultsJSONObject.put("testSuiteName", (Object)this.getTestSuiteName());
        buildResultsJSONObject.put("upstreamBranchSHA", (Object)this.getUpstreamBranchSHA());
        return buildResultsJSONObject;
    }

    public Build getControllerBuild() {
        if (this._controllerBuild != null) {
            return this._controllerBuild;
        }
        String controllerBuildURL = this.getParameterValue("CONTROLLER_BUILD_URL");
        if (controllerBuildURL == null || !controllerBuildURL.matches("https?://.*")) {
            return null;
        }
        this._controllerBuild = BuildFactory.newBuild(controllerBuildURL, null);
        return this._controllerBuild;
    }

    @Override
    public String getDisplayName() {
        StringBuilder sb = new StringBuilder(super.getDisplayName());
        String jenkinsJobVariant = this.getParameterValue("JENKINS_JOB_VARIANT");
        if (this.getParentBuild() != null && jenkinsJobVariant != null && !jenkinsJobVariant.isEmpty()) {
            sb.append("/");
            sb.append(jenkinsJobVariant);
        }
        return sb.toString();
    }

    public AxisBuild getDownstreamAxisBuild(String axisName) {
        AxisBuild targetAxisBuild = this._downstreamAxisBuilds.get(axisName);
        if (targetAxisBuild != null) {
            return targetAxisBuild;
        }
        for (AxisBuild axisBuild : this.getDownstreamAxisBuilds()) {
            if (!axisName.equals(axisBuild.getAxisName())) continue;
            return axisBuild;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AxisBuild> getDownstreamAxisBuilds() {
        if (this._downstreamAxisBuildsPopulated && !this._downstreamAxisBuilds.isEmpty()) {
            ArrayList<AxisBuild> downstreamAxisBuilds = new ArrayList<AxisBuild>(this._downstreamAxisBuilds.values());
            Collections.sort(downstreamAxisBuilds, new BaseBuild.BuildDisplayNameComparator());
            return downstreamAxisBuilds;
        }
        ArrayList<AxisBuild> downstreamAxisBuilds = new ArrayList<AxisBuild>();
        for (BatchBuild downstreamBatchBuild : this.getDownstreamBatchBuilds()) {
            downstreamAxisBuilds.addAll(downstreamBatchBuild.getDownstreamAxisBuilds());
        }
        Map<String, AxisBuild> map = this._downstreamAxisBuilds;
        synchronized (map) {
            if (this.isCompleted() && !this._downstreamAxisBuildsPopulated) {
                for (AxisBuild downstreamAxisBuild : downstreamAxisBuilds) {
                    this._downstreamAxisBuilds.put(downstreamAxisBuild.getAxisName(), downstreamAxisBuild);
                }
                this._downstreamAxisBuildsPopulated = true;
            }
        }
        Collections.sort(downstreamAxisBuilds, new BaseBuild.BuildDisplayNameComparator());
        return downstreamAxisBuilds;
    }

    public BatchBuild getDownstreamBatchBuild(String jobVariant) {
        BatchBuild targetBatchBuild = this._downstreamBatchBuilds.get(jobVariant);
        if (targetBatchBuild != null) {
            return targetBatchBuild;
        }
        for (BatchBuild batchBuild : this.getDownstreamBatchBuilds()) {
            if (!jobVariant.equals(batchBuild.getJobVariant())) continue;
            return batchBuild;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BatchBuild> getDownstreamBatchBuilds() {
        if (this._downstreamBatchBuildsPopulated && !this._downstreamBatchBuilds.isEmpty()) {
            ArrayList<BatchBuild> downstreamBatchBuilds = new ArrayList<BatchBuild>(this._downstreamBatchBuilds.values());
            Collections.sort(downstreamBatchBuilds, new BaseBuild.BuildDisplayNameComparator());
            return downstreamBatchBuilds;
        }
        ArrayList<BatchBuild> downstreamBatchBuilds = new ArrayList<BatchBuild>();
        List<Build> downstreamBuilds = this.getDownstreamBuilds(null);
        for (Build downstreamBuild : downstreamBuilds) {
            if (!(downstreamBuild instanceof BatchBuild)) continue;
            downstreamBatchBuilds.add((BatchBuild)downstreamBuild);
        }
        Map<String, BatchBuild> map = this._downstreamBatchBuilds;
        synchronized (map) {
            if (this.isCompleted() && !this._downstreamBatchBuildsPopulated) {
                for (BatchBuild downstreamBatchBuild : downstreamBatchBuilds) {
                    String jobVariant = downstreamBatchBuild.getJobVariant();
                    if (JenkinsResultsParserUtil.isNullOrEmpty(jobVariant)) continue;
                    this._downstreamBatchBuilds.put(jobVariant, downstreamBatchBuild);
                }
                this._downstreamBatchBuildsPopulated = true;
            }
        }
        Collections.sort(downstreamBatchBuilds, new BaseBuild.BuildDisplayNameComparator());
        return downstreamBatchBuilds;
    }

    public DownstreamBuild getDownstreamBuild(String axisName) {
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            String downstreamAxisVariable;
            String downstreamAxisName = downstreamBuild.getParameterValue("JOB_VARIANT");
            if (JenkinsResultsParserUtil.isNullOrEmpty(downstreamAxisName) || JenkinsResultsParserUtil.isNullOrEmpty(downstreamAxisVariable = downstreamBuild.getParameterValue("AXIS_VARIABLE")) || !axisName.equals(downstreamAxisName = downstreamAxisName + "/" + downstreamAxisVariable) || !(downstreamBuild instanceof DownstreamBuild)) continue;
            return (DownstreamBuild)downstreamBuild;
        }
        return null;
    }

    @Override
    public Element getGitHubMessageElement() {
        Collections.sort(this.downstreamBuilds, new BaseBuild.BuildDisplayNameComparator());
        if (this.getParentBuild() == null) {
            return this.getTopGitHubMessageElement();
        }
        return super.getGitHubMessageElement();
    }

    public String getJenkinsReport() {
        try {
            return JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(this.getJenkinsReportURL()));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get Jenkins report", ioException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Element getJenkinsReportElement() {
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        try {
            Element element = Dom4JUtil.getNewElement("html", null, this.getJenkinsReportHeadElement(), this.getJenkinsReportBodyElement());
            return element;
        }
        finally {
            String duration = JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start);
            System.out.println("Jenkins reported generated in " + duration);
        }
    }

    public String getJenkinsReportURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/jenkins-report.html";
        }
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        return JenkinsResultsParserUtil.combine("https://", jenkinsMaster.getName(), ".liferay.com/", "userContent/jobs/", this.getJobName(), "/builds/", String.valueOf(this.getBuildNumber()), "/jenkins-report.html");
    }

    public File getJobSummaryDir() {
        File jobSummaryDir = new File(this.getBuildDirPath(), "job-summary");
        if (!jobSummaryDir.exists()) {
            try {
                CIJobSummaryReportUtil.writeJobSummaryReport(jobSummaryDir, this.getJob());
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        return jobSummaryDir;
    }

    @Override
    public Map<String, String> getMetricLabels() {
        TreeMap<String, String> metricLabels = new TreeMap<String, String>();
        metricLabels.put("job_type", "top-level");
        metricLabels.put("top_level_job_name", this.getJobName());
        return metricLabels;
    }

    public List<String> getProjectNames() {
        return Collections.emptyList();
    }

    @Override
    public String getResult() {
        if (this.result == null && this.getBuildURL() != null) {
            JSONObject buildJSONObject = this.getBuildJSONObject("result");
            String result = buildJSONObject.optString("result");
            if (JenkinsResultsParserUtil.isNullOrEmpty(result)) {
                result = null;
            }
            this.setResult(result);
        }
        return this.result;
    }

    @Override
    public String getStatusSummary() {
        long currentTimeMillis = JenkinsResultsParserUtil.getCurrentTimeMillis();
        if (currentTimeMillis - 300000L >= this._lastDownstreamBuildsListingTimestamp) {
            StringBuilder sb = new StringBuilder(super.getStatusSummary());
            sb.append("\nRunning Builds: ");
            this._lastDownstreamBuildsListingTimestamp = JenkinsResultsParserUtil.getCurrentTimeMillis();
            for (Build downstreamBuild : this.getDownstreamBuilds("running")) {
                sb.append("\n");
                sb.append(downstreamBuild.getBuildURL());
            }
            return sb.toString();
        }
        return super.getStatusSummary();
    }

    @Override
    public JSONObject getTestReportJSONObject(boolean cache) {
        return null;
    }

    @Override
    public String getTestSuiteName() {
        String testSuiteName = this.getParameterValue("CI_TEST_SUITE");
        if (testSuiteName == null) {
            testSuiteName = "default";
        }
        return testSuiteName;
    }

    public BaseBuild.TimelineData getTimelineData() {
        return new BaseBuild.TimelineData(500, this);
    }

    public URL getUserContentURL() {
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        try {
            return new URL(JenkinsResultsParserUtil.combine("https://", jenkinsMaster.getName(), ".liferay.com/userContent/jobs/", this.getJobName(), "/builds/", String.valueOf(this.getBuildNumber())));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public Element getValidationGitHubMessageElement() {
        ValidationBuild validationBuild = null;
        for (Build downstreamBuild : this.downstreamBuilds) {
            if (!(downstreamBuild instanceof ValidationBuild)) continue;
            validationBuild = (ValidationBuild)downstreamBuild;
        }
        if (validationBuild == null) {
            throw new RuntimeException("Unable to find a validation build");
        }
        return validationBuild.getGitHubMessageElement();
    }

    @Override
    public boolean isCompareToUpstream() {
        return this._compareToUpstream;
    }

    @Override
    public boolean isFromCompletedBuild() {
        Build parentBuild = this.getParentBuild();
        if (parentBuild != null) {
            return parentBuild.isFromCompletedBuild();
        }
        String consoleText = this.getConsoleText();
        return consoleText.contains("stop-current-job:") || consoleText.contains("com.liferay.jenkins.results.parser.BuildLauncher teardown");
    }

    @Override
    public boolean isUniqueFailure() {
        return true;
    }

    @Override
    public void setCompareToUpstream(boolean compareToUpstream) {
        this._compareToUpstream = compareToUpstream;
    }

    @Override
    public void takeSlaveOffline(SlaveOfflineRule slaveOfflineRule) {
    }

    @Override
    public synchronized void update() {
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        super.update();
        this._updateDuration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
        if (this._sendBuildMetrics && !this.fromArchive && this.getParentBuild() == null) {
            if (!this.fromCompletedBuild) {
                this.sendBuildMetricsOnModifiedBuilds();
            } else {
                this.sendBuildMetrics(StatsDMetricsUtil.generateGaugeDeltaMetric("build_slave_usage_gauge", -1, this.getMetricLabels()));
            }
        }
    }

    protected TopLevelBuild(String url) {
        this(url, null);
    }

    protected TopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build.properties", ioException);
        }
        this._sendBuildMetrics = Boolean.valueOf(buildProperties.getProperty("build.metrics.send"));
        if (this._sendBuildMetrics) {
            this._metricsHostName = buildProperties.getProperty("build.metrics.host.name");
            String metricsHostPortString = buildProperties.getProperty("build.metrics.host.port");
            if (this._metricsHostName == null || metricsHostPortString == null) {
                throw new IllegalArgumentException("Properties \"build.metrics.host.name\" and \"build.metrics.host.port\" must be set to send build metrics");
            }
            try {
                this._metricsHostPort = Integer.parseInt(metricsHostPortString);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Please set \"build.metrics.host.port\" to an integer");
            }
            if (topLevelBuild == null) {
                this.sendBuildMetrics(StatsDMetricsUtil.generateGaugeDeltaMetric("build_slave_usage_gauge", 1, this.getMetricLabels()));
            }
        }
    }

    @Override
    protected void findDownstreamBuilds() {
        if (this.getParentBuild() != null) {
            return;
        }
        super.findDownstreamBuilds();
        this._findDownstreamBuildsInConsoleText();
        String consoleText = this.getConsoleText();
        for (Build downstreamBuild : this.downstreamBuilds) {
            BaseBuild downstreamBaseBuild = (BaseBuild)downstreamBuild;
            downstreamBaseBuild.checkForReinvocation(consoleText);
        }
    }

    protected Element getBaseBranchDetailsElement() {
        String baseBranchURL = JenkinsResultsParserUtil.combine("https://github.com/liferay/", this.getBaseGitRepositoryName(), "/tree/", this.getBranchName());
        String baseGitRepositoryName = this.getBaseGitRepositoryName();
        String baseGitRepositorySHA = null;
        if (this instanceof WorkspaceBuild && !this.fromArchive) {
            WorkspaceBuild workspaceBuild = (WorkspaceBuild)((Object)this);
            Workspace workspace = workspaceBuild.getWorkspace();
            WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
            baseGitRepositorySHA = workspaceGitRepository.getBaseBranchSHA();
        } else {
            baseGitRepositorySHA = !baseGitRepositoryName.equals("liferay-jenkins-ee") && baseGitRepositoryName.endsWith("-ee") ? this.getBaseGitRepositorySHA(baseGitRepositoryName.substring(0, baseGitRepositoryName.length() - 3)) : this.getBaseGitRepositorySHA(baseGitRepositoryName);
        }
        Element baseGitBranchDetailsElement = Dom4JUtil.getNewElement("p", null, "Branch Name: ", Dom4JUtil.getNewAnchorElement(baseBranchURL, this.getBranchName()));
        if (baseGitRepositorySHA != null) {
            String baseGitRepositoryCommitURL = "https://github.com/liferay/" + baseGitRepositoryName + "/commit/" + baseGitRepositorySHA;
            Dom4JUtil.addToElement(baseGitBranchDetailsElement, Dom4JUtil.getNewElement("br"), "Branch GIT ID: ", Dom4JUtil.getNewAnchorElement(baseGitRepositoryCommitURL, baseGitRepositorySHA));
        }
        return baseGitBranchDetailsElement;
    }

    protected Element[] getBuildFailureElements() {
        Map<Build, Element> downstreamBuildFailureMessages = this.getDownstreamBuildMessages(this.getFailedDownstreamBuilds());
        ArrayList<Element> allCurrentBuildFailureElements = new ArrayList<Element>();
        ArrayList<Element> upstreamBuildFailureElements = new ArrayList<Element>();
        int maxFailureCount = 5;
        for (Map.Entry<Build, Element> entry : downstreamBuildFailureMessages.entrySet()) {
            Element upstreamJobFailureElement;
            Build failedDownstreamBuild = entry.getKey();
            Element failureElement = entry.getValue();
            if (failureElement != null) {
                if (!failedDownstreamBuild.isUniqueFailure()) {
                    upstreamBuildFailureElements.add(failureElement);
                    continue;
                }
                if (TopLevelBuild.isHighPriorityBuildFailureElement(failureElement)) {
                    allCurrentBuildFailureElements.add(0, failureElement);
                    continue;
                }
                allCurrentBuildFailureElements.add(failureElement);
            }
            if ((upstreamJobFailureElement = failedDownstreamBuild.getGitHubMessageUpstreamJobFailureElement()) == null) continue;
            upstreamBuildFailureElements.add(upstreamJobFailureElement);
        }
        ArrayList<Element> buildFailureElements = new ArrayList<Element>();
        buildFailureElements.add(Dom4JUtil.getNewElement("hr"));
        if (allCurrentBuildFailureElements.isEmpty() && upstreamBuildFailureElements.isEmpty()) {
            allCurrentBuildFailureElements.add(0, super.getGitHubMessageElement());
        }
        if (allCurrentBuildFailureElements.isEmpty() && !upstreamBuildFailureElements.isEmpty()) {
            buildFailureElements.add(Dom4JUtil.getNewElement("h4", null, "This pull contains no unique failures."));
        } else {
            String failureTitle = "Failures unique to this pull:";
            if (!UpstreamFailureUtil.isUpstreamComparisonAvailable(this) && this.isCompareToUpstream()) {
                failureTitle = "Failures (upstream comparison is not available):";
            }
            buildFailureElements.add(Dom4JUtil.getNewElement("h4", null, failureTitle));
            buildFailureElements.add(Dom4JUtil.getOrderedListElement(allCurrentBuildFailureElements, maxFailureCount));
        }
        String acceptanceUpstreamJobURL = this.getAcceptanceUpstreamJobURL();
        if (allCurrentBuildFailureElements.size() < maxFailureCount && !upstreamBuildFailureElements.isEmpty()) {
            Element acceptanceUpstreamJobLinkElement = Dom4JUtil.getNewAnchorElement(acceptanceUpstreamJobURL, "acceptance upstream results");
            Element upstreamJobFailureElement = Dom4JUtil.getNewElement("details", null, Dom4JUtil.getNewElement("summary", null, Dom4JUtil.getNewElement("strong", null, "Failures in common with ", acceptanceUpstreamJobLinkElement, " at ", UpstreamFailureUtil.getUpstreamJobFailuresSHA(this), ":")));
            int remainingFailureCount = maxFailureCount - allCurrentBuildFailureElements.size();
            Dom4JUtil.getOrderedListElement(upstreamBuildFailureElements, upstreamJobFailureElement, remainingFailureCount);
            buildFailureElements.add(Dom4JUtil.getNewElement("hr"));
            buildFailureElements.add(upstreamJobFailureElement);
        }
        if (this.jobName.contains("pullrequest") && upstreamBuildFailureElements.isEmpty() && acceptanceUpstreamJobURL != null) {
            Element upstreamResultElement = Dom4JUtil.getNewElement("h4");
            Dom4JUtil.addToElement(upstreamResultElement, "For upstream results, click ", Dom4JUtil.getNewAnchorElement(acceptanceUpstreamJobURL, "here"), ".");
            buildFailureElements.add(upstreamResultElement);
            Map<String, String> startPropertiesTempMap = this.getStartPropertiesTempMap();
            String subrepositoryMergePullMentionUsers = startPropertiesTempMap.get("SUBREPOSITORY_MERGE_PULL_MENTION_USERS");
            if (subrepositoryMergePullMentionUsers != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("cc");
                for (String subrepositoryMergePullMentionUser : subrepositoryMergePullMentionUsers.split(",")) {
                    sb.append(" @");
                    sb.append(subrepositoryMergePullMentionUser);
                }
                buildFailureElements.add(Dom4JUtil.getNewElement("div", null, sb.toString()));
            }
        }
        return buildFailureElements.toArray(new Element[0]);
    }

    protected Element getDownstreamGitHubMessageElement() {
        Element failureMessageElement;
        String status = this.getStatus();
        if (!status.equals("completed") && this.getParentBuild() != null) {
            return null;
        }
        String result = this.getResult();
        if (Objects.equals(result, "SUCCESS")) {
            return null;
        }
        Element messageElement = Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewAnchorElement(this.getBuildURL(), null, this.getDisplayName()));
        if (Objects.equals(result, "ABORTED")) {
            messageElement.add(Dom4JUtil.toCodeSnippetElement("Build was aborted"));
        }
        if (Objects.equals(result, "FAILURE") && (failureMessageElement = this.getFailureMessageElement()) != null) {
            messageElement.add(failureMessageElement);
        }
        return messageElement;
    }

    @Override
    protected ExecutorService getExecutorService() {
        return _executorService;
    }

    protected Element getFailedJobSummaryElement() {
        Element jobSummaryListElement = this.getJobSummaryListElement(false, null);
        int failCount = this.getDownstreamBuildCount(null) - this.getDownstreamBuildCountByResult("SUCCESS") + 1;
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("h4", null, String.valueOf(failCount), " Failed Jobs:"), jobSummaryListElement);
    }

    @Override
    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return _FAILURE_MESSAGE_GENERATORS;
    }

    @Override
    protected Element getGitHubMessageJobResultsElement() {
        int successCount = this.getDownstreamBuildCountByResult("SUCCESS");
        int failCount = this.getDownstreamBuildCount(null) - successCount + 1;
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("h6", null, "Job Results:"), Dom4JUtil.getNewElement("p", null, String.valueOf(successCount), JenkinsResultsParserUtil.getNounForm(successCount, " Jobs", " Job"), " Passed.", Dom4JUtil.getNewElement("br"), String.valueOf(failCount), JenkinsResultsParserUtil.getNounForm(failCount, " Jobs", " Job"), " Failed."));
    }

    protected String getGitRepositoryDetailsPropertiesTempMapURL(String gitRepositoryType) {
        if (this.fromArchive) {
            return JenkinsResultsParserUtil.combine(this.getBuildURL(), "git.", gitRepositoryType, ".properties.json");
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        JenkinsMaster topLevelBuildJenkinsMaster = topLevelBuild.getJenkinsMaster();
        return JenkinsResultsParserUtil.combine("http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/", topLevelBuildJenkinsMaster.getName(), "/", topLevelBuild.getJobName(), "/", String.valueOf(topLevelBuild.getBuildNumber()), "/", topLevelBuild.getJobName(), "/git.", gitRepositoryType, ".properties");
    }

    protected Element getJenkinsReportBodyElement() {
        Element subheadingElement = null;
        JSONObject jobJSONObject = this.getBuildJSONObject();
        String description = jobJSONObject.optString("description");
        if (!description.isEmpty()) {
            subheadingElement = Dom4JUtil.getNewElement("h2");
            try {
                Dom4JUtil.addRawXMLToElement(subheadingElement, description);
            }
            catch (DocumentException documentException) {
                throw new RuntimeException("Unable to parse description HTML " + description, documentException);
            }
        }
        String buildURL = this.getBuildURL();
        Element headingElement = Dom4JUtil.getNewElement("h1", null, "Jenkins report for ", Dom4JUtil.getNewAnchorElement(buildURL, buildURL));
        return Dom4JUtil.getNewElement("body", null, headingElement, subheadingElement, this.getJenkinsReportSummaryElement(), this.getJenkinsReportTimelineElement(), this.getJenkinsReportTopLevelTableElement(), this.getJenkinsReportDownstreamElement());
    }

    @Override
    protected String getJenkinsReportBuildInfoCellElementTagName() {
        return "th";
    }

    protected Element getJenkinsReportChartJsScriptElement(String xData, String y1Data, String y2Data) {
        String resourceFileContent = null;
        try {
            resourceFileContent = JenkinsResultsParserUtil.getResourceFileContent("dependencies/chart_template.js");
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to load resource chart_template.js", ioException);
        }
        resourceFileContent = resourceFileContent.replace("'xData'", xData);
        resourceFileContent = resourceFileContent.replace("'y1Data'", y1Data);
        resourceFileContent = resourceFileContent.replace("'y2Data'", y2Data);
        Element scriptElement = Dom4JUtil.getNewElement("script");
        scriptElement.addText(resourceFileContent);
        return scriptElement;
    }

    protected Element getJenkinsReportDownstreamElement() {
        return Dom4JUtil.getNewElement("div", null, this.getJenkinsReportDownstreamTableElement(null, "queued", "Queued: "), this.getJenkinsReportDownstreamTableElement(null, "starting", "Starting: "), this.getJenkinsReportDownstreamTableElement(null, "running", "Running: "), this.getJenkinsReportDownstreamTableElement(null, "missing", "Missing: "), Dom4JUtil.getNewElement("h2", null, "Completed: "), this.getJenkinsReportDownstreamTableElement("ABORTED", "completed", "---- Aborted: "), this.getJenkinsReportDownstreamTableElement("FAILURE", "completed", "---- Failure: "), this.getJenkinsReportDownstreamTableElement("UNSTABLE", "completed", "---- Unstable: "), this.getJenkinsReportDownstreamTableElement("SUCCESS", "completed", "---- Success: "));
    }

    protected Element getJenkinsReportDownstreamTableElement(String result, String status, String captionText) {
        List<Element> tableRowElements = this.getJenkinsReportTableRowElements(result, status);
        if (tableRowElements.isEmpty()) {
            return null;
        }
        return Dom4JUtil.getNewElement("table", null, Dom4JUtil.getNewElement("caption", null, captionText, String.valueOf(this.getDownstreamBuildCount(result, status))), this.getJenkinsReportTableColumnHeadersElement(), tableRowElements.toArray(new Element[0]));
    }

    protected Element getJenkinsReportHeadElement() {
        Element headElement = Dom4JUtil.getNewElement("head");
        this.getResourceFileContentAsElement("style", headElement, "dependencies/jenkins_report.css");
        Element scriptElement = this.getResourceFileContentAsElement("script", headElement, "dependencies/jenkins_report.js");
        scriptElement.addAttribute("language", "javascript");
        return headElement;
    }

    protected Element getJenkinsReportSummaryElement() {
        Build longestRunningDownstreamBuild;
        Element summaryElement = Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("p", null, Dom4JUtil.getNewAnchorElement(_URL_CI_SYSTEM_STATUS, "CI System Status")), Dom4JUtil.getNewElement("p", null, "Start Time: ", this.toJenkinsReportDateString(new Date(this.getStartTime()), this.getJenkinsReportTimeZoneName())), Dom4JUtil.getNewElement("p", null, "Invocation Delay Time: ", JenkinsResultsParserUtil.toDurationString(this.getQueuingDuration())), Dom4JUtil.getNewElement("p", null, "Build Time: ", JenkinsResultsParserUtil.toDurationString(this.getDuration())), Dom4JUtil.getNewElement("p", null, "Total CPU Usage Time: ", JenkinsResultsParserUtil.toDurationString(this.getTotalDuration())), Dom4JUtil.getNewElement("p", null, "Total number of Jenkins slaves used: ", String.valueOf(this.getTotalSlavesUsedCount())), Dom4JUtil.getNewElement("p", null, "Average delay time for invoked build to start: ", JenkinsResultsParserUtil.toDurationString(this.getAverageDelayTime())));
        Build longestDelayedDownstreamBuild = this.getLongestDelayedDownstreamBuild();
        if (longestDelayedDownstreamBuild != null) {
            Dom4JUtil.getNewElement("p", summaryElement, "Longest delay time for invoked build to start: ", Dom4JUtil.getNewAnchorElement(longestDelayedDownstreamBuild.getBuildURL(), longestDelayedDownstreamBuild.getDisplayName()), " in: ", JenkinsResultsParserUtil.toDurationString(longestDelayedDownstreamBuild.getDelayTime()));
        }
        if ((longestRunningDownstreamBuild = this.getLongestRunningDownstreamBuild()) != null) {
            Dom4JUtil.getNewElement("p", summaryElement, "Longest Running Downstream Build: ", Dom4JUtil.getNewAnchorElement(longestRunningDownstreamBuild.getBuildURL(), longestRunningDownstreamBuild.getDisplayName()), " in: ", JenkinsResultsParserUtil.toDurationString(longestRunningDownstreamBuild.getDuration()));
        }
        try {
            TestResult longestRunningTest;
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            String longestRunningTestEnabled = buildProperties.getProperty("jenkins.report.longest.running.test.enabled", "false");
            if (longestRunningTestEnabled.equals("true") && (longestRunningTest = this.getLongestRunningTest()) != null) {
                Dom4JUtil.getNewElement("p", summaryElement, "Longest Running Test: ", Dom4JUtil.getNewAnchorElement(longestRunningTest.getTestReportURL(), longestRunningTest.getDisplayName()), " in: ", JenkinsResultsParserUtil.toDurationString(longestRunningTest.getDuration()));
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        return summaryElement;
    }

    protected Element getJenkinsReportTableColumnHeadersElement() {
        Element nameElement = Dom4JUtil.getNewElement("th", null, "Name");
        Element consoleElement = Dom4JUtil.getNewElement("th", null, "Console");
        Element testReportElement = Dom4JUtil.getNewElement("th", null, "Test Report");
        Element startTimeElement = Dom4JUtil.getNewElement("th", null, "Start Time");
        Element buildTimeElement = Dom4JUtil.getNewElement("th", null, "Build Time");
        Element estimatedBuildTimeElement = null;
        Element diffBuildTimeElement = null;
        if (this.buildDurationsEnabled()) {
            estimatedBuildTimeElement = Dom4JUtil.getNewElement("th", null, "Build Time (est)");
            diffBuildTimeElement = Dom4JUtil.getNewElement("th", null, "Build Time (+/-)");
        }
        Element statusElement = Dom4JUtil.getNewElement("th", null, "Status");
        Element resultElement = Dom4JUtil.getNewElement("th", null, "Result");
        Element tableColumnHeaderElement = Dom4JUtil.getNewElement("tr");
        Dom4JUtil.addToElement(tableColumnHeaderElement, nameElement, consoleElement, testReportElement, startTimeElement, buildTimeElement, estimatedBuildTimeElement, diffBuildTimeElement, statusElement, resultElement);
        return tableColumnHeaderElement;
    }

    protected Element getJenkinsReportTimelineElement() {
        Element canvasElement = Dom4JUtil.getNewElement("canvas");
        canvasElement.addAttribute("height", "300");
        canvasElement.addAttribute("id", "timeline");
        Element scriptElement = Dom4JUtil.getNewElement("script");
        scriptElement.addAttribute("src", _URL_CHART_JS);
        scriptElement.addText("");
        BaseBuild.TimelineData timelineData = this.getTimelineData();
        Element chartJSScriptElement = this.getJenkinsReportChartJsScriptElement(Arrays.toString(timelineData.getIndexData()), Arrays.toString(timelineData.getSlaveUsageData()), Arrays.toString(timelineData.getInvocationsData()));
        return Dom4JUtil.getNewElement("div", null, canvasElement, scriptElement, chartJSScriptElement);
    }

    protected Element getJenkinsReportTopLevelTableElement() {
        Element topLevelTableElement = Dom4JUtil.getNewElement("table");
        String result = this.getResult();
        if (result != null) {
            Dom4JUtil.getNewElement("caption", topLevelTableElement, "Top Level Build - ", Dom4JUtil.getNewElement("strong", null, this.getResult()));
        } else {
            Dom4JUtil.getNewElement("caption", topLevelTableElement, "Top Level Build - ", Dom4JUtil.getNewElement("strong", null, StringUtils.upperCase((String)this.getStatus())));
        }
        Dom4JUtil.addToElement(topLevelTableElement, this.getJenkinsReportTableColumnHeadersElement(), this.getJenkinsReportTableRowElement());
        List<Element> jenkinsReportStopWatchRecordElements = this.getJenkinsReportStopWatchRecordElements();
        Dom4JUtil.addToElement(topLevelTableElement, jenkinsReportStopWatchRecordElements.toArray());
        return topLevelTableElement;
    }

    protected Element getJobSummaryElement() {
        int successCount = this.getDownstreamBuildCountByResult("SUCCESS");
        String result = this.getResult();
        if (Objects.equals(result, "SUCCESS")) {
            ++successCount;
        }
        Element detailsElement = Dom4JUtil.getNewElement("details", null, Dom4JUtil.getNewElement("summary", null, Dom4JUtil.getNewElement("strong", null, "ci:test:", this.getTestSuiteName(), " - ", String.valueOf(successCount), " out of ", String.valueOf(this.getDownstreamBuildCount(null) + 1), " jobs PASSED")));
        if (result != null && !result.equals("SUCCESS")) {
            Dom4JUtil.addToElement(detailsElement, this.getFailedJobSummaryElement());
        }
        if (this.getDownstreamBuildCountByResult("SUCCESS") > 0) {
            Dom4JUtil.addToElement(detailsElement, this.getSuccessfulJobSummaryElement());
        }
        return detailsElement;
    }

    protected Element getJobSummaryListElement() {
        Element jobSummaryListElement = Dom4JUtil.getNewElement("ul");
        ArrayList<Build> builds = new ArrayList<Build>();
        builds.add(this);
        builds.addAll(this.getDownstreamBuilds(null));
        for (Build build : builds) {
            Element jobSummaryListItemElement = Dom4JUtil.getNewElement("li", jobSummaryListElement, new Object[0]);
            jobSummaryListItemElement.add(build.getGitHubMessageBuildAnchorElement());
        }
        return jobSummaryListElement;
    }

    protected Element getJobSummaryListElement(boolean success, List<String> jobVariants) {
        Element batchListElement = null;
        String batchName = null;
        ArrayList<Build> builds = new ArrayList<Build>();
        if (jobVariants != null) {
            builds.addAll(this.getJobVariantsDownstreamBuilds(jobVariants, null, null));
        } else {
            builds.add(this);
            builds.addAll(this.getDownstreamBuilds(null));
        }
        int count = 0;
        Element jobSummaryListElement = Dom4JUtil.getNewElement("ul");
        for (Build build : builds) {
            Element jobSummaryListItemElement;
            if (Objects.equals(this.getResult(), "SUCCESS") != success) continue;
            if (++count > 500) {
                jobSummaryListItemElement = Dom4JUtil.getNewElement("li", jobSummaryListElement, new Object[0]);
                jobSummaryListItemElement.addText("...");
                break;
            }
            if (build instanceof DownstreamBuild) {
                Element batchListItemElement;
                DownstreamBuild downstreamBuild = (DownstreamBuild)build;
                if (!Objects.equals(batchName, downstreamBuild.getBatchName())) {
                    batchName = downstreamBuild.getBatchName();
                    batchListItemElement = Dom4JUtil.getNewElement("li", jobSummaryListElement, new Object[0]);
                    batchListItemElement.addText(batchName);
                    batchListElement = Dom4JUtil.getNewElement("ul", batchListItemElement, new Object[0]);
                }
                batchListItemElement = Dom4JUtil.getNewElement("li", batchListElement, new Object[0]);
                batchListItemElement.add(build.getGitHubMessageBuildAnchorElement());
                continue;
            }
            jobSummaryListItemElement = Dom4JUtil.getNewElement("li", jobSummaryListElement, new Object[0]);
            jobSummaryListItemElement.add(build.getGitHubMessageBuildAnchorElement());
        }
        return jobSummaryListElement;
    }

    protected Element getMoreDetailsElement() {
        return Dom4JUtil.getNewElement("h5", null, "For more details click ", Dom4JUtil.getNewAnchorElement(this.getJenkinsReportURL(), "here"), ".");
    }

    protected Element getReevaluationDetailsElement(TopLevelBuildReport upstreamTopLevelBuildReport) {
        Element growURLElement = Dom4JUtil.getNewAnchorElement("https://grow.liferay.com/share/CI+liferay-continuous-integration+GitHub+Commands#General-Commands", "reevaluation");
        String buildID = JenkinsResultsParserUtil.getBuildID(this.getBuildURL());
        Element preElement = Dom4JUtil.getNewElement("pre", null, "ci:reevaluate:" + buildID);
        return Dom4JUtil.getNewElement("p", null, "This pull is eligible for ", growURLElement, ". When this ", Dom4JUtil.getNewAnchorElement(String.valueOf(upstreamTopLevelBuildReport.getBuildURL()), "upstream build"), " has completed, using the following CI command will compare ", "this pull request result against a more recent upstream result:", preElement);
    }

    protected Element getResourceFileContentAsElement(String tagName, Element parentElement, String resourceName) {
        String resourceFileContent = null;
        try {
            resourceFileContent = JenkinsResultsParserUtil.getResourceFileContent(resourceName);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to load resource " + resourceName, ioException);
        }
        return Dom4JUtil.getNewElement(tagName, parentElement, resourceFileContent);
    }

    protected Element getResultElement() {
        StringBuilder sb = new StringBuilder();
        String result = this.getResult();
        int successCount = this.getDownstreamBuildCountByResult("SUCCESS");
        if (result != null && result.matches("(APPROVED|SUCCESS)")) {
            ++successCount;
            sb.append(":heavy_check_mark: ");
        } else {
            sb.append(":x: ");
        }
        sb.append("ci:test:");
        sb.append(this.getTestSuiteName());
        sb.append(" - ");
        sb.append(String.valueOf(successCount));
        sb.append(" out of ");
        sb.append(String.valueOf(this.getDownstreamBuildCountByResult(null) + 1));
        sb.append(" jobs passed in ");
        sb.append(JenkinsResultsParserUtil.toDurationString(this.getDuration()));
        return Dom4JUtil.getNewElement("h3", null, sb.toString());
    }

    @Override
    protected String getStartPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/start.properties.json";
        }
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        return JenkinsResultsParserUtil.combine("http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/", jenkinsMaster.getName(), "/", this.getJobName(), "/", String.valueOf(this.getBuildNumber()), "/", this.getJobName(), "/", "start.properties");
    }

    @Override
    protected String getStopPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/stop.properties.json";
        }
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        return JenkinsResultsParserUtil.combine("http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/", jenkinsMaster.getName(), "/", this.getJobName(), "/", String.valueOf(this.getBuildNumber()), "/", this.getJobName(), "/", "stop.properties");
    }

    protected Element getSuccessfulJobSummaryElement() {
        Element jobSummaryListElement = this.getJobSummaryListElement(true, null);
        int successCount = this.getDownstreamBuildCountByResult("SUCCESS");
        if (Objects.equals(this.getResult(), "SUCCESS")) {
            ++successCount;
        }
        return Dom4JUtil.getNewElement("details", null, Dom4JUtil.getNewElement("summary", null, Dom4JUtil.getNewElement("strong", null, String.valueOf(successCount), " Successful Jobs:")), jobSummaryListElement);
    }

    @Override
    protected String getTempMapURL(String tempMapName) {
        String tempMapURL = super.getTempMapURL(tempMapName);
        if (tempMapURL != null) {
            return tempMapURL;
        }
        Matcher matcher = gitRepositoryTempMapNamePattern.matcher(tempMapName);
        if (matcher.find()) {
            return this.getGitRepositoryDetailsPropertiesTempMapURL(matcher.group("gitRepositoryType"));
        }
        return null;
    }

    @Override
    protected int getTestCountByStatus(String status) {
        int testCount = 0;
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            if (!(downstreamBuild instanceof BaseBuild)) continue;
            BaseBuild downstreamBaseBuild = (BaseBuild)downstreamBuild;
            testCount += downstreamBaseBuild.getTestCountByStatus(status);
        }
        return testCount;
    }

    protected Element getTopGitHubMessageElement() {
        String upstreamBranchSHA;
        TopLevelBuildReport upstreamTopLevelBuildReport;
        this.update();
        Element rootElement = Dom4JUtil.getNewElement("html");
        rootElement.add(this.getResultElement());
        Element detailsElement = Dom4JUtil.getNewElement("details", rootElement, Dom4JUtil.getNewElement("summary", null, "Click here for more details."));
        String result = this.getResult();
        if (this.isCompareToUpstream() && UpstreamFailureUtil.isUpstreamComparisonAvailable(this) && (upstreamTopLevelBuildReport = UpstreamFailureUtil.getUpstreamTopLevelBuildReport(this, upstreamBranchSHA = this.getUpstreamBranchSHA())) != null && this.isEligibleForReevaluation(result, upstreamBranchSHA)) {
            Dom4JUtil.addToElement(detailsElement, Dom4JUtil.getNewElement("br"), this.getReevaluationDetailsElement(upstreamTopLevelBuildReport));
        }
        Dom4JUtil.addToElement(detailsElement, Dom4JUtil.getNewElement("h4", null, "Base Branch:"), this.getBaseBranchDetailsElement());
        if (this.isCompareToUpstream() && UpstreamFailureUtil.isUpstreamComparisonAvailable(this)) {
            Dom4JUtil.addToElement(detailsElement, Dom4JUtil.getNewElement("h4", null, "Upstream Comparison:"), this.getUpstreamComparisonDetailsElement());
        }
        Dom4JUtil.addToElement(detailsElement, this.getJobSummaryElement(), this.getMoreDetailsElement());
        if (result != null && !result.equals("SUCCESS")) {
            Dom4JUtil.addToElement(detailsElement, this.getBuildFailureElements());
        }
        return rootElement;
    }

    protected String getUpstreamBranchSHA() {
        String upstreamBranchSHA = this.getParameterValue("GITHUB_UPSTREAM_BRANCH_SHA");
        if (upstreamBranchSHA == null || upstreamBranchSHA.isEmpty()) {
            Map<String, String> startPropertiesTempMap = this.getStartPropertiesTempMap();
            upstreamBranchSHA = startPropertiesTempMap.get("GITHUB_UPSTREAM_BRANCH_SHA");
        }
        return upstreamBranchSHA;
    }

    protected Element getUpstreamComparisonDetailsElement() {
        String upstreamJobFailuresSHA = UpstreamFailureUtil.getUpstreamJobFailuresSHA(this);
        String upstreamCommitURL = "https://github.com/liferay/" + this.getBaseGitRepositoryName() + "/commit/" + upstreamJobFailuresSHA;
        Element upstreamComparisonDetailsElement = Dom4JUtil.getNewElement("p", null, "Branch GIT ID: ", Dom4JUtil.getNewAnchorElement(upstreamCommitURL, upstreamJobFailuresSHA));
        TestrayBuild testrayBuild = UpstreamFailureUtil.getUpstreamTestrayBuild(this);
        Dom4JUtil.addToElement(upstreamComparisonDetailsElement, Dom4JUtil.getNewElement("br"), "Jenkins Build URL: ", Dom4JUtil.getNewAnchorElement(String.valueOf(testrayBuild.getURL()), testrayBuild.getName()));
        return upstreamComparisonDetailsElement;
    }

    protected boolean isEligibleForReevaluation(String result, String upstreamBranchSHA) {
        return result != null && !result.matches("(APPROVED|SUCCESS)") && !this.downstreamBuilds.isEmpty() && !upstreamBranchSHA.equals(UpstreamFailureUtil.getUpstreamJobFailuresSHA(this));
    }

    protected void sendBuildMetrics(String message) {
        if (this._sendBuildMetrics) {
            DatagramRequestUtil.send(message.trim(), this._metricsHostName, this._metricsHostPort);
        }
    }

    protected void sendBuildMetricsOnModifiedBuilds() {
        StringBuilder sb = new StringBuilder();
        Map<Map<String, String>, Integer> slaveUsages = this._getSlaveUsageByLabels();
        for (Map.Entry<Map<String, String>, Integer> slaveUsageEntry : slaveUsages.entrySet()) {
            Map<String, String> metricLabels = slaveUsageEntry.getKey();
            Integer slaveUsage = slaveUsageEntry.getValue();
            String buildMetricMessage = StatsDMetricsUtil.generateGaugeDeltaMetric("build_slave_usage_gauge", slaveUsage, metricLabels);
            if (buildMetricMessage == null) continue;
            sb.append(buildMetricMessage);
            sb.append("\n");
        }
        if (sb.length() > 0) {
            this.sendBuildMetrics(sb.toString());
        }
        this.sendBuildMetricsOnModifiedCompletedBuilds();
    }

    protected void sendBuildMetricsOnModifiedCompletedBuilds() {
        List<Build> modifiedCompletedBuilds = this.getModifiedDownstreamBuildsByStatus("completed");
        for (Build modifiedCompletedBuild : modifiedCompletedBuilds) {
            if (modifiedCompletedBuild instanceof BatchBuild) continue;
            this.sendBuildMetrics(StatsDMetricsUtil.generateTimerMetric("jenkins_job_build_duration", modifiedCompletedBuild.getDuration(), modifiedCompletedBuild.getMetricLabels()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _archiveBuildDatabase() {
        String status = this.getStatus();
        String urlSuffix = "build-database.json";
        File archiveFile = this.getArchiveFile(urlSuffix);
        if (!status.equals("completed")) {
            if (!archiveFile.exists()) return;
            JenkinsResultsParserUtil.delete(archiveFile);
            return;
        }
        if (archiveFile.exists()) {
            return;
        }
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase(this);
        try {
            JSONObject buildDatabaseJSONObject = new JSONObject(JenkinsResultsParserUtil.read(buildDatabase.getBuildDatabaseFile()));
            this.writeArchiveFile(buildDatabaseJSONObject.toString(4), this.getArchivePath() + "/" + urlSuffix);
            if (!JenkinsResultsParserUtil.debug) return;
        }
        catch (IOException ioException) {
            try {
                throw new RuntimeException("Unable to archive " + urlSuffix, ioException);
            }
            catch (Throwable throwable) {
                if (!JenkinsResultsParserUtil.debug) throw throwable;
                System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(this.getArchiveFile(urlSuffix)), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
                throw throwable;
            }
        }
        System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(this.getArchiveFile(urlSuffix)), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _archiveJenkinsReport() {
        long start;
        File archiveFile;
        block11: {
            String status = this.getStatus();
            String urlSuffix = "jenkins-report.html";
            archiveFile = this.getArchiveFile(urlSuffix);
            if (!status.equals("completed")) {
                if (!archiveFile.exists()) return;
                JenkinsResultsParserUtil.delete(archiveFile);
                return;
            }
            if (archiveFile.exists()) {
                return;
            }
            start = JenkinsResultsParserUtil.getCurrentTimeMillis();
            File jenkinsReportFile = new File(this.getBuildDirPath(), urlSuffix);
            try {
                if (!jenkinsReportFile.exists()) break block11;
                JenkinsResultsParserUtil.copy(jenkinsReportFile, archiveFile);
                if (!JenkinsResultsParserUtil.debug) return;
            }
            catch (IOException ioException) {
                try {
                    throw new RuntimeException("Unable to copy the Jenkins report", ioException);
                }
                catch (Throwable throwable) {
                    if (!JenkinsResultsParserUtil.debug) throw throwable;
                    System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(archiveFile), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
                    throw throwable;
                }
            }
            System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(archiveFile), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
            return;
        }
        if (JenkinsResultsParserUtil.debug) {
            System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(archiveFile), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
        }
        try {
            this.writeArchiveFile(this.getJenkinsReport(), this.getArchivePath() + "/jenkins-report.html");
            if (!JenkinsResultsParserUtil.debug) return;
        }
        catch (Exception exception) {
            try {
                System.out.println("Unable to archive Jenkins report");
                if (!JenkinsResultsParserUtil.debug) return;
            }
            catch (Throwable throwable) {
                if (!JenkinsResultsParserUtil.debug) throw throwable;
                System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(archiveFile), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
                throw throwable;
            }
            System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(archiveFile), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
            return;
        }
        System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(archiveFile), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _archiveProperties() {
        String status = this.getStatus();
        File archiveFile = new File(this.getArchiveRootDir(), this.getArchiveName() + "/archive.properties");
        if (!status.equals("completed")) {
            if (!archiveFile.exists()) return;
            JenkinsResultsParserUtil.delete(archiveFile);
            return;
        }
        if (archiveFile.exists()) {
            return;
        }
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        Properties archiveProperties = new Properties();
        archiveProperties.setProperty("top.level.build.url", this.replaceBuildURL(this.getBuildURL()));
        StringWriter sw = new StringWriter();
        try {
            archiveProperties.store(sw, null);
            JenkinsResultsParserUtil.write(archiveFile, sw.toString());
            if (!JenkinsResultsParserUtil.debug) return;
        }
        catch (IOException ioException) {
            try {
                throw new RuntimeException("Unable to archive properties", ioException);
            }
            catch (Throwable throwable) {
                if (!JenkinsResultsParserUtil.debug) throw throwable;
                System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(archiveFile), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
                throw throwable;
            }
        }
        System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(archiveFile), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
        return;
    }

    private void _findDownstreamBuildsInConsoleText() {
        if (this.getBuildURL() == null || this.getParentBuild() != null) {
            return;
        }
        String consoleText = this.getConsoleText();
        if (JenkinsResultsParserUtil.isNullOrEmpty(consoleText)) {
            return;
        }
        HashSet<String> downstreamBuildURLs = new HashSet<String>();
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            List<String> downstreamBadBuildURLs;
            String downstreamBuildURL = downstreamBuild.getBuildURL();
            if (downstreamBuildURL != null) {
                downstreamBuildURLs.add(downstreamBuildURL);
            }
            if ((downstreamBadBuildURLs = downstreamBuild.getBadBuildURLs()) == null) continue;
            downstreamBuildURLs.addAll(downstreamBadBuildURLs);
        }
        HashMap<String, String> urlAxisNames = new HashMap<String, String>();
        int i = consoleText.lastIndexOf("\nstop-current-job:");
        if (i != -1) {
            consoleText = consoleText.substring(0, i);
        }
        Matcher downstreamBuildURLMatcher = _downstreamBuildURLPattern.matcher(consoleText.substring(this.consoleReadCursor));
        this.consoleReadCursor = consoleText.length();
        while (downstreamBuildURLMatcher.find()) {
            String jobName;
            String url = downstreamBuildURLMatcher.group("url");
            Pattern reinvocationPattern = Pattern.compile(Pattern.quote(url) + " restarted at (?<url>[^\\s]*)\\.");
            Matcher reinvocationMatcher = reinvocationPattern.matcher(consoleText);
            while (reinvocationMatcher.find()) {
                url = reinvocationMatcher.group("url");
            }
            if (downstreamBuildURLs.contains(url) || urlAxisNames.containsKey(url)) continue;
            String jobVariant = downstreamBuildURLMatcher.group("jobVariant");
            if (!JenkinsResultsParserUtil.isNullOrEmpty(jobVariant) && !JenkinsResultsParserUtil.isNullOrEmpty(jobName = downstreamBuildURLMatcher.group("jobName")) && jobVariant.contains(jobName + "/")) {
                jobVariant = jobVariant.replaceAll(jobName + "/", "");
            }
            urlAxisNames.put(url, jobVariant);
        }
        this.addDownstreamBuilds(urlAxisNames);
    }

    private Map<Map<String, String>, Integer> _getSlaveUsageByLabels() {
        HashMap<Map<String, String>, Integer> slaveUsages = new HashMap<Map<String, String>, Integer>();
        List<Build> modifiedDownstreamBuilds = this.getModifiedDownstreamBuilds();
        for (Build modifiedDownstreamBuild : modifiedDownstreamBuilds) {
            Map<String, String> metricLabels = modifiedDownstreamBuild.getMetricLabels();
            Integer slaveUsage = (Integer)slaveUsages.get(metricLabels);
            if (slaveUsage == null) {
                slaveUsage = 0;
            }
            slaveUsage = slaveUsage + modifiedDownstreamBuild.getTotalSlavesUsedCount("running", true);
            slaveUsage = slaveUsage - modifiedDownstreamBuild.getTotalSlavesUsedCount("completed", true);
            slaveUsages.put(metricLabels, slaveUsage);
        }
        return slaveUsages;
    }

    public static class WorkspaceBranchInformation
    implements Build.BranchInformation {
        private static final Pattern _pattern = Pattern.compile("https://github.com/(?<username>[^/]+)/[^/]/pull/(?<pullNumber>\\d+)");
        private final WorkspaceGitRepository _workspaceGitRepository;

        @Override
        public String getCachedRemoteGitRefName() {
            return this._workspaceGitRepository.getGitHubDevBranchName();
        }

        @Override
        public String getOriginName() {
            return this._workspaceGitRepository.getSenderBranchUsername();
        }

        @Override
        public Integer getPullRequestNumber() {
            Matcher matcher = _pattern.matcher(this._workspaceGitRepository.getGitHubURL());
            if (!matcher.find()) {
                return 0;
            }
            return Integer.parseInt(matcher.group("pullNumber"));
        }

        @Override
        public String getReceiverUsername() {
            Matcher matcher = _pattern.matcher(this._workspaceGitRepository.getGitHubURL());
            if (!matcher.find()) {
                return "liferay";
            }
            return matcher.group("username");
        }

        @Override
        public String getRepositoryName() {
            return this._workspaceGitRepository.getName();
        }

        @Override
        public String getSenderBranchName() {
            return this._workspaceGitRepository.getSenderBranchName();
        }

        @Override
        public String getSenderBranchSHA() {
            return this._workspaceGitRepository.getSenderBranchSHA();
        }

        @Override
        public RemoteGitRef getSenderRemoteGitRef() {
            String remoteURL = JenkinsResultsParserUtil.combine("git@github.com:", this.getSenderUsername(), "/", this.getRepositoryName(), ".git");
            return GitUtil.getRemoteGitRef(this.getSenderBranchName(), new File("."), remoteURL);
        }

        @Override
        public String getSenderUsername() {
            return this._workspaceGitRepository.getSenderBranchUsername();
        }

        @Override
        public String getUpstreamBranchName() {
            return this._workspaceGitRepository.getUpstreamBranchName();
        }

        @Override
        public String getUpstreamBranchSHA() {
            return this._workspaceGitRepository.getBaseBranchSHA();
        }

        protected WorkspaceBranchInformation(WorkspaceGitRepository workspaceGitRepository) {
            this._workspaceGitRepository = workspaceGitRepository;
        }
    }
}

