/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.DefaultTopLevelBuild;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalBranchInformationBuild;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.PullRequestBuild;
import com.liferay.jenkins.results.parser.PullRequestFactory;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceBuild;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import com.liferay.jenkins.results.parser.failure.message.generator.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.FormatFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GenericFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PoshiValidationFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.RebaseFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.SourceFormatFailureMessageGenerator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class SourceFormatBuild
extends DefaultTopLevelBuild
implements PortalBranchInformationBuild,
PullRequestBuild,
WorkspaceBuild {
    private static final String _NAME_TEST_SUITE = "sf";
    private static final Pattern _gitHubUpstreamBranchShaPattern = Pattern.compile("\\[beanshell\\] GITHUB_UPSTREAM_BRANCH_SHA=(?<sha>[0-9a-f]{7,40})");
    private String _baseGitRepositorySHA;
    private PullRequest _pullRequest;

    public boolean bypassCITestRelevant() {
        Workspace workspace = this.getWorkspace();
        WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        if (!(workspaceGitRepository instanceof PortalWorkspaceGitRepository)) {
            return false;
        }
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = (PortalWorkspaceGitRepository)workspaceGitRepository;
        return portalWorkspaceGitRepository.bypassCITestRelevant();
    }

    @Override
    public String getBaseGitRepositoryName() {
        PullRequest pullRequest = this.getPullRequest();
        return pullRequest.getGitHubRemoteGitRepositoryName();
    }

    @Override
    public String getBaseGitRepositorySHA(String gitRepositoryName) {
        if (this._baseGitRepositorySHA != null) {
            return this._baseGitRepositorySHA;
        }
        if (!this.fromArchive) {
            Workspace workspace = this.getWorkspace();
            WorkspaceGitRepository primaryWorkspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
            this._baseGitRepositorySHA = primaryWorkspaceGitRepository.getBaseBranchSHA();
            return this._baseGitRepositorySHA;
        }
        String consoleText = this.getConsoleText();
        for (String line : consoleText.split("\\s*\\n\\s*")) {
            Matcher matcher = _gitHubUpstreamBranchShaPattern.matcher(line);
            if (!matcher.find()) continue;
            this._baseGitRepositorySHA = matcher.group("sha");
            return this._baseGitRepositorySHA;
        }
        throw new RuntimeException("Unable to find Source Format Base Git Repository SHA");
    }

    @Override
    public String getBranchName() {
        PullRequest pullRequest = this.getPullRequest();
        return pullRequest.getUpstreamRemoteGitBranchName();
    }

    @Override
    public Element[] getBuildFailureElements() {
        return new Element[]{this.getFailureMessageElement()};
    }

    @Override
    public Job.BuildProfile getBuildProfile() {
        return Job.BuildProfile.DXP;
    }

    @Override
    public Build.BranchInformation getPortalBaseBranchInformation() {
        return null;
    }

    @Override
    public Build.BranchInformation getPortalBranchInformation() {
        Workspace workspace = this.getWorkspace();
        return new TopLevelBuild.WorkspaceBranchInformation(workspace.getPrimaryWorkspaceGitRepository());
    }

    @Override
    public PullRequest getPullRequest() {
        if (this._pullRequest != null) {
            return this._pullRequest;
        }
        this._pullRequest = PullRequestFactory.newPullRequest(this.getParameterValue("PULL_REQUEST_URL"));
        return this._pullRequest;
    }

    @Override
    public String getTestSuiteName() {
        return _NAME_TEST_SUITE;
    }

    @Override
    public Element getTopGitHubMessageElement() {
        this.update();
        Element detailsElement = Dom4JUtil.getNewElement("details", null, Dom4JUtil.getNewElement("summary", null, "Click here for more details."), Dom4JUtil.getNewElement("h4", null, "Base Branch:"), this.getBaseBranchDetailsElement(), Dom4JUtil.getNewElement("h4", null, "Sender Branch:"), this.getSenderBranchDetailsElement());
        String result = this.getResult();
        int successCount = 0;
        if (Objects.equals(result, "SUCCESS")) {
            ++successCount;
        }
        Dom4JUtil.addToElement(detailsElement, String.valueOf(successCount), " out of ", String.valueOf(this.getDownstreamBuildCountByResult(null) + 1), "jobs PASSED");
        if (Objects.equals(result, "SUCCESS")) {
            Dom4JUtil.addToElement(detailsElement, this.getSuccessfulJobSummaryElement());
        } else {
            Dom4JUtil.addToElement(detailsElement, this.getFailedJobSummaryElement());
        }
        Dom4JUtil.addToElement(detailsElement, this.getMoreDetailsElement());
        if (!Objects.equals(result, "SUCCESS")) {
            Dom4JUtil.addToElement(detailsElement, this.getBuildFailureElements());
        }
        return Dom4JUtil.getNewElement("html", null, this.getResultElement(), detailsElement);
    }

    @Override
    public Workspace getWorkspace() {
        String upstreamBranchSHA;
        PullRequest pullRequest = this.getPullRequest();
        Workspace workspace = WorkspaceFactory.newWorkspace(pullRequest.getGitRepositoryName(), pullRequest.getUpstreamRemoteGitBranchName(), this.getJobName());
        WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        workspaceGitRepository.setGitHubURL(pullRequest.getHtmlURL());
        String senderBranchSHA = this.getParameterValue("GITHUB_SENDER_BRANCH_SHA");
        if (JenkinsResultsParserUtil.isSHA(senderBranchSHA)) {
            workspaceGitRepository.setSenderBranchSHA(senderBranchSHA);
        }
        if (JenkinsResultsParserUtil.isSHA(upstreamBranchSHA = this.getParameterValue("GITHUB_UPSTREAM_BRANCH_SHA"))) {
            workspaceGitRepository.setBaseBranchSHA(upstreamBranchSHA);
        }
        return workspace;
    }

    protected SourceFormatBuild(String url) {
        this(url, null);
    }

    protected SourceFormatBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return new FailureMessageGenerator[]{new FormatFailureMessageGenerator(), new PoshiValidationFailureMessageGenerator(), new RebaseFailureMessageGenerator(), new SourceFormatFailureMessageGenerator(), new GenericFailureMessageGenerator()};
    }

    protected Element getSenderBranchDetailsElement() {
        PullRequest pullRequest = this.getPullRequest();
        String gitHubRemoteGitRepositoryName = pullRequest.getGitHubRemoteGitRepositoryName();
        String senderBranchName = pullRequest.getSenderBranchName();
        String senderUsername = pullRequest.getSenderUsername();
        String senderBranchURL = JenkinsResultsParserUtil.combine("https://github.com/", senderUsername, "/", gitHubRemoteGitRepositoryName, "/tree/", senderBranchName);
        String senderSHA = pullRequest.getSenderSHA();
        String senderCommitURL = JenkinsResultsParserUtil.combine("https://github.com/", senderUsername, "/", gitHubRemoteGitRepositoryName, "/commit/", senderSHA);
        return Dom4JUtil.getNewElement("p", null, "Branch Name: ", Dom4JUtil.getNewAnchorElement(senderBranchURL, senderBranchName), Dom4JUtil.getNewElement("br"), "Branch GIT ID: ", Dom4JUtil.getNewAnchorElement(senderCommitURL, senderSHA));
    }
}

