/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONObject;

public class RootCauseAnalysisToolJob
extends BaseJob
implements PortalTestClassJob {
    private GitWorkingDirectory _jenkinsGitWorkingDirectory;
    private PortalGitWorkingDirectory _portalGitWorkingDirectory;
    private final String _upstreamBranchName;

    @Override
    public Set<String> getDistTypes() {
        return Collections.emptySet();
    }

    public GitWorkingDirectory getJenkinsGitWorkingDirectory() {
        return this._jenkinsGitWorkingDirectory;
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("upstream_branch_name", (Object)this._upstreamBranchName);
        return this.jsonObject;
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return this._portalGitWorkingDirectory;
    }

    @Override
    public boolean isSegmentEnabled() {
        return true;
    }

    protected RootCauseAnalysisToolJob(Job.BuildProfile buildProfile, String jobName, String upstreamBranchName) {
        super(buildProfile, jobName);
        this._upstreamBranchName = upstreamBranchName;
        this._initialize();
    }

    protected RootCauseAnalysisToolJob(JSONObject jsonObject) {
        super(jsonObject);
        this._upstreamBranchName = jsonObject.getString("upstream_branch_name");
        this._initialize();
    }

    @Override
    protected Set<String> getRawBatchNames() {
        return new HashSet<String>();
    }

    private void _initialize() {
        this._jenkinsGitWorkingDirectory = GitWorkingDirectoryFactory.newJenkinsGitWorkingDirectory();
        this._portalGitWorkingDirectory = GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(this._upstreamBranchName);
        this.jobPropertiesFiles.add(new File(this._jenkinsGitWorkingDirectory.getWorkingDirectory(), "commands/build.properties"));
        this.jobPropertiesFiles.add(new File(this._jenkinsGitWorkingDirectory.getWorkingDirectory(), "commands/dependencies/root-cause-analysis-tool.properties"));
        this.jobPropertiesFiles.add(new File(this._portalGitWorkingDirectory.getWorkingDirectory(), "test.properties"));
    }
}

