/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseGitRef;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.RemoteGitRepository;

public class RemoteGitRef
extends BaseGitRef
implements Comparable<RemoteGitRef> {
    private final RemoteGitRepository _remoteGitRepository;

    @Override
    public int compareTo(RemoteGitRef o) {
        String name = this.getName();
        return name.compareTo(o.getName());
    }

    public String getHtmlURL() {
        return JenkinsResultsParserUtil.combine("https://github.com/", this.getUsername(), "/", this.getRepositoryName(), "/tree/", this.getName());
    }

    public RemoteGitRepository getRemoteGitRepository() {
        return this._remoteGitRepository;
    }

    public String getRemoteURL() {
        RemoteGitRepository remoteRepository = this.getRemoteGitRepository();
        return remoteRepository.getRemoteURL();
    }

    public String getRepositoryName() {
        return this._remoteGitRepository.getName();
    }

    public String getUsername() {
        RemoteGitRepository remoteGitRepository = this.getRemoteGitRepository();
        return remoteGitRepository.getUsername();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRemoteURL());
        sb.append(" (");
        sb.append(this.getName());
        sb.append(" - ");
        sb.append(this.getSHA());
        sb.append(")");
        return sb.toString();
    }

    protected RemoteGitRef(RemoteGitRepository remoteGitRepository, String name, String sha) {
        super(name, sha);
        if (remoteGitRepository == null) {
            throw new IllegalArgumentException("Remote Git repository is null");
        }
        this._remoteGitRepository = remoteGitRepository;
    }
}

