/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.DefaultTopLevelBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.QAWebsitesBranchInformationBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceBuild;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.util.Arrays;
import java.util.List;

public class QAWebsitesTopLevelBuild
extends DefaultTopLevelBuild
implements QAWebsitesBranchInformationBuild,
WorkspaceBuild {
    public QAWebsitesTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
        this.findDownstreamBuilds();
    }

    @Override
    public String getBaseGitRepositoryName() {
        return "liferay-qa-websites-ee";
    }

    @Override
    public List<String> getProjectNames() {
        String projectNames = this.getParameterValue("PROJECT_NAMES");
        return Arrays.asList(projectNames.split(","));
    }

    @Override
    public Build.BranchInformation getQAWebsitesBranchInformation() {
        Workspace workspace = this.getWorkspace();
        if (workspace == null) {
            return null;
        }
        WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        if (workspaceGitRepository == null) {
            return null;
        }
        return new TopLevelBuild.WorkspaceBranchInformation(workspaceGitRepository);
    }

    @Override
    public Workspace getWorkspace() {
        String qaWebsitesBranchSHA;
        Workspace workspace = WorkspaceFactory.newWorkspace(this.getBaseGitRepositoryName(), this.getBranchName(), this.getJobName());
        WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        String qaWebsitesGitHubURL = this._getQAWebsitesGitHubURL();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(qaWebsitesGitHubURL)) {
            workspaceGitRepository.setGitHubURL(qaWebsitesGitHubURL);
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(qaWebsitesBranchSHA = this._getQAWebsitesBranchSHA())) {
            workspaceGitRepository.setSenderBranchSHA(qaWebsitesBranchSHA);
        }
        return workspace;
    }

    private String _getQAWebsitesBranchSHA() {
        return this.getParameterValue("TEST_QA_WEBSITES_GIT_ID");
    }

    private String _getQAWebsitesGitHubURL() {
        String qaWebsitesBranchUsername;
        String qaWebsitesBranchName = this.getParameterValue("TEST_QA_WEBSITES_BRANCH_NAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(qaWebsitesBranchName)) {
            qaWebsitesBranchName = "master";
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(qaWebsitesBranchUsername = this.getParameterValue("TEST_QA_WEBSITES_BRANCH_USERNAME"))) {
            qaWebsitesBranchUsername = "liferay";
        }
        return JenkinsResultsParserUtil.combine("https://github.com/", qaWebsitesBranchUsername, "/" + this.getBaseGitRepositoryName() + "/tree/", qaWebsitesBranchName);
    }
}

