/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AnalyticsCloudBranchInformationBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.DefaultTopLevelBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PluginsBranchInformationBuild;
import com.liferay.jenkins.results.parser.PortalBranchInformationBuild;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.PullRequestBuild;
import com.liferay.jenkins.results.parser.PullRequestFactory;
import com.liferay.jenkins.results.parser.SubrepositoryWorkspace;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceBuild;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;

public class PullRequestSubrepositoryTopLevelBuild
extends DefaultTopLevelBuild
implements AnalyticsCloudBranchInformationBuild,
PluginsBranchInformationBuild,
PortalBranchInformationBuild,
PullRequestBuild,
WorkspaceBuild {
    private PullRequest _pullRequest;

    public PullRequestSubrepositoryTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getBranchName() {
        String branchName = this.getParameterValue("GITHUB_UPSTREAM_BRANCH_NAME");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(branchName)) {
            return branchName;
        }
        return this.getBranchName();
    }

    @Override
    public Build.BranchInformation getOSBAsahBranchInformation() {
        Workspace workspace = this.getWorkspace();
        return new TopLevelBuild.WorkspaceBranchInformation(workspace.getWorkspaceGitRepository("com-liferay-osb-asah-private"));
    }

    @Override
    public Build.BranchInformation getOSBFaroBranchInformation() {
        Workspace workspace = this.getWorkspace();
        return new TopLevelBuild.WorkspaceBranchInformation(workspace.getWorkspaceGitRepository("com-liferay-osb-faro-private"));
    }

    @Override
    public Build.BranchInformation getPluginsBranchInformation() {
        Workspace workspace = this.getWorkspace();
        if (!(workspace instanceof SubrepositoryWorkspace)) {
            return null;
        }
        SubrepositoryWorkspace subrepositoryWorkspace = (SubrepositoryWorkspace)workspace;
        return new TopLevelBuild.WorkspaceBranchInformation(subrepositoryWorkspace.getPluginsWorkspaceGitRepository());
    }

    @Override
    public Build.BranchInformation getPortalBaseBranchInformation() {
        return null;
    }

    @Override
    public Build.BranchInformation getPortalBranchInformation() {
        Workspace workspace = this.getWorkspace();
        if (!(workspace instanceof SubrepositoryWorkspace)) {
            return null;
        }
        SubrepositoryWorkspace subrepositoryWorkspace = (SubrepositoryWorkspace)workspace;
        return new TopLevelBuild.WorkspaceBranchInformation(subrepositoryWorkspace.getPortalWorkspaceGitRepository());
    }

    public String getPortalUpstreamBranchName() {
        String portalUpstreamBranchName = this.getParameterValue("PORTAL_UPSTREAM_BRANCH_NAME");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalUpstreamBranchName)) {
            return portalUpstreamBranchName;
        }
        return this.getBranchName();
    }

    @Override
    public PullRequest getPullRequest() {
        if (this._pullRequest != null) {
            return this._pullRequest;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/");
        sb.append(this.getParameterValue("GITHUB_RECEIVER_USERNAME"));
        sb.append("/");
        sb.append(this.getParameterValue("REPOSITORY_NAME"));
        sb.append("/pull/");
        sb.append(this.getParameterValue("GITHUB_PULL_REQUEST_NUMBER"));
        this._pullRequest = PullRequestFactory.newPullRequest(sb.toString());
        return this._pullRequest;
    }

    @Override
    public Workspace getWorkspace() {
        String upstreamBranchSHA;
        PullRequest pullRequest = this.getPullRequest();
        Workspace workspace = WorkspaceFactory.newWorkspace(pullRequest.getGitRepositoryName(), pullRequest.getUpstreamRemoteGitBranchName(), this.getJobName());
        if (workspace instanceof SubrepositoryWorkspace) {
            SubrepositoryWorkspace subrepositoryWorkspace = (SubrepositoryWorkspace)workspace;
            subrepositoryWorkspace.setBuildProfile(this.getBuildProfile());
            subrepositoryWorkspace.setPortalUpstreamBranchName(this.getPortalUpstreamBranchName());
        }
        WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        workspaceGitRepository.setGitHubURL(pullRequest.getHtmlURL());
        String senderBranchSHA = this._getSenderBranchSHA();
        if (JenkinsResultsParserUtil.isSHA(senderBranchSHA)) {
            workspaceGitRepository.setSenderBranchSHA(senderBranchSHA);
        }
        if (JenkinsResultsParserUtil.isSHA(upstreamBranchSHA = this._getUpstreamBranchSHA())) {
            workspaceGitRepository.setBaseBranchSHA(upstreamBranchSHA);
        }
        return workspace;
    }

    private String _getSenderBranchSHA() {
        String senderBranchSHA = this.getParameterValue("GITHUB_SENDER_BRANCH_SHA");
        if (JenkinsResultsParserUtil.isSHA(senderBranchSHA)) {
            return senderBranchSHA;
        }
        return null;
    }

    private String _getUpstreamBranchSHA() {
        String upstreamBranchSHA = this.getParameterValue("GITHUB_UPSTREAM_BRANCH_SHA");
        if (JenkinsResultsParserUtil.isSHA(upstreamBranchSHA)) {
            return upstreamBranchSHA;
        }
        return null;
    }
}

