/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRemote;
import com.liferay.jenkins.results.parser.GitRepositoryFactory;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LocalGitBranch;
import com.liferay.jenkins.results.parser.PortalTopLevelBuildData;
import com.liferay.jenkins.results.parser.PortalTopLevelBuildRunner;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.PullRequestFactory;
import com.liferay.jenkins.results.parser.RemoteGitBranch;
import com.liferay.jenkins.results.parser.RemoteGitRepository;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class PoshiReleasePortalTopLevelBuildRunner
extends PortalTopLevelBuildRunner<PortalTopLevelBuildData> {
    private static final String _DEFAULT_CI_TEST_SUITE = "poshi-release";
    private static final String _NAME_BUILD_PARAMETER_PORTAL_GITHUB_URL = "PORTAL_GITHUB_URL";
    private static final String _NAME_BUILD_PARAMETER_PORTAL_MASTER_CI_TEST_SUITE = "PORTAL_MASTER_CI_TEST_SUITE";
    private static final Pattern _bundleVersionPattern = Pattern.compile("Bundle-Version:[\\s]*(.*)");
    private static final Pattern _gitHubURLPattern = Pattern.compile("https://github.com/(?<username>[^/]+)/(?<repository>[^/]+)/(commits|tree)/(?<branch>[^/]+)");
    private String _gradlePluginsPoshiRunnerVersion;
    private final Map<String, PullRequest> _pullRequests = new HashMap<String, PullRequest>();
    private final Map<GitWorkingDirectory, RemoteGitBranch> _remoteGitBranches = new HashMap<GitWorkingDirectory, RemoteGitBranch>();

    public void commitGradlePluginsPoshiRunnerCache(GitWorkingDirectory gitWorkingDirectory) throws IOException {
        File buildTestGradleFile = this.getBuildTestGradleFile(gitWorkingDirectory);
        gitWorkingDirectory.commitFileToCurrentBranch(buildTestGradleFile.getCanonicalPath(), "POSHI-0 CI TESTING ONLY: Use latest gradle-plugins-poshi-runner");
        gitWorkingDirectory.commitFileToCurrentBranch(".m2-tmp", "POSHI-0 CI TESTING ONLY: FAKE GRADLE CACHE");
    }

    public LocalGitBranch createLocalGitBranch(GitWorkingDirectory gitWorkingDirectory) throws IOException {
        String upstreamBranchName = gitWorkingDirectory.getUpstreamBranchName();
        LocalGitBranch pullRequestLocalGitBranch = gitWorkingDirectory.createLocalGitBranch(upstreamBranchName + "-temp-pr-" + System.currentTimeMillis(), true, this._getDistPortalBundlesBuildSHA(gitWorkingDirectory.getUpstreamBranchName()));
        gitWorkingDirectory.checkoutLocalGitBranch(pullRequestLocalGitBranch);
        gitWorkingDirectory.reset("--hard");
        this.updateGradlePluginsPoshiRunnerDependency(gitWorkingDirectory);
        this.commitGradlePluginsPoshiRunnerCache(gitWorkingDirectory);
        return pullRequestLocalGitBranch;
    }

    public void deleteRemoteGitBranches() {
        for (Map.Entry<GitWorkingDirectory, RemoteGitBranch> entry : this._remoteGitBranches.entrySet()) {
            RemoteGitBranch remoteGitBranch = entry.getValue();
            if (remoteGitBranch == null) continue;
            GitWorkingDirectory gitWorkingDirectory = entry.getKey();
            System.out.println("Deleting remote git branch: " + gitWorkingDirectory.getGitDirectory());
            gitWorkingDirectory.deleteRemoteGitBranch(remoteGitBranch);
        }
    }

    public File getBuildTestGradleFile(GitWorkingDirectory gitWorkingDirectory) {
        return new File(gitWorkingDirectory.getWorkingDirectory(), "portal-web/build-test.gradle");
    }

    public RemoteGitRepository getPullRequestRemoteGitRepository(String upstreamBranchName) {
        String portalGitHubURL = this._getPortalGitHubURL();
        Matcher matcher = GitRemote.getRemoteURLMatcher(portalGitHubURL);
        if (matcher.find()) {
            String repositoryName = "liferay-portal";
            if (!upstreamBranchName.equals("master")) {
                repositoryName = repositoryName + "-ee";
            }
            return GitRepositoryFactory.getRemoteGitRepository(matcher.group("hostname"), repositoryName, matcher.group("username"));
        }
        throw new RuntimeException("Invalid portal GitHub URL: " + portalGitHubURL);
    }

    @Override
    public Workspace getWorkspace() {
        Workspace workspace = super.getWorkspace();
        WorkspaceGitRepository primaryWorkspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        primaryWorkspaceGitRepository.setRebase(true);
        PortalTopLevelBuildData portalTopLevelBuildData = (PortalTopLevelBuildData)this.getBuildData();
        primaryWorkspaceGitRepository.setGitHubURL(portalTopLevelBuildData.getPortalGitHubURL());
        return workspace;
    }

    @Override
    public void run() {
        this.validateBuildParameters();
        this.publishJenkinsReport();
        this.updateBuildDescription();
        this.setUpWorkspace();
        this.preparePoshiPortalPullRequests();
        this.invokeDownstreamBuilds();
        this.waitForDownstreamBuildsToComplete();
        this.publishJenkinsReport();
        this.deleteRemoteGitBranches();
    }

    public void updateGradlePluginsPoshiRunnerDependency(GitWorkingDirectory gitWorkingDirectory) throws IOException {
        Workspace workspace = this.getWorkspace();
        WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        File sourceCacheDir = new File(workspaceGitRepository.getDirectory(), ".m2-tmp/com/liferay/com.liferay.gradle.plugins.poshi.runner");
        File targetCacheDir = new File(gitWorkingDirectory.getWorkingDirectory(), ".m2-tmp/com/liferay/com.liferay.gradle.plugins.poshi.runner");
        FileUtils.copyDirectory((File)sourceCacheDir, (File)targetCacheDir);
        File file = this.getBuildTestGradleFile(gitWorkingDirectory);
        String fileContent = JenkinsResultsParserUtil.read(file);
        JenkinsResultsParserUtil.write(file, fileContent.replaceAll("([\\s]*)(.*\"com\\.liferay\\.gradle\\.plugins\\.defaults\".*)", "$1$2$1classpath group: \"com.liferay\", name: \"com.liferay.gradle.plugins.poshi.runner\", version: \"" + this.getGradlePluginsPoshiRunnerVersion() + "\""));
    }

    protected PoshiReleasePortalTopLevelBuildRunner(PortalTopLevelBuildData portalTopLevelBuildData) {
        super(portalTopLevelBuildData);
    }

    protected PullRequest createPortalPullRequest(GitWorkingDirectory gitWorkingDirectory) {
        try {
            LocalGitBranch localGitBranch = gitWorkingDirectory.getCurrentLocalGitBranch();
            String upstreamBranchName = gitWorkingDirectory.getUpstreamBranchName();
            if (!upstreamBranchName.equals("master")) {
                localGitBranch = this.createLocalGitBranch(gitWorkingDirectory);
            }
            RemoteGitBranch remoteGitBranch = gitWorkingDirectory.pushToRemoteGitRepository(true, localGitBranch, localGitBranch.getName(), this.getPullRequestRemoteGitRepository(upstreamBranchName));
            this._remoteGitBranches.put(gitWorkingDirectory, remoteGitBranch);
            PortalTopLevelBuildData portalTopLevelBuildData = (PortalTopLevelBuildData)this.getBuildData();
            return PullRequestFactory.newPullRequest(gitWorkingDirectory.createPullRequest("Testing Poshi Release: " + portalTopLevelBuildData.getBuildURL(), remoteGitBranch.getName(), remoteGitBranch.getUsername(), remoteGitBranch.getUsername(), "Poshi Release | " + upstreamBranchName));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to create pull request", ioException);
        }
    }

    protected String getGradlePluginsPoshiRunnerVersion() {
        if (this._gradlePluginsPoshiRunnerVersion != null) {
            return this._gradlePluginsPoshiRunnerVersion;
        }
        Workspace workspace = this.getWorkspace();
        WorkspaceGitRepository primaryWorkspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        File bndFile = new File(primaryWorkspaceGitRepository.getDirectory(), "modules/sdk/gradle-plugins-poshi-runner/bnd.bnd");
        try {
            String fileContent = JenkinsResultsParserUtil.read(bndFile);
            Matcher matcher = _bundleVersionPattern.matcher(fileContent);
            matcher.find();
            this._gradlePluginsPoshiRunnerVersion = matcher.group(1);
            return this._gradlePluginsPoshiRunnerVersion;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected String getJobInvocationURL(String jobName) {
        Object buildData = this.getBuildData();
        String cohortName = buildData.getCohortName();
        return JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getMostAvailableMasterURL("http://" + cohortName + ".liferay.com", 1), "/job/", jobName.replaceAll("-controller\\(.*\\)", ""));
    }

    @Override
    protected void invokeDownstreamBuilds() {
        Object buildData = this.getBuildData();
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        for (Map.Entry<String, PullRequest> entry : this._pullRequests.entrySet()) {
            StringBuilder sb = new StringBuilder();
            String jobName = "test-portal-acceptance-pullrequest(" + entry.getKey() + ")";
            sb.append(this.getJobInvocationURL(jobName));
            sb.append("/buildWithParameters?");
            sb.append("token=");
            try {
                sb.append(JenkinsResultsParserUtil.getBuildProperty("jenkins.authentication.token"));
                HashMap<String, String> invocationParameters = new HashMap<String, String>();
                String upstreamBranchName = entry.getKey();
                invocationParameters.put("CI_TEST_SUITE", this._getCITestSuite(upstreamBranchName));
                invocationParameters.put("GITHUB_UPSTREAM_BRANCH_NAME", upstreamBranchName);
                invocationParameters.put("GITHUB_UPSTREAM_BRANCH_SHA", this._getDistPortalBundlesBuildSHA(upstreamBranchName));
                invocationParameters.put("JENKINS_JOB_VARIANT", this._getCITestSuite(upstreamBranchName));
                invocationParameters.put("PORTAL_BUNDLES_DIST_URL", JenkinsResultsParserUtil.getDistPortalBundlesBuildURL(upstreamBranchName));
                PullRequest pullRequest = entry.getValue();
                invocationParameters.put("GITHUB_PULL_REQUEST_NUMBER", pullRequest.getNumber());
                invocationParameters.put("GITHUB_RECEIVER_USERNAME", pullRequest.getReceiverUsername());
                invocationParameters.put("GITHUB_SENDER_BRANCH_NAME", pullRequest.getSenderBranchName());
                invocationParameters.put("GITHUB_SENDER_BRANCH_SHA", pullRequest.getSenderSHA());
                invocationParameters.put("GITHUB_SENDER_USERNAME", pullRequest.getSenderUsername());
                invocationParameters.put("JENKINS_GITHUB_BRANCH_NAME", this._getGitHubBranchName("JENKINS_GITHUB_URL"));
                invocationParameters.put("JENKINS_GITHUB_BRANCH_USERNAME", this._getGitHubBranchUsername("JENKINS_GITHUB_URL"));
                invocationParameters.put("JENKINS_TOP_LEVEL_BUILD_URL", buildData.getBuildURL());
                for (Map.Entry invocationParameter : invocationParameters.entrySet()) {
                    String invocationParameterValue = (String)invocationParameter.getValue();
                    if (JenkinsResultsParserUtil.isNullOrEmpty(invocationParameterValue)) continue;
                    sb.append("&");
                    sb.append((String)invocationParameter.getKey());
                    sb.append("=");
                    sb.append(invocationParameterValue);
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            topLevelBuild.addDownstreamBuilds(sb.toString());
        }
    }

    @Override
    protected void prepareInvocationBuildDataList() {
    }

    protected void preparePoshiPortalPullRequests() {
        Workspace workspace = this.getWorkspace();
        WorkspaceGitRepository primaryWorkspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        File jarFile = new File(primaryWorkspaceGitRepository.getDirectory(), ".m2-tmp/com/liferay/com.liferay.gradle.plugins.poshi.runner/" + this.getGradlePluginsPoshiRunnerVersion() + "/com.liferay.gradle.plugins.poshi.runner-" + this.getGradlePluginsPoshiRunnerVersion() + ".jar");
        if (!jarFile.exists()) {
            throw new RuntimeException("Poshi Runner Gradle Plugin cached jar does not exist: " + jarFile);
        }
        for (WorkspaceGitRepository workspaceGitRepository : workspace.getWorkspaceGitRepositories()) {
            if (!(workspaceGitRepository instanceof PortalWorkspaceGitRepository)) continue;
            GitWorkingDirectory gitWorkingDirectory = workspaceGitRepository.getGitWorkingDirectory();
            this._pullRequests.put(gitWorkingDirectory.getUpstreamBranchName(), this.createPortalPullRequest(gitWorkingDirectory));
        }
    }

    @Override
    protected void validateBuildParameters() {
        this._validateBuildParameterPortalGitHubURL();
    }

    private String _getCITestSuite(String upstreamBranchName) {
        if (upstreamBranchName.equals("master")) {
            return this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_MASTER_CI_TEST_SUITE);
        }
        return _DEFAULT_CI_TEST_SUITE;
    }

    private String _getDistPortalBundlesBuildSHA(String upstreamBranchName) throws IOException {
        String distPortalBundlesBuildURL = JenkinsResultsParserUtil.getDistPortalBundlesBuildURL(upstreamBranchName);
        String distPortalBundlesBuildSHA = JenkinsResultsParserUtil.toString(distPortalBundlesBuildURL + "/git-hash");
        return distPortalBundlesBuildSHA.trim();
    }

    private String _getGitHubBranchName(String parameterName) {
        Object buildData = this.getBuildData();
        String gitHubURL = buildData.getBuildParameter(parameterName);
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitHubURL)) {
            return null;
        }
        Matcher matcher = _gitHubURLPattern.matcher(gitHubURL);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("branch");
    }

    private String _getGitHubBranchUsername(String parameterName) {
        Object buildData = this.getBuildData();
        String gitHubURL = buildData.getBuildParameter(parameterName);
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitHubURL)) {
            return null;
        }
        Matcher matcher = _gitHubURLPattern.matcher(gitHubURL);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("username");
    }

    private String _getPortalGitHubURL() {
        return this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_GITHUB_URL);
    }

    private void _validateBuildParameterPortalGitHubURL() {
        String repositoryName;
        String portalGitHubURL = this._getPortalGitHubURL();
        if (portalGitHubURL == null || portalGitHubURL.isEmpty()) {
            this.failBuildRunner("PORTAL_GITHUB_URL is null");
        }
        String failureMessage = JenkinsResultsParserUtil.combine(_NAME_BUILD_PARAMETER_PORTAL_GITHUB_URL, " has an invalid Portal GitHub URL <a href=\"", portalGitHubURL, "\">", portalGitHubURL, "</a>");
        Matcher matcher = _gitHubURLPattern.matcher(portalGitHubURL);
        if (!matcher.find()) {
            this.failBuildRunner(failureMessage);
        }
        if (!(repositoryName = matcher.group("repository")).equals("liferay-portal")) {
            this.failBuildRunner(failureMessage);
        }
    }
}

