/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JUnitTestResult;
import org.dom4j.Element;
import org.json.JSONObject;

public class PoshiJUnitTestResult
extends JUnitTestResult {
    @Override
    public String getDisplayName() {
        String testName = this.getTestName();
        if (testName.startsWith("test[")) {
            return testName.substring(5, testName.length() - 1);
        }
        return this.getSimpleClassName() + "." + testName;
    }

    @Override
    public Element getGitHubElement() {
        String testReportURL = this.getTestReportURL();
        Element downstreamBuildListItemElement = Dom4JUtil.getNewElement("div", null, new Object[0]);
        downstreamBuildListItemElement.add(Dom4JUtil.getNewAnchorElement(testReportURL, this.getDisplayName()));
        Dom4JUtil.addToElement(downstreamBuildListItemElement, " - ", Dom4JUtil.getNewAnchorElement(this.getPoshiReportURL(), "Poshi Report"), " - ", Dom4JUtil.getNewAnchorElement(this.getPoshiSummaryURL(), "Poshi Summary"), " - ", Dom4JUtil.getNewAnchorElement(this.getConsoleOutputURL(), "Console Output"));
        String errorDetails = this.getErrorDetails();
        if (errorDetails != null && !errorDetails.isEmpty()) {
            Dom4JUtil.addToElement(Dom4JUtil.toCodeSnippetElement(errorDetails), new Object[0]);
        }
        if (this.hasLiferayLog()) {
            Dom4JUtil.addToElement(downstreamBuildListItemElement, " - ", Dom4JUtil.getNewAnchorElement(this.getLiferayLogURL(), "Liferay Log"));
        }
        return downstreamBuildListItemElement;
    }

    protected PoshiJUnitTestResult(Build build, JSONObject caseJSONObject) {
        super(build, caseJSONObject);
    }

    protected String getPoshiReportURL() {
        StringBuilder sb = new StringBuilder();
        String name = this.getDisplayName();
        sb.append(this.getTestrayLogsURL());
        sb.append("/");
        sb.append(name.replace('#', '_'));
        sb.append("/index.html.gz");
        return sb.toString();
    }

    protected String getPoshiSummaryURL() {
        StringBuilder sb = new StringBuilder();
        String name = this.getDisplayName();
        sb.append(this.getTestrayLogsURL());
        sb.append("/");
        sb.append(name.replace('#', '_'));
        sb.append("/summary.html.gz");
        return sb.toString();
    }
}

