/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.BaseWorkspace;
import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PluginsWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.ReleaseToolWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.File;
import java.io.IOException;
import java.nio.file.PathMatcher;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public class PortalWorkspace
extends BaseWorkspace {
    private boolean _commitOSBAsahModule;
    private boolean _commitOSBFaroModule;
    private String _osbAsahGitHubURL;
    private String _osbFaroGitHubURL;
    private String _portalPrivateGitHubURL;

    public Job.BuildProfile getBuildProfile() {
        String buildProfileString = this.jsonObject.optString("build_profile", "dxp");
        return Job.BuildProfile.getByString(buildProfileString);
    }

    public WorkspaceGitRepository getLegacyWorkspaceGitRepository() {
        return this.getWorkspaceGitRepository("liferay-qa-portal-legacy-ee");
    }

    public PluginsWorkspaceGitRepository getPluginsWorkspaceGitRepository() {
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = this.getPortalWorkspaceGitRepository();
        WorkspaceGitRepository workspaceGitRepository = this.getWorkspaceGitRepository(portalWorkspaceGitRepository.getPluginsRepositoryDirName());
        if (!(workspaceGitRepository instanceof PluginsWorkspaceGitRepository)) {
            return null;
        }
        return (PluginsWorkspaceGitRepository)workspaceGitRepository;
    }

    public PortalWorkspaceGitRepository getPortalWorkspaceGitRepository() {
        WorkspaceGitRepository workspaceGitRepository = this.getPrimaryWorkspaceGitRepository();
        if (!(workspaceGitRepository instanceof PortalWorkspaceGitRepository)) {
            throw new RuntimeException("The portal workspace Git repository is not set");
        }
        return (PortalWorkspaceGitRepository)workspaceGitRepository;
    }

    public void setBuildProfile(Job.BuildProfile buildProfile) {
        if (buildProfile == null) {
            throw new RuntimeException("Invalid build profile " + (Object)((Object)buildProfile));
        }
        this.jsonObject.put("build_profile", (Object)buildProfile.toString());
    }

    public void setCommitOSBAsahModule(boolean commitOSBAsahModule) {
        this._commitOSBAsahModule = commitOSBAsahModule;
    }

    public void setCommitOSBFaroModule(boolean commitOSBFaroModule) {
        this._commitOSBFaroModule = commitOSBFaroModule;
    }

    public void setOSBAsahGitHubURL(String osbAsahGitHubURL) {
        this._osbAsahGitHubURL = osbAsahGitHubURL;
    }

    public void setOSBFaroGitHubURL(String osbFaroGitHubURL) {
        this._osbFaroGitHubURL = osbFaroGitHubURL;
    }

    public void setPortalPrivateGitHubURL(String portalPrivateGitHubURL) {
        this._portalPrivateGitHubURL = portalPrivateGitHubURL;
    }

    @Override
    public void setUp() {
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = this.getPortalWorkspaceGitRepository();
        portalWorkspaceGitRepository.setUp();
        this._configureBladeSamplesWorkspaceGitRepository();
        this._configureLiferayFacesAlloyWorkspaceGitRepository();
        this._configureLiferayFacesBridgeImplWorkspaceGitRepository();
        this._configureLiferayFacesPortalWorkspaceGitRepository();
        this._configureLiferayFacesShowcaseWorkspaceGitRepository();
        this._configureOSBAsahWorkspaceGitRepository();
        this._configureOSBFaroWorkspaceGitRepository();
        this._configurePluginsWorkspaceGitRepository();
        this._configurePortalPrivateWorkspaceGitRepository();
        this._configurePortalsPlutoWorkspaceGitRepository();
        this._configureReleaseToolWorkspaceGitRepository();
        super.setUp();
        Job.BuildProfile buildProfile = this.getBuildProfile();
        if (buildProfile == Job.BuildProfile.DXP) {
            portalWorkspaceGitRepository.setUpPortalProfile();
        }
        portalWorkspaceGitRepository.setUpTCKHome();
        this.updateOSBAsahModule();
        this.updateOSBFaroModule();
    }

    protected PortalWorkspace(JSONObject jsonObject) {
        super(jsonObject);
    }

    protected PortalWorkspace(String primaryRepositoryName, String upstreamBranchName) {
        super(primaryRepositoryName, upstreamBranchName);
    }

    protected PortalWorkspace(String primaryRepositoryName, String upstreamBranchName, String jobName) {
        super(primaryRepositoryName, upstreamBranchName, jobName);
    }

    protected void copyOSBAsahRepositoryToModule() {
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = this.getPortalWorkspaceGitRepository();
        File modulesDir = new File(portalWorkspaceGitRepository.getDirectory(), "modules/dxp/apps/osb/osb-asah");
        if (!modulesDir.exists()) {
            return;
        }
        WorkspaceGitRepository workspaceGitRepository = this.getWorkspaceGitRepository("com-liferay-osb-asah-private");
        if (workspaceGitRepository == null) {
            return;
        }
        List<PathMatcher> deleteExcludePathMatchers = JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(modulesDir), File.separator), ".gradle/", ".gitrepo", "ci-merge", "gradle/");
        try {
            JenkinsResultsParserUtil.delete(modulesDir, null, deleteExcludePathMatchers);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        List<PathMatcher> copyExcludePathMatchers = JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(workspaceGitRepository.getDirectory()), File.separator), ".git/", ".gradle/", "gradle/", "settings.gradle");
        try {
            JenkinsResultsParserUtil.copy(workspaceGitRepository.getDirectory(), modulesDir, null, copyExcludePathMatchers);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("module.dir", "dxp/apps/osb/osb-asah");
            parameters.put("portal.dir", JenkinsResultsParserUtil.getCanonicalPath(portalWorkspaceGitRepository.getDirectory()));
            AntUtil.callTarget(portalWorkspaceGitRepository.getDirectory(), "build-test.xml", "clean-version-override", parameters);
        }
        catch (AntException antException) {
            throw new RuntimeException(antException);
        }
        List<File> versionOverrideFiles = JenkinsResultsParserUtil.findFiles(modulesDir, JenkinsResultsParserUtil.combine(".version-override-", modulesDir.getName(), ".properties"));
        for (File versionOverrideFile : versionOverrideFiles) {
            JenkinsResultsParserUtil.delete(versionOverrideFile);
        }
        GitWorkingDirectory gitWorkingDirectory = portalWorkspaceGitRepository.getGitWorkingDirectory();
        String gitStatus = gitWorkingDirectory.status();
        System.out.println(gitStatus);
        if (!this._commitOSBAsahModule || gitStatus.contains("nothing to commit")) {
            return;
        }
        gitWorkingDirectory.commitFileToCurrentBranch("modules/dxp/apps/osb/osb-asah", JenkinsResultsParserUtil.combine("Committing changes from ", workspaceGitRepository.getName(), " at ", workspaceGitRepository.getSenderBranchSHA(), " for testing on CI"));
    }

    protected void copyOSBFaroRepositoryToModule() {
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = this.getPortalWorkspaceGitRepository();
        File modulesDir = new File(portalWorkspaceGitRepository.getDirectory(), "modules/dxp/apps/osb/osb-faro");
        if (!modulesDir.exists()) {
            return;
        }
        WorkspaceGitRepository workspaceGitRepository = this.getWorkspaceGitRepository("com-liferay-osb-faro-private");
        if (workspaceGitRepository == null) {
            return;
        }
        List<PathMatcher> deleteExcludePathMatchers = JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(modulesDir), File.separator), ".gradle/", ".gitrepo", "ci-merge", "gradle/");
        try {
            JenkinsResultsParserUtil.delete(modulesDir, null, deleteExcludePathMatchers);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        List<PathMatcher> copyExcludePathMatchers = JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(workspaceGitRepository.getDirectory()), File.separator), ".git/", ".gradle/", "gradle/", "settings.gradle");
        try {
            JenkinsResultsParserUtil.copy(workspaceGitRepository.getDirectory(), modulesDir, null, copyExcludePathMatchers);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("module.dir", "dxp/apps/osb/osb-faro");
            parameters.put("portal.dir", JenkinsResultsParserUtil.getCanonicalPath(portalWorkspaceGitRepository.getDirectory()));
            AntUtil.callTarget(portalWorkspaceGitRepository.getDirectory(), "build-test.xml", "clean-version-override", parameters);
        }
        catch (AntException antException) {
            throw new RuntimeException(antException);
        }
        List<File> versionOverrideFiles = JenkinsResultsParserUtil.findFiles(modulesDir, JenkinsResultsParserUtil.combine(".version-override-", modulesDir.getName(), ".properties"));
        for (File versionOverrideFile : versionOverrideFiles) {
            JenkinsResultsParserUtil.delete(versionOverrideFile);
        }
        GitWorkingDirectory gitWorkingDirectory = portalWorkspaceGitRepository.getGitWorkingDirectory();
        String gitStatus = gitWorkingDirectory.status();
        System.out.println(gitStatus);
        if (!this._commitOSBFaroModule || gitStatus.contains("nothing to commit")) {
            return;
        }
        gitWorkingDirectory.commitFileToCurrentBranch("modules/dxp/apps/osb/osb-faro", JenkinsResultsParserUtil.combine("Committing changes from ", workspaceGitRepository.getName(), " at ", workspaceGitRepository.getSenderBranchSHA(), " for testing on CI"));
    }

    protected WorkspaceGitRepository getOSBAsahWorkspaceGitRepository() {
        return this.getWorkspaceGitRepository("com-liferay-osb-asah-private");
    }

    protected WorkspaceGitRepository getOSBFaroWorkspaceGitRepository() {
        return this.getWorkspaceGitRepository("com-liferay-osb-faro-private");
    }

    protected void updateOSBAsahModule() {
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = this.getPortalWorkspaceGitRepository();
        File ciMergeFile = new File(portalWorkspaceGitRepository.getDirectory(), "modules/dxp/apps/osb/osb-asah/ci-merge");
        if (!ciMergeFile.exists()) {
            return;
        }
        this.copyOSBAsahRepositoryToModule();
    }

    protected void updateOSBFaroModule() {
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = this.getPortalWorkspaceGitRepository();
        File ciMergeFile = new File(portalWorkspaceGitRepository.getDirectory(), "modules/dxp/apps/osb/osb-faro/ci-merge");
        if (!ciMergeFile.exists()) {
            return;
        }
        this.copyOSBFaroRepositoryToModule();
    }

    private void _configureBladeSamplesWorkspaceGitRepository() {
        this._updateWorkspaceGitRepository("git-commit-blade-samples", "liferay-blade-samples");
    }

    private void _configureLiferayFacesAlloyWorkspaceGitRepository() {
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = this.getPortalWorkspaceGitRepository();
        String gitHubURL = portalWorkspaceGitRepository.getLiferayFacesAlloyURL();
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitHubURL)) {
            return;
        }
        WorkspaceGitRepository workspaceGitRepository = this.getWorkspaceGitRepository("liferay-faces-alloy");
        if (workspaceGitRepository == null) {
            return;
        }
        workspaceGitRepository.setGitHubURL(gitHubURL);
    }

    private void _configureLiferayFacesBridgeImplWorkspaceGitRepository() {
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = this.getPortalWorkspaceGitRepository();
        String gitHubURL = portalWorkspaceGitRepository.getLiferayFacesBridgeImplURL();
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitHubURL)) {
            return;
        }
        WorkspaceGitRepository workspaceGitRepository = this.getWorkspaceGitRepository("liferay-faces-bridge-impl");
        if (workspaceGitRepository == null) {
            return;
        }
        workspaceGitRepository.setGitHubURL(gitHubURL);
    }

    private void _configureLiferayFacesPortalWorkspaceGitRepository() {
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = this.getPortalWorkspaceGitRepository();
        String gitHubURL = portalWorkspaceGitRepository.getLiferayFacesPortalURL();
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitHubURL)) {
            return;
        }
        WorkspaceGitRepository workspaceGitRepository = this.getWorkspaceGitRepository("liferay-faces-portal");
        if (workspaceGitRepository == null) {
            return;
        }
        workspaceGitRepository.setGitHubURL(gitHubURL);
    }

    private void _configureLiferayFacesShowcaseWorkspaceGitRepository() {
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = this.getPortalWorkspaceGitRepository();
        String gitHubURL = portalWorkspaceGitRepository.getLiferayFacesShowcaseURL();
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitHubURL)) {
            return;
        }
        WorkspaceGitRepository workspaceGitRepository = this.getWorkspaceGitRepository("liferay-faces-showcase");
        if (workspaceGitRepository == null) {
            return;
        }
        workspaceGitRepository.setGitHubURL(gitHubURL);
    }

    private void _configureOSBAsahWorkspaceGitRepository() {
        boolean updated = this._updateWorkspaceGitRepository("modules/dxp/apps/osb/osb-asah/ci-merge", "com-liferay-osb-asah-private");
        if (updated || this._osbAsahGitHubURL == null) {
            return;
        }
        WorkspaceGitRepository workspaceGitRepository = this.getWorkspaceGitRepository("com-liferay-osb-asah-private");
        if (workspaceGitRepository == null) {
            return;
        }
        workspaceGitRepository.setGitHubURL(this._osbAsahGitHubURL);
    }

    private void _configureOSBFaroWorkspaceGitRepository() {
        if (this._osbFaroGitHubURL == null) {
            return;
        }
        WorkspaceGitRepository workspaceGitRepository = this.getWorkspaceGitRepository("com-liferay-osb-faro-private");
        if (workspaceGitRepository == null) {
            return;
        }
        workspaceGitRepository.setGitHubURL(this._osbFaroGitHubURL);
    }

    private void _configurePluginsWorkspaceGitRepository() {
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = this.getPortalWorkspaceGitRepository();
        this._updateWorkspaceGitRepository("git-commit-plugins", portalWorkspaceGitRepository.getPluginsRepositoryDirName());
        PluginsWorkspaceGitRepository pluginsWorkspaceGitRepository = this.getPluginsWorkspaceGitRepository();
        if (pluginsWorkspaceGitRepository == null) {
            return;
        }
        pluginsWorkspaceGitRepository.setPortalUpstreamBranchName(portalWorkspaceGitRepository.getUpstreamBranchName());
    }

    private void _configurePortalPrivateWorkspaceGitRepository() {
        WorkspaceGitRepository primaryWorkspaceGitRepository = this.getPrimaryWorkspaceGitRepository();
        if (!(primaryWorkspaceGitRepository instanceof PortalWorkspaceGitRepository)) {
            return;
        }
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = (PortalWorkspaceGitRepository)primaryWorkspaceGitRepository;
        String portalPrivateDirectoryName = portalWorkspaceGitRepository.getPortalPrivateRepositoryDirName();
        WorkspaceGitRepository workspaceGitRepository = this.getWorkspaceGitRepository(portalPrivateDirectoryName);
        if (workspaceGitRepository == null || this._portalPrivateGitHubURL == null) {
            return;
        }
        workspaceGitRepository.setGitHubURL(this._portalPrivateGitHubURL);
        this._updateWorkspaceGitRepository("git-commit-portal-private", portalPrivateDirectoryName);
    }

    private void _configurePortalsPlutoWorkspaceGitRepository() {
        this._updateWorkspaceGitRepository("git-commit-portals-pluto", "portals-pluto");
    }

    private void _configureReleaseToolWorkspaceGitRepository() {
        this._updateWorkspaceGitRepository("git-commit/liferay-release-tool-ee", "liferay-release-tool-ee");
        ReleaseToolWorkspaceGitRepository releaseToolWorkspaceGitRepository = this._getReleaseToolWorkspaceGitRepository();
        if (releaseToolWorkspaceGitRepository == null) {
            return;
        }
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = this.getPortalWorkspaceGitRepository();
        releaseToolWorkspaceGitRepository.setPortalUpstreamBranchName(portalWorkspaceGitRepository.getUpstreamBranchName());
    }

    private ReleaseToolWorkspaceGitRepository _getReleaseToolWorkspaceGitRepository() {
        WorkspaceGitRepository workspaceGitRepository = this.getWorkspaceGitRepository("liferay-release-tool-ee");
        if (!(workspaceGitRepository instanceof ReleaseToolWorkspaceGitRepository)) {
            return null;
        }
        return (ReleaseToolWorkspaceGitRepository)workspaceGitRepository;
    }

    private boolean _updateWorkspaceGitRepository(String gitCommitFilePath, String gitRepositoryName) {
        WorkspaceGitRepository workspaceGitRepository = this.getWorkspaceGitRepository(gitRepositoryName);
        if (workspaceGitRepository == null) {
            return false;
        }
        WorkspaceGitRepository primaryWorkspaceGitRepository = this.getPrimaryWorkspaceGitRepository();
        String gitCommit = primaryWorkspaceGitRepository.getFileContent(gitCommitFilePath);
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitCommit)) {
            return false;
        }
        if (JenkinsResultsParserUtil.isSHA(gitCommit)) {
            workspaceGitRepository.setSenderBranchSHA(gitCommit);
            return true;
        }
        if (!GitUtil.isValidGitHubRefURL(gitCommit) && !PullRequest.isValidGitHubPullRequestURL(gitCommit)) {
            return false;
        }
        workspaceGitRepository.setGitHubURL(gitCommit);
        return true;
    }
}

