/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamControllerBuildData;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamControllerBuildRunner;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class PortalTestSuiteUpstreamControllerSingleSuiteBuildRunner<S extends PortalTestSuiteUpstreamControllerBuildData>
extends PortalTestSuiteUpstreamControllerBuildRunner<S> {
    private static final Integer _CONTROLLER_BUILD_TIMEOUT_DEFAULT = 86400000;
    private static final Pattern _buildURLPattern = Pattern.compile("https://(?<masterHostname>test-\\d+-\\d+)\\.liferay\\.com/job/(?<jobName>[^/]+)/(?<buildNumber>\\d+)/?");
    private static final Pattern _jobURLPattern = Pattern.compile("https://(?<masterHostname>test-\\d+-\\d+)\\.liferay\\.com/job/(?<jobName>[^/\"]+)/?");
    private static final Pattern _portalBranchSHAPattern = Pattern.compile("<strong>Git ID:</strong> <a href=\"https://github.com/[^/]+/[^/]+/commit/(?<branchSHA>[0-9a-f]{40})\">[0-9a-f]{7}</a>");
    private static final Pattern _portalGitHubCompareURLPattern = Pattern.compile("<strong>Git Compare:</strong> <a href=\"[^\"]+\">[^<]+</a>");

    @Override
    public void run() {
        this.retirePreviousBuilds();
        if (this._allowConcurrentBuilds() || this._expirePreviousBuild()) {
            super.run();
            return;
        }
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        if (this._previousBuildHasCurrentSHA()) {
            buildData.setBuildDescription(JenkinsResultsParserUtil.combine("<strong>SKIPPED</strong> - <a href=\"https://github.com/", "liferay/liferay-portal/commit/", buildData.getPortalBranchSHA(), "\">", this._getPortalBranchAbbreviatedSHA(), "</a> was already ran"));
            super.updateBuildDescription();
            return;
        }
        if (this._previousBuildHasExistingInvocation()) {
            buildData.setBuildDescription("<strong>SKIPPED</strong> - Job was already invoked");
            super.updateBuildDescription();
            return;
        }
        if (this._previousBuildHasRunningInvocation()) {
            buildData.setBuildDescription("<strong>SKIPPED</strong> - Job is already running");
            super.updateBuildDescription();
            return;
        }
        super.run();
    }

    protected PortalTestSuiteUpstreamControllerSingleSuiteBuildRunner(S buildData) {
        super(buildData);
    }

    @Override
    protected void invokeTestSuiteBuilds() {
        String testrayProjectName;
        String jenkinsAuthenticationToken;
        String jobURL = this.getJobURL();
        StringBuilder sb = new StringBuilder();
        sb.append(jobURL);
        sb.append("/buildWithParameters?");
        try {
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            jenkinsAuthenticationToken = buildProperties.getProperty("jenkins.authentication.token");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        sb.append("token=");
        sb.append(jenkinsAuthenticationToken);
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        HashMap<String, String> invocationParameters = new HashMap<String, String>();
        String testSuiteName = buildData.getTestSuiteName();
        invocationParameters.put("CI_TEST_SUITE", testSuiteName);
        invocationParameters.put("CONTROLLER_BUILD_URL", buildData.getBuildURL());
        invocationParameters.put("JENKINS_GITHUB_BRANCH_NAME", buildData.getJenkinsGitHubBranchName());
        invocationParameters.put("JENKINS_GITHUB_BRANCH_USERNAME", buildData.getJenkinsGitHubUsername());
        invocationParameters.put("PORTAL_GIT_COMMIT", buildData.getPortalBranchSHA());
        String portalGitHubCompareURL = this._getPortalGitHubCompareURL();
        if (portalGitHubCompareURL != null) {
            invocationParameters.put("PORTAL_GITHUB_COMPARE_URL", portalGitHubCompareURL);
        }
        invocationParameters.put("PORTAL_GITHUB_URL", buildData.getPortalGitHubURL());
        String testPortalBuildProfile = this.getTestPortalBuildProfile(testSuiteName);
        if (testPortalBuildProfile != null) {
            invocationParameters.put("TEST_PORTAL_BUILD_PROFILE", testPortalBuildProfile);
        }
        if ((testrayProjectName = buildData.getTestrayProjectName()) != null) {
            invocationParameters.put("TESTRAY_BUILD_NAME", buildData.getTestrayBuildName());
            invocationParameters.put("TESTRAY_PROJECT_NAME", testrayProjectName);
            invocationParameters.put("TESTRAY_ROUTINE_NAME", buildData.getTestrayRoutineName());
        }
        invocationParameters.putAll(buildData.getBuildParameters());
        for (Map.Entry invocationParameter : invocationParameters.entrySet()) {
            if (invocationParameter.getValue() == null) continue;
            sb.append("&");
            sb.append((String)invocationParameter.getKey());
            sb.append("=");
            sb.append((String)invocationParameter.getValue());
        }
        try {
            JenkinsResultsParserUtil.toString(sb.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        sb = new StringBuilder();
        sb.append("<a href=\"");
        sb.append(JenkinsResultsParserUtil.getRemoteURL(jobURL));
        sb.append("\"><strong>IN QUEUE</strong></a>");
        sb.append("<ul><li><strong>Git ID:</strong> ");
        sb.append("<a href=\"https://github.com/");
        sb.append(buildData.getPortalGitHubUsername());
        sb.append("/");
        sb.append(buildData.getPortalGitHubRepositoryName());
        sb.append("/commit/");
        sb.append(buildData.getPortalBranchSHA());
        sb.append("\">");
        sb.append(this._getPortalBranchAbbreviatedSHA());
        sb.append("</a></li>");
        if (portalGitHubCompareURL != null) {
            sb.append("<li><strong>Git Compare:</strong> <a href=\"");
            sb.append(this._getPortalGitHubCompareURL());
            sb.append("\">??? commits</a></li>");
        }
        sb.append("</ul>");
        buildData.setBuildDescription(sb.toString());
        this.updateBuildDescription();
    }

    private boolean _allowConcurrentBuilds() {
        String allowConcurrentBuildsString = System.getenv("ALLOW_CONCURRENT_BUILDS");
        if (allowConcurrentBuildsString == null) {
            return false;
        }
        allowConcurrentBuildsString = allowConcurrentBuildsString.toLowerCase();
        return (allowConcurrentBuildsString = allowConcurrentBuildsString.trim()).equals("true");
    }

    private boolean _expirePreviousBuild() {
        for (JSONObject previousBuildJSONObject : this.getPreviousBuildJSONObjects()) {
            Matcher jobURLMatcher;
            String controllerBuildURL;
            Matcher buildURLMatcher;
            String description = previousBuildJSONObject.optString("description", "");
            if (!description.contains("IN PROGRESS") && !description.contains("IN QUEUE") || !(buildURLMatcher = _buildURLPattern.matcher(controllerBuildURL = previousBuildJSONObject.getString("url"))).find() || !(jobURLMatcher = _jobURLPattern.matcher(description)).find()) continue;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("CONTROLLER_BUILD_URL", controllerBuildURL);
            JenkinsMaster jenkinsMaster = JenkinsMaster.getInstance(jobURLMatcher.group("masterHostname"));
            String jobName = jobURLMatcher.group("jobName");
            if (jenkinsMaster.isBuildQueued(jobName, parameters) || jenkinsMaster.isBuildInProgress(jobName, parameters)) {
                long timestamp = previousBuildJSONObject.optLong("timestamp", 0L);
                if (timestamp == 0L) continue;
                long inProgressBuildDuration = JenkinsResultsParserUtil.getCurrentTimeMillis() - timestamp;
                System.out.println(JenkinsResultsParserUtil.combine("In progress build started ", JenkinsResultsParserUtil.toDurationString(inProgressBuildDuration), " ago"));
                if (inProgressBuildDuration < this._getControllerBuildTimeout()) {
                    return false;
                }
            }
            description = description.replace("IN PROGRESS", "EXPIRE");
            description = description.replace("IN QUEUE", "EXPIRE");
            JenkinsResultsParserUtil.updateBuildDescription(description, previousBuildJSONObject.getInt("number"), buildURLMatcher.group("jobName"), buildURLMatcher.group("masterHostname"));
            return true;
        }
        return false;
    }

    private long _getControllerBuildTimeout() {
        try {
            PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
            String controllerBuildTimeout = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "controller.build.timeout", buildData.getJobName());
            if (!JenkinsResultsParserUtil.isNullOrEmpty(controllerBuildTimeout)) {
                return Long.parseLong(controllerBuildTimeout) * 1000L;
            }
            return _CONTROLLER_BUILD_TIMEOUT_DEFAULT.intValue();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private String _getPortalBranchAbbreviatedSHA() {
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        String portalBranchSHA = buildData.getPortalBranchSHA();
        return portalBranchSHA.substring(0, 7);
    }

    private String _getPortalGitHubCompareURL() {
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        return buildData.getPortalGitHubCompareURL(this._getPreviousBuildPortalBranchSHA());
    }

    private String _getPreviousBuildPortalBranchSHA() {
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        String currentPortalBranchSHA = buildData.getPortalBranchSHA();
        for (JSONObject previousBuildJSONObject : this.getPreviousBuildJSONObjects()) {
            String previousPortalBranchSHA;
            String description = previousBuildJSONObject.optString("description", "");
            Matcher matcher = _portalBranchSHAPattern.matcher(description);
            if (!matcher.find() || currentPortalBranchSHA.equals(previousPortalBranchSHA = matcher.group("branchSHA"))) continue;
            return previousPortalBranchSHA;
        }
        return null;
    }

    private boolean _previousBuildHasCurrentSHA() {
        String portalBranchSHA = this._getPortalBranchAbbreviatedSHA();
        for (JSONObject previousBuildJSONObject : this.getPreviousBuildJSONObjects()) {
            String description = previousBuildJSONObject.optString("description", "");
            if (description.contains("EXPIRE") || description.contains("SKIPPED") || !description.contains(portalBranchSHA)) continue;
            return true;
        }
        return false;
    }

    private boolean _previousBuildHasExistingInvocation() {
        for (JSONObject previousBuildJSONObject : this.getPreviousBuildJSONObjects()) {
            String description = previousBuildJSONObject.optString("description", "");
            if (!description.contains("IN QUEUE")) continue;
            return true;
        }
        return false;
    }

    private boolean _previousBuildHasRunningInvocation() {
        for (JSONObject previousBuildJSONObject : this.getPreviousBuildJSONObjects()) {
            Matcher buildURLMatcher;
            String description = previousBuildJSONObject.optString("description", "");
            if (!description.contains("IN PROGRESS") || !(buildURLMatcher = _buildURLPattern.matcher(description)).find()) continue;
            String buildURL = buildURLMatcher.group();
            try {
                JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(buildURL + "/api/json?tree=result"));
                Object result = jsonObject.get("result");
                if (result.equals(JSONObject.NULL)) {
                    return true;
                }
                JSONObject injectedEnvVarsJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(previousBuildJSONObject.getString("url") + "/injectedEnvVars/api/json"));
                JSONObject envMapJSONObject = injectedEnvVarsJSONObject.getJSONObject("envMap");
                StringBuilder sb = new StringBuilder();
                sb.append("<strong style=\"color: red\">FAILURE</strong> - ");
                sb.append(buildURLMatcher.group());
                Matcher portalBranchSHAMatcher = _portalBranchSHAPattern.matcher(description);
                Matcher portalGitHubCompareURLMatcher = _portalGitHubCompareURLPattern.matcher(description);
                if (portalBranchSHAMatcher.find() || portalGitHubCompareURLMatcher.find()) {
                    sb.append("<ul>");
                    if (portalBranchSHAMatcher.find()) {
                        sb.append("<li>");
                        sb.append(portalBranchSHAMatcher.group());
                        sb.append("</li>");
                    }
                    if (portalGitHubCompareURLMatcher.find()) {
                        sb.append("<li>");
                        sb.append(portalGitHubCompareURLMatcher.group());
                        sb.append("</li>");
                    }
                    sb.append("</ul>");
                }
                JenkinsResultsParserUtil.updateBuildDescription(sb.toString(), Integer.valueOf(envMapJSONObject.getString("BUILD_NUMBER")), envMapJSONObject.getString("JOB_NAME"), envMapJSONObject.getString("HOSTNAME"));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        return false;
    }
}

