/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;

public class PortalRelease {
    private static final String[] _BASE_URL_STRINGS = new String[]{"http://mirrors.lax.liferay.com/releases.liferay.com/portal", "http://mirrors.lax.liferay.com/files.liferay.com/private/ee/portal", "https://releases.liferay.com/portal", "https://files.liferay.com/private/ee/portal"};
    private static final String _PORTAL_VERSION_REGEX = "(?<portalVersion>\\d\\.([u\\d\\.]+)(-ee)?(-dxp-\\d+)?(\\-(ep|ga|rc|sp)\\d+)?)";
    private static final Pattern _bundleFileNamePattern = Pattern.compile(".+\\-(?<portalVersion>\\d\\.([u\\d\\.]+)(-ee)?(-dxp-\\d+)?(\\-(ep|ga|rc|sp)\\d+)?).*\\.(7z|tar.gz|zip)");
    private static final Pattern _bundlesBaseURLPattern = Pattern.compile("https?://.+/(?<portalVersion>\\d\\.([u\\d\\.]+)(-ee)?(-dxp-\\d+)?(\\-(ep|ga|rc|sp)\\d+)?)");
    private static final Pattern _bundleURLPattern = Pattern.compile("(?<bundlesBaseURL>https?://.+)/(?<bundleFileName>[^\\/]+\\.(7z|tar.gz|zip))");
    private static final Pattern _portalBundleGlassFishFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-glassfish-[^\\\"]+\\.(7z|tar.gz|zip))\\\"");
    private static final Pattern _portalBundleJBossFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-jboss-[^\\\"]+\\.(7z|tar.gz|zip))\\\"");
    private static final Pattern _portalBundleTomcatFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-tomcat-[^\\\"]+\\.(7z|tar.gz|zip))\\\"");
    private static final Pattern _portalBundleWildFlyFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-wildfly-[^\\\"]+\\.(7z|tar.gz|zip))\\\"");
    private static final Pattern _portalDependenciesZipFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-dependencies-[^\\\"]+\\.zip)\\\"");
    private static final Pattern _portalOSGiZipFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-osgi-[^\\\"]+\\.zip)\\\"");
    private static final Pattern _portalSQLZipFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-sql-[^\\\"]+\\.zip)\\\"");
    private static final Pattern _portalToolsZipFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-tools-[^\\\"]+\\.zip)\\\"");
    private static final Pattern _portalVersionPattern = Pattern.compile("(?<majorVersion>\\d)\\.(?<minorVersion>\\d)\\.(?<fixVersion>\\d+)([-\\.](?<updatePrefix>u)?(?<updateVersion>\\d+))?(-dxp-(?<dxpVersion>\\d+))?.*");
    private static final Pattern _portalWarFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+\\.war)\\\"");
    private final URL _bundlesBaseURL;
    private String _pluginsWarZipURLString;
    private String _portalBundleGlassFishURLString;
    private String _portalBundleJBossURLString;
    private String _portalBundleTomcatURLString;
    private String _portalBundleWildFlyURLString;
    private String _portalDependenciesZipURLString;
    private String _portalOSGiZipURLString;
    private String _portalSQLZipURLString;
    private String _portalToolsZipURLString;
    private final String _portalVersion;
    private String _portalWarURLString;

    public PortalRelease(String portalVersion) {
        URL bundlesBaseURL = null;
        for (String baseURLString : _BASE_URL_STRINGS) {
            String bundlesBaseURLString = baseURLString + "/" + portalVersion.replaceAll("\\.u", "-u");
            String bundlesBaseURLContent = null;
            try {
                bundlesBaseURLContent = JenkinsResultsParserUtil.toString(bundlesBaseURLString + "/", true, 0, 5, 0);
                bundlesBaseURL = new URL(bundlesBaseURLString);
                break;
            }
            catch (IOException iOException) {
                try {
                    String xml = JenkinsResultsParserUtil.toString(baseURLString + "/");
                    xml = xml.substring(xml.indexOf("<html>"));
                    xml = xml.replaceAll("&nbsp;", "");
                    xml = xml.replaceAll("<img[^>]+>", "");
                    xml = xml.replaceAll("<hr>", "");
                    Document document = Dom4JUtil.parse(xml);
                    for (Node node : Dom4JUtil.getNodesByXPath(document, "//a")) {
                        String text = node.getText();
                        text = text.trim();
                        if (!(text = text.replace("/", "")).startsWith(portalVersion + "-")) continue;
                        bundlesBaseURLString = baseURLString + "/" + text;
                        try {
                            bundlesBaseURLContent = JenkinsResultsParserUtil.toString(bundlesBaseURLString + "/", true, 0, 5, 0);
                            portalVersion = text;
                            break;
                        }
                        catch (IOException iOException2) {
                        }
                    }
                    if (bundlesBaseURLContent == null) continue;
                    bundlesBaseURL = new URL(bundlesBaseURLString);
                    break;
                }
                catch (IOException | DocumentException exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        if (bundlesBaseURL == null) {
            throw new RuntimeException("Invalid portal version " + portalVersion);
        }
        this._portalVersion = portalVersion;
        this._bundlesBaseURL = this._getLocalURL(bundlesBaseURL.toString());
        this._initializeURLs();
    }

    public PortalRelease(URL bundleURL) {
        Matcher bundleURLMatcher = _bundleURLPattern.matcher(bundleURL.toString());
        if (!bundleURLMatcher.find()) {
            throw new RuntimeException("Invalid URL " + bundleURL);
        }
        String portalVersion = null;
        String bundleFileName = bundleURLMatcher.group("bundleFileName");
        Matcher bundleFileNameMatcher = _bundleFileNamePattern.matcher(bundleFileName);
        if (bundleFileNameMatcher.find()) {
            portalVersion = bundleFileNameMatcher.group("portalVersion");
        }
        String bundlesBaseURLString = bundleURLMatcher.group("bundlesBaseURL");
        if (portalVersion == null) {
            Matcher bundlesBaseURLMatcher = _bundlesBaseURLPattern.matcher(bundlesBaseURLString);
            if (!bundlesBaseURLMatcher.find()) {
                throw new RuntimeException("Invalid bundle file name " + bundleFileName);
            }
            portalVersion = bundlesBaseURLMatcher.group("portalVersion");
        }
        this._bundlesBaseURL = this._getLocalURL(bundlesBaseURLString);
        this._portalVersion = portalVersion;
        this._initializeURLs();
    }

    public PortalRelease(URL bundlesBaseURL, String portalVersion) {
        if (bundlesBaseURL == null) {
            throw new RuntimeException("Bundles base URL is null");
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalVersion)) {
            throw new RuntimeException("Portal version is null or empty");
        }
        this._portalVersion = portalVersion;
        String bundlesBaseURLString = bundlesBaseURL.toString();
        if (bundlesBaseURLString.endsWith("/")) {
            bundlesBaseURLString = bundlesBaseURLString.substring(0, bundlesBaseURLString.length() - 1);
        }
        this._bundlesBaseURL = this._getLocalURL(bundlesBaseURLString);
        this._initializeURLs();
    }

    public URL getBundlesBaseLocalURL() {
        return this._getLocalURL(this._bundlesBaseURL.toString());
    }

    public URL getBundlesBaseURL() {
        return this._getRemoteURL(this._bundlesBaseURL.toString());
    }

    public String getHTMLReport() {
        URL[] urls;
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        for (URL url : urls = new URL[]{this.getPluginsWarZipURL(), this.getPortalBundleGlassFishURL(), this.getPortalBundleJBossURL(), this.getPortalBundleTomcatURL(), this.getPortalBundleWildFlyURL(), this.getPortalDependenciesZipURL(), this.getPortalOSGiZipURL(), this.getPortalSQLZipURL(), this.getPortalToolsZipURL(), this.getPortalWarURL()}) {
            if (url == null) continue;
            String urlString = url.toString();
            sb.append("<li><a href=\"");
            sb.append(urlString);
            sb.append("\">");
            sb.append(urlString.replaceAll(".+/([^/]+)", "$1"));
            sb.append("</a></li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public URL getPluginsWarZipLocalURL() {
        return this._getLocalURL(this._pluginsWarZipURLString);
    }

    public URL getPluginsWarZipURL() {
        return this._getRemoteURL(this._pluginsWarZipURLString);
    }

    public URL getPortalBundleGlassFishLocalURL() {
        return this._getLocalURL(this._portalBundleGlassFishURLString);
    }

    public URL getPortalBundleGlassFishURL() {
        return this._getRemoteURL(this._portalBundleGlassFishURLString);
    }

    public URL getPortalBundleJBossLocalURL() {
        return this._getLocalURL(this._portalBundleJBossURLString);
    }

    public URL getPortalBundleJBossURL() {
        return this._getRemoteURL(this._portalBundleJBossURLString);
    }

    public URL getPortalBundleTomcatLocalURL() {
        return this._getLocalURL(this._portalBundleTomcatURLString);
    }

    public URL getPortalBundleTomcatURL() {
        return this._getRemoteURL(this._portalBundleTomcatURLString);
    }

    public URL getPortalBundleWildFlyLocalURL() {
        return this._getLocalURL(this._portalBundleWildFlyURLString);
    }

    public URL getPortalBundleWildFlyURL() {
        return this._getRemoteURL(this._portalBundleWildFlyURLString);
    }

    public URL getPortalDependenciesZipLocalURL() {
        return this._getLocalURL(this._portalDependenciesZipURLString);
    }

    public URL getPortalDependenciesZipURL() {
        return this._getRemoteURL(this._portalDependenciesZipURLString);
    }

    public URL getPortalOSGiZipLocalURL() {
        return this._getLocalURL(this._portalOSGiZipURLString);
    }

    public URL getPortalOSGiZipURL() {
        return this._getRemoteURL(this._portalOSGiZipURLString);
    }

    public URL getPortalSQLZipLocalURL() {
        return this._getLocalURL(this._portalSQLZipURLString);
    }

    public URL getPortalSQLZipURL() {
        return this._getRemoteURL(this._portalSQLZipURLString);
    }

    public URL getPortalToolsZipLocalURL() {
        return this._getLocalURL(this._portalToolsZipURLString);
    }

    public URL getPortalToolsZipURL() {
        return this._getRemoteURL(this._portalToolsZipURLString);
    }

    public String getPortalUpstreamBranchName() {
        try {
            String portalUpstreamBranchName = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "portal.branch.name", this.getPortalVersionPropertyOption());
            if (!JenkinsResultsParserUtil.isNullOrEmpty(portalUpstreamBranchName)) {
                return portalUpstreamBranchName;
            }
        }
        catch (IOException portalUpstreamBranchName) {
            // empty catch block
        }
        Matcher matcher = _portalVersionPattern.matcher(this._portalVersion);
        if (!matcher.find()) {
            return "master";
        }
        StringBuilder sb = new StringBuilder();
        String majorVersion = matcher.group("majorVersion");
        if (majorVersion.equals("6")) {
            sb.append("ee-");
        }
        sb.append(majorVersion);
        sb.append(".");
        sb.append(matcher.group("minorVersion"));
        sb.append(".x");
        return sb.toString();
    }

    public String getPortalVersion() {
        return this._portalVersion;
    }

    public String getPortalVersionPropertyOption() {
        String updateVersion;
        Matcher matcher = _portalVersionPattern.matcher(this._portalVersion);
        if (!matcher.find()) {
            return this._portalVersion;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(matcher.group("majorVersion"));
        sb.append(".");
        sb.append(matcher.group("minorVersion"));
        sb.append(".");
        sb.append(matcher.group("fixVersion"));
        String dxpVersion = matcher.group("dxpVersion");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(dxpVersion)) {
            sb.append("-dxp-");
            sb.append(dxpVersion);
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(updateVersion = matcher.group("updateVersion"))) {
            sb.append(".");
            String updatePrefix = matcher.group("updatePrefix");
            if (!JenkinsResultsParserUtil.isNullOrEmpty(updatePrefix)) {
                sb.append(updatePrefix);
            }
            sb.append(updateVersion);
        }
        return sb.toString();
    }

    public URL getPortalWarLocalURL() {
        return this._getLocalURL(this._portalWarURLString);
    }

    public URL getPortalWarURL() {
        return this._getRemoteURL(this._portalWarURLString);
    }

    public void setPluginsWarZipURL(URL pluginsWarZipURL) {
        if (pluginsWarZipURL == null) {
            this._pluginsWarZipURLString = null;
            return;
        }
        this._pluginsWarZipURLString = JenkinsResultsParserUtil.getLocalURL(pluginsWarZipURL.toString());
    }

    public void setPortalBundleGlassFishURL(URL portalBundleGlassFishURL) {
        if (portalBundleGlassFishURL == null) {
            this._portalBundleGlassFishURLString = null;
            return;
        }
        this._portalBundleGlassFishURLString = JenkinsResultsParserUtil.getLocalURL(portalBundleGlassFishURL.toString());
    }

    public void setPortalBundleJBossURL(URL portalBundleJBossURL) {
        if (portalBundleJBossURL == null) {
            this._portalBundleJBossURLString = null;
            return;
        }
        this._portalBundleJBossURLString = JenkinsResultsParserUtil.getLocalURL(portalBundleJBossURL.toString());
    }

    public void setPortalBundleTomcatURL(URL portalBundleTomcatURL) {
        if (portalBundleTomcatURL == null) {
            this._portalBundleTomcatURLString = null;
            return;
        }
        this._portalBundleTomcatURLString = JenkinsResultsParserUtil.getLocalURL(portalBundleTomcatURL.toString());
    }

    public void setPortalBundleWildFlyURL(URL portalBundleWildFlyURL) {
        if (portalBundleWildFlyURL == null) {
            this._portalBundleWildFlyURLString = null;
            return;
        }
        this._portalBundleWildFlyURLString = JenkinsResultsParserUtil.getLocalURL(portalBundleWildFlyURL.toString());
    }

    public void setPortalDependenciesZipURL(URL portalDependenciesZipURL) {
        if (portalDependenciesZipURL == null) {
            this._portalDependenciesZipURLString = null;
            return;
        }
        this._portalDependenciesZipURLString = JenkinsResultsParserUtil.getLocalURL(portalDependenciesZipURL.toString());
    }

    public void setPortalOSGiZipURL(URL portalOSGiZipURL) {
        if (portalOSGiZipURL == null) {
            this._portalOSGiZipURLString = null;
            return;
        }
        this._portalOSGiZipURLString = JenkinsResultsParserUtil.getLocalURL(portalOSGiZipURL.toString());
    }

    public void setPortalSQLZipURL(URL portalSQLZipURL) {
        if (portalSQLZipURL == null) {
            this._portalSQLZipURLString = null;
            return;
        }
        this._portalSQLZipURLString = JenkinsResultsParserUtil.getLocalURL(portalSQLZipURL.toString());
    }

    public void setPortalToolsZipURL(URL portalToolsZipURL) {
        if (portalToolsZipURL == null) {
            this._portalToolsZipURLString = null;
            return;
        }
        this._portalToolsZipURLString = JenkinsResultsParserUtil.getLocalURL(portalToolsZipURL.toString());
    }

    public void setPortalWarURL(URL portalWarURL) {
        if (portalWarURL == null) {
            this._portalWarURLString = null;
            return;
        }
        this._portalWarURLString = JenkinsResultsParserUtil.getLocalURL(portalWarURL.toString());
    }

    private URL _getLocalURL(String urlString) {
        if (urlString == null) {
            return null;
        }
        try {
            return new URL(JenkinsResultsParserUtil.getLocalURL(urlString.replaceAll("([^:])//", "$1/")));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private URL _getRemoteURL(String urlString) {
        if (urlString == null) {
            return null;
        }
        try {
            return new URL(JenkinsResultsParserUtil.getRemoteURL(urlString.replaceAll("([^:])//", "$1/")));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private String _getURLString(String bundlesBaseURLContent, Pattern pattern) {
        Matcher matcher = pattern.matcher(bundlesBaseURLContent);
        if (!matcher.find()) {
            return null;
        }
        return this.getBundlesBaseLocalURL() + "/" + matcher.group("fileName");
    }

    private String _getURLStringFromBuildProperties(String basePropertyName) {
        try {
            String fixVersion;
            String urlString = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), basePropertyName, this.getPortalVersionPropertyOption());
            String portalBuildProfile = "portal";
            Matcher matcher = _portalVersionPattern.matcher(this._portalVersion);
            if (matcher.find() && (fixVersion = matcher.group("fixVersion")).length() >= 2) {
                portalBuildProfile = "dxp";
            }
            if (JenkinsResultsParserUtil.isNullOrEmpty(urlString)) {
                urlString = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), basePropertyName, this.getPortalUpstreamBranchName(), portalBuildProfile);
            }
            if (!JenkinsResultsParserUtil.isNullOrEmpty(urlString)) {
                return urlString;
            }
            return null;
        }
        catch (IOException ioException) {
            return null;
        }
    }

    private void _initializeURLs() {
        String portalWarURLString;
        String portalToolsZipURLString;
        String portalSQLZipURLString;
        String portalOSGiZipURLString;
        String portalDependenciesZipURLString;
        String portalBundleWildFlyURLString;
        String portalBundleTomcatURLString;
        String portalBundleJBossURLString;
        String portalBundleGlassFishURLString;
        String pluginsWarZipURLString = this._getURLStringFromBuildProperties("plugins.war.zip.url");
        if (JenkinsResultsParserUtil.isURL(pluginsWarZipURLString)) {
            this._pluginsWarZipURLString = pluginsWarZipURLString;
        }
        if (JenkinsResultsParserUtil.isURL(portalBundleGlassFishURLString = this._getURLStringFromBuildProperties("portal.bundle.glassfish"))) {
            this._portalBundleGlassFishURLString = portalBundleGlassFishURLString;
        }
        if (JenkinsResultsParserUtil.isURL(portalBundleJBossURLString = this._getURLStringFromBuildProperties("portal.bundle.jboss"))) {
            this._portalBundleJBossURLString = portalBundleJBossURLString;
        }
        if (JenkinsResultsParserUtil.isURL(portalBundleTomcatURLString = this._getURLStringFromBuildProperties("portal.bundle.tomcat"))) {
            this._portalBundleTomcatURLString = portalBundleTomcatURLString;
        }
        if (JenkinsResultsParserUtil.isURL(portalBundleWildFlyURLString = this._getURLStringFromBuildProperties("portal.bundle.wildfly"))) {
            this._portalBundleWildFlyURLString = portalBundleWildFlyURLString;
        }
        if (JenkinsResultsParserUtil.isURL(portalDependenciesZipURLString = this._getURLStringFromBuildProperties("portal.dependencies.zip.url"))) {
            this._portalDependenciesZipURLString = portalDependenciesZipURLString;
        }
        if (JenkinsResultsParserUtil.isURL(portalOSGiZipURLString = this._getURLStringFromBuildProperties("portal.osgi.zip.url"))) {
            this._portalOSGiZipURLString = portalOSGiZipURLString;
        }
        if (JenkinsResultsParserUtil.isURL(portalSQLZipURLString = this._getURLStringFromBuildProperties("portal.sql.zip.url"))) {
            this._portalSQLZipURLString = portalSQLZipURLString;
        }
        if (JenkinsResultsParserUtil.isURL(portalToolsZipURLString = this._getURLStringFromBuildProperties("portal.tools.zip.url"))) {
            this._portalToolsZipURLString = portalToolsZipURLString;
        }
        if (JenkinsResultsParserUtil.isURL(portalWarURLString = this._getURLStringFromBuildProperties("portal.war.url"))) {
            this._portalWarURLString = portalWarURLString;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(this._portalBundleTomcatURLString)) {
            return;
        }
        String bundlesBaseURLContent = null;
        try {
            bundlesBaseURLContent = JenkinsResultsParserUtil.toString(this.getBundlesBaseLocalURL() + "/", false, 0, 5, 0);
        }
        catch (IOException ioException) {
            return;
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(bundlesBaseURLContent)) {
            return;
        }
        this._portalBundleGlassFishURLString = this._getURLString(bundlesBaseURLContent, _portalBundleGlassFishFileNamePattern);
        this._portalBundleJBossURLString = this._getURLString(bundlesBaseURLContent, _portalBundleJBossFileNamePattern);
        this._portalBundleTomcatURLString = this._getURLString(bundlesBaseURLContent, _portalBundleTomcatFileNamePattern);
        this._portalBundleWildFlyURLString = this._getURLString(bundlesBaseURLContent, _portalBundleWildFlyFileNamePattern);
        this._portalDependenciesZipURLString = this._getURLString(bundlesBaseURLContent, _portalDependenciesZipFileNamePattern);
        this._portalOSGiZipURLString = this._getURLString(bundlesBaseURLContent, _portalOSGiZipFileNamePattern);
        this._portalSQLZipURLString = this._getURLString(bundlesBaseURLContent, _portalSQLZipFileNamePattern);
        this._portalToolsZipURLString = this._getURLString(bundlesBaseURLContent, _portalToolsZipFileNamePattern);
        this._portalWarURLString = this._getURLString(bundlesBaseURLContent, _portalWarFileNamePattern);
    }
}

