/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PluginsGitWorkingDirectory;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONObject;

public class PortalGitWorkingDirectory
extends GitWorkingDirectory {
    private Properties _appServerProperties;
    private Properties _releaseProperties;
    private Properties _testProperties;

    public Properties getAppServerProperties() {
        if (this._appServerProperties != null) {
            return this._appServerProperties;
        }
        this._appServerProperties = JenkinsResultsParserUtil.getProperties(new File(this.getWorkingDirectory(), "app.server.properties"));
        return this._appServerProperties;
    }

    public String getMajorPortalVersion() {
        return JenkinsResultsParserUtil.getProperty(this.getReleaseProperties(), "lp.version.major");
    }

    public List<File> getModifiedModuleDirsList() throws IOException {
        return this.getModifiedModuleDirsList(null, null);
    }

    public List<File> getModifiedModuleDirsList(List<PathMatcher> excludesPathMatchers, List<PathMatcher> includesPathMatchers) throws IOException {
        return JenkinsResultsParserUtil.getDirectoriesContainingFiles(this.getModuleDirsList(excludesPathMatchers, includesPathMatchers), this.getModifiedFilesList());
    }

    public List<File> getModifiedNonposhiModules() throws IOException {
        List<File> modifiedFilesList = this.getModifiedFilesList();
        ArrayList<File> modifiedNonposhiFilesList = new ArrayList<File>();
        for (File modifiedFile : modifiedFilesList) {
            if (JenkinsResultsParserUtil.isPoshiFile(modifiedFile)) continue;
            modifiedNonposhiFilesList.add(modifiedFile);
        }
        return JenkinsResultsParserUtil.getDirectoriesContainingFiles(this.getModuleDirsList(null, null), modifiedNonposhiFilesList);
    }

    public List<File> getModifiedNPMTestModuleDirsList() throws IOException {
        List<File> modifiedModuleDirsList = this.getModifiedModuleDirsList();
        ArrayList<File> modifiedNPMTestModuleDirsList = new ArrayList<File>(modifiedModuleDirsList.size());
        for (File modifiedModuleDir : modifiedModuleDirsList) {
            if (!this._isNPMTestModuleDir(modifiedModuleDir)) continue;
            modifiedNPMTestModuleDirsList.add(modifiedModuleDir);
        }
        return modifiedNPMTestModuleDirsList;
    }

    public List<File> getModifiedPoshiModules() throws IOException {
        List<File> modifiedFilesList = this.getModifiedFilesList();
        ArrayList<File> modifiedPoshiFilesList = new ArrayList<File>();
        for (File modifiedFile : modifiedFilesList) {
            if (!JenkinsResultsParserUtil.isPoshiFile(modifiedFile)) continue;
            modifiedPoshiFilesList.add(modifiedFile);
        }
        return JenkinsResultsParserUtil.getDirectoriesContainingFiles(this.getModuleDirsList(null, null), modifiedPoshiFilesList);
    }

    public List<File> getModuleAppDirs() {
        ArrayList<File> moduleAppDirs = new ArrayList<File>();
        List<File> moduleAppBndFiles = JenkinsResultsParserUtil.findFiles(new File(this.getWorkingDirectory(), "modules"), "app\\.bnd");
        for (File moduleAppBndFile : moduleAppBndFiles) {
            moduleAppDirs.add(moduleAppBndFile.getParentFile());
        }
        return moduleAppDirs;
    }

    public List<File> getModuleDirsList() throws IOException {
        return this.getModuleDirsList(null, null);
    }

    public List<File> getModuleDirsList(List<PathMatcher> excludesPathMatchers, List<PathMatcher> includesPathMatchers) throws IOException {
        File modulesDir = new File(this.getWorkingDirectory(), "modules");
        if (!modulesDir.exists()) {
            return new ArrayList<File>();
        }
        final List<PathMatcher> excludedModulesPathMatchers = excludesPathMatchers;
        final List<PathMatcher> includedModulesPathMatchers = includesPathMatchers;
        final ArrayList<File> moduleDirsList = new ArrayList<File>();
        Files.walkFileTree(modulesDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
            private Module _module;

            @Override
            public FileVisitResult postVisitDirectory(Path filePath, IOException ioException) {
                if (this._module == null) {
                    return FileVisitResult.CONTINUE;
                }
                Module currentModule = Module.getModule(filePath);
                if (currentModule == null) {
                    return FileVisitResult.CONTINUE;
                }
                File currentFile = currentModule.getFile();
                if (currentFile.equals(this._module.getFile())) {
                    moduleDirsList.add(currentFile);
                    this._module = null;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) {
                if (!JenkinsResultsParserUtil.isFileIncluded((List<PathMatcher>)excludedModulesPathMatchers, (List<PathMatcher>)includedModulesPathMatchers, filePath)) {
                    return FileVisitResult.CONTINUE;
                }
                Module currentModule = Module.getModule(filePath);
                if (currentModule == null) {
                    return FileVisitResult.CONTINUE;
                }
                if (this._module == null) {
                    this._module = currentModule;
                    return FileVisitResult.CONTINUE;
                }
                int currentPriority = currentModule.getPriority();
                if (currentPriority < this._module.getPriority()) {
                    this._module = currentModule;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        Collections.sort(moduleDirsList);
        return moduleDirsList;
    }

    public List<File> getModulePullSubrepoDirs() {
        File modulesDir = new File(this.getWorkingDirectory(), "modules");
        if (!modulesDir.exists()) {
            return new ArrayList<File>();
        }
        ArrayList<File> moduleSubrepoDirs = new ArrayList<File>();
        List<File> gitrepoFiles = JenkinsResultsParserUtil.findFiles(modulesDir, "\\.gitrepo");
        for (File gitrepoFile : gitrepoFiles) {
            Properties gitrepoProperties = JenkinsResultsParserUtil.getProperties(gitrepoFile);
            String mode = gitrepoProperties.getProperty("mode", "push");
            if (!mode.equals("pull")) continue;
            moduleSubrepoDirs.add(gitrepoFile.getParentFile());
        }
        return moduleSubrepoDirs;
    }

    public List<File> getNPMTestModuleDirsList() throws IOException {
        ArrayList<File> npmModuleDirsList = new ArrayList<File>();
        for (File moduleDir : this.getModuleDirsList()) {
            if (!this._isNPMTestModuleDir(moduleDir)) continue;
            npmModuleDirsList.add(moduleDir);
        }
        return npmModuleDirsList;
    }

    public PluginsGitWorkingDirectory getPluginsGitWorkingDirectory() {
        String lpPluginsDir = JenkinsResultsParserUtil.getProperty(this.getReleaseProperties(), "lp.plugins.dir");
        GitWorkingDirectory pluginsGitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(this.getUpstreamBranchName(), new File(lpPluginsDir), "liferay-plugins-ee");
        if (pluginsGitWorkingDirectory instanceof PluginsGitWorkingDirectory) {
            return (PluginsGitWorkingDirectory)pluginsGitWorkingDirectory;
        }
        throw new RuntimeException("Unable to find a plugins Git working directory");
    }

    public Properties getReleaseProperties() {
        if (this._releaseProperties != null) {
            return this._releaseProperties;
        }
        this._releaseProperties = JenkinsResultsParserUtil.getProperties(new File(this.getWorkingDirectory(), "release.properties"));
        return this._releaseProperties;
    }

    public Properties getTestProperties() {
        if (this._testProperties != null) {
            return this._testProperties;
        }
        File testPropertiesFile = new File(this.getWorkingDirectory(), "test.properties");
        if (!testPropertiesFile.exists()) {
            return this._testProperties;
        }
        this._testProperties = JenkinsResultsParserUtil.getProperties(testPropertiesFile);
        return this._testProperties;
    }

    protected PortalGitWorkingDirectory(String upstreamBranchName, String workingDirectoryPath) throws IOException {
        super(upstreamBranchName, workingDirectoryPath);
    }

    protected PortalGitWorkingDirectory(String upstreamBranchName, String workingDirectoryPath, String gitRepositoryName) throws IOException {
        super(upstreamBranchName, workingDirectoryPath, gitRepositoryName);
    }

    private boolean _isNPMTestModuleDir(File moduleDir) {
        List<File> packageJSONFiles = JenkinsResultsParserUtil.findFiles(moduleDir, "package\\.json");
        for (File packageJSONFile : packageJSONFiles) {
            JSONObject scriptsJSONObject;
            JSONObject jsonObject = null;
            try {
                jsonObject = JenkinsResultsParserUtil.createJSONObject(JenkinsResultsParserUtil.read(packageJSONFile));
            }
            catch (IOException ioException) {
                System.out.println("Unable to read invalid JSON " + packageJSONFile.getPath());
                continue;
            }
            catch (JSONException jsonException) {
                System.out.println("Invalid JSON file " + packageJSONFile.getPath());
                continue;
            }
            if (!jsonObject.has("scripts") || !(scriptsJSONObject = jsonObject.getJSONObject("scripts")).has("test")) continue;
            return true;
        }
        return false;
    }

    private static class Module {
        private static Map<Integer, String[]> _markerFileNames = new HashMap<Integer, String[]>(){
            {
                this.put(0, new String[]{".lfrbuild-release-src", ".gitrepo"});
                this.put(1, new String[]{"app.bnd"});
                this.put(2, new String[]{"bnd.bnd"});
                this.put(3, new String[]{"build.gradle", "build.xml", "pom.xml"});
            }
        };
        private final File _file;
        private final int _priority;

        public static Module getModule(Path path) {
            File file = path.toFile();
            if (!file.isDirectory()) {
                return null;
            }
            for (int i = 0; i < _markerFileNames.size(); ++i) {
                for (String markerFileName : _markerFileNames.get(i)) {
                    File markerFile = new File(file, markerFileName);
                    if (!markerFile.exists()) continue;
                    return new Module(file, i);
                }
            }
            return null;
        }

        public File getFile() {
            return this._file;
        }

        public int getPriority() {
            return this._priority;
        }

        public String toString() {
            return JenkinsResultsParserUtil.combine(String.valueOf(this._priority), " ", this._file.toString());
        }

        private Module(File file, int priority) {
            this._file = file;
            this._priority = priority;
        }
    }
}

